/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import net.minecraft.util.ChatDeserializer;

public final class ComponentUtils {
    public static final String EMPTY = ComponentUtils.createPlainTextComponent("");

    public static String createPlainTextComponent(String text) {
        JsonObject ret = new JsonObject();
        ret.addProperty("text", text);
        return ChatDeserializer.e((JsonElement)ret);
    }

    public static String createTranslatableComponent(String key) {
        JsonObject ret = new JsonObject();
        ret.addProperty("translate", key);
        return ChatDeserializer.e((JsonElement)ret);
    }

    public static String retrieveTranslationString(String possibleJson) {
        try {
            JsonObject object;
            JsonElement translation;
            JsonElement element = JsonParser.parseString((String)possibleJson);
            if (element instanceof JsonObject && (translation = (object = (JsonObject)element).get("translate")) instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)translation;
                return primitive.getAsString();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String convertFromLenient(String input) {
        if (input == null) {
            return input;
        }
        if (input.isEmpty() || input.equals("null")) {
            return EMPTY;
        }
        char firstCharacter = input.charAt(0);
        char lastCharacter = input.charAt(input.length() - 1);
        if (firstCharacter == '\"' && lastCharacter == '\"' || firstCharacter == '{' && lastCharacter == '}' || firstCharacter == '[' && lastCharacter == ']') {
            try {
                JsonElement json = JsonParser.parseString((String)input);
                if (json.isJsonPrimitive()) {
                    return ComponentUtils.createPlainTextComponent(json.getAsString());
                }
                return ChatDeserializer.e(json);
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return ComponentUtils.createPlainTextComponent(input);
    }

    private ComponentUtils() {
    }
}

