/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V135 {
    private static final int VERSION = 135;

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(135){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType ret = null;
                while (data.hasKey("Riding", ObjectType.MAP)) {
                    MapType riding = data.getMap("Riding");
                    data.remove("Riding");
                    ListType passengers = Types.NBT.createEmptyList();
                    riding.setList("Passengers", passengers);
                    passengers.addMap(data);
                    data = riding;
                    ret = data;
                }
                return ret;
            }
        });
        MCTypeRegistry.PLAYER.addStructureWalker(135, new DataWalkerItemLists("Inventory", "EnderItems"));
        MCTypeRegistry.PLAYER.addStructureWalker(135, (data, fromVersion, toVersion) -> {
            MapType<String> rootVehicle = data.getMap("RootVehicle");
            if (rootVehicle != null) {
                WalkerUtils.convert(MCTypeRegistry.ENTITY, rootVehicle, "Entity", fromVersion, toVersion);
            }
            return null;
        });
        MCTypeRegistry.ENTITY.addStructureWalker(135, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, (MapType<String>)data, "Passengers", fromVersion, toVersion);
            return null;
        });
    }

    private V135() {
    }
}

