/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V165 {
    private static final int VERSION = 165;

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(165){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                ListType pages = tag.getList("pages", ObjectType.STRING);
                if (pages == null) {
                    return null;
                }
                int len = pages.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    String page = pages.getString(i2);
                    pages.setString(i2, ComponentUtils.convertFromLenient(page));
                }
                return null;
            }
        });
    }

    private V165() {
    }
}

