/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller;

import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public final class EntityDataController
extends RegionFileIOThread.ChunkDataController {
    private final EntityRegionFileStorage storage;

    public EntityDataController(EntityRegionFileStorage storage) {
        super(RegionFileIOThread.RegionFileType.ENTITY_DATA);
        this.storage = storage;
    }

    @Override
    public RegionFileCache getCache() {
        return this.storage;
    }

    @Override
    public void writeData(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
        this.storage.a(new ChunkCoordIntPair(chunkX, chunkZ), compound);
    }

    @Override
    public NBTTagCompound readData(int chunkX, int chunkZ) throws IOException {
        return this.storage.a(new ChunkCoordIntPair(chunkX, chunkZ));
    }

    public static final class EntityRegionFileStorage
    extends RegionFileCache {
        public EntityRegionFileStorage(RegionStorageInfo regionStorageInfo, Path directory, boolean dsync) {
            super(regionStorageInfo, directory, dsync);
        }

        @Override
        public void a(ChunkCoordIntPair pos, NBTTagCompound nbt) throws IOException {
            ChunkCoordIntPair nbtPos;
            ChunkCoordIntPair chunkCoordIntPair = nbtPos = nbt == null ? null : EntityStorage.a(nbt);
            if (nbtPos != null && !pos.equals(nbtPos)) {
                throw new IllegalArgumentException("Entity chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + pos.toString() + " but compound says coordinate is " + String.valueOf(nbtPos) + " for world: " + String.valueOf(this));
            }
            super.a(pos, nbt);
        }
    }
}

