/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.poi;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoiChunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiChunk.class);
    public final WorldServer world;
    public final int chunkX;
    public final int chunkZ;
    public final int minSection;
    public final int maxSection;
    private final VillagePlaceSection[] sections;
    private boolean isDirty;
    private boolean loaded;

    public PoiChunk(WorldServer world, int chunkX, int chunkZ, int minSection, int maxSection) {
        this(world, chunkX, chunkZ, minSection, maxSection, new VillagePlaceSection[maxSection - minSection + 1]);
    }

    public PoiChunk(WorldServer world, int chunkX, int chunkZ, int minSection, int maxSection, VillagePlaceSection[] sections) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.sections = sections;
        if (this.sections.length != maxSection - minSection + 1) {
            throw new IllegalStateException("Incorrect length used, expected " + (maxSection - minSection + 1) + ", got " + this.sections.length);
        }
    }

    public void load() {
        TickThread.ensureTickThread((World)this.world, this.chunkX, this.chunkZ, "Loading in poi chunk off-main");
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.world.l().l().moonrise$loadInPoiChunk(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        for (VillagePlaceSection section : this.sections) {
            if (section == null || section.moonrise$isEmpty()) continue;
            return false;
        }
        return true;
    }

    public VillagePlaceSection getOrCreateSection(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            int idx = chunkY - this.minSection;
            VillagePlaceSection ret = this.sections[idx];
            if (ret != null) {
                return ret;
            }
            VillagePlace poiManager = this.world.y();
            long key = CoordinateUtils.getChunkSectionKey(this.chunkX, chunkY, this.chunkZ);
            this.sections[idx] = new VillagePlaceSection(() -> poiManager.a(key));
            return this.sections[idx];
        }
        throw new IllegalArgumentException("chunkY is out of bounds, chunkY: " + chunkY + " outside [" + this.minSection + "," + this.maxSection + "]");
    }

    public VillagePlaceSection getSection(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            return this.sections[chunkY - this.minSection];
        }
        return null;
    }

    public Optional<VillagePlaceSection> getSectionForVanilla(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            VillagePlaceSection ret = this.sections[chunkY - this.minSection];
            return ret == null ? Optional.empty() : ret.moonrise$asOptional();
        }
        return Optional.empty();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public NBTTagCompound save() {
        RegistryOps<NBTBase> registryOps = RegistryOps.a(DynamicOpsNBT.a, (HolderLookup.a)this.world.H_());
        NBTTagCompound ret = new NBTTagCompound();
        NBTTagCompound sections = new NBTTagCompound();
        ret.a("Sections", sections);
        ret.a("DataVersion", SharedConstants.b().d().c());
        WorldServer world = this.world;
        VillagePlace poiManager = world.y();
        int chunkX = this.chunkX;
        int chunkZ = this.chunkZ;
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            int finalSectionY;
            long key;
            Codec<VillagePlaceSection> codec;
            DataResult serializedResult;
            NBTBase serialized;
            VillagePlaceSection section = this.sections[sectionY - this.minSection];
            if (section == null || section.moonrise$isEmpty() || (serialized = (NBTBase)(serializedResult = (codec = VillagePlaceSection.a(() -> PoiChunk.lambda$save$1(poiManager, key = CoordinateUtils.getChunkSectionKey(chunkX, sectionY, chunkZ)))).encodeStart(registryOps, (Object)section)).resultOrPartial(arg_0 -> PoiChunk.lambda$save$2(world, chunkX, finalSectionY = sectionY, chunkZ, arg_0)).orElse(null)) == null) continue;
            sections.a(Integer.toString(sectionY), serialized);
        }
        return sections.g() ? null : ret;
    }

    public static PoiChunk empty(WorldServer world, int chunkX, int chunkZ) {
        PoiChunk ret = new PoiChunk(world, chunkX, chunkZ, WorldUtil.getMinSection(world), WorldUtil.getMaxSection(world));
        ret.loaded = true;
        return ret;
    }

    public static PoiChunk parse(WorldServer world, int chunkX, int chunkZ, NBTTagCompound data) {
        PoiChunk ret = PoiChunk.empty(world, chunkX, chunkZ);
        RegistryOps<NBTBase> registryOps = RegistryOps.a(DynamicOpsNBT.a, (HolderLookup.a)world.H_());
        NBTTagCompound sections = data.p("Sections");
        if (sections.g()) {
            return ret;
        }
        VillagePlace poiManager = world.y();
        boolean readAnything = false;
        for (int sectionY = ret.minSection; sectionY <= ret.maxSection; ++sectionY) {
            int finalSectionY;
            NBTTagCompound section;
            long coordinateKey;
            Codec<VillagePlaceSection> codec;
            DataResult deserializeResult;
            VillagePlaceSection deserialized;
            String key = Integer.toString(sectionY);
            if (!sections.e(key) || (deserialized = (VillagePlaceSection)(deserializeResult = (codec = VillagePlaceSection.a(() -> PoiChunk.lambda$parse$3(poiManager, coordinateKey = CoordinateUtils.getChunkSectionKey(chunkX, sectionY, chunkZ)))).parse(registryOps, (Object)(section = sections.p(key)))).resultOrPartial(arg_0 -> PoiChunk.lambda$parse$4(world, chunkX, finalSectionY = sectionY, chunkZ, arg_0)).orElse(null)) == null || deserialized.moonrise$isEmpty()) continue;
            readAnything = true;
            ret.sections[sectionY - ret.minSection] = deserialized;
        }
        ret.loaded = !readAnything;
        return ret;
    }

    private static /* synthetic */ void lambda$parse$4(WorldServer world, int chunkX, int finalSectionY, int chunkZ, String description) {
        LOGGER.error("Failed to deserialize poi chunk for world: " + WorldUtil.getWorldName(world) + ", chunk: (" + chunkX + "," + finalSectionY + "," + chunkZ + "); description: " + description);
    }

    private static /* synthetic */ void lambda$parse$3(VillagePlace poiManager, long coordinateKey) {
        poiManager.a(coordinateKey);
    }

    private static /* synthetic */ void lambda$save$2(WorldServer world, int chunkX, int finalSectionY, int chunkZ, String description) {
        LOGGER.error("Failed to serialize poi chunk for world: " + WorldUtil.getWorldName(world) + ", chunk: (" + chunkX + "," + finalSectionY + "," + chunkZ + "); description: " + description);
    }

    private static /* synthetic */ void lambda$save$1(VillagePlace poiManager, long key) {
        poiManager.a(key);
    }
}

