/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.destroystokyo.paper.entity.ai.MobGoalHelper;
import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.entity.ai.PaperCustomGoal;
import com.destroystokyo.paper.entity.ai.PaperVanillaGoal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftMob;
import org.bukkit.entity.Mob;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperMobGoals
implements MobGoals {
    public <T extends Mob> void addGoal(T mob, int priority, Goal<T> goal) {
        PathfinderGoal mojangGoal;
        CraftMob craftMob = (CraftMob)mob;
        if (goal instanceof PaperVanillaGoal) {
            PaperVanillaGoal vanillaGoal = (PaperVanillaGoal)goal;
            mojangGoal = vanillaGoal.getHandle();
        } else {
            mojangGoal = new PaperCustomGoal<T>(goal);
        }
        this.getHandle(craftMob, goal.getTypes()).a(priority, mojangGoal);
    }

    public <T extends Mob> void removeGoal(T mob, Goal<T> goal) {
        CraftMob craftMob = (CraftMob)mob;
        if (goal instanceof PaperCustomGoal) {
            this.getHandle(craftMob, goal.getTypes()).a((PathfinderGoal)goal);
        } else if (goal instanceof PaperVanillaGoal) {
            this.getHandle(craftMob, goal.getTypes()).a(((PaperVanillaGoal)goal).getHandle());
        } else {
            LinkedList<PathfinderGoal> toRemove = new LinkedList<PathfinderGoal>();
            for (PathfinderGoalWrapped item : this.getHandle(craftMob, goal.getTypes()).b()) {
                if (!(item.k() instanceof PaperCustomGoal) || ((PaperCustomGoal)item.k()).getHandle() != goal) continue;
                toRemove.add(item.k());
            }
            for (PathfinderGoal g2 : toRemove) {
                this.getHandle(craftMob, goal.getTypes()).a(g2);
            }
        }
    }

    public <T extends Mob> void removeAllGoals(T mob) {
        for (GoalType type : GoalType.values()) {
            this.removeAllGoals(mob, type);
        }
    }

    public <T extends Mob> void removeAllGoals(T mob, GoalType type) {
        for (Goal<T> goal : this.getAllGoals(mob, type)) {
            this.removeGoal(mob, goal);
        }
    }

    public <T extends Mob> void removeGoal(T mob, GoalKey<T> key) {
        for (Goal<T> goal : this.getGoals(mob, key)) {
            this.removeGoal(mob, goal);
        }
    }

    public <T extends Mob> boolean hasGoal(T mob, GoalKey<T> key) {
        for (Goal<T> g2 : this.getAllGoals(mob)) {
            if (!g2.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public <T extends Mob> Goal<T> getGoal(T mob, GoalKey<T> key) {
        for (Goal<T> g2 : this.getAllGoals(mob)) {
            if (!g2.getKey().equals(key)) continue;
            return g2;
        }
        return null;
    }

    public <T extends Mob> Collection<Goal<T>> getGoals(T mob, GoalKey<T> key) {
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (Goal<T> g2 : this.getAllGoals(mob)) {
            if (!g2.getKey().equals(key)) continue;
            goals.add(g2);
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getAllGoals(T mob) {
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (GoalType type : GoalType.values()) {
            goals.addAll(this.getAllGoals(mob, type));
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getAllGoals(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (PathfinderGoalWrapped item : this.getHandle(craftMob, type).b()) {
            if (!item.k().getFlags().hasElement(MobGoalHelper.paperToVanilla(type))) continue;
            if (item.k() instanceof PaperCustomGoal) {
                goals.add(((PaperCustomGoal)item.k()).getHandle());
                continue;
            }
            goals.add(item.k().asPaperVanillaGoal());
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getAllGoalsWithout(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (GoalType internalType : GoalType.values()) {
            if (internalType == type) continue;
            for (PathfinderGoalWrapped item : this.getHandle(craftMob, internalType).b()) {
                if (item.k().getFlags().hasElement(MobGoalHelper.paperToVanilla(type))) continue;
                if (item.k() instanceof PaperCustomGoal) {
                    goals.add(((PaperCustomGoal)item.k()).getHandle());
                    continue;
                }
                goals.add(item.k().asPaperVanillaGoal());
            }
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getRunningGoals(T mob) {
        HashSet<Goal<T>> goals = new HashSet<Goal<T>>();
        for (GoalType type : GoalType.values()) {
            goals.addAll(this.getRunningGoals(mob, type));
        }
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getRunningGoals(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet goals = new HashSet();
        this.getHandle(craftMob, type).b().stream().filter(PathfinderGoalWrapped::h).filter(item -> item.k().getFlags().hasElement(MobGoalHelper.paperToVanilla(type))).forEach(item -> {
            if (item.k() instanceof PaperCustomGoal) {
                goals.add(((PaperCustomGoal)item.k()).getHandle());
            } else {
                goals.add(item.k().asPaperVanillaGoal());
            }
        });
        return goals;
    }

    public <T extends Mob> Collection<Goal<T>> getRunningGoalsWithout(T mob, GoalType type) {
        CraftMob craftMob = (CraftMob)mob;
        HashSet goals = new HashSet();
        for (GoalType internalType : GoalType.values()) {
            if (internalType == type) continue;
            this.getHandle(craftMob, internalType).b().stream().filter(PathfinderGoalWrapped::h).filter(item -> !item.k().getFlags().hasElement(MobGoalHelper.paperToVanilla(type))).forEach(item -> {
                if (item.k() instanceof PaperCustomGoal) {
                    goals.add(((PaperCustomGoal)item.k()).getHandle());
                } else {
                    goals.add(item.k().asPaperVanillaGoal());
                }
            });
        }
        return goals;
    }

    private PathfinderGoalSelector getHandle(CraftMob mob, EnumSet<GoalType> types) {
        if (types.contains(GoalType.TARGET)) {
            return mob.getHandle().bX;
        }
        return mob.getHandle().bW;
    }

    private PathfinderGoalSelector getHandle(CraftMob mob, GoalType type) {
        if (type == GoalType.TARGET) {
            return mob.getHandle().bX;
        }
        return mob.getHandle().bW;
    }
}

