/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.UtilColor;
import net.minecraft.world.item.component.ResolvableProfile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R1.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.profile.CraftPlayerTextures;
import org.bukkit.craftbukkit.v1_21_R1.profile.CraftProfileProperty;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="PlayerProfile")
public class CraftPlayerProfile
implements PlayerProfile,
SharedPlayerProfile {
    private boolean emptyName;
    private boolean emptyUUID;
    private GameProfile profile;
    private final PropertySet properties = new PropertySet();

    public CraftPlayerProfile(CraftPlayer player) {
        this.profile = player.getHandle().fX();
    }

    public CraftPlayerProfile(UUID id, String name) {
        this.profile = CraftPlayerProfile.createAuthLibProfile(id, name);
        this.emptyName = name == null;
        this.emptyUUID = id == null;
    }

    public CraftPlayerProfile(GameProfile profile) {
        Validate.notNull((Object)profile, (String)"GameProfile cannot be null!", (Object[])new Object[0]);
        this.profile = profile;
    }

    public CraftPlayerProfile(ResolvableProfile resolvableProfile) {
        this(resolvableProfile.d().orElse(null), resolvableProfile.c().orElse(null));
        CraftPlayerProfile.copyProfileProperties(resolvableProfile.f(), this.profile);
    }

    public boolean hasProperty(String property) {
        return this.profile.getProperties().containsKey((Object)property);
    }

    public void setProperty(ProfileProperty property) {
        String name = property.getName();
        PropertyMap properties = this.profile.getProperties();
        properties.removeAll((Object)name);
        Preconditions.checkArgument((properties.size() < 16 ? 1 : 0) != 0, (Object)"Cannot add more than 16 properties to a profile");
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    public CraftPlayerTextures getTextures() {
        return new CraftPlayerTextures(this);
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        if (textures == null) {
            this.removeProperty("textures");
        } else {
            CraftPlayerTextures craftPlayerTextures = new CraftPlayerTextures(this);
            craftPlayerTextures.copyFrom(textures);
            craftPlayerTextures.rebuildPropertyIfDirty();
        }
    }

    public GameProfile getGameProfile() {
        return this.profile;
    }

    @Nullable
    public UUID getId() {
        return this.emptyUUID ? null : this.profile.getId();
    }

    @Deprecated(forRemoval=true)
    public UUID setId(@Nullable UUID uuid) {
        GameProfile previousProfile = this.profile;
        UUID previousId = this.getId();
        this.profile = CraftPlayerProfile.createAuthLibProfile(uuid, previousProfile.getName());
        CraftPlayerProfile.copyProfileProperties(previousProfile, this.profile);
        this.emptyUUID = uuid == null;
        return previousId;
    }

    @Override
    public UUID getUniqueId() {
        return this.getId();
    }

    @Override
    @Nullable
    public String getName() {
        return this.emptyName ? null : this.profile.getName();
    }

    @Deprecated(forRemoval=true)
    public String setName(@Nullable String name) {
        GameProfile prev = this.profile;
        this.profile = CraftPlayerProfile.createAuthLibProfile(prev.getId(), name);
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        this.emptyName = name == null;
        return prev.getName();
    }

    @Nonnull
    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<ProfileProperty> properties) {
        properties.forEach(this::setProperty);
    }

    public void clearProperties() {
        this.profile.getProperties().clear();
    }

    @Override
    public boolean removeProperty(String property) {
        return !this.profile.getProperties().removeAll((Object)property).isEmpty();
    }

    @Override
    @Nullable
    public Property getProperty(String property) {
        return (Property)Iterables.getFirst((Iterable)this.profile.getProperties().get((Object)property), null);
    }

    @Override
    @Nullable
    public void setProperty(@NotNull String propertyName, @Nullable Property property) {
        if (property != null) {
            this.setProperty(new ProfileProperty(propertyName, property.value(), property.signature()));
        } else {
            this.profile.getProperties().removeAll((Object)propertyName);
        }
    }

    @Override
    @NotNull
    public GameProfile buildGameProfile() {
        GameProfile profile = new GameProfile(this.profile.getId(), this.profile.getName());
        profile.getProperties().putAll((Multimap)this.profile.getProperties());
        return profile;
    }

    @Override
    @NotNull
    public ResolvableProfile buildResolvableProfile() {
        if (this.emptyName || this.emptyUUID) {
            return new ResolvableProfile(this.emptyName ? Optional.empty() : Optional.of(this.profile.getName()), this.emptyUUID ? Optional.empty() : Optional.of(this.profile.getId()), this.profile.getProperties());
        }
        return new ResolvableProfile(this.buildGameProfile());
    }

    public CraftPlayerProfile clone() {
        CraftPlayerProfile clone = new CraftPlayerProfile(this.getId(), this.getName());
        clone.setProperties(this.getProperties());
        return clone;
    }

    public boolean isComplete() {
        return this.getId() != null && StringUtils.isNotBlank((CharSequence)this.getName());
    }

    @NotNull
    public CompletableFuture<PlayerProfile> update() {
        return CompletableFuture.supplyAsync(() -> {
            CraftPlayerProfile clone = this.clone();
            clone.complete(true);
            return clone;
        }, SystemUtils.PROFILE_EXECUTOR);
    }

    public boolean completeFromCache() {
        return this.completeFromCache(false, GlobalConfiguration.get().proxies.isProxyOnlineMode());
    }

    public boolean completeFromCache(boolean onlineMode) {
        return this.completeFromCache(false, onlineMode);
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        Optional<GameProfile> optProfile;
        GameProfile profile;
        MinecraftServer server = MinecraftServer.getServer();
        String name = this.profile.getName();
        UserCache userCache = server.au();
        if (this.getId() == null && (profile = onlineMode ? (lookupUUID ? (GameProfile)userCache.a(name).orElse(null) : userCache.getProfileIfCached(name)) : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) != null) {
            CraftPlayerProfile.copyProfileProperties(this.profile, profile);
            this.profile = profile;
            this.emptyUUID = false;
        }
        if ((this.profile.getName().isEmpty() || !this.hasTextures()) && this.getId() != null && (optProfile = userCache.a(this.profile.getId())).isPresent()) {
            GameProfile profile2 = optProfile.get();
            if (this.profile.getName().isEmpty()) {
                CraftPlayerProfile.copyProfileProperties(this.profile, profile2);
                this.profile = profile2;
                this.emptyName = false;
            } else if (profile2 != this.profile) {
                CraftPlayerProfile.copyProfileProperties(profile2, this.profile);
            }
        }
        return this.isComplete();
    }

    public boolean complete(boolean textures) {
        return this.complete(textures, GlobalConfiguration.get().proxies.isProxyOnlineMode());
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        if (this.isComplete() && (!textures || this.hasTextures())) {
            return true;
        }
        MinecraftServer server = MinecraftServer.getServer();
        boolean isCompleteFromCache = this.completeFromCache(true, onlineMode);
        if (onlineMode && (!isCompleteFromCache || textures && !this.hasTextures())) {
            ProfileResult result = server.ar().fetchProfile(this.profile.getId(), true);
            if (result != null && result.profile() != null) {
                CraftPlayerProfile.copyProfileProperties(result.profile(), this.profile, true);
            }
            if (this.isComplete()) {
                server.au().a(this.profile);
            }
        }
        return this.isComplete() && (!onlineMode || !textures || this.hasTextures());
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target) {
        CraftPlayerProfile.copyProfileProperties(source, target, false);
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target, boolean clearTarget) {
        if (source == target) {
            throw new IllegalArgumentException("Source and target profiles are the same (" + String.valueOf(source) + ")");
        }
        PropertyMap sourceProperties = source.getProperties();
        PropertyMap targetProperties = target.getProperties();
        if (clearTarget) {
            targetProperties.clear();
        }
        if (sourceProperties.isEmpty()) {
            return;
        }
        for (Property property : sourceProperties.values()) {
            targetProperties.removeAll((Object)property.name());
            targetProperties.put((Object)property.name(), (Object)property);
        }
    }

    private static GameProfile createAuthLibProfile(UUID uniqueId, String name) {
        Preconditions.checkArgument((name == null || name.length() <= 16 ? 1 : 0) != 0, (Object)"Name cannot be longer than 16 characters");
        Preconditions.checkArgument((name == null || UtilColor.f(name) ? 1 : 0) != 0, (String)"The name of the profile contains invalid characters: %s", (Object)name);
        return new GameProfile(uniqueId != null ? uniqueId : SystemUtils.e, name != null ? name : "");
    }

    private static ProfileProperty toBukkit(Property property) {
        return new ProfileProperty(property.name(), property.value(), property.signature());
    }

    public static PlayerProfile asBukkitCopy(GameProfile gameProfile) {
        CraftPlayerProfile profile = new CraftPlayerProfile(gameProfile.getId(), gameProfile.getName());
        CraftPlayerProfile.copyProfileProperties(gameProfile, profile.profile);
        return profile;
    }

    public static PlayerProfile asBukkitMirror(GameProfile profile) {
        return new CraftPlayerProfile(profile);
    }

    public static Property asAuthlib(ProfileProperty property) {
        return new Property(property.getName(), property.getValue(), property.getSignature());
    }

    public static GameProfile asAuthlibCopy(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return CraftPlayerProfile.asAuthlib(craft.clone());
    }

    public static GameProfile asAuthlib(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return craft.getGameProfile();
    }

    public static ResolvableProfile asResolvableProfileCopy(PlayerProfile profile) {
        return ((SharedPlayerProfile)profile).buildResolvableProfile();
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (!this.emptyUUID) {
            map.put("uniqueId", this.getId().toString());
        }
        if (!this.emptyName) {
            map.put("name", this.getName());
        }
        if (!this.properties.isEmpty()) {
            ArrayList<Map<String, Object>> propertiesData = new ArrayList<Map<String, Object>>();
            for (ProfileProperty property : this.properties) {
                propertiesData.add(CraftProfileProperty.serialize(new Property(property.getName(), property.getValue(), property.getSignature())));
            }
            map.put("properties", propertiesData);
        }
        return map;
    }

    public static CraftPlayerProfile deserialize(Map<String, Object> map) {
        UUID uniqueId = ConfigSerializationUtil.getUuid(map, "uniqueId", true);
        String name = ConfigSerializationUtil.getString(map, "name", true);
        CraftPlayerProfile profile = new CraftPlayerProfile(uniqueId, name);
        if (map.containsKey("properties")) {
            for (Object propertyData : (List)map.get("properties")) {
                if (!(propertyData instanceof Map)) {
                    throw new IllegalArgumentException("Property data (" + String.valueOf(propertyData) + ") is not a valid Map");
                }
                Property property = CraftProfileProperty.deserialize((Map)propertyData);
                profile.profile.getProperties().put((Object)property.name(), (Object)property);
            }
        }
        return profile;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CraftPlayerProfile that = (CraftPlayerProfile)o2;
        return this.emptyName == that.emptyName && this.emptyUUID == that.emptyUUID && Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hash(this.emptyName, this.emptyUUID, this.profile);
    }

    public String toString() {
        return "CraftPlayerProfile [uniqueId=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", properties=" + org.bukkit.craftbukkit.v1_21_R1.profile.CraftPlayerProfile.toString(this.profile.getProperties()) + "]";
    }

    private class PropertySet
    extends AbstractSet<ProfileProperty> {
        private PropertySet() {
        }

        @Override
        @Nonnull
        public Iterator<ProfileProperty> iterator() {
            return new ProfilePropertyIterator(this, CraftPlayerProfile.this.profile.getProperties().values().iterator());
        }

        @Override
        public int size() {
            return CraftPlayerProfile.this.profile.getProperties().size();
        }

        @Override
        public boolean add(ProfileProperty property) {
            CraftPlayerProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ProfileProperty> c2) {
            CraftPlayerProfile.this.setProperties(c2);
            return true;
        }

        @Override
        public boolean contains(Object o2) {
            return o2 instanceof ProfileProperty && CraftPlayerProfile.this.profile.getProperties().containsKey((Object)((ProfileProperty)o2).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<ProfileProperty> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(PropertySet propertySet, Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProfileProperty next() {
                return CraftPlayerProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

