/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.GivensParameters;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MatrixUtil {
    private static final float a = 3.0f + 2.0f * Math.sqrt((float)2.0f);
    private static final GivensParameters b = GivensParameters.a(0.7853982f);

    private MatrixUtil() {
    }

    public static Matrix4f a(Matrix4f matrix, float scalar) {
        return matrix.set(matrix.m00() * scalar, matrix.m01() * scalar, matrix.m02() * scalar, matrix.m03() * scalar, matrix.m10() * scalar, matrix.m11() * scalar, matrix.m12() * scalar, matrix.m13() * scalar, matrix.m20() * scalar, matrix.m21() * scalar, matrix.m22() * scalar, matrix.m23() * scalar, matrix.m30() * scalar, matrix.m31() * scalar, matrix.m32() * scalar, matrix.m33() * scalar);
    }

    private static GivensParameters a(float a11, float a12, float a22) {
        float g2 = a12;
        float f2 = 2.0f * (a11 - a22);
        if (a * g2 * g2 < f2 * f2) {
            return GivensParameters.a(g2, f2);
        }
        return b;
    }

    private static GivensParameters a(float a1, float a2) {
        float f2 = (float)java.lang.Math.hypot(a1, a2);
        float g2 = f2 > 1.0E-6f ? a2 : 0.0f;
        float h2 = Math.abs((float)a1) + Math.max((float)f2, (float)1.0E-6f);
        if (a1 < 0.0f) {
            float i2 = g2;
            g2 = h2;
            h2 = i2;
        }
        return GivensParameters.a(g2, h2);
    }

    private static void a(Matrix3f X, Matrix3f A) {
        X.mul((Matrix3fc)A);
        A.transpose();
        A.mul((Matrix3fc)X);
        X.set((Matrix3fc)A);
    }

    private static void a(Matrix3f AtA, Matrix3f matrix3f, Quaternionf quaternionf, Quaternionf quaternionf2) {
        if (AtA.m01 * AtA.m01 + AtA.m10 * AtA.m10 > 1.0E-6f) {
            GivensParameters givensParameters = MatrixUtil.a(AtA.m00, 0.5f * (AtA.m01 + AtA.m10), AtA.m11);
            Quaternionf quaternionf3 = givensParameters.c(quaternionf);
            quaternionf2.mul((Quaternionfc)quaternionf3);
            givensParameters.c(matrix3f);
            MatrixUtil.a(AtA, matrix3f);
        }
        if (AtA.m02 * AtA.m02 + AtA.m20 * AtA.m20 > 1.0E-6f) {
            GivensParameters givensParameters2 = MatrixUtil.a(AtA.m00, 0.5f * (AtA.m02 + AtA.m20), AtA.m22).a();
            Quaternionf quaternionf4 = givensParameters2.b(quaternionf);
            quaternionf2.mul((Quaternionfc)quaternionf4);
            givensParameters2.b(matrix3f);
            MatrixUtil.a(AtA, matrix3f);
        }
        if (AtA.m12 * AtA.m12 + AtA.m21 * AtA.m21 > 1.0E-6f) {
            GivensParameters givensParameters3 = MatrixUtil.a(AtA.m11, 0.5f * (AtA.m12 + AtA.m21), AtA.m22);
            Quaternionf quaternionf5 = givensParameters3.a(quaternionf);
            quaternionf2.mul((Quaternionfc)quaternionf5);
            givensParameters3.a(matrix3f);
            MatrixUtil.a(AtA, matrix3f);
        }
    }

    public static Quaternionf a(Matrix3f AtA, int numJacobiIterations) {
        Quaternionf quaternionf = new Quaternionf();
        Matrix3f matrix3f = new Matrix3f();
        Quaternionf quaternionf2 = new Quaternionf();
        for (int i2 = 0; i2 < numJacobiIterations; ++i2) {
            MatrixUtil.a(AtA, matrix3f, quaternionf2, quaternionf);
        }
        quaternionf.normalize();
        return quaternionf;
    }

    public static Triple<Quaternionf, Vector3f, Quaternionf> a(Matrix3f A) {
        GivensParameters givensParameters2;
        Matrix3f matrix3f = new Matrix3f((Matrix3fc)A);
        matrix3f.transpose();
        matrix3f.mul((Matrix3fc)A);
        Quaternionf quaternionf = MatrixUtil.a(matrix3f, 5);
        float f2 = matrix3f.m00;
        float g2 = matrix3f.m11;
        boolean bl = (double)f2 < 1.0E-6;
        boolean bl2 = (double)g2 < 1.0E-6;
        Matrix3f matrix3f2 = matrix3f;
        Matrix3f matrix3f3 = A.rotate((Quaternionfc)quaternionf);
        Quaternionf quaternionf2 = new Quaternionf();
        Quaternionf quaternionf3 = new Quaternionf();
        if (bl) {
            GivensParameters givensParameters = MatrixUtil.a(matrix3f3.m11, -matrix3f3.m10);
        } else {
            givensParameters2 = MatrixUtil.a(matrix3f3.m00, matrix3f3.m01);
        }
        Quaternionf quaternionf4 = givensParameters2.c(quaternionf3);
        Matrix3f matrix3f4 = givensParameters2.c(matrix3f2);
        quaternionf2.mul((Quaternionfc)quaternionf4);
        matrix3f4.transpose().mul((Matrix3fc)matrix3f3);
        matrix3f2 = matrix3f3;
        givensParameters2 = bl ? MatrixUtil.a(matrix3f4.m22, -matrix3f4.m20) : MatrixUtil.a(matrix3f4.m00, matrix3f4.m02);
        givensParameters2 = givensParameters2.a();
        Quaternionf quaternionf5 = givensParameters2.b(quaternionf3);
        Matrix3f matrix3f5 = givensParameters2.b(matrix3f2);
        quaternionf2.mul((Quaternionfc)quaternionf5);
        matrix3f5.transpose().mul((Matrix3fc)matrix3f4);
        matrix3f2 = matrix3f4;
        givensParameters2 = bl2 ? MatrixUtil.a(matrix3f5.m22, -matrix3f5.m21) : MatrixUtil.a(matrix3f5.m11, matrix3f5.m12);
        Quaternionf quaternionf6 = givensParameters2.a(quaternionf3);
        Matrix3f matrix3f6 = givensParameters2.a(matrix3f2);
        quaternionf2.mul((Quaternionfc)quaternionf6);
        matrix3f6.transpose().mul((Matrix3fc)matrix3f5);
        Vector3f vector3f = new Vector3f(matrix3f6.m00, matrix3f6.m11, matrix3f6.m22);
        return Triple.of((Object)quaternionf2, (Object)vector3f, (Object)quaternionf.conjugate());
    }

    public static boolean a(Matrix4f matrix) {
        return (matrix.properties() & 8) != 0;
    }

    public static boolean b(Matrix4f matrix) {
        return (matrix.properties() & 0x10) != 0;
    }
}

