/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import io.papermc.paper.ServerBuildInfo;
import java.util.List;
import joptsimple.OptionSet;
import net.minecraft.SharedConstants;
import net.minecraft.server.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaperBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bootstrap");

    private PaperBootstrap() {
    }

    public static void boot(OptionSet options) {
        SharedConstants.a();
        PaperBootstrap.getStartupVersionMessages().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        Main.main(options);
    }

    private static List<String> getStartupVersionMessages() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        String javaVmName = System.getProperty("java.vm.name");
        String javaVmVersion = System.getProperty("java.vm.version");
        String javaVendor = System.getProperty("java.vendor");
        String javaVendorVersion = System.getProperty("java.vendor.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        ServerBuildInfo bi = ServerBuildInfo.buildInfo();
        return List.of(String.format("Running Java %s (%s %s; %s %s) on %s %s (%s)", javaSpecVersion, javaVmName, javaVmVersion, javaVendor, javaVendorVersion, osName, osVersion, osArch), String.format("Loading %s %s for Minecraft %s", bi.brandName(), bi.asString(ServerBuildInfo.StringRepresentation.VERSION_FULL), bi.minecraftVersionId()));
    }
}

