/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier.argument;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.function.Predicate;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;

public class WrappedArgumentCommandNode<NMS, API>
extends ArgumentCommandNode<CommandSourceStack, NMS> {
    private final ArgumentType<API> pureArgumentType;

    public WrappedArgumentCommandNode(String name, ArgumentType<API> pureArgumentType, ArgumentType<NMS> nmsNativeType, Command<CommandSourceStack> command, Predicate<CommandSourceStack> requirement, CommandNode<CommandSourceStack> redirect, RedirectModifier<CommandSourceStack> modifier, boolean forks, SuggestionProvider<CommandSourceStack> customSuggestions) {
        super(name, nmsNativeType, command, requirement, redirect, modifier, forks, customSuggestions);
        if (!ArgumentTypeInfos.a(nmsNativeType.getClass())) {
            throw new IllegalArgumentException("Unexpected argument type was passed: " + String.valueOf(nmsNativeType.getClass()) + ". This should be an NMS type!");
        }
        this.pureArgumentType = pureArgumentType;
    }

    public void parse(StringReader reader, CommandContextBuilder<CommandSourceStack> contextBuilder) throws CommandSyntaxException {
        int start = reader.getCursor();
        Object result = this.pureArgumentType.parse(reader);
        ParsedArgument parsed = new ParsedArgument(start, reader.getCursor(), result);
        contextBuilder.withArgument(this.getName(), parsed);
        contextBuilder.withNode((CommandNode)((Object)this), parsed.getRange());
    }
}

