/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import com.destroystokyo.paper.io.SyncLoadFinder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import io.papermc.paper.command.CommandUtil;
import io.papermc.paper.command.PaperSubcommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class SyncLoadInfoCommand
implements PaperSubcommand {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");

    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.doSyncLoadInfo(sender, args);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        return CommandUtil.getListMatchingLast(sender, args, "clear");
    }

    private void doSyncLoadInfo(CommandSender sender, String[] args) {
        if (!SyncLoadFinder.ENABLED) {
            String systemFlag = "-Dpaper.debug-sync-loads=true";
            sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)"This command requires the server startup flag '"))).append(((TextComponent)Component.text((String)systemFlag, (TextColor)NamedTextColor.WHITE).clickEvent(ClickEvent.copyToClipboard((String)systemFlag))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy the system flag"))))).append((Component)Component.text((String)"' to be set.")));
            return;
        }
        if (args.length > 0 && args[0].equals("clear")) {
            SyncLoadFinder.clear();
            sender.sendMessage((Component)Component.text((String)"Sync load data cleared.", (TextColor)NamedTextColor.GRAY));
            return;
        }
        File file = new File(new File(new File("."), "debug"), "sync-load-info-" + FORMATTER.format(LocalDateTime.now()) + ".txt");
        file.getParentFile().mkdirs();
        sender.sendMessage((Component)Component.text((String)("Writing sync load info to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
        try {
            JsonObject data = SyncLoadFinder.serialize();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent(" ");
            jsonWriter.setLenient(false);
            Streams.write((JsonElement)data, (JsonWriter)jsonWriter);
            try (PrintStream out = new PrintStream((OutputStream)new FileOutputStream(file), false, StandardCharsets.UTF_8);){
                out.print(stringWriter);
            }
            sender.sendMessage((Component)Component.text((String)"Successfully written sync load information!", (TextColor)NamedTextColor.GREEN));
        }
        catch (Throwable thr) {
            sender.sendMessage((Component)Component.text((String)"Failed to write sync load information! See the console for more info.", (TextColor)NamedTextColor.RED));
            MinecraftServer.k.warn("Error occurred while dumping sync chunk load info", thr);
        }
    }
}

