/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.manager;

import co.aikar.timings.Timings;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.PermissionManager;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.manager.NormalPaperPermissionManager;
import io.papermc.paper.plugin.manager.PaperEventManager;
import io.papermc.paper.plugin.manager.PaperPluginInstanceManager;
import io.papermc.paper.plugin.manager.StupidSPMPermissionManagerWrapper;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperPluginManagerImpl
implements PluginManager,
DependencyContext {
    final PaperPluginInstanceManager instanceManager;
    final PaperEventManager paperEventManager;
    PermissionManager permissionManager;

    public PaperPluginManagerImpl(Server server, CommandMap commandMap, @Nullable SimplePluginManager permissionManager) {
        this.instanceManager = new PaperPluginInstanceManager(this, commandMap, server);
        this.paperEventManager = new PaperEventManager(server);
        this.permissionManager = permissionManager == null ? new NormalPaperPermissionManager() : new StupidSPMPermissionManagerWrapper(permissionManager);
    }

    public static PaperPluginManagerImpl getInstance() {
        return ((CraftServer)Bukkit.getServer()).paperPluginManager;
    }

    @Nullable
    public Plugin getPlugin(@NotNull String name) {
        return this.instanceManager.getPlugin(name);
    }

    @NotNull
    public Plugin[] getPlugins() {
        return this.instanceManager.getPlugins();
    }

    public boolean isPluginEnabled(@NotNull String name) {
        return this.instanceManager.isPluginEnabled(name);
    }

    public boolean isPluginEnabled(@Nullable Plugin plugin) {
        return this.instanceManager.isPluginEnabled(plugin);
    }

    public void loadPlugin(Plugin plugin) {
        this.instanceManager.loadPlugin(plugin);
    }

    @Nullable
    public Plugin loadPlugin(@NotNull File file) throws InvalidPluginException, InvalidDescriptionException, UnknownDependencyException {
        return this.instanceManager.loadPlugin(file.toPath());
    }

    @NotNull
    public Plugin[] loadPlugins(@NotNull File directory) {
        return this.instanceManager.loadPlugins(directory.toPath());
    }

    @NotNull
    public Plugin[] loadPlugins(@NotNull File[] files) {
        return this.instanceManager.loadPlugins(files);
    }

    public void disablePlugins() {
        this.instanceManager.disablePlugins();
    }

    public synchronized void clearPlugins() {
        this.instanceManager.clearPlugins();
        this.permissionManager.clearPermissions();
        this.paperEventManager.clearEvents();
    }

    public void enablePlugin(@NotNull Plugin plugin) {
        this.instanceManager.enablePlugin(plugin);
    }

    public void disablePlugin(@NotNull Plugin plugin) {
        this.instanceManager.disablePlugin(plugin);
    }

    public boolean isTransitiveDependency(PluginMeta pluginMeta, PluginMeta dependencyConfig) {
        return this.instanceManager.isTransitiveDepend(pluginMeta, dependencyConfig);
    }

    public boolean hasDependency(String pluginIdentifier) {
        return this.instanceManager.hasDependency(pluginIdentifier);
    }

    public void callEvent(@NotNull Event event) throws IllegalStateException {
        this.paperEventManager.callEvent(event);
    }

    public void registerEvents(@NotNull Listener listener, @NotNull Plugin plugin) {
        this.paperEventManager.registerEvents(listener, plugin);
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin) {
        this.paperEventManager.registerEvent(event, listener, priority, executor, plugin);
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin, boolean ignoreCancelled) {
        this.paperEventManager.registerEvent(event, listener, priority, executor, plugin, ignoreCancelled);
    }

    @Nullable
    public Permission getPermission(@NotNull String name) {
        return this.permissionManager.getPermission(name);
    }

    public void addPermission(@NotNull Permission perm) {
        this.permissionManager.addPermission(perm);
    }

    public void removePermission(@NotNull Permission perm) {
        this.permissionManager.removePermission(perm);
    }

    public void removePermission(@NotNull String name) {
        this.permissionManager.removePermission(name);
    }

    @NotNull
    public Set<Permission> getDefaultPermissions(boolean op) {
        return this.permissionManager.getDefaultPermissions(op);
    }

    public void recalculatePermissionDefaults(@NotNull Permission perm) {
        this.permissionManager.recalculatePermissionDefaults(perm);
    }

    public void subscribeToPermission(@NotNull String permission, @NotNull Permissible permissible) {
        this.permissionManager.subscribeToPermission(permission, permissible);
    }

    public void unsubscribeFromPermission(@NotNull String permission, @NotNull Permissible permissible) {
        this.permissionManager.unsubscribeFromPermission(permission, permissible);
    }

    @NotNull
    public Set<Permissible> getPermissionSubscriptions(@NotNull String permission) {
        return this.permissionManager.getPermissionSubscriptions(permission);
    }

    public void subscribeToDefaultPerms(boolean op, @NotNull Permissible permissible) {
        this.permissionManager.subscribeToDefaultPerms(op, permissible);
    }

    public void unsubscribeFromDefaultPerms(boolean op, @NotNull Permissible permissible) {
        this.permissionManager.unsubscribeFromDefaultPerms(op, permissible);
    }

    @NotNull
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        return this.permissionManager.getDefaultPermSubscriptions(op);
    }

    @NotNull
    public Set<Permission> getPermissions() {
        return this.permissionManager.getPermissions();
    }

    public void addPermissions(@NotNull List<Permission> perm) {
        this.permissionManager.addPermissions(perm);
    }

    public void clearPermissions() {
        this.permissionManager.clearPermissions();
    }

    public void overridePermissionManager(@NotNull Plugin plugin, @Nullable PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean useTimings() {
        return Timings.isTimingsEnabled();
    }

    public void registerInterface(@NotNull Class<? extends PluginLoader> loader) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public MutableGraph<String> getInstanceManagerGraph() {
        return this.instanceManager.getDependencyGraph();
    }
}

