/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryHolder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.entry.BaseRegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntry;
import java.util.function.BiFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.ApiVersion;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class CraftRegistryEntry<M, B extends Keyed>
extends BaseRegistryEntry<M, B> {
    private static final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> EMPTY = (namespacedKey, apiVersion) -> namespacedKey;
    protected final Class<?> classToPreload;
    protected final BiFunction<NamespacedKey, M, B> minecraftToBukkit;
    protected BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater = EMPTY;

    protected CraftRegistryEntry(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<B> apiKey, Class<?> classToPreload, BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        super(mcKey, apiKey);
        Preconditions.checkArgument((!classToPreload.getPackageName().startsWith("net.minecraft") ? 1 : 0) != 0, (Object)(String.valueOf(classToPreload) + " should not be in the net.minecraft package as the class-to-preload"));
        this.classToPreload = classToPreload;
        this.minecraftToBukkit = minecraftToBukkit;
    }

    @Override
    public RegistryEntry<M, B> withSerializationUpdater(BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.updater = updater;
        return this;
    }

    @Override
    public RegistryHolder<B> createRegistryHolder(IRegistry<M> nmsRegistry) {
        return new RegistryHolder.Memoized(() -> this.createApiRegistry(nmsRegistry));
    }

    private CraftRegistry<B, M> createApiRegistry(IRegistry<M> nmsRegistry) {
        return new CraftRegistry<B, M>(this.classToPreload, nmsRegistry, this.minecraftToBukkit, this.updater);
    }
}

