/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.tag;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.PostFlattenTagRegistrar;
import io.papermc.paper.tag.TagEventConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperPostFlattenTagRegistrar<M, T>
implements PaperRegistrar<BootstrapContext>,
PostFlattenTagRegistrar<T> {
    public final Map<MinecraftKey, Collection<M>> tags;
    private final Function<MinecraftKey, Optional<? extends M>> fromIdConverter;
    private final Function<M, MinecraftKey> toIdConverter;
    private final RegistryKey<T> registryKey;

    public PaperPostFlattenTagRegistrar(Map<MinecraftKey, Collection<M>> tags, TagEventConfig<M, T> config) {
        this.tags = tags;
        this.fromIdConverter = config.fromIdConverter();
        this.toIdConverter = config.toIdConverter();
        this.registryKey = config.apiRegistryKey();
    }

    @Override
    public void setCurrentContext(@Nullable BootstrapContext owner) {
    }

    public RegistryKey<T> registryKey() {
        return this.registryKey;
    }

    public Map<TagKey<T>, Collection<TypedKey<T>>> getAllTags() {
        ImmutableMap.Builder tags = ImmutableMap.builderWithExpectedSize((int)this.tags.size());
        for (Map.Entry<MinecraftKey, Collection<M>> entry : this.tags.entrySet()) {
            TagKey key = TagKey.create(this.registryKey, (Key)CraftNamespacedKey.fromMinecraft(entry.getKey()));
            tags.put((Object)key, this.convert(entry.getValue()));
        }
        return tags.build();
    }

    private Collection<TypedKey<T>> convert(Collection<M> nms) {
        return Collections.unmodifiableCollection(Collections2.transform(nms, m2 -> this.convert(this.toIdConverter.apply(m2))));
    }

    private TypedKey<T> convert(MinecraftKey location) {
        return TypedKey.create(this.registryKey, (Key)CraftNamespacedKey.fromMinecraft(location));
    }

    private M convert(TypedKey<T> key) {
        Optional<M> optional = this.fromIdConverter.apply(PaperAdventure.asVanilla(key.key()));
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(key) + " doesn't exist");
        }
        return optional.get();
    }

    public boolean hasTag(TagKey<T> tagKey) {
        return this.tags.containsKey(PaperAdventure.asVanilla(tagKey.key()));
    }

    private Collection<M> getNmsTag(TagKey<T> tagKey, boolean create) {
        MinecraftKey vanillaKey = PaperAdventure.asVanilla(tagKey.key());
        Collection tag = this.tags.get(vanillaKey);
        if (tag == null) {
            if (create) {
                tag = this.tags.computeIfAbsent(vanillaKey, k2 -> new ArrayList());
            } else {
                throw new NoSuchElementException("Tag " + String.valueOf(tagKey) + " is not present");
            }
        }
        return tag;
    }

    public Collection<TypedKey<T>> getTag(TagKey<T> tagKey) {
        return this.convert(this.getNmsTag(tagKey, false));
    }

    public void addToTag(TagKey<T> tagKey, Collection<TypedKey<T>> values) {
        ArrayList<M> nmsTag = new ArrayList<M>(this.getNmsTag(tagKey, true));
        for (TypedKey<T> key : values) {
            nmsTag.add(this.convert(key));
        }
        this.tags.put(PaperAdventure.asVanilla(tagKey.key()), nmsTag);
    }

    public void setTag(TagKey<T> tagKey, Collection<TypedKey<T>> values) {
        List newList = List.copyOf(Collections2.transform(values, this::convert));
        this.tags.put(PaperAdventure.asVanilla(tagKey.key()), newList);
    }
}

