/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.tag;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.AbstractLifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.PrioritizableLifecycleEventType;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.event.RegistryEventMap;
import io.papermc.paper.tag.PaperPostFlattenTagRegistrar;
import io.papermc.paper.tag.PaperPreFlattenTagRegistrar;
import io.papermc.paper.tag.PostFlattenTagRegistrar;
import io.papermc.paper.tag.PreFlattenTagRegistrar;
import io.papermc.paper.tag.TagEventConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagDataPack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperTagListenerManager {
    public static final String PRE_FLATTEN_EVENT_NAME = "pre-flatten";
    public static final String POST_FLATTEN_EVENT_NAME = "post-flatten";
    public static final PaperTagListenerManager INSTANCE = new PaperTagListenerManager();
    public final RegistryEventMap preFlatten = new RegistryEventMap("pre-flatten");
    public final RegistryEventMap postFlatten = new RegistryEventMap("post-flatten");

    private PaperTagListenerManager() {
    }

    public <A> Map<MinecraftKey, List<TagDataPack.a>> firePreFlattenEvent(Map<MinecraftKey, List<TagDataPack.a>> initial, @Nullable TagEventConfig<?, A> config) {
        if (config == null || config.preFlatten() == null || !config.preFlatten().hasHandlers()) {
            return initial;
        }
        PaperPreFlattenTagRegistrar<A> registrar = new PaperPreFlattenTagRegistrar<A>(initial, config);
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(config.preFlatten(), registrar, BootstrapContext.class, config.cause());
        return Map.copyOf(registrar.tags);
    }

    public <M, A> Map<MinecraftKey, Collection<M>> firePostFlattenEvent(Map<MinecraftKey, Collection<M>> initial, @Nullable TagEventConfig<M, A> config) {
        if (config == null || config.postFlatten() == null || !config.postFlatten().hasHandlers()) {
            return initial;
        }
        PaperPostFlattenTagRegistrar<M, A> registrar = new PaperPostFlattenTagRegistrar<M, A>(initial, config);
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(config.postFlatten(), registrar, BootstrapContext.class, config.cause());
        return Map.copyOf(registrar.tags);
    }

    public <M, B> @Nullable TagEventConfig<Holder<M>, B> createEventConfig(IRegistry<M> registry, ReloadableRegistrarEvent.Cause cause) {
        if (PaperRegistries.getEntry(registry.d()) == null) {
            return null;
        }
        RegistryKey registryKey = PaperRegistries.registryFromNms(registry.d());
        AbstractLifecycleEventType preFlatten = null;
        if (this.preFlatten.hasHandlers(registryKey)) {
            preFlatten = (AbstractLifecycleEventType)this.preFlatten.getEventType(registryKey);
        }
        AbstractLifecycleEventType postFlatten = null;
        if (this.postFlatten.hasHandlers(registryKey)) {
            postFlatten = (AbstractLifecycleEventType)this.postFlatten.getEventType(registryKey);
        }
        return new TagEventConfig(preFlatten, postFlatten, cause, registry::c, h2 -> ((Holder.c)h2).h().a(), PaperRegistries.registryFromNms(registry.d()));
    }

    public <T> PrioritizableLifecycleEventType.Simple<BootstrapContext, ReloadableRegistrarEvent<PreFlattenTagRegistrar<T>>> getPreFlattenType(RegistryKey<T> registryKey) {
        return this.preFlatten.getOrCreate(registryKey, (ignored, name) -> new PrioritizableLifecycleEventType.Simple((String)name, BootstrapContext.class));
    }

    public <T> PrioritizableLifecycleEventType.Simple<BootstrapContext, ReloadableRegistrarEvent<PostFlattenTagRegistrar<T>>> getPostFlattenType(RegistryKey<T> registryKey) {
        return this.postFlatten.getOrCreate(registryKey, (ignored, name) -> new PrioritizableLifecycleEventType.Simple((String)name, BootstrapContext.class));
    }
}

