/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.spongepowered.configurate.util.CheckedConsumer;

public final class AtomicFiles {
    private AtomicFiles() {
    }

    public static void atomicWrite(Path path, CheckedConsumer<Path, IOException> op) throws IOException {
        Path tmp = AtomicFiles.tempFile(path);
        try {
            op.accept((Object)tmp);
            AtomicFiles.atomicMove(tmp, path, true);
        }
        catch (IOException ex) {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException ex1) {
                ex.addSuppressed(ex1);
            }
            throw ex;
        }
    }

    private static Path tempFile(Path path) {
        return path.resolveSibling("." + System.nanoTime() + "-" + ThreadLocalRandom.current().nextInt() + "-" + path.getFileName().toString() + ".tmp");
    }

    public static void atomicMove(Path from, Path to, boolean replaceExisting) throws IOException {
        int maxRetries = 2;
        try {
            AtomicFiles.atomicMoveIfPossible(from, to, replaceExisting);
        }
        catch (AccessDeniedException ex) {
            int retries = 1;
            while (true) {
                try {
                    Thread.sleep(10L * (long)retries);
                    AtomicFiles.atomicMoveIfPossible(from, to, replaceExisting);
                    break;
                }
                catch (AccessDeniedException ex1) {
                    ex.addSuppressed(ex1);
                    if (retries == 2) {
                        throw ex;
                    }
                }
                catch (InterruptedException interruptedException) {
                    ex.addSuppressed(interruptedException);
                    Thread.currentThread().interrupt();
                    throw ex;
                }
                ++retries;
            }
        }
    }

    private static void atomicMoveIfPossible(Path from, Path to, boolean replaceExisting) throws IOException {
        CopyOption[] copyOptionArray;
        if (replaceExisting) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.ATOMIC_MOVE;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.ATOMIC_MOVE;
        }
        CopyOption[] options = copyOptionArray;
        try {
            Files.move(from, to, options);
        }
        catch (AtomicMoveNotSupportedException ex) {
            CopyOption[] copyOptionArray4;
            if (replaceExisting) {
                CopyOption[] copyOptionArray5 = new CopyOption[1];
                copyOptionArray4 = copyOptionArray5;
                copyOptionArray5[0] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                copyOptionArray4 = new CopyOption[]{};
            }
            Files.move(from, to, copyOptionArray4);
        }
    }

    private static <T, X extends Throwable> Consumer<T> sneaky(CheckedConsumer<T, X> consumer) {
        return t2 -> {
            try {
                consumer.accept(t2);
            }
            catch (Throwable thr) {
                AtomicFiles.rethrow(thr);
            }
        };
    }

    private static <X extends Throwable> RuntimeException rethrow(Throwable t2) throws X {
        throw t2;
    }
}

