/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class DataSanitizationUtil {
    private static final ThreadLocal<DataSanitizer> DATA_SANITIZER = ThreadLocal.withInitial(DataSanitizer::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChargedProjectiles> CHARGED_PROJECTILES = DataSanitizationUtil.codec(ChargedProjectiles.c, DataSanitizationUtil::sanitizeChargedProjectiles);
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> BUNDLE_CONTENTS = DataSanitizationUtil.codec(BundleContents.c, DataSanitizationUtil::sanitizeBundleContents);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> CONTAINER = DataSanitizationUtil.codec(ItemContainerContents.c, contents -> ItemContainerContents.a);

    public static DataSanitizer start(boolean sanitize) {
        DataSanitizer sanitizer = DATA_SANITIZER.get();
        if (sanitize) {
            sanitizer.start();
        }
        return sanitizer;
    }

    private static ChargedProjectiles sanitizeChargedProjectiles(ChargedProjectiles projectiles) {
        if (projectiles.b()) {
            return projectiles;
        }
        return ChargedProjectiles.a(List.of(new ItemStack(projectiles.a(Items.uu) ? Items.uu : Items.ow)));
    }

    private static BundleContents sanitizeBundleContents(BundleContents contents) {
        if (contents.f()) {
            return contents;
        }
        int sizeUsed = MathHelper.a(contents.e(), 64);
        if (sizeUsed <= 64) {
            return new BundleContents(List.of(new ItemStack(Items.qO, Math.max(1, sizeUsed))));
        }
        ObjectArrayList sanitizedRepresentation = new ObjectArrayList(sizeUsed / 64 + 1);
        while (sizeUsed > 0) {
            int stackCount = Math.min(64, sizeUsed);
            sanitizedRepresentation.add(new ItemStack(Items.qO, stackCount));
            sizeUsed -= stackCount;
        }
        return new BundleContents((List<ItemStack>)sanitizedRepresentation);
    }

    private static <B, A> StreamCodec<B, A> codec(StreamCodec<B, A> delegate, UnaryOperator<A> sanitizer) {
        return new DataSanitizationCodec<B, A>(delegate, sanitizer);
    }

    private DataSanitizationUtil() {
    }

    public record DataSanitizer(AtomicBoolean value) implements AutoCloseable
    {
        public DataSanitizer() {
            this(new AtomicBoolean(false));
        }

        public void start() {
            this.value.compareAndSet(false, true);
        }

        @Override
        public void close() {
            this.value.compareAndSet(true, false);
        }
    }

    private record DataSanitizationCodec<B, A>(StreamCodec<B, A> delegate, UnaryOperator<A> sanitizer) implements StreamCodec<B, A>
    {
        @Override
        public @NonNull A decode(@NonNull B buf) {
            return (A)this.delegate.decode(buf);
        }

        @Override
        public void encode(@NonNull B buf, @NonNull A value) {
            if (!DATA_SANITIZER.get().value().get()) {
                this.delegate.encode(buf, value);
            } else {
                this.delegate.encode(buf, this.sanitizer.apply(value));
            }
        }
    }
}

