/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.util.Waitable;

public final class MCUtil {
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MinecraftServer.getServer().execute(run);
        } else {
            run.run();
        }
    };
    public static final ThreadPoolExecutor asyncExecutor = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.k)).build());

    private MCUtil() {
    }

    public static List<ChunkCoordIntPair> getSpiralOutChunks(BlockPosition blockposition, int radius) {
        ArrayList list = Lists.newArrayList();
        list.add(new ChunkCoordIntPair(blockposition.u() >> 4, blockposition.w() >> 4));
        for (int r2 = 1; r2 <= radius; ++r2) {
            int x2 = -r2;
            int z2 = r2;
            while (x2 <= r2 && z2 > -r2) {
                list.add(new ChunkCoordIntPair(blockposition.u() + (x2 << 4) >> 4, blockposition.w() + (z2 << 4) >> 4));
                list.add(new ChunkCoordIntPair(blockposition.u() - (x2 << 4) >> 4, blockposition.w() - (z2 << 4) >> 4));
                if (x2 < r2) {
                    ++x2;
                    continue;
                }
                --z2;
            }
        }
        return list;
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r2 -> r2, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MinecraftServer.getServer().bx();
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.k.warn("Asynchronous " + reason + "!", (Throwable)new IllegalStateException());
            }
            MinecraftServer.getServer().processQueue.add(run);
            return;
        }
        run.run();
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.k.warn("Asynchronous " + reason + "! Blocking thread until it returns ", (Throwable)new IllegalStateException());
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MinecraftServer.getServer().processQueue.add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e2) {
                MinecraftServer.k.warn("Encountered exception", (Throwable)e2);
                return null;
            }
        }
        return run.get();
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(World world, double x2, double y2, double z2) {
        return new Location((org.bukkit.World)world.getWorld(), x2, y2, z2);
    }

    public static Location toLocation(World world, BlockPosition pos) {
        return new Location((org.bukkit.World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
    }

    public static BlockPosition toBlockPosition(Location loc) {
        return new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static BlockPosition toBlockPos(Position pos) {
        return new BlockPosition(pos.blockX(), pos.blockY(), pos.blockZ());
    }

    public static FinePosition toPosition(Vec3D vector) {
        return Position.fine((double)vector.c, (double)vector.d, (double)vector.e);
    }

    public static io.papermc.paper.math.BlockPosition toPosition(BaseBlockPosition vector) {
        return Position.block((int)vector.u(), (int)vector.v(), (int)vector.w());
    }

    public static Vec3D toVec3(Position position) {
        return new Vec3D(position.x(), position.y(), position.z());
    }

    public static boolean isEdgeOfChunk(BlockPosition pos) {
        int modX = pos.u() & 0xF;
        int modZ = pos.w() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        asyncExecutor.execute(run);
    }
}

