/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.FilteredText;

public class ArgumentChat
implements SignedArgument<a> {
    private static final Collection<String> a = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");
    static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((length, maxLength) -> IChatBaseComponent.b("argument.message.too_long", length, maxLength));

    public static ArgumentChat a() {
        return new ArgumentChat();
    }

    public static IChatBaseComponent a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        a message = (a)context.getArgument(name, a.class);
        return message.a((CommandListenerWrapper)context.getSource());
    }

    public static void a(CommandContext<CommandListenerWrapper> context, String name, Consumer<PlayerChatMessage> callback) throws CommandSyntaxException {
        a message = (a)context.getArgument(name, a.class);
        ArgumentChat.resolveChatMessage(message, context, name, callback);
    }

    public static void resolveChatMessage(a message, CommandContext<CommandListenerWrapper> context, String name, Consumer<PlayerChatMessage> callback) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        IChatBaseComponent component = message.a(commandSourceStack);
        CommandSigningContext commandSigningContext = commandSourceStack.n();
        PlayerChatMessage playerChatMessage = commandSigningContext.a(name);
        if (playerChatMessage != null) {
            ArgumentChat.a(callback, commandSourceStack, playerChatMessage.a(component));
        } else {
            ArgumentChat.b(callback, commandSourceStack, PlayerChatMessage.a(message.a).a(component));
        }
    }

    private static void a(Consumer<PlayerChatMessage> callback, CommandListenerWrapper source, PlayerChatMessage message) {
        MinecraftServer minecraftServer = source.l();
        CompletableFuture<FilteredText> completableFuture = ArgumentChat.a(source, message);
        CompletableFuture<IChatBaseComponent> componentFuture = minecraftServer.bm().decorate(source.i(), source, message.d());
        source.o().append(CompletableFuture.allOf(completableFuture, componentFuture), filtered -> {
            PlayerChatMessage playerChatMessage2 = message.a((IChatBaseComponent)componentFuture.join()).a(((FilteredText)completableFuture.join()).e());
            callback.accept(playerChatMessage2);
        });
    }

    private static void b(Consumer<PlayerChatMessage> callback, CommandListenerWrapper source, PlayerChatMessage message) {
        ChatDecorator chatDecorator = source.l().bm();
        CompletableFuture<IChatBaseComponent> componentFuture = chatDecorator.decorate(source.i(), source, message.d());
        source.o().append(componentFuture, result -> callback.accept(message.a((IChatBaseComponent)result)));
    }

    private static CompletableFuture<FilteredText> a(CommandListenerWrapper source, PlayerChatMessage message) {
        EntityPlayer serverPlayer = source.i();
        return serverPlayer != null && message.a(serverPlayer.cz()) ? serverPlayer.Y().a(message.c()) : CompletableFuture.completedFuture(FilteredText.a(message.c()));
    }

    public a a(StringReader stringReader) throws CommandSyntaxException {
        return net.minecraft.commands.arguments.ArgumentChat$a.a(stringReader, true);
    }

    public <S> a a(StringReader stringReader, @Nullable S object) throws CommandSyntaxException {
        return net.minecraft.commands.arguments.ArgumentChat$a.a(stringReader, ArgumentParserSelector.a(object));
    }

    public Collection<String> getExamples() {
        return a;
    }

    public record a(String a, b[] b) {
        IChatBaseComponent a(CommandListenerWrapper source) throws CommandSyntaxException {
            return this.a(source, ArgumentParserSelector.a(source));
        }

        public IChatBaseComponent a(CommandListenerWrapper source, boolean canUseSelectors) throws CommandSyntaxException {
            if (this.b.length != 0 && canUseSelectors) {
                IChatMutableComponent mutableComponent = IChatBaseComponent.b(this.a.substring(0, this.b[0].a()));
                int i2 = this.b[0].a();
                for (b part : this.b) {
                    IChatBaseComponent component = part.a(source);
                    if (i2 < part.a()) {
                        mutableComponent.f(this.a.substring(i2, part.a()));
                    }
                    mutableComponent.b(component);
                    i2 = part.b();
                }
                if (i2 < this.a.length()) {
                    mutableComponent.f(this.a.substring(i2));
                }
                return mutableComponent;
            }
            return IChatBaseComponent.b(this.a);
        }

        public static a a(StringReader reader, boolean allowAtSelectors) throws CommandSyntaxException {
            if (reader.getRemainingLength() > 256) {
                throw b.create((Object)reader.getRemainingLength(), (Object)256);
            }
            String string = reader.getRemaining();
            if (!allowAtSelectors) {
                reader.setCursor(reader.getTotalLength());
                return new a(string, new b[0]);
            }
            ArrayList list = Lists.newArrayList();
            int i2 = reader.getCursor();
            while (true) {
                EntitySelector entitySelector;
                int j2;
                block8: {
                    if (!reader.canRead()) {
                        return new a(string, list.toArray(new b[0]));
                    }
                    if (reader.peek() == '@') {
                        j2 = reader.getCursor();
                        try {
                            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(reader, true);
                            entitySelector = entitySelectorParser.t();
                            break block8;
                        }
                        catch (CommandSyntaxException var8) {
                            if (var8.getType() != ArgumentParserSelector.h && var8.getType() != ArgumentParserSelector.f) {
                                throw var8;
                            }
                            reader.setCursor(j2 + 1);
                            continue;
                        }
                    }
                    reader.skip();
                    continue;
                }
                list.add(new b(j2 - i2, reader.getCursor() - i2, entitySelector));
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "text;parts", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "text;parts", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "text;parts", "a", "b"}, this, o2);
        }
    }

    public record b(int a, int b, EntitySelector c) {
        public IChatBaseComponent a(CommandListenerWrapper source) throws CommandSyntaxException {
            return EntitySelector.a(this.c.b(source));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "start;end;selector", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "start;end;selector", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "start;end;selector", "a", "b", "c"}, this, o2);
        }
    }
}

