/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution;

import com.google.common.collect.Queues;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public class ExecutionContext<T>
implements AutoCloseable {
    private static final int a = 10000000;
    private static final Logger b = LogUtils.getLogger();
    private final int c;
    private final int d;
    private final GameProfilerFiller e;
    @Nullable
    private TraceCallbacks f;
    private int g;
    private boolean h;
    private final Deque<CommandQueueEntry<T>> i = Queues.newArrayDeque();
    private final List<CommandQueueEntry<T>> j = new ObjectArrayList();
    private int k;

    public ExecutionContext(int maxCommandChainLength, int maxCommandForkCount, GameProfilerFiller profiler) {
        this.c = maxCommandChainLength;
        this.d = maxCommandForkCount;
        this.e = profiler;
        this.g = maxCommandChainLength;
    }

    private static <T extends ExecutionCommandSource<T>> Frame a(ExecutionContext<T> context, CommandResultCallback returnValueConsumer) {
        if (context.k == 0) {
            return new Frame(0, returnValueConsumer, context.i::clear);
        }
        int i2 = context.k + 1;
        return new Frame(i2, returnValueConsumer, context.b(i2));
    }

    public static <T extends ExecutionCommandSource<T>> void a(ExecutionContext<T> context, InstantiatedFunction<T> procedure, T source, CommandResultCallback returnValueConsumer) {
        context.a(new CommandQueueEntry<T>(ExecutionContext.a(context, returnValueConsumer), new CallFunction<T>(procedure, source.p(), false).bind(source)));
    }

    public static <T extends ExecutionCommandSource<T>> void a(ExecutionContext<T> context, String command, ContextChain<T> contextChain, T source, CommandResultCallback returnValueConsumer) {
        context.a(new CommandQueueEntry<T>(ExecutionContext.a(context, returnValueConsumer), new BuildContexts.b<T>(command, contextChain, source)));
    }

    private void f() {
        this.h = true;
        this.j.clear();
        this.i.clear();
    }

    public void a(CommandQueueEntry<T> entry) {
        if (this.j.size() + this.i.size() > 10000000) {
            this.f();
        }
        if (!this.h) {
            this.j.add(entry);
        }
    }

    public void a(int depth) {
        while (!this.i.isEmpty() && this.i.peek().a().c() >= depth) {
            this.i.removeFirst();
        }
    }

    public Frame.a b(int depth) {
        return () -> this.a(depth);
    }

    public void a() {
        this.g();
        while (true) {
            if (this.g <= 0) {
                b.info("Command execution stopped due to limit (executed {} commands)", (Object)this.c);
                break;
            }
            CommandQueueEntry<T> commandQueueEntry = this.i.pollFirst();
            if (commandQueueEntry == null) {
                return;
            }
            this.k = commandQueueEntry.a().c();
            commandQueueEntry.a(this);
            if (this.h) {
                b.error("Command execution stopped due to command queue overflow (max {})", (Object)10000000);
                break;
            }
            this.g();
        }
        this.k = 0;
    }

    private void g() {
        for (int i2 = this.j.size() - 1; i2 >= 0; --i2) {
            this.i.addFirst(this.j.get(i2));
        }
        this.j.clear();
    }

    public void a(@Nullable TraceCallbacks tracer) {
        this.f = tracer;
    }

    @Nullable
    public TraceCallbacks b() {
        return this.f;
    }

    public GameProfilerFiller c() {
        return this.e;
    }

    public int d() {
        return this.d;
    }

    public void e() {
        --this.g;
    }

    @Override
    @Override
    public void close() {
        if (this.f != null) {
            this.f.close();
        }
    }
}

