/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.c<T>> b();

    default public Stream<ResourceKey<T>> c() {
        return this.b().map(Holder.c::h);
    }

    public Stream<HolderSet.Named<T>> d();

    default public Stream<TagKey<T>> e() {
        return this.d().map(HolderSet.Named::g);
    }

    public static interface a {
        public Stream<ResourceKey<? extends IRegistry<?>>> a();

        public <T> Optional<b<T>> a(ResourceKey<? extends IRegistry<? extends T>> var1);

        default public <T> b<T> b(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
            return this.a(registryRef).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(registryRef.a()) + " not found"));
        }

        default public <V> RegistryOps<V> a(DynamicOps<V> delegate) {
            return RegistryOps.a(delegate, this);
        }

        default public HolderGetter.a b() {
            return new HolderGetter.a(){

                @Override
                @Override
                public <T> Optional<HolderGetter<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                    return this.a(registryRef).map(lookup -> lookup);
                }
            };
        }

        public static a a(Stream<b<?>> wrappers) {
            final Map<ResourceKey, b> map = wrappers.collect(Collectors.toUnmodifiableMap(b::f, wrapper -> wrapper));
            return new a(){

                @Override
                @Override
                public Stream<ResourceKey<? extends IRegistry<?>>> a() {
                    return map.keySet().stream();
                }

                @Override
                @Override
                public <T> Optional<b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                    return Optional.ofNullable((b)map.get(registryRef));
                }
            };
        }
    }

    public static interface b<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends IRegistry<? extends T>> f();

        public Lifecycle g();

        default public b<T> a(FeatureFlagSet enabledFeatures) {
            if (FeatureElement.bA.contains(this.f())) {
                return this.a((T feature) -> ((FeatureElement)feature).a(enabledFeatures));
            }
            return this;
        }

        default public b<T> a(final Predicate<T> predicate) {
            return new a<T>(){

                @Override
                @Override
                public b<T> a() {
                    return this;
                }

                @Override
                @Override
                public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                    return this.a().a(key).filter(entry -> predicate.test(entry.a()));
                }

                @Override
                @Override
                public Stream<Holder.c<T>> b() {
                    return this.a().b().filter(entry -> predicate.test(entry.a()));
                }
            };
        }

        public static interface a<T>
        extends b<T> {
            public b<T> a();

            @Override
            @Override
            default public ResourceKey<? extends IRegistry<? extends T>> f() {
                return this.a().f();
            }

            @Override
            @Override
            default public Lifecycle g() {
                return this.a().g();
            }

            @Override
            @Override
            default public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return this.a().a(key);
            }

            @Override
            @Override
            default public Stream<Holder.c<T>> b() {
                return this.a().b();
            }

            @Override
            @Override
            default public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return this.a().a(tag);
            }

            @Override
            @Override
            default public Stream<HolderSet.Named<T>> d() {
                return this.a().d();
            }
        }
    }
}

