/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.RegistryLayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.EnchantmentProviderTypes;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger aB = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> aC = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> aD = new RegistryMaterials(ResourceKey.a(Registries.a), Lifecycle.stable());
    public static final RegistryBlocks<GameEvent> a = BuiltInRegistries.a(Registries.G, "step", GameEvent::a);
    public static final IRegistry<SoundEffect> b = BuiltInRegistries.a(Registries.al, (IRegistry<T> registry) -> SoundEffects.nC);
    public static final RegistryBlocks<FluidType> c = BuiltInRegistries.b(Registries.D, "empty", registry -> FluidTypes.a);
    public static final IRegistry<MobEffectList> d = BuiltInRegistries.a(Registries.W, MobEffects::a);
    public static final RegistryBlocks<Block> e = BuiltInRegistries.b(Registries.f, "air", registry -> Blocks.a);
    public static final RegistryBlocks<EntityTypes<?>> f = BuiltInRegistries.b(Registries.z, "pig", registry -> EntityTypes.az);
    public static final RegistryBlocks<Item> g = BuiltInRegistries.b(Registries.K, "air", registry -> Items.a);
    public static final IRegistry<PotionRegistry> h = BuiltInRegistries.a(Registries.ad, Potions::a);
    public static final IRegistry<Particle<?>> i = BuiltInRegistries.a(Registries.Y, (IRegistry<T> registry) -> Particles.b);
    public static final IRegistry<TileEntityTypes<?>> j = BuiltInRegistries.b(Registries.h, registry -> TileEntityTypes.a);
    public static final IRegistry<MinecraftKey> k = BuiltInRegistries.a(Registries.r, (IRegistry<T> registry) -> StatisticList.E);
    public static final RegistryBlocks<ChunkStatus> l = BuiltInRegistries.a(Registries.o, "empty", (IRegistry<T> registry) -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> m = BuiltInRegistries.a(Registries.ah, (IRegistry<T> registry) -> DefinedStructureRuleTestType.a);
    public static final IRegistry<RuleBlockEntityModifierType<?>> n = BuiltInRegistries.a(Registries.ai, (IRegistry<T> registry) -> RuleBlockEntityModifierType.b);
    public static final IRegistry<PosRuleTestType<?>> o = BuiltInRegistries.a(Registries.ac, (IRegistry<T> registry) -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> p = BuiltInRegistries.a(Registries.V, (IRegistry<T> registry) -> Containers.i);
    public static final IRegistry<Recipes<?>> q = BuiltInRegistries.a(Registries.af, (IRegistry<T> registry) -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> r = BuiltInRegistries.a(Registries.ae, (IRegistry<T> registry) -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> s = BuiltInRegistries.a(Registries.c, GenericAttributes::a);
    public static final IRegistry<PositionSourceType<?>> t = BuiltInRegistries.a(Registries.ab, (IRegistry<T> registry) -> PositionSourceType.a);
    public static final IRegistry<ArgumentTypeInfo<?, ?>> u = BuiltInRegistries.a(Registries.p, ArgumentTypeInfos::a);
    public static final IRegistry<StatisticWrapper<?>> v = BuiltInRegistries.a(Registries.am, (IRegistry<T> registry) -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> w = BuiltInRegistries.a(Registries.aw, "plains", (IRegistry<T> registry) -> VillagerType.c);
    public static final RegistryBlocks<VillagerProfession> x = BuiltInRegistries.a(Registries.av, "none", (IRegistry<T> registry) -> VillagerProfession.b);
    public static final IRegistry<VillagePlaceType> y = BuiltInRegistries.a(Registries.aa, PoiTypes::a);
    public static final RegistryBlocks<MemoryModuleType<?>> z = BuiltInRegistries.a(Registries.U, "dummy", (IRegistry<T> registry) -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> A = BuiltInRegistries.a(Registries.ak, "dummy", (IRegistry<T> registry) -> SensorType.a);
    public static final IRegistry<Schedule> B = BuiltInRegistries.a(Registries.aj, (IRegistry<T> registry) -> Schedule.c);
    public static final IRegistry<Activity> C = BuiltInRegistries.a(Registries.b, (IRegistry<T> registry) -> Activity.b);
    public static final IRegistry<LootEntryType> D = BuiltInRegistries.a(Registries.Q, (IRegistry<T> registry) -> LootEntries.b);
    public static final IRegistry<LootItemFunctionType<?>> E = BuiltInRegistries.a(Registries.N, (IRegistry<T> registry) -> LootItemFunctions.e);
    public static final IRegistry<LootItemConditionType> F = BuiltInRegistries.a(Registries.M, (IRegistry<T> registry) -> LootItemConditions.a);
    public static final IRegistry<LootNumberProviderType> G = BuiltInRegistries.a(Registries.P, (IRegistry<T> registry) -> NumberProviders.b);
    public static final IRegistry<LootNbtProviderType> H = BuiltInRegistries.a(Registries.O, (IRegistry<T> registry) -> NbtProviders.c);
    public static final IRegistry<LootScoreProviderType> I = BuiltInRegistries.a(Registries.R, (IRegistry<T> registry) -> ScoreboardNameProviders.c);
    public static final IRegistry<FloatProviderType<?>> J = BuiltInRegistries.a(Registries.C, (IRegistry<T> registry) -> FloatProviderType.a);
    public static final IRegistry<IntProviderType<?>> K = BuiltInRegistries.a(Registries.J, (IRegistry<T> registry) -> IntProviderType.a);
    public static final IRegistry<HeightProviderType<?>> L = BuiltInRegistries.a(Registries.H, (IRegistry<T> registry) -> HeightProviderType.a);
    public static final IRegistry<BlockPredicateType<?>> M = BuiltInRegistries.a(Registries.i, (IRegistry<T> registry) -> BlockPredicateType.k);
    public static final IRegistry<WorldGenCarverAbstract<?>> N = BuiltInRegistries.a(Registries.k, (IRegistry<T> registry) -> WorldGenCarverAbstract.a);
    public static final IRegistry<WorldGenerator<?>> O = BuiltInRegistries.a(Registries.A, (IRegistry<T> registry) -> WorldGenerator.I);
    public static final IRegistry<StructurePlacementType<?>> P = BuiltInRegistries.a(Registries.ao, (IRegistry<T> registry) -> StructurePlacementType.a);
    public static final IRegistry<WorldGenFeatureStructurePieceType> Q = BuiltInRegistries.a(Registries.an, (IRegistry<T> registry) -> WorldGenFeatureStructurePieceType.c);
    public static final IRegistry<StructureType<?>> R = BuiltInRegistries.a(Registries.as, (IRegistry<T> registry) -> StructureType.f);
    public static final IRegistry<PlacementModifierType<?>> S = BuiltInRegistries.a(Registries.Z, (IRegistry<T> registry) -> PlacementModifierType.f);
    public static final IRegistry<WorldGenFeatureStateProviders<?>> T = BuiltInRegistries.a(Registries.j, (IRegistry<T> registry) -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> U = BuiltInRegistries.a(Registries.E, (IRegistry<T> registry) -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> V = BuiltInRegistries.a(Registries.au, (IRegistry<T> registry) -> TrunkPlacers.a);
    public static final IRegistry<RootPlacerType<?>> W = BuiltInRegistries.a(Registries.ag, (IRegistry<T> registry) -> RootPlacerType.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> X = BuiltInRegistries.a(Registries.at, (IRegistry<T> registry) -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> Y = BuiltInRegistries.a(Registries.B, (IRegistry<T> registry) -> FeatureSizeType.a);
    public static final IRegistry<MapCodec<? extends WorldChunkManager>> Z = BuiltInRegistries.a(Registries.e, BiomeSources::a);
    public static final IRegistry<MapCodec<? extends ChunkGenerator>> aa = BuiltInRegistries.a(Registries.n, ChunkGenerators::a);
    public static final IRegistry<MapCodec<? extends SurfaceRules.f>> ab = BuiltInRegistries.a(Registries.S, SurfaceRules.f::a);
    public static final IRegistry<MapCodec<? extends SurfaceRules.o>> ac = BuiltInRegistries.a(Registries.T, SurfaceRules.o::a);
    public static final IRegistry<MapCodec<? extends DensityFunction>> ad = BuiltInRegistries.a(Registries.t, DensityFunctions::a);
    public static final IRegistry<MapCodec<? extends Block>> ae = BuiltInRegistries.a(Registries.g, BlockTypes::a);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> af = BuiltInRegistries.a(Registries.ar, (IRegistry<T> registry) -> DefinedStructureStructureProcessorType.e);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> ag = BuiltInRegistries.a(Registries.ap, (IRegistry<T> registry) -> WorldGenFeatureDefinedStructurePools.d);
    public static final IRegistry<MapCodec<? extends PoolAliasBinding>> ah = BuiltInRegistries.a(Registries.aq, PoolAliasBindings::a);
    public static final IRegistry<CatVariant> ai = BuiltInRegistries.a(Registries.l, CatVariant::a);
    public static final IRegistry<FrogVariant> aj = BuiltInRegistries.a(Registries.F, FrogVariant::a);
    public static final IRegistry<Instrument> ak = BuiltInRegistries.a(Registries.I, Instruments::a);
    public static final IRegistry<DecoratedPotPattern> al = BuiltInRegistries.a(Registries.ax, DecoratedPotPatterns::a);
    public static final IRegistry<CreativeModeTab> am = BuiltInRegistries.a(Registries.q, CreativeModeTabs::a);
    public static final IRegistry<CriterionTrigger<?>> an = BuiltInRegistries.a(Registries.aV, CriterionTriggers::a);
    public static final IRegistry<NumberFormatType<?>> ao = BuiltInRegistries.a(Registries.ay, NumberFormatTypes::a);
    public static final IRegistry<ArmorMaterial> ap = BuiltInRegistries.a(Registries.az, EnumArmorMaterial::a);
    public static final IRegistry<DataComponentType<?>> aq = BuiltInRegistries.a(Registries.aA, DataComponents::a);
    public static final IRegistry<MapCodec<? extends EntitySubPredicate>> ar = BuiltInRegistries.a(Registries.aB, EntitySubPredicates::a);
    public static final IRegistry<ItemSubPredicate.a<?>> as = BuiltInRegistries.a(Registries.aC, ItemSubPredicates::a);
    public static final IRegistry<MapDecorationType> at = BuiltInRegistries.a(Registries.aD, MapDecorationTypes::a);
    public static final IRegistry<DataComponentType<?>> au = BuiltInRegistries.a(Registries.aE, EnchantmentEffectComponents::a);
    public static final IRegistry<MapCodec<? extends LevelBasedValue>> av = BuiltInRegistries.a(Registries.v, LevelBasedValue::a);
    public static final IRegistry<MapCodec<? extends EnchantmentEntityEffect>> aw = BuiltInRegistries.a(Registries.u, EnchantmentEntityEffect::a);
    public static final IRegistry<MapCodec<? extends EnchantmentLocationBasedEffect>> ax = BuiltInRegistries.a(Registries.w, EnchantmentLocationBasedEffect::b);
    public static final IRegistry<MapCodec<? extends EnchantmentValueEffect>> ay = BuiltInRegistries.a(Registries.y, EnchantmentValueEffect::a);
    public static final IRegistry<MapCodec<? extends EnchantmentProvider>> az = BuiltInRegistries.a(Registries.x, EnchantmentProviderTypes::a);
    public static final IRegistry<? extends IRegistry<?>> aA = aD;
    public static final Conversions BUILT_IN_CONVERSIONS = new Conversions(new RegistryOps.c(){

        @Override
        public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
            IRegistry registry = RegistryLayer.f.d(registryRef);
            return Optional.of(new RegistryOps.b(registry.q(), registry.v(), Lifecycle.experimental()));
        }
    });

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, a<T> initializer) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, Lifecycle.stable(), false), initializer);
    }

    private static <T> IRegistry<T> b(ResourceKey<? extends IRegistry<T>> key, a<T> initializer) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, Lifecycle.stable(), true), initializer);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> initializer) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultId, key, Lifecycle.stable(), false), initializer);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> initializer) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultId, key, Lifecycle.stable(), true), initializer);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> key, R registry, a<T> initializer) {
        DispenserRegistry.a(() -> "registry " + String.valueOf(key));
        PaperRegistryAccess.instance().registerRegistry(registry.d(), registry);
        MinecraftKey resourceLocation = key.a();
        aC.put(resourceLocation, () -> initializer.run(registry));
        aD.a(key, registry, RegistrationInfo.a);
        return registry;
    }

    public static void a() {
        BuiltInRegistries.bootStrap(() -> {});
    }

    public static void bootStrap(Runnable runnable) {
        aA.m();
        BuiltInRegistries.b();
        runnable.run();
        BuiltInRegistries.c();
        BuiltInRegistries.a(aA);
    }

    private static void b() {
        aC.forEach((id, initializer) -> {
            if (initializer.get() == null) {
                aB.error("Unable to bootstrap registry '{}'", id);
            }
        });
    }

    private static void c() {
        aA.m();
        for (IRegistry iRegistry : aA) {
            PaperRegistryListenerManager.INSTANCE.runFreezeListeners(iRegistry.d(), BUILT_IN_CONVERSIONS);
            iRegistry.m();
        }
    }

    private static <T extends IRegistry<?>> void a(IRegistry<T> registries) {
        registries.forEach(registry -> {
            if (registry.f().isEmpty()) {
                SystemUtils.b("Registry '" + String.valueOf(registries.b(registry)) + "' was empty after loading");
            }
            if (registry instanceof RegistryBlocks) {
                MinecraftKey resourceLocation = ((RegistryBlocks)registry).b();
                Validate.notNull(registry.a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + String.valueOf(resourceLocation)), (Object[])new Object[0]);
            }
        });
    }

    @FunctionalInterface
    static interface a<T> {
        public Object run(IRegistry<T> var1);
    }
}

