/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;

public abstract class EntityLootSubProvider
implements LootTableSubProvider {
    private static final Set<EntityTypes<?>> b = ImmutableSet.of(EntityTypes.by, EntityTypes.d, EntityTypes.af, EntityTypes.aS, EntityTypes.bj);
    protected final HolderLookup.a a;
    private final FeatureFlagSet c;
    private final FeatureFlagSet d;
    private final Map<EntityTypes<?>, Map<ResourceKey<LootTable>, LootTable.a>> e = Maps.newHashMap();

    protected final AnyOfCondition.a a() {
        HolderLookup.b<Enchantment> registryLookup = this.a.b(Registries.aL);
        return AnyOfCondition.a(LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, CriterionConditionEntity.a.a().a(CriterionConditionEntityFlags.a.a().b(true))), LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.c, CriterionConditionEntity.a.a().a(CriterionConditionEntityEquipment.a.a().f(CriterionConditionItem.a.a().a(ItemSubPredicates.b, ItemEnchantmentsPredicate.a(List.of(new CriterionConditionEnchantments(registryLookup.b(EnchantmentTags.p), CriterionConditionValue.IntegerRange.c))))))));
    }

    protected EntityLootSubProvider(FeatureFlagSet requiredFeatures, HolderLookup.a registryLookup) {
        this(requiredFeatures, requiredFeatures, registryLookup);
    }

    protected EntityLootSubProvider(FeatureFlagSet requiredFeatures, FeatureFlagSet featureSet, HolderLookup.a registryLookup) {
        this.c = requiredFeatures;
        this.d = featureSet;
        this.a = registryLookup;
    }

    protected static LootTable.a a(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(item))).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(NestedLootTable.a(EntityTypes.aJ.k())));
    }

    public abstract void b();

    @Override
    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.a> lootTableBiConsumer) {
        this.b();
        HashSet set = new HashSet();
        BuiltInRegistries.f.i().forEach(entityType -> {
            EntityTypes entityType2 = (EntityTypes)entityType.a();
            if (!entityType2.a(this.c)) {
                return;
            }
            if (EntityLootSubProvider.a(entityType2)) {
                Map<ResourceKey<LootTable>, LootTable.a> map = this.e.remove(entityType2);
                ResourceKey<LootTable> resourceKey2 = entityType2.k();
                if (resourceKey2 != LootTables.a && entityType2.a(this.d) && (map == null || !map.containsKey(resourceKey2))) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourceKey2, entityType.h().a()));
                }
                if (map != null) {
                    map.forEach((tableKey, lootTableBuilder) -> {
                        if (!set.add(tableKey)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", tableKey, entityType.h().a()));
                        }
                        lootTableBiConsumer.accept((ResourceKey<LootTable>)tableKey, (LootTable.a)lootTableBuilder);
                    });
                }
            } else {
                Map<ResourceKey<LootTable>, LootTable.a> map2 = this.e.remove(entityType2);
                if (map2 != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map2.keySet().stream().map(resourceKey -> resourceKey.a().toString()).collect(Collectors.joining(",")), entityType.h().a()));
                }
            }
        });
        if (!this.e.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + String.valueOf(this.e.keySet()));
        }
    }

    private static boolean a(EntityTypes<?> entityType) {
        return b.contains(entityType) || entityType.f() != EnumCreatureType.h;
    }

    protected LootItemCondition.a c() {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(EntityTypes.R)));
    }

    protected LootItemCondition.a a(ResourceKey<FrogVariant> frogVariant) {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(EntityTypes.R).a(EntitySubPredicates.b(BuiltInRegistries.aj.g(frogVariant)))));
    }

    protected void a(EntityTypes<?> entityType, LootTable.a lootTable) {
        this.a(entityType, entityType.k(), lootTable);
    }

    protected void a(EntityTypes<?> entityType, ResourceKey<LootTable> tableKey, LootTable.a lootTable) {
        this.e.computeIfAbsent(entityType, type -> new HashMap()).put(tableKey, lootTable);
    }
}

