/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.Tilt;

public class BlockModelGenerators {
    final Consumer<BlockStateGenerator> b;
    final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;
    private final Consumer<Item> d;
    final List<Block> e = ImmutableList.of((Object)Blocks.ey, (Object)Blocks.eE, (Object)Blocks.hY);
    final Map<Block, c> f = ImmutableMap.builder().put((Object)Blocks.b, BlockModelGenerators::a).put((Object)Blocks.sJ, BlockModelGenerators::c).put((Object)Blocks.eM, BlockModelGenerators::b).build();
    final Map<Block, TexturedModel> g = ImmutableMap.builder().put((Object)Blocks.aV, (Object)TexturedModel.y.get(Blocks.aV)).put((Object)Blocks.jp, (Object)TexturedModel.y.get(Blocks.jp)).put((Object)Blocks.jS, (Object)TexturedModel.a(TextureMapping.a(Blocks.aV, "_top"))).put((Object)Blocks.jU, (Object)TexturedModel.a(TextureMapping.a(Blocks.jp, "_top"))).put((Object)Blocks.aX, (Object)TexturedModel.d.get(Blocks.aV).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.G(Blocks.aX)))).put((Object)Blocks.jr, (Object)TexturedModel.d.get(Blocks.jp).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.G(Blocks.jr)))).put((Object)Blocks.hd, (Object)TexturedModel.d.get(Blocks.hd)).put((Object)Blocks.jT, (Object)TexturedModel.a(TextureMapping.a(Blocks.hd, "_bottom"))).put((Object)Blocks.pr, (Object)TexturedModel.z.get(Blocks.pr)).put((Object)Blocks.sJ, (Object)TexturedModel.z.get(Blocks.sJ)).put((Object)Blocks.he, (Object)TexturedModel.d.get(Blocks.he).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.G(Blocks.he)))).put((Object)Blocks.aW, (Object)TexturedModel.d.get(Blocks.aW).a((TextureMapping textures) -> {
        textures.a(TextureSlot.d, TextureMapping.a(Blocks.aV, "_top"));
        textures.a(TextureSlot.i, TextureMapping.G(Blocks.aW));
    })).put((Object)Blocks.jq, (Object)TexturedModel.d.get(Blocks.jq).a((TextureMapping textures) -> {
        textures.a(TextureSlot.d, TextureMapping.a(Blocks.jp, "_top"));
        textures.a(TextureSlot.i, TextureMapping.G(Blocks.jq));
    })).put((Object)Blocks.qM, (Object)TexturedModel.z.get(Blocks.qM)).put((Object)Blocks.qH, (Object)TexturedModel.z.get(Blocks.qH)).build();
    static final Map<BlockFamily.b, BiConsumer<b, Block>> h = ImmutableMap.builder().put((Object)BlockFamily.b.a, b::a).put((Object)BlockFamily.b.e, b::l).put((Object)BlockFamily.b.b, b::k).put((Object)BlockFamily.b.c, b::k).put((Object)BlockFamily.b.f, b::c).put((Object)BlockFamily.b.g, b::d).put((Object)BlockFamily.b.h, b::e).put((Object)BlockFamily.b.i, b::f).put((Object)BlockFamily.b.k, b::h).put((Object)BlockFamily.b.l, b::i).put((Object)BlockFamily.b.m, b::j).put((Object)BlockFamily.b.n, b::g).put((Object)BlockFamily.b.p, b::m).put((Object)BlockFamily.b.q, b::b).build();
    public static final List<Pair<BlockStateBoolean, Function<MinecraftKey, Variant>>> a = List.of(Pair.of((Object)BlockProperties.L, model -> Variant.a().a(VariantProperties.c, model)), Pair.of((Object)BlockProperties.M, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.N, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.O, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.J, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.K, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    private static final Map<d, MinecraftKey> i = new HashMap<d, MinecraftKey>();

    private static BlockStateGenerator a(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.e.a(block, textures, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation);
    }

    private static BlockStateGenerator b(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.f.a(block, textures, modelCollector);
        return BlockModelGenerators.c(block, resourceLocation);
    }

    private static BlockStateGenerator c(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.l.a(block, textures, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation).a(BlockModelGenerators.f());
    }

    public BlockModelGenerators(Consumer<BlockStateGenerator> blockStateCollector, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector, Consumer<Item> simpleItemModelExemptionCollector) {
        this.b = blockStateCollector;
        this.c = modelCollector;
        this.d = simpleItemModelExemptionCollector;
    }

    void c(Block block) {
        this.d.accept(block.r());
    }

    void a(Block block, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(block.r()), new DelegatedModel(parentModelId));
    }

    private void a(Item item, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(item), new DelegatedModel(parentModelId));
    }

    void a(Item item) {
        ModelTemplates.bx.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void d(Block block) {
        Item item = block.r();
        if (item != Items.a) {
            ModelTemplates.bx.a(ModelLocationUtils.a(item), TextureMapping.F(block), this.c);
        }
    }

    private void a(Block block, String textureSuffix) {
        Item item = block.r();
        ModelTemplates.bx.a(ModelLocationUtils.a(item), TextureMapping.k(TextureMapping.a(block, textureSuffix)), this.c);
    }

    private static PropertyDispatch b() {
        return PropertyDispatch.a(BlockProperties.R).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a());
    }

    private static PropertyDispatch c() {
        return PropertyDispatch.a(BlockProperties.R).a(EnumDirection.d, Variant.a()).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch d() {
        return PropertyDispatch.a(BlockProperties.R).a(EnumDirection.f, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch e() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.b, Variant.a().a(VariantProperties.a, VariantProperties.a.d)).a(EnumDirection.c, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b));
    }

    private static MultiVariantGenerator b(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, BlockModelGenerators.a(modelId));
    }

    private static Variant[] a(MinecraftKey modelId) {
        return new Variant[]{Variant.a().a(VariantProperties.c, modelId), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.d)};
    }

    private static MultiVariantGenerator a(Block block, MinecraftKey firstModelId, MinecraftKey secondModelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, firstModelId), Variant.a().a(VariantProperties.c, secondModelId), Variant.a().a(VariantProperties.c, firstModelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, secondModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static PropertyDispatch a(BlockStateBoolean property, MinecraftKey trueModel, MinecraftKey falseModel) {
        return PropertyDispatch.a(property).a((Boolean)true, Variant.a().a(VariantProperties.c, trueModel)).a((Boolean)false, Variant.a().a(VariantProperties.c, falseModel));
    }

    private void e(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.c.create(block, this.c);
        this.b.accept(BlockModelGenerators.a(block, resourceLocation, resourceLocation2));
    }

    private void f(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        this.b.accept(BlockModelGenerators.b(block, resourceLocation));
    }

    private void g(Block block) {
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.bv).a((T1 dusted) -> {
            String string = "_" + dusted;
            MinecraftKey resourceLocation = TextureMapping.a(block, string);
            return Variant.a().a(VariantProperties.c, ModelTemplates.c.a(block, string, new TextureMapping().a(TextureSlot.a, resourceLocation), this.c));
        })));
        this.a(block, TextureMapping.a(block, "_0"));
    }

    static BlockStateGenerator b(Block buttonBlock, MinecraftKey regularModelId, MinecraftKey pressedModelId) {
        return MultiVariantGenerator.a(buttonBlock).a(PropertyDispatch.a(BlockProperties.w).a((Boolean)false, Variant.a().a(VariantProperties.c, regularModelId)).a((Boolean)true, Variant.a().a(VariantProperties.c, pressedModelId))).a(PropertyDispatch.a(BlockProperties.U, BlockProperties.R).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c)));
    }

    private static PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> a(PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> variantMap, BlockPropertyDoubleBlockHalf targetHalf, MinecraftKey leftHingeClosedModelId, MinecraftKey leftHingeOpenModelId, MinecraftKey rightHingeClosedModelId, MinecraftKey rightHingeOpenModelId) {
        return variantMap.a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static BlockStateGenerator a(Block doorBlock, MinecraftKey bottomLeftHingeClosedModelId, MinecraftKey bottomLeftHingeOpenModelId, MinecraftKey bottomRightHingeClosedModelId, MinecraftKey bottomRightHingeOpenModelId, MinecraftKey topLeftHingeClosedModelId, MinecraftKey topLeftHingeOpenModelId, MinecraftKey topRightHingeClosedModelId, MinecraftKey topRightHingeOpenModelId) {
        return MultiVariantGenerator.a(doorBlock).a(BlockModelGenerators.a(BlockModelGenerators.a(PropertyDispatch.a(BlockProperties.R, BlockProperties.ae, BlockProperties.be, BlockProperties.u), BlockPropertyDoubleBlockHalf.b, bottomLeftHingeClosedModelId, bottomLeftHingeOpenModelId, bottomRightHingeClosedModelId, bottomRightHingeOpenModelId), BlockPropertyDoubleBlockHalf.a, topLeftHingeClosedModelId, topLeftHingeOpenModelId, topRightHingeClosedModelId, topRightHingeOpenModelId));
    }

    static BlockStateGenerator a(Block customFenceBlock, MinecraftKey postModelId, MinecraftKey northModelId, MinecraftKey eastModelId, MinecraftKey southModelId, MinecraftKey westModelId) {
        return MultiPartGenerator.a(customFenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, northModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, eastModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, southModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, westModelId).a(VariantProperties.d, false));
    }

    static BlockStateGenerator c(Block fenceBlock, MinecraftKey postModelId, MinecraftKey sideModelId) {
        return MultiPartGenerator.a(fenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block wallBlock, MinecraftKey postModelId, MinecraftKey lowSideModelId, MinecraftKey tallSideModelId) {
        return MultiPartGenerator.a(wallBlock).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.W, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.W, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block fenceGateBlock, MinecraftKey openModelId, MinecraftKey closedModelId, MinecraftKey openWallModelId, MinecraftKey closedWallModelId, boolean uvlock) {
        return MultiVariantGenerator.a(fenceGateBlock, Variant.a().a(VariantProperties.d, uvlock)).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.q, BlockProperties.u).a((Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, closedModelId)).a((Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, closedWallModelId)).a((Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a((Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, openWallModelId)));
    }

    static BlockStateGenerator b(Block stairsBlock, MinecraftKey innerModelId, MinecraftKey regularModelId, MinecraftKey outerModelId) {
        return MultiVariantGenerator.a(stairsBlock).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.af, BlockProperties.bi).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)));
    }

    private static BlockStateGenerator c(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.af, BlockProperties.u).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.a)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private static BlockStateGenerator d(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.af, BlockProperties.u).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)));
    }

    static MultiVariantGenerator c(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId));
    }

    private static PropertyDispatch f() {
        return PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.b, Variant.a()).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    static BlockStateGenerator a(Block block, TextureMapping textureMap, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.g.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation2 = ModelTemplates.h.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation3 = ModelTemplates.i.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation4 = ModelTemplates.j.a(block, textureMap, modelCollector);
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation4)).a(PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, resourceLocation3)));
    }

    static BlockStateGenerator d(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId)).a(BlockModelGenerators.f());
    }

    private void e(Block block, MinecraftKey modelId) {
        this.b.accept(BlockModelGenerators.d(block, modelId));
    }

    public void a(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation));
    }

    private void c(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    static BlockStateGenerator d(Block block, MinecraftKey verticalModelId, MinecraftKey horizontalModelId) {
        return MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, verticalModelId)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private void a(Block block, TexturedModel.a verticalModelFactory, TexturedModel.a horizontalModelFactory) {
        MinecraftKey resourceLocation = verticalModelFactory.create(block, this.c);
        MinecraftKey resourceLocation2 = horizontalModelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation, resourceLocation2));
    }

    private MinecraftKey a(Block block, String suffix, ModelTemplate model, Function<MinecraftKey, TextureMapping> texturesFactory) {
        return model.a(block, suffix, texturesFactory.apply(TextureMapping.a(block, suffix)), this.c);
    }

    static BlockStateGenerator e(Block pressurePlateBlock, MinecraftKey upModelId, MinecraftKey downModelId) {
        return MultiVariantGenerator.a(pressurePlateBlock).a(BlockModelGenerators.a(BlockProperties.w, downModelId, upModelId));
    }

    static BlockStateGenerator e(Block slabBlock, MinecraftKey bottomModelId, MinecraftKey topModelId, MinecraftKey fullModelId) {
        return MultiVariantGenerator.a(slabBlock).a(PropertyDispatch.a(BlockProperties.bh).a(BlockPropertySlabType.b, Variant.a().a(VariantProperties.c, bottomModelId)).a(BlockPropertySlabType.a, Variant.a().a(VariantProperties.c, topModelId)).a(BlockPropertySlabType.c, Variant.a().a(VariantProperties.c, fullModelId)));
    }

    public void a(Block block) {
        this.b(block, TexturedModel.a);
    }

    public void b(Block block, TexturedModel.a modelFactory) {
        this.b.accept(BlockModelGenerators.c(block, modelFactory.create(block, this.c)));
    }

    private void a(Block block, TextureMapping textures, ModelTemplate model) {
        MinecraftKey resourceLocation = model.a(block, textures, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private b h(Block block) {
        TexturedModel texturedModel = this.g.getOrDefault(block, TexturedModel.a.get(block));
        return new b(texturedModel.b()).a(block, texturedModel.a());
    }

    public void a(Block strippedLog, Block hangingSign, Block wallHangingSign) {
        TextureMapping textureMapping = TextureMapping.u(strippedLog);
        MinecraftKey resourceLocation = ModelTemplates.aa.a(hangingSign, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(hangingSign, resourceLocation));
        this.b.accept(BlockModelGenerators.c(wallHangingSign, resourceLocation));
        this.a(hangingSign.r());
        this.c(wallHangingSign);
    }

    void i(Block doorBlock) {
        TextureMapping textureMapping = TextureMapping.t(doorBlock);
        MinecraftKey resourceLocation = ModelTemplates.v.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.w.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.x.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.y.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.z.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.A.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.B.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.C.a(doorBlock, textureMapping, this.c);
        this.a(doorBlock.r());
        this.b.accept(BlockModelGenerators.a(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8));
    }

    private void a(Block parent, Block doorBlock) {
        MinecraftKey resourceLocation = ModelTemplates.v.a(parent);
        MinecraftKey resourceLocation2 = ModelTemplates.w.a(parent);
        MinecraftKey resourceLocation3 = ModelTemplates.x.a(parent);
        MinecraftKey resourceLocation4 = ModelTemplates.y.a(parent);
        MinecraftKey resourceLocation5 = ModelTemplates.z.a(parent);
        MinecraftKey resourceLocation6 = ModelTemplates.A.a(parent);
        MinecraftKey resourceLocation7 = ModelTemplates.B.a(parent);
        MinecraftKey resourceLocation8 = ModelTemplates.C.a(parent);
        this.a(doorBlock, ModelLocationUtils.a(parent.r()));
        this.b.accept(BlockModelGenerators.a(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8));
    }

    void j(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.ak.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.al.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.am.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    void k(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.ah.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ai.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aj.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    private void b(Block parent, Block trapdoorBlock) {
        MinecraftKey resourceLocation = ModelTemplates.ah.a(parent);
        MinecraftKey resourceLocation2 = ModelTemplates.ai.a(parent);
        MinecraftKey resourceLocation3 = ModelTemplates.aj.a(parent);
        this.a(trapdoorBlock, ModelLocationUtils.a(parent.r()));
        this.b.accept(BlockModelGenerators.d(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
    }

    private void g() {
        this.c(Blocks.sD);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.sD);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.sD, "_partial_tilt");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.sD, "_full_tilt");
        this.b.accept(MultiVariantGenerator.a(Blocks.sD).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.bl).a(Tilt.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.b, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(Tilt.d, Variant.a().a(VariantProperties.c, resourceLocation3))));
    }

    private f l(Block logBlock) {
        return new f(TextureMapping.n(logBlock));
    }

    private void m(Block block) {
        this.c(block, block);
    }

    private void c(Block block, Block modelReference) {
        this.b.accept(BlockModelGenerators.c(block, ModelLocationUtils.a(modelReference)));
    }

    private void a(Block block, e tintType) {
        this.d(block);
        this.b(block, tintType);
    }

    private void a(Block block, e tintType, TextureMapping texture) {
        this.d(block);
        this.b(block, tintType, texture);
    }

    private void b(Block block, e tintType) {
        TextureMapping textureMapping = TextureMapping.c(block);
        this.b(block, tintType, textureMapping);
    }

    private void b(Block block, e tintType, TextureMapping crossTexture) {
        MinecraftKey resourceLocation = tintType.a().a(block, crossTexture, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void a(Block block, e tintType, IBlockState<Integer> stageProperty, int ... stages) {
        if (stageProperty.a().size() != stages.length) {
            throw new IllegalArgumentException("missing values for property: " + String.valueOf(stageProperty));
        }
        PropertyDispatch propertyDispatch = PropertyDispatch.a(stageProperty).a((T1 stage) -> {
            String string = "_stage" + stages[stage];
            TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(block, string));
            MinecraftKey resourceLocation = tintType.a().a(block, string, textureMapping, this.c);
            return Variant.a().a(VariantProperties.c, resourceLocation);
        });
        this.a(block.r());
        this.b.accept(MultiVariantGenerator.a(block).a(propertyDispatch));
    }

    private void a(Block plantBlock, Block flowerPotBlock, e tintType) {
        this.a(plantBlock, tintType);
        TextureMapping textureMapping = TextureMapping.d(plantBlock);
        MinecraftKey resourceLocation = tintType.b().a(flowerPotBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(flowerPotBlock, resourceLocation));
    }

    private void d(Block coralFanBlock, Block coralWallFanBlock) {
        TexturedModel texturedModel = TexturedModel.p.get(coralFanBlock);
        MinecraftKey resourceLocation = texturedModel.a(coralFanBlock, this.c);
        this.b.accept(BlockModelGenerators.c(coralFanBlock, resourceLocation));
        MinecraftKey resourceLocation2 = ModelTemplates.aC.a(coralWallFanBlock, texturedModel.b(), this.c);
        this.b.accept(MultiVariantGenerator.a(coralWallFanBlock, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockModelGenerators.b()));
        this.d(coralFanBlock);
    }

    private void e(Block stemBlock, Block attachedStemBlock) {
        this.a(stemBlock.r());
        TextureMapping textureMapping = TextureMapping.h(stemBlock);
        TextureMapping textureMapping2 = TextureMapping.a(stemBlock, attachedStemBlock);
        MinecraftKey resourceLocation = ModelTemplates.aU.a(attachedStemBlock, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(attachedStemBlock, Variant.a().a(VariantProperties.c, resourceLocation)).a(PropertyDispatch.a(BlockProperties.R).a(EnumDirection.e, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.c))));
        this.b.accept(MultiVariantGenerator.a(stemBlock).a(PropertyDispatch.a(BlockProperties.av).a((T1 age) -> Variant.a().a(VariantProperties.c, ModelTemplates.aT[age].a(stemBlock, textureMapping, this.c)))));
    }

    private void h() {
        Block block = Blocks.kC;
        this.a(block.r());
        MinecraftKey resourceLocation = ModelLocationUtils.a(block, "_top");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(block, "_bottom");
        this.f(block, resourceLocation, resourceLocation2);
    }

    private void i() {
        Block block = Blocks.kB;
        this.a(block.r());
        PropertyDispatch propertyDispatch = PropertyDispatch.a(PitcherCropBlock.d, BlockProperties.ae).a((T1 age, T2 half) -> switch (half) {
            default -> throw new MatchException(null, null);
            case BlockPropertyDoubleBlockHalf.a -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block, "_top_stage_" + age));
            case BlockPropertyDoubleBlockHalf.b -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block, "_bottom_stage_" + age));
        });
        this.b.accept(MultiVariantGenerator.a(block).a(propertyDispatch));
    }

    private void a(Block coral, Block deadCoral, Block coralBlock, Block deadCoralBlock, Block coralFan, Block deadCoralFan, Block coralWallFan, Block deadCoralWallFan) {
        this.a(coral, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(deadCoral, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(coralBlock);
        this.a(deadCoralBlock);
        this.d(coralFan, coralWallFan);
        this.d(deadCoralFan, deadCoralWallFan);
    }

    private void c(Block doubleBlock, e tintType) {
        this.a(doubleBlock, "_top");
        MinecraftKey resourceLocation = this.a(doubleBlock, "_top", tintType.a(), TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(doubleBlock, "_bottom", tintType.a(), TextureMapping::c);
        this.f(doubleBlock, resourceLocation, resourceLocation2);
    }

    private void j() {
        this.a(Blocks.iD, "_front");
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.iD, "_top");
        MinecraftKey resourceLocation2 = this.a(Blocks.iD, "_bottom", net.minecraft.data.models.BlockModelGenerators$e.b.a(), TextureMapping::c);
        this.f(Blocks.iD, resourceLocation, resourceLocation2);
    }

    private void k() {
        MinecraftKey resourceLocation = this.a(Blocks.bx, "_top", ModelTemplates.bk, TextureMapping::a);
        MinecraftKey resourceLocation2 = this.a(Blocks.bx, "_bottom", ModelTemplates.bk, TextureMapping::a);
        this.f(Blocks.bx, resourceLocation, resourceLocation2);
    }

    private void l() {
        this.c(Blocks.sF);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.sF, "_top");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.sF, "_bottom");
        this.b.accept(MultiVariantGenerator.a(Blocks.sF).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.ae).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, resourceLocation))));
    }

    private void f(Block block, MinecraftKey upperHalfModelId, MinecraftKey lowerHalfModelId) {
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.ae).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, lowerHalfModelId)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, upperHalfModelId))));
    }

    private void n(Block rail) {
        TextureMapping textureMapping = TextureMapping.e(rail);
        TextureMapping textureMapping2 = TextureMapping.e(TextureMapping.a(rail, "_corner"));
        MinecraftKey resourceLocation = ModelTemplates.as.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.at.a(rail, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.au.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.av.a(rail, textureMapping, this.c);
        this.d(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(PropertyDispatch.a(BlockProperties.ag).a(BlockPropertyTrackPosition.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockPropertyTrackPosition.b, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.e, Variant.a().a(VariantProperties.c, resourceLocation3)).a(BlockPropertyTrackPosition.f, Variant.a().a(VariantProperties.c, resourceLocation4)).a(BlockPropertyTrackPosition.g, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyTrackPosition.h, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.i, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyTrackPosition.j, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void o(Block rail) {
        MinecraftKey resourceLocation = this.a(rail, "", ModelTemplates.as, TextureMapping::e);
        MinecraftKey resourceLocation2 = this.a(rail, "", ModelTemplates.au, TextureMapping::e);
        MinecraftKey resourceLocation3 = this.a(rail, "", ModelTemplates.av, TextureMapping::e);
        MinecraftKey resourceLocation4 = this.a(rail, "_on", ModelTemplates.as, TextureMapping::e);
        MinecraftKey resourceLocation5 = this.a(rail, "_on", ModelTemplates.au, TextureMapping::e);
        MinecraftKey resourceLocation6 = this.a(rail, "_on", ModelTemplates.av, TextureMapping::e);
        PropertyDispatch propertyDispatch = PropertyDispatch.a(BlockProperties.w, BlockProperties.ah).a((T1 on, T2 shape) -> {
            switch (shape) {
                case a: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation4 : resourceLocation);
                }
                case b: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation4 : resourceLocation).a(VariantProperties.b, VariantProperties.a.b);
                }
                case c: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation5 : resourceLocation2).a(VariantProperties.b, VariantProperties.a.b);
                }
                case d: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation6 : resourceLocation3).a(VariantProperties.b, VariantProperties.a.b);
                }
                case e: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation5 : resourceLocation2);
                }
                case f: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation6 : resourceLocation3);
                }
            }
            throw new UnsupportedOperationException("Fix you generator!");
        });
        this.d(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(propertyDispatch));
    }

    private a a(MinecraftKey modelId, Block particleBlock) {
        return new a(modelId, particleBlock);
    }

    private a f(Block block, Block particleBlock) {
        return new a(ModelLocationUtils.a(block), particleBlock);
    }

    private void a(Block block, Item particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.aa.a(block, TextureMapping.a(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void f(Block block, MinecraftKey particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.aa.a(block, TextureMapping.h(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void g(Block wool, Block carpet) {
        this.a(wool);
        MinecraftKey resourceLocation = TexturedModel.j.get(wool).a(carpet, this.c);
        this.b.accept(BlockModelGenerators.c(carpet, resourceLocation));
    }

    private void p(Block flowerbed) {
        this.a(flowerbed.r());
        MinecraftKey resourceLocation = TexturedModel.k.create(flowerbed, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.l.create(flowerbed, this.c);
        MinecraftKey resourceLocation3 = TexturedModel.m.create(flowerbed, this.c);
        MinecraftKey resourceLocation4 = TexturedModel.n.create(flowerbed, this.c);
        this.b.accept(MultiPartGenerator.a(flowerbed).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void a(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(BlockModelGenerators.b(block, resourceLocation));
        }
    }

    private void b(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void h(Block glass, Block glassPane) {
        this.a(glass);
        TextureMapping textureMapping = TextureMapping.b(glass, glassPane);
        MinecraftKey resourceLocation = ModelTemplates.aI.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aJ.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aK.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aG.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.aH.a(glassPane, textureMapping, this.c);
        Item item = glassPane.r();
        ModelTemplates.bx.a(ModelLocationUtils.a(item), TextureMapping.F(glass), this.c);
        this.b.accept(MultiPartGenerator.a(glassPane).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void q(Block commandBlock) {
        TextureMapping textureMapping = TextureMapping.z(commandBlock);
        MinecraftKey resourceLocation = ModelTemplates.aL.a(commandBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(commandBlock, "_conditional", ModelTemplates.aL, (MinecraftKey id) -> textureMapping.c(TextureSlot.i, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(commandBlock).a(BlockModelGenerators.a(BlockProperties.c, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void r(Block anvil) {
        MinecraftKey resourceLocation = TexturedModel.r.create(anvil, this.c);
        this.b.accept(BlockModelGenerators.c(anvil, resourceLocation).a(BlockModelGenerators.c()));
    }

    private List<Variant> a(int age) {
        String string = "_age" + age;
        return IntStream.range(1, 5).mapToObj(i2 -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mZ, i2 + string))).collect(Collectors.toList());
    }

    private void m() {
        this.c(Blocks.mZ);
        this.b.accept(MultiPartGenerator.a(Blocks.mZ).a((Condition)Condition.a().a(BlockProperties.aq, 0), this.a(0)).a((Condition)Condition.a().a(BlockProperties.aq, 1), this.a(1)).a((Condition)Condition.a().a(BlockProperties.bk, BlockPropertyBambooSize.b), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mZ, "_small_leaves"))).a((Condition)Condition.a().a(BlockProperties.bk, BlockPropertyBambooSize.c), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mZ, "_large_leaves"))));
    }

    private PropertyDispatch n() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a()).a(EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    private void o() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.nU, "_top_open");
        this.b.accept(MultiVariantGenerator.a(Blocks.nU).a(this.n()).a(PropertyDispatch.a(BlockProperties.u).a((Boolean)false, Variant.a().a(VariantProperties.c, TexturedModel.f.create(Blocks.nU, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, TexturedModel.f.get(Blocks.nU).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.f, resourceLocation)).a(Blocks.nU, "_open", this.c)))));
    }

    private static <T extends Comparable<T>> PropertyDispatch a(IBlockState<T> property, T fence, MinecraftKey higherOrEqualModelId, MinecraftKey lowerModelId) {
        Variant variant = Variant.a().a(VariantProperties.c, higherOrEqualModelId);
        Variant variant2 = Variant.a().a(VariantProperties.c, lowerModelId);
        return PropertyDispatch.a(property).a((T1 comparable2) -> {
            boolean bl = comparable2.compareTo(fence) >= 0;
            return bl ? variant : variant2;
        });
    }

    private void a(Block beehive, Function<Block, TextureMapping> texturesFactory) {
        TextureMapping textureMapping = texturesFactory.apply(beehive).b(TextureSlot.i, TextureSlot.c);
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.g, TextureMapping.a(beehive, "_front_honey"));
        MinecraftKey resourceLocation = ModelTemplates.q.a(beehive, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.q.a(beehive, "_honey", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(beehive).a(BlockModelGenerators.b()).a(BlockModelGenerators.a(BlockProperties.aN, 5, resourceLocation2, resourceLocation)));
    }

    private void a(Block crop, IBlockState<Integer> ageProperty, int ... ageTextureIndices) {
        if (ageProperty.a().size() != ageTextureIndices.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        PropertyDispatch propertyDispatch = PropertyDispatch.a(ageProperty).a(arg_0 -> this.a(ageTextureIndices, (Int2ObjectMap)int2ObjectMap, crop, arg_0));
        this.a(crop.r());
        this.b.accept(MultiVariantGenerator.a(crop).a(propertyDispatch));
    }

    private void p() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.od, "_floor");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.od, "_ceiling");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.od, "_wall");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.od, "_between_walls");
        this.a(Items.wr);
        this.b.accept(MultiVariantGenerator.a(Blocks.od).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.V).a(EnumDirection.c, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.d, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.d, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3)).a(EnumDirection.e, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4)).a(EnumDirection.e, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c))));
    }

    private void q() {
        this.b.accept(MultiVariantGenerator.a(Blocks.nZ, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.nZ))).a(PropertyDispatch.a(BlockProperties.U, BlockProperties.R).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void d(Block cooker, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(cooker, this.c);
        MinecraftKey resourceLocation2 = TextureMapping.a(cooker, "_front_on");
        MinecraftKey resourceLocation3 = modelFactory.get(cooker).a((TextureMapping textures) -> textures.a(TextureSlot.g, resourceLocation2)).a(cooker, "_on", this.c);
        this.b.accept(MultiVariantGenerator.a(cooker).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void a(Block ... blocks) {
        MinecraftKey resourceLocation = ModelLocationUtils.a("campfire_off");
        for (Block block : blocks) {
            MinecraftKey resourceLocation2 = ModelTemplates.bc.a(block, TextureMapping.E(block), this.c);
            this.a(block.r());
            this.b.accept(MultiVariantGenerator.a(block).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void s(Block block) {
        MinecraftKey resourceLocation = ModelTemplates.bt.a(block, TextureMapping.l(block), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void t(Block block) {
        MinecraftKey resourceLocation2;
        if (block == Blocks.tj) {
            MinecraftKey resourceLocation = ModelTemplates.bv.a(block, TextureMapping.m(block), this.c);
        } else {
            resourceLocation2 = ModelTemplates.bu.a(block, TextureMapping.m(block), this.c);
        }
        this.b.accept(BlockModelGenerators.c(block, resourceLocation2));
    }

    private void r() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.G(Blocks.cl), TextureMapping.G(Blocks.n));
        MinecraftKey resourceLocation = ModelTemplates.j.a(Blocks.cl, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(Blocks.cl, resourceLocation));
    }

    private void s() {
        this.a(Items.lH);
        this.b.accept(MultiPartGenerator.a(Blocks.cw).a(Condition.b(Condition.a().a(BlockProperties.ab, BlockPropertyRedstoneSide.c).a(BlockProperties.aa, BlockPropertyRedstoneSide.c).a(BlockProperties.ac, BlockPropertyRedstoneSide.c).a(BlockProperties.ad, BlockPropertyRedstoneSide.c), Condition.a().a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a})), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_dot"))).a((Condition)Condition.a().a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side0"))).a((Condition)Condition.a().a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt0"))).a((Condition)Condition.a().a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.ab, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up"))).a((Condition)Condition.a().a(BlockProperties.aa, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.ac, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.ad, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void t() {
        this.a(Items.lL);
        this.b.accept(MultiVariantGenerator.a(Blocks.gY).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.bd, BlockProperties.w).a(BlockPropertyComparatorMode.a, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gY))).a(BlockPropertyComparatorMode.a, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gY, "_on"))).a(BlockPropertyComparatorMode.b, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gY, "_subtract"))).a(BlockPropertyComparatorMode.b, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gY, "_on_subtract")))));
    }

    private void u() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.jR);
        TextureMapping textureMapping2 = TextureMapping.a(TextureMapping.a(Blocks.jE, "_side"), textureMapping.a(TextureSlot.f));
        MinecraftKey resourceLocation = ModelTemplates.ab.a(Blocks.jE, textureMapping2, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ac.a(Blocks.jE, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.j.b(Blocks.jE, "_double", textureMapping2, this.c);
        this.b.accept(BlockModelGenerators.e(Blocks.jE, resourceLocation, resourceLocation2, resourceLocation3));
        this.b.accept(BlockModelGenerators.c(Blocks.jR, ModelTemplates.c.a(Blocks.jR, textureMapping, this.c)));
    }

    private void v() {
        this.a(Items.sq);
        this.b.accept(MultiPartGenerator.a(Blocks.fs).a(Variant.a().a(VariantProperties.c, TextureMapping.G(Blocks.fs))).a((Condition)Condition.a().a(BlockProperties.k, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fs, "_bottle0"))).a((Condition)Condition.a().a(BlockProperties.l, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fs, "_bottle1"))).a((Condition)Condition.a().a(BlockProperties.m, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fs, "_bottle2"))).a((Condition)Condition.a().a(BlockProperties.k, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fs, "_empty0"))).a((Condition)Condition.a().a(BlockProperties.l, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fs, "_empty1"))).a((Condition)Condition.a().a(BlockProperties.m, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fs, "_empty2"))));
    }

    private void u(Block mushroomBlock) {
        MinecraftKey resourceLocation = ModelTemplates.bp.a(mushroomBlock, TextureMapping.b(mushroomBlock), this.c);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a("mushroom_block_inside");
        this.b.accept(MultiPartGenerator.a(mushroomBlock).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, false)));
        this.a(mushroomBlock, TexturedModel.a.createWithSuffix(mushroomBlock, "_inventory", this.c));
    }

    private void w() {
        this.a(Items.rB);
        this.b.accept(MultiVariantGenerator.a(Blocks.eg).a(PropertyDispatch.a(BlockProperties.ay).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice2"))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice3"))).a((Integer)4, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice4"))).a((Integer)5, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice5"))).a((Integer)6, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice6")))));
    }

    private void x() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.nX, "_side3")).a(TextureSlot.o, TextureMapping.G(Blocks.t)).a(TextureSlot.n, TextureMapping.a(Blocks.nX, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.nX, "_side3")).a(TextureSlot.l, TextureMapping.a(Blocks.nX, "_side3")).a(TextureSlot.k, TextureMapping.a(Blocks.nX, "_side1")).a(TextureSlot.m, TextureMapping.a(Blocks.nX, "_side2"));
        this.b.accept(BlockModelGenerators.c(Blocks.nX, ModelTemplates.a.a(Blocks.nX, textureMapping, this.c)));
    }

    private void y() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.ob, "_front")).a(TextureSlot.o, TextureMapping.a(Blocks.ob, "_bottom")).a(TextureSlot.n, TextureMapping.a(Blocks.ob, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.ob, "_front")).a(TextureSlot.k, TextureMapping.a(Blocks.ob, "_front")).a(TextureSlot.l, TextureMapping.a(Blocks.ob, "_side")).a(TextureSlot.m, TextureMapping.a(Blocks.ob, "_side"));
        this.b.accept(BlockModelGenerators.c(Blocks.ob, ModelTemplates.a.a(Blocks.ob, textureMapping, this.c)));
    }

    private void a(Block block, Block otherTextureSource, BiFunction<Block, Block, TextureMapping> texturesFactory) {
        TextureMapping textureMapping = texturesFactory.apply(block, otherTextureSource);
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.a.a(block, textureMapping, this.c)));
    }

    public void b(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(block, "_particle")).a(TextureSlot.o, TextureMapping.a(block, "_down")).a(TextureSlot.n, TextureMapping.a(block, "_up")).a(TextureSlot.j, TextureMapping.a(block, "_north")).a(TextureSlot.k, TextureMapping.a(block, "_south")).a(TextureSlot.l, TextureMapping.a(block, "_east")).a(TextureSlot.m, TextureMapping.a(block, "_west"));
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.a.a(block, textureMapping, this.c)));
    }

    private void z() {
        TextureMapping textureMapping = TextureMapping.k(Blocks.eZ);
        this.b.accept(BlockModelGenerators.c(Blocks.eZ, ModelLocationUtils.a(Blocks.eZ)));
        this.a(Blocks.ee, textureMapping);
        this.a(Blocks.ef, textureMapping);
    }

    private void a(Block block, TextureMapping texture) {
        MinecraftKey resourceLocation = ModelTemplates.p.a(block, texture.c(TextureSlot.g, TextureMapping.G(block)), this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void A() {
        this.a(Items.sr);
        this.m(Blocks.ft);
        this.b.accept(BlockModelGenerators.c(Blocks.fv, ModelTemplates.bs.a(Blocks.fv, TextureMapping.j(TextureMapping.a(Blocks.H, "_still")), this.c)));
        this.b.accept(MultiVariantGenerator.a(Blocks.fu).a(PropertyDispatch.a(LayeredCauldronBlock.g).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.bq.a(Blocks.fu, "_level1", TextureMapping.j(TextureMapping.a(Blocks.G, "_still")), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.br.a(Blocks.fu, "_level2", TextureMapping.j(TextureMapping.a(Blocks.G, "_still")), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.bs.a(Blocks.fu, "_full", TextureMapping.j(TextureMapping.a(Blocks.G, "_still")), this.c)))));
        this.b.accept(MultiVariantGenerator.a(Blocks.fw).a(PropertyDispatch.a(LayeredCauldronBlock.g).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.bq.a(Blocks.fw, "_level1", TextureMapping.j(TextureMapping.G(Blocks.qP)), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.br.a(Blocks.fw, "_level2", TextureMapping.j(TextureMapping.G(Blocks.qP)), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.bs.a(Blocks.fw, "_full", TextureMapping.j(TextureMapping.G(Blocks.qP)), this.c)))));
    }

    private void B() {
        TextureMapping textureMapping = TextureMapping.b(Blocks.kv);
        MinecraftKey resourceLocation = ModelTemplates.aE.a(Blocks.kv, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.kv, "_dead", ModelTemplates.aE, (MinecraftKey id) -> textureMapping.c(TextureSlot.b, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(Blocks.kv).a(BlockModelGenerators.a(BlockProperties.au, 5, resourceLocation2, resourceLocation)));
    }

    private void C() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.tq);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.tq, "_triggered");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.tq, "_crafting");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.tq, "_crafting_triggered");
        this.b.accept(MultiVariantGenerator.a(Blocks.tq).a(PropertyDispatch.a(BlockProperties.T).a((T1 orientation) -> this.a((BlockPropertyJigsawOrientation)orientation, Variant.a()))).a(PropertyDispatch.a(BlockProperties.A, CrafterBlock.b).a((Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation4)).a((Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation2)).a((Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation3))));
    }

    private void v(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.cD, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.cD, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.i, TextureMapping.a(Blocks.cD, "_top")).a(TextureSlot.g, TextureMapping.a(block, "_front_vertical"));
        MinecraftKey resourceLocation = ModelTemplates.p.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.r.a(block, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.P).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void D() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.fy);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.fy, "_filled");
        this.b.accept(MultiVariantGenerator.a(Blocks.fy).a(PropertyDispatch.a(BlockProperties.h).a((Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation2))).a(BlockModelGenerators.c()));
    }

    private void E() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.ku, "_side");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.ku, "_noside");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.ku, "_noside1");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.ku, "_noside2");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.ku, "_noside3");
        this.b.accept(MultiPartGenerator.a(Blocks.ku).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2), Variant.a().a(VariantProperties.c, resourceLocation3), Variant.a().a(VariantProperties.c, resourceLocation4), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    }

    private void F() {
        this.b.accept(MultiPartGenerator.a(Blocks.pc).a(Variant.a().a(VariantProperties.c, TextureMapping.G(Blocks.pc))).a((Condition)Condition.a().a(BlockProperties.aL, 1), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents1"))).a((Condition)Condition.a().a(BlockProperties.aL, 2), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents2"))).a((Condition)Condition.a().a(BlockProperties.aL, 3), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents3"))).a((Condition)Condition.a().a(BlockProperties.aL, 4), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents4"))).a((Condition)Condition.a().a(BlockProperties.aL, 5), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents5"))).a((Condition)Condition.a().a(BlockProperties.aL, 6), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents6"))).a((Condition)Condition.a().a(BlockProperties.aL, 7), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents7"))).a((Condition)Condition.a().a(BlockProperties.aL, 8), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.pc, "_contents_ready"))));
    }

    private void w(Block copperBulbBlock) {
        MinecraftKey resourceLocation = ModelTemplates.c.a(copperBulbBlock, TextureMapping.a(copperBulbBlock), this.c);
        MinecraftKey resourceLocation2 = this.a(copperBulbBlock, "_powered", ModelTemplates.c, TextureMapping::b);
        MinecraftKey resourceLocation3 = this.a(copperBulbBlock, "_lit", ModelTemplates.c, TextureMapping::b);
        MinecraftKey resourceLocation4 = this.a(copperBulbBlock, "_lit_powered", ModelTemplates.c, TextureMapping::b);
        this.b.accept(this.a(copperBulbBlock, resourceLocation, resourceLocation3, resourceLocation2, resourceLocation4));
    }

    private BlockStateGenerator a(Block copperBulbBlock, MinecraftKey modelId, MinecraftKey litModelId, MinecraftKey poweredModelId, MinecraftKey litPoweredModelId) {
        return MultiVariantGenerator.a(copperBulbBlock).a(PropertyDispatch.a(BlockProperties.r, BlockProperties.w).a((T1 lit, T2 powered) -> {
            if (lit.booleanValue()) {
                return Variant.a().a(VariantProperties.c, powered != false ? litPoweredModelId : litModelId);
            }
            return Variant.a().a(VariantProperties.c, powered != false ? poweredModelId : modelId);
        }));
    }

    private void i(Block unwaxedCopperBulbBlock, Block waxedCopperBulbBlock) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(unwaxedCopperBulbBlock);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(unwaxedCopperBulbBlock, "_powered");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(unwaxedCopperBulbBlock, "_lit");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(unwaxedCopperBulbBlock, "_lit_powered");
        this.a(waxedCopperBulbBlock, ModelLocationUtils.a(unwaxedCopperBulbBlock.r()));
        this.b.accept(this.a(waxedCopperBulbBlock, resourceLocation, resourceLocation3, resourceLocation2, resourceLocation4));
    }

    private void x(Block block) {
        this.c(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelTemplates.ao.a(block, TextureMapping.c(block), this.c))).a(this.n()));
    }

    private void G() {
        this.x(Blocks.qy);
        this.x(Blocks.qx);
        this.x(Blocks.qw);
        this.x(Blocks.qv);
    }

    private void H() {
        this.c(Blocks.st);
        PropertyDispatch.b<EnumDirection, DripstoneThickness> c2 = PropertyDispatch.a(BlockProperties.bm, BlockProperties.bn);
        for (DripstoneThickness dripstoneThickness : DripstoneThickness.values()) {
            c2.a(EnumDirection.b, dripstoneThickness, this.a(EnumDirection.b, dripstoneThickness));
        }
        for (DripstoneThickness dripstoneThickness2 : DripstoneThickness.values()) {
            c2.a(EnumDirection.a, dripstoneThickness2, this.a(EnumDirection.a, dripstoneThickness2));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.st).a(c2));
    }

    private Variant a(EnumDirection direction, DripstoneThickness thickness) {
        String string = "_" + direction.c() + "_" + thickness.c();
        TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(Blocks.st, string));
        return Variant.a().a(VariantProperties.c, ModelTemplates.an.a(Blocks.st, string, textureMapping, this.c));
    }

    private void y(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.G(Blocks.dV)).a(TextureSlot.f, TextureMapping.G(block)).a(TextureSlot.i, TextureMapping.a(block, "_side"));
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.n.a(block, textureMapping, this.c)));
    }

    private void I() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.gZ, "_side");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.gZ, "_top")).a(TextureSlot.i, resourceLocation);
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.gZ, "_inverted_top")).a(TextureSlot.i, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.gZ).a(PropertyDispatch.a(BlockProperties.p).a((Boolean)false, Variant.a().a(VariantProperties.c, ModelTemplates.aF.a(Blocks.gZ, textureMapping, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, ModelTemplates.aF.a(ModelLocationUtils.a(Blocks.gZ, "_inverted"), textureMapping2, this.c)))));
    }

    private void z(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.n()));
    }

    private void J() {
        Block block = Blocks.ss;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block, "_on");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.n()).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation, resourceLocation2)));
    }

    private void K() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.B, TextureMapping.G(Blocks.j)).a(TextureSlot.f, TextureMapping.G(Blocks.cC));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.B, TextureMapping.G(Blocks.j)).a(TextureSlot.f, TextureMapping.a(Blocks.cC, "_moist"));
        MinecraftKey resourceLocation = ModelTemplates.aW.a(Blocks.cC, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aW.a(TextureMapping.a(Blocks.cC, "_moist"), textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cC).a(BlockModelGenerators.a(BlockProperties.aQ, 7, resourceLocation2, resourceLocation)));
    }

    private List<MinecraftKey> A(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aX.a(ModelLocationUtils.a(texture, "_floor0"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aX.a(ModelLocationUtils.a(texture, "_floor1"), TextureMapping.w(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2);
    }

    private List<MinecraftKey> B(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aY.a(ModelLocationUtils.a(texture, "_side0"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aY.a(ModelLocationUtils.a(texture, "_side1"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aZ.a(ModelLocationUtils.a(texture, "_side_alt0"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aZ.a(ModelLocationUtils.a(texture, "_side_alt1"), TextureMapping.w(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private List<MinecraftKey> C(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.ba.a(ModelLocationUtils.a(texture, "_up0"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ba.a(ModelLocationUtils.a(texture, "_up1"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bb.a(ModelLocationUtils.a(texture, "_up_alt0"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bb.a(ModelLocationUtils.a(texture, "_up_alt1"), TextureMapping.w(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private static List<Variant> a(List<MinecraftKey> modelIds, UnaryOperator<Variant> processor) {
        return modelIds.stream().map(modelId -> Variant.a().a(VariantProperties.c, modelId)).map(processor).collect(Collectors.toList());
    }

    private void L() {
        Condition.c condition = Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false).a(BlockProperties.J, false);
        List<MinecraftKey> list = this.A(Blocks.cr);
        List<MinecraftKey> list2 = this.B(Blocks.cr);
        List<MinecraftKey> list3 = this.C(Blocks.cr);
        this.b.accept(MultiPartGenerator.a(Blocks.cr).a((Condition)condition, BlockModelGenerators.a(list, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.L, true), condition), BlockModelGenerators.a(list2, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.M, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(Condition.b(Condition.a().a(BlockProperties.N, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(Condition.b(Condition.a().a(BlockProperties.O, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))).a((Condition)Condition.a().a(BlockProperties.J, true), BlockModelGenerators.a(list3, variant -> variant)));
    }

    private void M() {
        List<MinecraftKey> list = this.A(Blocks.cs);
        List<MinecraftKey> list2 = this.B(Blocks.cs);
        this.b.accept(MultiPartGenerator.a(Blocks.cs).a(BlockModelGenerators.a(list, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void D(Block lantern) {
        MinecraftKey resourceLocation = TexturedModel.t.create(lantern, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.u.create(lantern, this.c);
        this.a(lantern.r());
        this.b.accept(MultiVariantGenerator.a(lantern).a(BlockModelGenerators.a(BlockProperties.j, resourceLocation2, resourceLocation)));
    }

    private void N() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.a(Blocks.ad, "_side"), TextureMapping.a(Blocks.ad, "_top"));
        MinecraftKey resourceLocation = ModelTemplates.j.a(Blocks.ad, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(Blocks.ad, resourceLocation));
    }

    private void O() {
        this.a(Items.ad);
        Block block = Blocks.E;
        PropertyDispatch.b<Boolean, Integer> c2 = PropertyDispatch.a(MangrovePropaguleBlock.d, MangrovePropaguleBlock.b);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        for (int i2 = 0; i2 <= 4; ++i2) {
            MinecraftKey resourceLocation2 = ModelLocationUtils.a(block, "_hanging_" + i2);
            c2.a((Boolean)true, (Integer)i2, Variant.a().a(VariantProperties.c, resourceLocation2));
            c2.a((Boolean)false, (Integer)i2, Variant.a().a(VariantProperties.c, resourceLocation));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.E).a(c2));
    }

    private void P() {
        this.b.accept(MultiVariantGenerator.a(Blocks.kI).a(PropertyDispatch.a(BlockProperties.as).a((Integer)0, Variant.a().a(VariantProperties.c, this.a(Blocks.kI, "_0", ModelTemplates.c, TextureMapping::b))).a((Integer)1, Variant.a().a(VariantProperties.c, this.a(Blocks.kI, "_1", ModelTemplates.c, TextureMapping::b))).a((Integer)2, Variant.a().a(VariantProperties.c, this.a(Blocks.kI, "_2", ModelTemplates.c, TextureMapping::b))).a((Integer)3, Variant.a().a(VariantProperties.c, this.a(Blocks.kI, "_3", ModelTemplates.c, TextureMapping::b)))));
    }

    private void Q() {
        MinecraftKey resourceLocation = TextureMapping.G(Blocks.j);
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).b(TextureSlot.e, TextureSlot.c).a(TextureSlot.f, TextureMapping.a(Blocks.i, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.i, "_snow"));
        Variant variant = Variant.a().a(VariantProperties.c, ModelTemplates.n.a(Blocks.i, "_snow", textureMapping, this.c));
        this.a(Blocks.i, ModelLocationUtils.a(Blocks.i), variant);
        MinecraftKey resourceLocation2 = TexturedModel.f.get(Blocks.fl).a((TextureMapping textures) -> textures.a(TextureSlot.e, resourceLocation)).a(Blocks.fl, this.c);
        this.a(Blocks.fl, resourceLocation2, variant);
        MinecraftKey resourceLocation3 = TexturedModel.f.get(Blocks.l).a((TextureMapping textures) -> textures.a(TextureSlot.e, resourceLocation)).a(Blocks.l, this.c);
        this.a(Blocks.l, resourceLocation3, variant);
    }

    private void a(Block topSoil, MinecraftKey modelId, Variant snowyVariant) {
        List<Variant> list = Arrays.asList(BlockModelGenerators.a(modelId));
        this.b.accept(MultiVariantGenerator.a(topSoil).a(PropertyDispatch.a(BlockProperties.z).a((Boolean)true, snowyVariant).a((Boolean)false, list)));
    }

    private void R() {
        this.a(Items.rh);
        this.b.accept(MultiVariantGenerator.a(Blocks.fC).a(PropertyDispatch.a(BlockProperties.ar).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fC, "_stage0"))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fC, "_stage1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fC, "_stage2")))).a(BlockModelGenerators.c()));
    }

    private void S() {
        this.b.accept(BlockModelGenerators.b(Blocks.kE, ModelLocationUtils.a(Blocks.kE)));
    }

    private void j(Block weightedPressurePlate, Block textureSource) {
        TextureMapping textureMapping = TextureMapping.b(textureSource);
        MinecraftKey resourceLocation = ModelTemplates.Y.a(weightedPressurePlate, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.Z.a(weightedPressurePlate, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(weightedPressurePlate).a(BlockModelGenerators.a(BlockProperties.aT, 1, resourceLocation2, resourceLocation)));
    }

    private void T() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.hc);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.hc, "_side");
        this.a(Items.lR);
        this.b.accept(MultiVariantGenerator.a(Blocks.hc).a(PropertyDispatch.a(BlockProperties.Q).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void k(Block modelSource, Block child) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(modelSource);
        this.b.accept(MultiVariantGenerator.a(child, Variant.a().a(VariantProperties.c, resourceLocation)));
        this.a(child, resourceLocation);
    }

    private void U() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.eW, "_post_ends");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.eW, "_post");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.eW, "_cap");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.eW, "_cap_alt");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.eW, "_side");
        MinecraftKey resourceLocation6 = ModelLocationUtils.a(Blocks.eW, "_side_alt");
        this.b.accept(MultiPartGenerator.a(Blocks.eW).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.L, true).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, true).a(BlockProperties.N, false).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, true).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation6)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation6).a(VariantProperties.b, VariantProperties.a.b)));
        this.d(Blocks.eW);
    }

    private void E(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(BlockModelGenerators.b()));
    }

    private void V() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.dw);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.dw, "_on");
        this.d(Blocks.dw);
        this.b.accept(MultiVariantGenerator.a(Blocks.dw).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation, resourceLocation2)).a(PropertyDispatch.a(BlockProperties.U, BlockProperties.R).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void W() {
        this.d(Blocks.fm);
        this.b.accept(BlockModelGenerators.b(Blocks.fm, ModelLocationUtils.a(Blocks.fm)));
    }

    private void X() {
        this.d(Blocks.tn);
        this.b.accept(BlockModelGenerators.c(Blocks.tn, ModelLocationUtils.a(Blocks.tn)));
    }

    private void Y() {
        this.b.accept(MultiVariantGenerator.a(Blocks.ed).a(PropertyDispatch.a(BlockProperties.H).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ed, "_ns"))).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ed, "_ew")))));
    }

    private void Z() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.dV, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dV, Variant.a().a(VariantProperties.c, resourceLocation), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.d)));
    }

    private void aa() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.kO);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.kO, "_on");
        this.b.accept(MultiVariantGenerator.a(Blocks.kO).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void ab() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.a(Blocks.by, "_bottom")).a(TextureSlot.i, TextureMapping.a(Blocks.by, "_side"));
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.by, "_top_sticky");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.by, "_top");
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, resourceLocation);
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, resourceLocation2);
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.by, "_base");
        this.a(Blocks.by, resourceLocation3, textureMapping3);
        this.a(Blocks.br, resourceLocation3, textureMapping2);
        MinecraftKey resourceLocation4 = ModelTemplates.n.a(Blocks.by, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation2), this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.n.a(Blocks.br, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation), this.c);
        this.a(Blocks.by, resourceLocation4);
        this.a(Blocks.br, resourceLocation5);
    }

    private void a(Block piston, MinecraftKey extendedModelId, TextureMapping textures) {
        MinecraftKey resourceLocation = ModelTemplates.bh.a(piston, textures, this.c);
        this.b.accept(MultiVariantGenerator.a(piston).a(BlockModelGenerators.a(BlockProperties.g, extendedModelId, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void ac() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.F, TextureMapping.a(Blocks.by, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.by, "_side"));
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.by, "_top_sticky"));
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.by, "_top"));
        this.b.accept(MultiVariantGenerator.a(Blocks.bz).a(PropertyDispatch.a(BlockProperties.x, BlockProperties.bg).a((Boolean)false, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.bi.a(Blocks.by, "_head", textureMapping3, this.c))).a((Boolean)false, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.bi.a(Blocks.by, "_head_sticky", textureMapping2, this.c))).a((Boolean)true, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.bj.a(Blocks.by, "_head_short", textureMapping3, this.c))).a((Boolean)true, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.bj.a(Blocks.by, "_head_short_sticky", textureMapping2, this.c)))).a(BlockModelGenerators.e()));
    }

    private void ad() {
        Block block = Blocks.tr;
        TextureMapping textureMapping = TextureMapping.a(block, "_side_inactive", "_top_inactive");
        TextureMapping textureMapping2 = TextureMapping.a(block, "_side_active", "_top_active");
        TextureMapping textureMapping3 = TextureMapping.a(block, "_side_active", "_top_ejecting_reward");
        TextureMapping textureMapping4 = TextureMapping.a(block, "_side_inactive_ominous", "_top_inactive_ominous");
        TextureMapping textureMapping5 = TextureMapping.a(block, "_side_active_ominous", "_top_active_ominous");
        TextureMapping textureMapping6 = TextureMapping.a(block, "_side_active_ominous", "_top_ejecting_reward_ominous");
        MinecraftKey resourceLocation = ModelTemplates.o.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.o.a(block, "_active", textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.o.a(block, "_ejecting_reward", textureMapping3, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.o.a(block, "_inactive_ominous", textureMapping4, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.o.a(block, "_active_ominous", textureMapping5, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.o.a(block, "_ejecting_reward_ominous", textureMapping6, this.c);
        this.a(block, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.by, BlockProperties.bA).a((T1 spawnerState, T2 ominous) -> switch (spawnerState) {
            default -> throw new MatchException(null, null);
            case TrialSpawnerState.a, TrialSpawnerState.f -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation4 : resourceLocation);
            case TrialSpawnerState.b, TrialSpawnerState.c, TrialSpawnerState.d -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation5 : resourceLocation2);
            case TrialSpawnerState.e -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation6 : resourceLocation3);
        })));
    }

    private void ae() {
        Block block = Blocks.ts;
        TextureMapping textureMapping = TextureMapping.a(block, "_front_off", "_side_off", "_top", "_bottom");
        TextureMapping textureMapping2 = TextureMapping.a(block, "_front_on", "_side_on", "_top", "_bottom");
        TextureMapping textureMapping3 = TextureMapping.a(block, "_front_ejecting", "_side_on", "_top", "_bottom");
        TextureMapping textureMapping4 = TextureMapping.a(block, "_front_ejecting", "_side_on", "_top_ejecting", "_bottom");
        MinecraftKey resourceLocation = ModelTemplates.bN.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bN.a(block, "_active", textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bN.a(block, "_unlocking", textureMapping3, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bN.a(block, "_ejecting_reward", textureMapping4, this.c);
        TextureMapping textureMapping5 = TextureMapping.a(block, "_front_off_ominous", "_side_off_ominous", "_top_ominous", "_bottom_ominous");
        TextureMapping textureMapping6 = TextureMapping.a(block, "_front_on_ominous", "_side_on_ominous", "_top_ominous", "_bottom_ominous");
        TextureMapping textureMapping7 = TextureMapping.a(block, "_front_ejecting_ominous", "_side_on_ominous", "_top_ominous", "_bottom_ominous");
        TextureMapping textureMapping8 = TextureMapping.a(block, "_front_ejecting_ominous", "_side_on_ominous", "_top_ejecting_ominous", "_bottom_ominous");
        MinecraftKey resourceLocation5 = ModelTemplates.bN.a(block, "_ominous", textureMapping5, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.bN.a(block, "_active_ominous", textureMapping6, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.bN.a(block, "_unlocking_ominous", textureMapping7, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.bN.a(block, "_ejecting_reward_ominous", textureMapping8, this.c);
        this.a(block, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(block).a(BlockModelGenerators.b()).a(PropertyDispatch.a(VaultBlock.b, VaultBlock.d).a((T1 vaultState, T2 ominous) -> switch (vaultState) {
            default -> throw new MatchException(null, null);
            case VaultState.a -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation5 : resourceLocation);
            case VaultState.b -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation6 : resourceLocation2);
            case VaultState.c -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation7 : resourceLocation3);
            case VaultState.d -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation8 : resourceLocation4);
        })));
    }

    private void af() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.qQ, "_inactive");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.qQ, "_active");
        this.a(Blocks.qQ, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.qQ).a(PropertyDispatch.a(BlockProperties.bo).a((T1 phase) -> Variant.a().a(VariantProperties.c, phase == SculkSensorPhase.b || phase == SculkSensorPhase.c ? resourceLocation2 : resourceLocation))));
    }

    private void ag() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.qR, "_inactive");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.qR, "_active");
        this.a(Blocks.qR, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.qR).a(PropertyDispatch.a(BlockProperties.bo).a((T1 phase) -> Variant.a().a(VariantProperties.c, phase == SculkSensorPhase.b || phase == SculkSensorPhase.c ? resourceLocation2 : resourceLocation))).a(BlockModelGenerators.b()));
    }

    private void ah() {
        MinecraftKey resourceLocation = ModelTemplates.bM.a(Blocks.qV, TextureMapping.a(false), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bM.a(Blocks.qV, "_can_summon", TextureMapping.a(true), this.c);
        this.a(Blocks.qV, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.qV).a(BlockModelGenerators.a(BlockProperties.G, resourceLocation2, resourceLocation)));
    }

    private void ai() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.nS, "_stable");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.nS, "_unstable");
        this.a(Blocks.nS, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.nS).a(BlockModelGenerators.a(BlockProperties.b, resourceLocation2, resourceLocation)));
    }

    private void aj() {
        MinecraftKey resourceLocation = this.a(Blocks.sv, "", ModelTemplates.ao, TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(Blocks.sv, "_lit", ModelTemplates.ao, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.sv).a(BlockModelGenerators.a(BlockProperties.D, resourceLocation2, resourceLocation)));
        MinecraftKey resourceLocation3 = this.a(Blocks.sw, "", ModelTemplates.ao, TextureMapping::c);
        MinecraftKey resourceLocation4 = this.a(Blocks.sw, "_lit", ModelTemplates.ao, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.sw).a(BlockModelGenerators.a(BlockProperties.D, resourceLocation4, resourceLocation3)));
    }

    private void ak() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.fB, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.fB, "_on", ModelTemplates.c, TextureMapping::b);
        this.b.accept(MultiVariantGenerator.a(Blocks.fB).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)));
    }

    private void l(Block torch, Block wallTorch) {
        TextureMapping textureMapping = TextureMapping.y(torch);
        this.b.accept(BlockModelGenerators.c(torch, ModelTemplates.bf.a(torch, textureMapping, this.c)));
        this.b.accept(MultiVariantGenerator.a(wallTorch, Variant.a().a(VariantProperties.c, ModelTemplates.bg.a(wallTorch, textureMapping, this.c))).a(BlockModelGenerators.d()));
        this.d(torch);
        this.c(wallTorch);
    }

    private void al() {
        TextureMapping textureMapping = TextureMapping.y(Blocks.dK);
        TextureMapping textureMapping2 = TextureMapping.i(TextureMapping.a(Blocks.dK, "_off"));
        MinecraftKey resourceLocation = ModelTemplates.bf.a(Blocks.dK, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bf.a(Blocks.dK, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dK).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation, resourceLocation2)));
        MinecraftKey resourceLocation3 = ModelTemplates.bg.a(Blocks.dL, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bg.a(Blocks.dL, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dL).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation4)).a(BlockModelGenerators.d()));
        this.d(Blocks.dK);
        this.c(Blocks.dL);
    }

    private void am() {
        this.a(Items.lK);
        this.b.accept(MultiVariantGenerator.a(Blocks.eh).a(PropertyDispatch.a(BlockProperties.aA, BlockProperties.s, BlockProperties.w).a((T1 tick, T2 locked, T3 on) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('_').append(tick).append("tick");
            if (on.booleanValue()) {
                stringBuilder.append("_on");
            }
            if (locked.booleanValue()) {
                stringBuilder.append("_locked");
            }
            return Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.eh, stringBuilder.toString()));
        })).a(BlockModelGenerators.c()));
    }

    private void an() {
        this.a(Items.cT);
        this.b.accept(MultiVariantGenerator.a(Blocks.mV).a(PropertyDispatch.a(BlockProperties.aS, BlockProperties.C).a((Integer)1, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("dead_sea_pickle")))).a((Integer)2, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_dead_sea_pickles")))).a((Integer)3, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_dead_sea_pickles")))).a((Integer)4, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_dead_sea_pickles")))).a((Integer)1, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("sea_pickle")))).a((Integer)2, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_sea_pickles")))).a((Integer)3, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_sea_pickles")))).a((Integer)4, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_sea_pickles"))))));
    }

    private void ao() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.dN);
        MinecraftKey resourceLocation = ModelTemplates.c.a(Blocks.dP, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dN).a(PropertyDispatch.a(BlockProperties.aF).a((T1 height) -> Variant.a().a(VariantProperties.c, height < 8 ? ModelLocationUtils.a(Blocks.dN, "_height" + height * 2) : resourceLocation))));
        this.a(Blocks.dN, ModelLocationUtils.a(Blocks.dN, "_height2"));
        this.b.accept(BlockModelGenerators.c(Blocks.dP, resourceLocation));
    }

    private void ap() {
        this.b.accept(MultiVariantGenerator.a(Blocks.oc, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.oc))).a(BlockModelGenerators.b()));
    }

    private void aq() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.pa, this.c);
        this.a(Blocks.pa, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.pa).a(PropertyDispatch.a(BlockProperties.bj).a((T1 mode) -> Variant.a().a(VariantProperties.c, this.a(Blocks.pa, "_" + mode.c(), ModelTemplates.c, TextureMapping::b)))));
    }

    private void ar() {
        this.a(Items.wu);
        this.b.accept(MultiVariantGenerator.a(Blocks.oi).a(PropertyDispatch.a(BlockProperties.as).a((T1 stage) -> Variant.a().a(VariantProperties.c, this.a(Blocks.oi, "_stage" + stage, ModelTemplates.ao, TextureMapping::c)))));
    }

    private void as() {
        this.a(Items.ps);
        this.b.accept(MultiVariantGenerator.a(Blocks.fI).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.M, BlockProperties.L, BlockProperties.N, BlockProperties.O).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_n"))).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ne"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_nse"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_nsew"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ns"))).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_n"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ne"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ns"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_nse"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fI, "_attached_nsew")))));
    }

    private void at() {
        this.d(Blocks.fH);
        this.b.accept(MultiVariantGenerator.a(Blocks.fH).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.w).a((T1 boolean_, T2 boolean2) -> Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fH, (boolean_ != false ? "_attached" : "") + (boolean2 != false ? "_on" : ""))))).a(BlockModelGenerators.b()));
    }

    private MinecraftKey a(int eggs, String prefix, TextureMapping textures) {
        switch (eggs) {
            case 1: {
                return ModelTemplates.bl.a(ModelLocationUtils.a(prefix + "turtle_egg"), textures, this.c);
            }
            case 2: {
                return ModelTemplates.bm.a(ModelLocationUtils.a("two_" + prefix + "turtle_eggs"), textures, this.c);
            }
            case 3: {
                return ModelTemplates.bn.a(ModelLocationUtils.a("three_" + prefix + "turtle_eggs"), textures, this.c);
            }
            case 4: {
                return ModelTemplates.bo.a(ModelLocationUtils.a("four_" + prefix + "turtle_eggs"), textures, this.c);
            }
        }
        throw new UnsupportedOperationException();
    }

    private MinecraftKey a(Integer eggs, Integer hatch) {
        switch (hatch) {
            case 0: {
                return this.a(eggs, "", TextureMapping.b(TextureMapping.G(Blocks.mf)));
            }
            case 1: {
                return this.a(eggs, "slightly_cracked_", TextureMapping.b(TextureMapping.a(Blocks.mf, "_slightly_cracked")));
            }
            case 2: {
                return this.a(eggs, "very_cracked_", TextureMapping.b(TextureMapping.a(Blocks.mf, "_very_cracked")));
            }
        }
        throw new UnsupportedOperationException();
    }

    private void au() {
        this.a(Items.kp);
        this.b.accept(MultiVariantGenerator.a(Blocks.mf).a(PropertyDispatch.a(BlockProperties.aD, BlockProperties.aE).b((T1 integer, T2 integer2) -> Arrays.asList(BlockModelGenerators.a(this.a((Integer)integer, (Integer)integer2))))));
    }

    private void av() {
        this.a(Items.kq);
        Function<Integer, MinecraftKey> function = hatch -> {
            String string = switch (hatch) {
                case 1 -> "_slightly_cracked";
                case 2 -> "_very_cracked";
                default -> "_not_cracked";
            };
            TextureMapping textureMapping = TextureMapping.a(string);
            return ModelTemplates.bw.a(Blocks.mg, string, textureMapping, this.c);
        };
        this.b.accept(MultiVariantGenerator.a(Blocks.mg).a(PropertyDispatch.a(SnifferEggBlock.c).a((T1 hatch) -> Variant.a().a(VariantProperties.c, (MinecraftKey)function.apply((Integer)hatch)))));
    }

    private void F(Block block) {
        this.d(block);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        Condition.c terminalCondition2 = SystemUtils.a(Condition.a(), (? super T terminalCondition) -> a.stream().map(Pair::getFirst).forEach(property -> {
            if (block.o().b(property)) {
                terminalCondition.a(property, false);
            }
        }));
        for (Pair<BlockStateBoolean, Function<MinecraftKey, Variant>> pair : a) {
            BlockStateBoolean booleanProperty = (BlockStateBoolean)pair.getFirst();
            Function function = (Function)pair.getSecond();
            if (!block.o().b(booleanProperty)) continue;
            multiPartGenerator.a((Condition)Condition.a().a(booleanProperty, true), (Variant)function.apply(resourceLocation));
            multiPartGenerator.a((Condition)terminalCondition2, (Variant)function.apply(resourceLocation));
        }
        this.b.accept(multiPartGenerator);
    }

    private void aw() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.qU, "_bottom");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, TextureMapping.a(Blocks.qU, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.qU, "_side"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, TextureMapping.a(Blocks.qU, "_top_bloom")).a(TextureSlot.i, TextureMapping.a(Blocks.qU, "_side_bloom"));
        MinecraftKey resourceLocation2 = ModelTemplates.n.a(Blocks.qU, "", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.n.a(Blocks.qU, "_bloom", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.qU).a(PropertyDispatch.a(BlockProperties.E).a((T1 bloom) -> Variant.a().a(VariantProperties.c, bloom != false ? resourceLocation3 : resourceLocation2))));
        this.a(Items.gj, resourceLocation2);
    }

    private void ax() {
        Block block = Blocks.cm;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        List.of(Pair.of((Object)EnumDirection.c, (Object)((Object)VariantProperties.a.a)), Pair.of((Object)EnumDirection.f, (Object)((Object)VariantProperties.a.b)), Pair.of((Object)EnumDirection.d, (Object)((Object)VariantProperties.a.c)), Pair.of((Object)EnumDirection.e, (Object)((Object)VariantProperties.a.d))).forEach(pair -> {
            EnumDirection direction = (EnumDirection)pair.getFirst();
            VariantProperties.a rotation = (VariantProperties.a)((Object)((Object)pair.getSecond()));
            Condition.c terminalCondition = Condition.a().a(BlockProperties.R, direction);
            multiPartGenerator.a((Condition)terminalCondition, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, rotation).a(VariantProperties.d, true));
            this.a(multiPartGenerator, terminalCondition, rotation);
        });
        this.b.accept(multiPartGenerator);
        this.a(block, ModelLocationUtils.a(block, "_inventory"));
        i.clear();
    }

    private void a(MultiPartGenerator blockStateSupplier, Condition.c facingCondition, VariantProperties.a rotation) {
        List.of(Pair.of((Object)BlockProperties.bp, (Object)ModelTemplates.aM), Pair.of((Object)BlockProperties.bq, (Object)ModelTemplates.aN), Pair.of((Object)BlockProperties.br, (Object)ModelTemplates.aO), Pair.of((Object)BlockProperties.bs, (Object)ModelTemplates.aP), Pair.of((Object)BlockProperties.bt, (Object)ModelTemplates.aQ), Pair.of((Object)BlockProperties.bu, (Object)ModelTemplates.aR)).forEach(pair -> {
            BlockStateBoolean booleanProperty = (BlockStateBoolean)pair.getFirst();
            ModelTemplate modelTemplate = (ModelTemplate)pair.getSecond();
            this.a(blockStateSupplier, facingCondition, rotation, booleanProperty, modelTemplate, true);
            this.a(blockStateSupplier, facingCondition, rotation, booleanProperty, modelTemplate, false);
        });
    }

    private void a(MultiPartGenerator blockStateSupplier, Condition.c facingCondition, VariantProperties.a rotation, BlockStateBoolean property, ModelTemplate model, boolean occupied) {
        String string = occupied ? "_occupied" : "_empty";
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.b, TextureMapping.a(Blocks.cm, string));
        d bookSlotModelCacheKey = new d(model, string);
        MinecraftKey resourceLocation = i.computeIfAbsent(bookSlotModelCacheKey, key -> model.a(Blocks.cm, string, textureMapping, this.c));
        blockStateSupplier.a(Condition.a(facingCondition, Condition.a().a(property, occupied)), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, rotation));
    }

    private void ay() {
        this.b.accept(BlockModelGenerators.c(Blocks.kJ, ModelTemplates.c.a(Blocks.kJ, TextureMapping.b(ModelLocationUtils.a("magma")), this.c)));
    }

    private void G(Block shulkerBox) {
        this.b(shulkerBox, TexturedModel.q);
        ModelTemplates.bD.a(ModelLocationUtils.a(shulkerBox.r()), TextureMapping.u(shulkerBox), this.c);
    }

    private void b(Block plant, Block plantStem, e tintType) {
        this.b(plant, tintType);
        this.b(plantStem, tintType);
    }

    private void m(Block bed, Block particleSource) {
        ModelTemplates.bE.a(ModelLocationUtils.a(bed.r()), TextureMapping.u(particleSource), this.c);
    }

    private void az() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.b);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.b, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.eN, resourceLocation, resourceLocation2));
        this.a(Blocks.eN, resourceLocation);
    }

    private void aA() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.sJ);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.sJ, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.td, resourceLocation, resourceLocation2).a(BlockModelGenerators.f()));
        this.a(Blocks.td, resourceLocation);
    }

    private void n(Block root, Block pottedRoot) {
        this.a(root, net.minecraft.data.models.BlockModelGenerators$e.b);
        TextureMapping textureMapping = TextureMapping.d(TextureMapping.a(root, "_pot"));
        MinecraftKey resourceLocation = net.minecraft.data.models.BlockModelGenerators$e.b.b().a(pottedRoot, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(pottedRoot, resourceLocation));
    }

    private void aB() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.pl, "_bottom");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.pl, "_top_off");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.pl, "_top");
        MinecraftKey[] resourceLocations = new MinecraftKey[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, i2 == 0 ? resourceLocation2 : resourceLocation3).a(TextureSlot.i, TextureMapping.a(Blocks.pl, "_side" + i2));
            resourceLocations[i2] = ModelTemplates.n.a(Blocks.pl, "_" + i2, textureMapping, this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.pl).a(PropertyDispatch.a(BlockProperties.aZ).a((T1 charges) -> Variant.a().a(VariantProperties.c, resourceLocations[charges]))));
        this.a(Items.wS, resourceLocations[0]);
    }

    private Variant a(BlockPropertyJigsawOrientation orientation, Variant variant) {
        switch (orientation) {
            case b: {
                return variant.a(VariantProperties.a, VariantProperties.a.b);
            }
            case c: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c);
            }
            case d: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d);
            }
            case a: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b);
            }
            case f: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.c);
            }
            case g: {
                return variant.a(VariantProperties.a, VariantProperties.a.d);
            }
            case h: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.b);
            }
            case e: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.d);
            }
            case k: {
                return variant;
            }
            case l: {
                return variant.a(VariantProperties.b, VariantProperties.a.c);
            }
            case i: {
                return variant.a(VariantProperties.b, VariantProperties.a.d);
            }
            case j: {
                return variant.a(VariantProperties.b, VariantProperties.a.b);
            }
        }
        throw new UnsupportedOperationException("Rotation " + String.valueOf(orientation) + " can't be expressed with existing x and y values");
    }

    private void aC() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.pb, "_top");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.pb, "_bottom");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.pb, "_side");
        MinecraftKey resourceLocation4 = TextureMapping.a(Blocks.pb, "_lock");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.o, resourceLocation3).a(TextureSlot.m, resourceLocation3).a(TextureSlot.l, resourceLocation3).a(TextureSlot.c, resourceLocation).a(TextureSlot.j, resourceLocation).a(TextureSlot.k, resourceLocation2).a(TextureSlot.n, resourceLocation4);
        MinecraftKey resourceLocation5 = ModelTemplates.b.a(Blocks.pb, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.pb, Variant.a().a(VariantProperties.c, resourceLocation5)).a(PropertyDispatch.a(BlockProperties.T).a((T1 frontAndTop) -> this.a((BlockPropertyJigsawOrientation)frontAndTop, Variant.a()))));
    }

    private void aD() {
        Block block = Blocks.n;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        TexturedModel texturedModel = TexturedModel.a.get(block);
        Block block2 = Blocks.jH;
        MinecraftKey resourceLocation2 = ModelTemplates.ab.a(block2, texturedModel.b(), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ac.a(block2, texturedModel.b(), this.c);
        this.b.accept(BlockModelGenerators.e(block2, resourceLocation2, resourceLocation3, resourceLocation));
    }

    public void a() {
        BlockFamilies.a().filter(BlockFamily::c).forEach(family -> this.h(family.a()).a((BlockFamily)family));
        this.h(Blocks.rf).a(BlockFamilies.w).a(Blocks.rf, Blocks.rD).a(Blocks.rj, Blocks.rn).a(BlockFamilies.y);
        this.h(Blocks.re).a(BlockFamilies.A).a(Blocks.re, Blocks.rC).a(Blocks.ri, Blocks.rm).a(BlockFamilies.C);
        this.h(Blocks.rd).a(BlockFamilies.E).a(Blocks.rd, Blocks.rB).a(Blocks.rh, Blocks.rl).a(BlockFamilies.G);
        this.h(Blocks.rc).a(BlockFamilies.I).a(Blocks.rc, Blocks.rA).a(Blocks.rg, Blocks.rk).a(BlockFamilies.K);
        this.w(Blocks.sk);
        this.w(Blocks.sl);
        this.w(Blocks.sm);
        this.w(Blocks.sn);
        this.i(Blocks.sk, Blocks.so);
        this.i(Blocks.sl, Blocks.sp);
        this.i(Blocks.sm, Blocks.sq);
        this.i(Blocks.sn, Blocks.sr);
        this.m(Blocks.a);
        this.c(Blocks.nc, Blocks.a);
        this.c(Blocks.nb, Blocks.a);
        this.m(Blocks.fO);
        this.m(Blocks.dQ);
        this.c(Blocks.nd, Blocks.G);
        this.m(Blocks.fA);
        this.m(Blocks.me);
        this.m(Blocks.fr);
        this.m(Blocks.fR);
        this.a(Items.ue);
        this.m(Blocks.pg);
        this.m(Blocks.G);
        this.m(Blocks.H);
        this.m(Blocks.hV);
        this.a(Items.fS);
        this.o(Blocks.pM, Blocks.qd);
        this.o(Blocks.pN, Blocks.qe);
        this.o(Blocks.pO, Blocks.qf);
        this.o(Blocks.pP, Blocks.qg);
        this.o(Blocks.pQ, Blocks.qh);
        this.o(Blocks.pR, Blocks.qi);
        this.o(Blocks.pS, Blocks.qj);
        this.o(Blocks.pT, Blocks.qk);
        this.o(Blocks.pU, Blocks.ql);
        this.o(Blocks.pV, Blocks.qm);
        this.o(Blocks.pW, Blocks.qn);
        this.o(Blocks.pX, Blocks.qo);
        this.o(Blocks.pY, Blocks.qp);
        this.o(Blocks.pZ, Blocks.qq);
        this.o(Blocks.qa, Blocks.qr);
        this.o(Blocks.qb, Blocks.qs);
        this.o(Blocks.pL, Blocks.qc);
        this.m(Blocks.na);
        this.m(Blocks.gs);
        this.m(Blocks.qP);
        this.m(Blocks.sx);
        this.s(Blocks.sy);
        this.s(Blocks.sz);
        this.t(Blocks.ti);
        this.t(Blocks.tj);
        this.aj();
        this.g(Blocks.sC, Blocks.sA);
        this.p(Blocks.sB);
        this.a(Blocks.hW, Items.hB);
        this.a(Items.hB);
        this.aE();
        this.a(Blocks.kN, Items.jb);
        this.a(Items.jb);
        this.f(Blocks.bQ, TextureMapping.a(Blocks.by, "_side"));
        this.a(Blocks.R);
        this.a(Blocks.S);
        this.a(Blocks.iB);
        this.a(Blocks.cx);
        this.a(Blocks.cy);
        this.a(Blocks.cz);
        this.a(Blocks.fE);
        this.a(Blocks.fF);
        this.a(Blocks.fJ);
        this.a(Blocks.N);
        this.a(Blocks.T);
        this.a(Blocks.O);
        this.a(Blocks.ch);
        this.a(Blocks.P);
        this.a(Blocks.Q);
        this.a(Blocks.ci);
        this.b(Blocks.pj, TexturedModel.d);
        this.a(Blocks.pi);
        this.a(Blocks.aR);
        this.a(Blocks.aS);
        this.a(Blocks.aT);
        this.a(Blocks.hb);
        this.a(Blocks.dI);
        this.a(Blocks.dJ);
        this.a(Blocks.ha);
        this.a(Blocks.pC);
        this.a(Blocks.mW);
        this.a(Blocks.dR);
        this.a(Blocks.k);
        this.a(Blocks.pk);
        this.a(Blocks.fz);
        this.a(Blocks.ec);
        this.a(Blocks.L);
        this.a(Blocks.ph);
        this.a(Blocks.dO);
        this.b(Blocks.dT, TexturedModel.g);
        this.b(Blocks.pq, TexturedModel.d);
        this.b(Blocks.fa, TexturedModel.d);
        this.m(Blocks.ac);
        this.m(Blocks.ga);
        this.a(Blocks.kK);
        this.a(Blocks.aY);
        this.a(Blocks.iC);
        this.a(Blocks.co);
        this.a(Blocks.pK);
        this.a(Blocks.ii);
        this.a(Blocks.oy);
        this.a(Blocks.dW);
        this.a(Blocks.dX);
        this.b(Blocks.ct, TexturedModel.b);
        this.a(Blocks.aO);
        this.b(Blocks.bw, TexturedModel.v);
        this.a(Items.cS);
        this.b(Blocks.ck, TexturedModel.f);
        this.b(Blocks.pd, TexturedModel.d);
        this.a(Blocks.op);
        this.a(Blocks.aP);
        this.a(Blocks.qt);
        this.a(Blocks.qu);
        this.a(Blocks.qN);
        this.a(Blocks.su);
        this.a(Blocks.tf);
        this.a(Blocks.tg);
        this.a(Blocks.th);
        this.e(Blocks.qS);
        this.m(Blocks.tt);
        this.aD();
        this.a(Blocks.ra);
        this.a(Blocks.rb);
        this.a(Blocks.qW);
        this.a(Blocks.qX);
        this.a(Blocks.qY);
        this.a(Blocks.qZ);
        this.k(Blocks.qW, Blocks.rw);
        this.k(Blocks.qX, Blocks.ry);
        this.k(Blocks.qY, Blocks.rx);
        this.k(Blocks.qZ, Blocks.rz);
        this.i(Blocks.rM);
        this.i(Blocks.rN);
        this.i(Blocks.rP);
        this.i(Blocks.rO);
        this.a(Blocks.rM, Blocks.rQ);
        this.a(Blocks.rN, Blocks.rR);
        this.a(Blocks.rP, Blocks.rT);
        this.a(Blocks.rO, Blocks.rS);
        this.k(Blocks.rU);
        this.k(Blocks.rV);
        this.k(Blocks.rX);
        this.k(Blocks.rW);
        this.b(Blocks.rU, Blocks.rY);
        this.b(Blocks.rV, Blocks.rZ);
        this.b(Blocks.rX, Blocks.sb);
        this.b(Blocks.rW, Blocks.sa);
        this.a(Blocks.sc);
        this.a(Blocks.sd);
        this.a(Blocks.se);
        this.a(Blocks.sf);
        this.k(Blocks.sc, Blocks.sg);
        this.k(Blocks.sd, Blocks.sh);
        this.k(Blocks.se, Blocks.si);
        this.k(Blocks.sf, Blocks.sj);
        this.j(Blocks.gW, Blocks.ch);
        this.j(Blocks.gX, Blocks.ci);
        this.G();
        this.r();
        this.ax();
        this.v();
        this.w();
        this.a(new Block[]{Blocks.og, Blocks.oh});
        this.x();
        this.A();
        this.B();
        this.E();
        this.F();
        this.I();
        this.D();
        this.z(Blocks.kt);
        this.J();
        this.K();
        this.L();
        this.M();
        this.P();
        this.Q();
        this.R();
        this.S();
        this.q();
        this.T();
        this.U();
        this.V();
        this.W();
        this.Y();
        this.Z();
        this.aa();
        this.ab();
        this.ac();
        this.ai();
        this.al();
        this.ak();
        this.am();
        this.an();
        this.y();
        this.ao();
        this.ap();
        this.aq();
        this.ar();
        this.as();
        this.at();
        this.au();
        this.av();
        this.F(Blocks.ff);
        this.F(Blocks.fg);
        this.F(Blocks.qT);
        this.ay();
        this.aC();
        this.af();
        this.ag();
        this.ah();
        this.X();
        this.O();
        this.N();
        this.ad();
        this.ae();
        this.E(Blocks.cO);
        this.d(Blocks.cO);
        this.E(Blocks.oa);
        this.g();
        this.E(Blocks.sE);
        this.l(Blocks.cp, Blocks.cq);
        this.l(Blocks.ea, Blocks.eb);
        this.a(Blocks.cA, Blocks.n, TextureMapping::c);
        this.a(Blocks.nY, Blocks.p, TextureMapping::d);
        this.y(Blocks.ow);
        this.y(Blocks.on);
        this.v(Blocks.aU);
        this.v(Blocks.hi);
        this.C();
        this.D(Blocks.oe);
        this.D(Blocks.of);
        this.e(Blocks.eX, ModelLocationUtils.a(Blocks.eX));
        this.a(Blocks.dY, TexturedModel.d);
        this.a(Blocks.dZ, TexturedModel.d);
        this.a(Blocks.te);
        this.a(Blocks.kM, TexturedModel.d);
        this.f(Blocks.j);
        this.f(Blocks.sH);
        this.f(Blocks.I);
        this.g(Blocks.J);
        this.g(Blocks.M);
        this.f(Blocks.K);
        this.e(Blocks.F);
        this.b(Blocks.to, TexturedModel.f);
        this.a(Blocks.ij, TexturedModel.d, TexturedModel.e);
        this.a(Blocks.kx, TexturedModel.w, TexturedModel.x);
        this.a(Blocks.hf, TexturedModel.w, TexturedModel.x);
        this.a(Blocks.tk, TexturedModel.d, TexturedModel.e);
        this.a(Blocks.tl, TexturedModel.d, TexturedModel.e);
        this.a(Blocks.tm, TexturedModel.d, TexturedModel.e);
        this.c(Blocks.nT, TexturedModel.i);
        this.z();
        this.a(Blocks.pe, TextureMapping::A);
        this.a(Blocks.pf, TextureMapping::C);
        this.a(Blocks.kD, BlockProperties.as, 0, 1, 2, 3);
        this.a(Blocks.gt, BlockProperties.av, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.fq, BlockProperties.as, 0, 1, 1, 2);
        this.a(Blocks.gu, BlockProperties.av, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.cB, BlockProperties.av, 0, 1, 2, 3, 4, 5, 6, 7);
        this.a(Blocks.kA, net.minecraft.data.models.BlockModelGenerators$e.b, BlockProperties.aq, 0, 1);
        this.i();
        this.h();
        this.a(ModelLocationUtils.a("decorated_pot"), Blocks.iA).b(Blocks.tp);
        this.a(ModelLocationUtils.a("banner"), Blocks.n).a(ModelTemplates.bF, Blocks.iJ, Blocks.iK, Blocks.iL, Blocks.iM, Blocks.iN, Blocks.iO, Blocks.iP, Blocks.iQ, Blocks.iR, Blocks.iS, Blocks.iT, Blocks.iU, Blocks.iV, Blocks.iW, Blocks.iX, Blocks.iY).b(Blocks.iZ, Blocks.ja, Blocks.jb, Blocks.jc, Blocks.jd, Blocks.je, Blocks.jf, Blocks.jg, Blocks.jh, Blocks.ji, Blocks.jj, Blocks.jk, Blocks.jl, Blocks.jm, Blocks.jn, Blocks.jo);
        this.a(ModelLocationUtils.a("bed"), Blocks.n).b(Blocks.aZ, Blocks.ba, Blocks.bb, Blocks.bc, Blocks.bd, Blocks.be, Blocks.bf, Blocks.bg, Blocks.bh, Blocks.bi, Blocks.bj, Blocks.bk, Blocks.bl, Blocks.bm, Blocks.bn, Blocks.bo);
        this.m(Blocks.aZ, Blocks.bA);
        this.m(Blocks.ba, Blocks.bB);
        this.m(Blocks.bb, Blocks.bC);
        this.m(Blocks.bc, Blocks.bD);
        this.m(Blocks.bd, Blocks.bE);
        this.m(Blocks.be, Blocks.bF);
        this.m(Blocks.bf, Blocks.bG);
        this.m(Blocks.bg, Blocks.bH);
        this.m(Blocks.bh, Blocks.bI);
        this.m(Blocks.bi, Blocks.bJ);
        this.m(Blocks.bj, Blocks.bK);
        this.m(Blocks.bk, Blocks.bL);
        this.m(Blocks.bl, Blocks.bM);
        this.m(Blocks.bm, Blocks.bN);
        this.m(Blocks.bn, Blocks.bO);
        this.m(Blocks.bo, Blocks.bP);
        this.a(ModelLocationUtils.a("skull"), Blocks.dW).a(ModelTemplates.bG, Blocks.gM, Blocks.gK, Blocks.gI, Blocks.gE, Blocks.gG, Blocks.gQ).a(Blocks.gO).b(Blocks.gN, Blocks.gP, Blocks.gL, Blocks.gJ, Blocks.gF, Blocks.gH, Blocks.gR);
        this.G(Blocks.kP);
        this.G(Blocks.kQ);
        this.G(Blocks.kR);
        this.G(Blocks.kS);
        this.G(Blocks.kT);
        this.G(Blocks.kU);
        this.G(Blocks.kV);
        this.G(Blocks.kW);
        this.G(Blocks.kX);
        this.G(Blocks.kY);
        this.G(Blocks.kZ);
        this.G(Blocks.la);
        this.G(Blocks.lb);
        this.G(Blocks.lc);
        this.G(Blocks.ld);
        this.G(Blocks.le);
        this.G(Blocks.lf);
        this.b(Blocks.mX, TexturedModel.q);
        this.c(Blocks.mX);
        this.a(ModelLocationUtils.a("chest"), Blocks.n).b(Blocks.cv, Blocks.gV);
        this.a(ModelLocationUtils.a("ender_chest"), Blocks.co).b(Blocks.fG);
        this.f(Blocks.fx, Blocks.co).a(Blocks.fx, Blocks.kF);
        this.a(Blocks.aM);
        this.a(Blocks.aN);
        this.a(Blocks.lw);
        this.a(Blocks.lx);
        this.a(Blocks.ly);
        this.a(Blocks.lz);
        this.a(Blocks.lA);
        this.a(Blocks.lB);
        this.a(Blocks.lC);
        this.a(Blocks.lD);
        this.a(Blocks.lE);
        this.a(Blocks.lF);
        this.a(Blocks.lG);
        this.a(Blocks.lH);
        this.a(Blocks.lI);
        this.a(Blocks.lJ);
        this.a(Blocks.lK);
        this.a(Blocks.lL);
        this.a(TexturedModel.a, Blocks.lM, Blocks.lN, Blocks.lO, Blocks.lP, Blocks.lQ, Blocks.lR, Blocks.lS, Blocks.lT, Blocks.lU, Blocks.lV, Blocks.lW, Blocks.lX, Blocks.lY, Blocks.lZ, Blocks.ma, Blocks.mb);
        this.a(Blocks.iA);
        this.a(Blocks.hj);
        this.a(Blocks.hk);
        this.a(Blocks.hl);
        this.a(Blocks.hm);
        this.a(Blocks.hn);
        this.a(Blocks.ho);
        this.a(Blocks.hp);
        this.a(Blocks.hq);
        this.a(Blocks.hr);
        this.a(Blocks.hs);
        this.a(Blocks.ht);
        this.a(Blocks.hu);
        this.a(Blocks.hv);
        this.a(Blocks.hw);
        this.a(Blocks.hx);
        this.a(Blocks.hy);
        this.a(Blocks.qO);
        this.h(Blocks.aQ, Blocks.eY);
        this.h(Blocks.ei, Blocks.hz);
        this.h(Blocks.ej, Blocks.hA);
        this.h(Blocks.ek, Blocks.hB);
        this.h(Blocks.el, Blocks.hC);
        this.h(Blocks.em, Blocks.hD);
        this.h(Blocks.en, Blocks.hE);
        this.h(Blocks.eo, Blocks.hF);
        this.h(Blocks.ep, Blocks.hG);
        this.h(Blocks.eq, Blocks.hH);
        this.h(Blocks.er, Blocks.hI);
        this.h(Blocks.es, Blocks.hJ);
        this.h(Blocks.et, Blocks.hK);
        this.h(Blocks.eu, Blocks.hL);
        this.h(Blocks.ev, Blocks.hM);
        this.h(Blocks.ew, Blocks.hN);
        this.h(Blocks.ex, Blocks.hO);
        this.b(TexturedModel.o, Blocks.lg, Blocks.lh, Blocks.li, Blocks.lj, Blocks.lk, Blocks.ll, Blocks.lm, Blocks.ln, Blocks.lo, Blocks.lp, Blocks.lq, Blocks.lr, Blocks.ls, Blocks.lt, Blocks.lu, Blocks.lv);
        this.g(Blocks.bA, Blocks.ik);
        this.g(Blocks.bB, Blocks.il);
        this.g(Blocks.bC, Blocks.im);
        this.g(Blocks.bD, Blocks.in);
        this.g(Blocks.bE, Blocks.io);
        this.g(Blocks.bF, Blocks.ip);
        this.g(Blocks.bG, Blocks.iq);
        this.g(Blocks.bH, Blocks.ir);
        this.g(Blocks.bI, Blocks.is);
        this.g(Blocks.bJ, Blocks.it);
        this.g(Blocks.bK, Blocks.iu);
        this.g(Blocks.bL, Blocks.iv);
        this.g(Blocks.bM, Blocks.iw);
        this.g(Blocks.bN, Blocks.ix);
        this.g(Blocks.bO, Blocks.iy);
        this.g(Blocks.bP, Blocks.iz);
        this.a(Blocks.sI);
        this.a(Blocks.eL);
        this.a(Blocks.bu, Blocks.gb, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Blocks.bR, Blocks.gc, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bT, Blocks.gd, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bU, Blocks.ge, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bV, Blocks.gf, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bW, Blocks.gg, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bX, Blocks.gh, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bY, Blocks.gi, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bZ, Blocks.gj, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ca, Blocks.gk, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cb, Blocks.gl, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cc, Blocks.gm, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ce, Blocks.gn, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cd, Blocks.go, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cg, Blocks.gp, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cf, Blocks.gq, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bv, Blocks.gr, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bS, Blocks.fS, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.H();
        this.u(Blocks.eT);
        this.u(Blocks.eU);
        this.u(Blocks.eV);
        this.a(Blocks.bt, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.b(Blocks.dS, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Items.dJ);
        this.b(Blocks.mc, Blocks.md, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Items.dK);
        this.c(Blocks.md);
        this.b(Blocks.sG, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.sG);
        this.c(Blocks.sw);
        this.b(Blocks.oz, Blocks.oA, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.oB, Blocks.oC, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.oz, "_plant");
        this.c(Blocks.oA);
        this.a(Blocks.oB, "_plant");
        this.c(Blocks.oC);
        this.a(Blocks.mY, net.minecraft.data.models.BlockModelGenerators$e.a, TextureMapping.c(TextureMapping.a(Blocks.mZ, "_stage0")));
        this.m();
        this.a(Blocks.bs, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iE, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iF, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iG, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iH, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.c(Blocks.iI, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.j();
        this.k();
        this.l();
        this.a(Blocks.mw, Blocks.mr, Blocks.mm, Blocks.mh, Blocks.mG, Blocks.mB, Blocks.mQ, Blocks.mL);
        this.a(Blocks.mx, Blocks.ms, Blocks.mn, Blocks.mi, Blocks.mH, Blocks.mC, Blocks.mR, Blocks.mM);
        this.a(Blocks.my, Blocks.mt, Blocks.mo, Blocks.mj, Blocks.mI, Blocks.mD, Blocks.mS, Blocks.mN);
        this.a(Blocks.mz, Blocks.mu, Blocks.mp, Blocks.mk, Blocks.mJ, Blocks.mE, Blocks.mT, Blocks.mO);
        this.a(Blocks.mA, Blocks.mv, Blocks.mq, Blocks.ml, Blocks.mK, Blocks.mF, Blocks.mU, Blocks.mP);
        this.e(Blocks.fe, Blocks.fc);
        this.e(Blocks.fd, Blocks.fb);
        this.l(Blocks.ab).c(Blocks.ab).a(Blocks.av);
        this.l(Blocks.am).c(Blocks.am).a(Blocks.aD);
        this.a(Blocks.am, Blocks.dj, Blocks.ds);
        this.b(Blocks.aL, TexturedModel.s);
        this.l(Blocks.Y).c(Blocks.Y).a(Blocks.as);
        this.l(Blocks.ai).c(Blocks.ai).a(Blocks.aA);
        this.a(Blocks.ai, Blocks.dd, Blocks.do);
        this.a(Blocks.B, Blocks.fX, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aI, TexturedModel.s);
        this.l(Blocks.Z).d(Blocks.Z).a(Blocks.at);
        this.l(Blocks.aj).d(Blocks.aj).a(Blocks.aB);
        this.a(Blocks.aj, Blocks.de, Blocks.dp);
        this.a(Blocks.C, Blocks.fY, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aJ, TexturedModel.s);
        this.l(Blocks.W).c(Blocks.W).a(Blocks.aq);
        this.l(Blocks.ag).c(Blocks.ag).a(Blocks.ay);
        this.a(Blocks.ag, Blocks.dc, Blocks.dn);
        this.a(Blocks.z, Blocks.fV, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aG, TexturedModel.s);
        this.l(Blocks.U).c(Blocks.U).a(Blocks.ao);
        this.l(Blocks.al).c(Blocks.al).a(Blocks.aw);
        this.a(Blocks.al, Blocks.da, Blocks.dl);
        this.a(Blocks.x, Blocks.fT, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aE, TexturedModel.s);
        this.l(Blocks.V).c(Blocks.V).a(Blocks.ap);
        this.l(Blocks.af).c(Blocks.af).a(Blocks.ax);
        this.a(Blocks.af, Blocks.db, Blocks.dm);
        this.a(Blocks.y, Blocks.fU, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aF, TexturedModel.s);
        this.l(Blocks.aa).c(Blocks.aa).a(Blocks.au);
        this.l(Blocks.ak).c(Blocks.ak).a(Blocks.aC);
        this.a(Blocks.ak, Blocks.dg, Blocks.dr);
        this.a(Blocks.D, Blocks.fZ, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aK, TexturedModel.s);
        this.l(Blocks.X).c(Blocks.X).a(Blocks.ar);
        this.l(Blocks.ah).c(Blocks.ah).a(Blocks.az);
        this.a(Blocks.ah, Blocks.df, Blocks.dq);
        this.a(Blocks.A, Blocks.fW, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aH, TexturedModel.s);
        this.l(Blocks.os).b(Blocks.os).a(Blocks.ou);
        this.l(Blocks.ot).b(Blocks.ot).a(Blocks.ov);
        this.a(Blocks.ot, Blocks.dh, Blocks.dt);
        this.a(Blocks.ox, Blocks.pm, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.n(Blocks.oD, Blocks.po);
        this.l(Blocks.oj).b(Blocks.oj).a(Blocks.ol);
        this.l(Blocks.ok).b(Blocks.ok).a(Blocks.om);
        this.a(Blocks.ok, Blocks.di, Blocks.du);
        this.a(Blocks.oo, Blocks.pn, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.n(Blocks.oq, Blocks.pp);
        this.l(Blocks.ae).d(Blocks.ae);
        this.l(Blocks.an).d(Blocks.an);
        this.a(Blocks.v, Blocks.dk, Blocks.dv);
        this.b(Blocks.or, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Items.dG);
        this.i(Blocks.dy);
        this.k(Blocks.hY);
        this.u();
        this.n(Blocks.cP);
        this.o(Blocks.bp);
        this.o(Blocks.bq);
        this.o(Blocks.hh);
        this.t();
        this.q(Blocks.fN);
        this.q(Blocks.kG);
        this.q(Blocks.kH);
        this.r(Blocks.gS);
        this.r(Blocks.gT);
        this.r(Blocks.gU);
        this.o();
        this.p();
        this.d(Blocks.cD, TexturedModel.h);
        this.d(Blocks.nW, TexturedModel.h);
        this.d(Blocks.nV, TexturedModel.i);
        this.s();
        this.aB();
        this.aw();
        this.k(Blocks.eK, Blocks.eS);
        this.k(Blocks.m, Blocks.eO);
        this.k(Blocks.eJ, Blocks.eR);
        this.k(Blocks.eI, Blocks.eQ);
        this.az();
        this.k(Blocks.eH, Blocks.eP);
        this.aA();
        ItemMonsterEgg.h().forEach(item -> this.a((Item)item, ModelLocationUtils.b("template_spawn_egg")));
    }

    private void aE() {
        this.c(Blocks.hX);
        PropertyDispatch.a<Integer> c1 = PropertyDispatch.a(BlockProperties.aP);
        for (int i2 = 0; i2 < 16; ++i2) {
            String string = String.format(Locale.ROOT, "_%02d", i2);
            MinecraftKey resourceLocation = TextureMapping.a(Items.hC, string);
            c1.a((Integer)i2, Variant.a().a(VariantProperties.c, ModelTemplates.aa.a(Blocks.hX, string, TextureMapping.h(resourceLocation), this.c)));
            ModelTemplates.bx.a(ModelLocationUtils.a(Items.hC, string), TextureMapping.k(resourceLocation), this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.hX).a(c1));
    }

    private void o(Block candle, Block cake) {
        this.a(candle.r());
        TextureMapping textureMapping = TextureMapping.b(TextureMapping.G(candle));
        TextureMapping textureMapping2 = TextureMapping.b(TextureMapping.a(candle, "_lit"));
        MinecraftKey resourceLocation = ModelTemplates.bH.a(candle, "_one_candle", textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bI.a(candle, "_two_candles", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bJ.a(candle, "_three_candles", textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bK.a(candle, "_four_candles", textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.bH.a(candle, "_one_candle_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.bI.a(candle, "_two_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.bJ.a(candle, "_three_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.bK.a(candle, "_four_candles_lit", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(candle).a(PropertyDispatch.a(BlockProperties.az, BlockProperties.r).a((Integer)1, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Integer)2, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation2)).a((Integer)3, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation3)).a((Integer)4, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation4)).a((Integer)1, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation5)).a((Integer)2, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation6)).a((Integer)3, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation7)).a((Integer)4, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation8))));
        MinecraftKey resourceLocation9 = ModelTemplates.bL.a(cake, TextureMapping.a(candle, false), this.c);
        MinecraftKey resourceLocation10 = ModelTemplates.bL.a(cake, "_lit", TextureMapping.a(candle, true), this.c);
        this.b.accept(MultiVariantGenerator.a(cake).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation10, resourceLocation9)));
    }

    private /* synthetic */ Variant a(int[] age, Int2ObjectMap int2ObjectMap, Block block, Integer integer) {
        int i2 = age[integer];
        MinecraftKey resourceLocation = (MinecraftKey)int2ObjectMap.computeIfAbsent(i2, j2 -> this.a(block, "_stage" + i2, ModelTemplates.aV, TextureMapping::g));
        return Variant.a().a(VariantProperties.c, resourceLocation);
    }

    @FunctionalInterface
    static interface c {
        public BlockStateGenerator create(Block var1, MinecraftKey var2, TextureMapping var3, BiConsumer<MinecraftKey, Supplier<JsonElement>> var4);
    }

    class b {
        private final TextureMapping b;
        private final Map<ModelTemplate, MinecraftKey> c = Maps.newHashMap();
        @Nullable
        private BlockFamily d;
        @Nullable
        private MinecraftKey e;
        private final Set<Block> f = new HashSet<Block>();

        public b(TextureMapping textures) {
            this.b = textures;
        }

        public b a(Block block, ModelTemplate model) {
            this.e = model.a(block, this.b, BlockModelGenerators.this.c);
            if (BlockModelGenerators.this.f.containsKey(block)) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.this.f.get(block).create(block, this.e, this.b, BlockModelGenerators.this.c));
            } else {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.e));
            }
            return this;
        }

        public b a(Block parent, Block child) {
            MinecraftKey resourceLocation = ModelLocationUtils.a(parent);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(child, resourceLocation));
            BlockModelGenerators.this.a(child, resourceLocation);
            this.f.add(child);
            return this;
        }

        public b a(Block buttonBlock) {
            MinecraftKey resourceLocation = ModelTemplates.s.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.t.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(buttonBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.u.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(buttonBlock, resourceLocation3);
            return this;
        }

        public b b(Block wallBlock) {
            MinecraftKey resourceLocation = ModelTemplates.M.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.N.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.O.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(wallBlock, resourceLocation, resourceLocation2, resourceLocation3));
            MinecraftKey resourceLocation4 = ModelTemplates.P.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(wallBlock, resourceLocation4);
            return this;
        }

        public b c(Block customFenceBlock) {
            TextureMapping textureMapping = TextureMapping.p(customFenceBlock);
            MinecraftKey resourceLocation = ModelTemplates.D.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.E.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.F.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.G.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation5 = ModelTemplates.H.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(customFenceBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5));
            MinecraftKey resourceLocation6 = ModelTemplates.I.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(customFenceBlock, resourceLocation6);
            return this;
        }

        public b d(Block fenceBlock) {
            MinecraftKey resourceLocation = ModelTemplates.J.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.K.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(fenceBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.L.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(fenceBlock, resourceLocation3);
            return this;
        }

        public b e(Block customFenceGateBlock) {
            TextureMapping textureMapping = TextureMapping.p(customFenceGateBlock);
            MinecraftKey resourceLocation = ModelTemplates.R.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.Q.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.T.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.S.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(customFenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, false));
            return this;
        }

        public b f(Block fenceGateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.V.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.U.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.X.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.W.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(fenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, true));
            return this;
        }

        public b g(Block pressurePlateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.Y.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.Z.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(pressurePlateBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public b h(Block signBlock) {
            if (this.d == null) {
                throw new IllegalStateException("Family not defined");
            }
            Block block = this.d.b().get((Object)BlockFamily.b.r);
            MinecraftKey resourceLocation = ModelTemplates.aa.a(signBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(signBlock, resourceLocation));
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, resourceLocation));
            BlockModelGenerators.this.a(signBlock.r());
            BlockModelGenerators.this.c(block);
            return this;
        }

        public b i(Block block) {
            if (this.e == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            MinecraftKey resourceLocation = this.a(ModelTemplates.ab, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.ac, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(block, resourceLocation, resourceLocation2, this.e));
            BlockModelGenerators.this.a(block, resourceLocation);
            return this;
        }

        public b j(Block block) {
            MinecraftKey resourceLocation = this.a(ModelTemplates.af, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.ae, block);
            MinecraftKey resourceLocation3 = this.a(ModelTemplates.ag, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(block, resourceLocation, resourceLocation2, resourceLocation3));
            BlockModelGenerators.this.a(block, resourceLocation2);
            return this;
        }

        private b k(Block block) {
            TexturedModel texturedModel = BlockModelGenerators.this.g.getOrDefault(block, TexturedModel.a.get(block));
            MinecraftKey resourceLocation = texturedModel.a(block, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, resourceLocation));
            return this;
        }

        private b l(Block block) {
            BlockModelGenerators.this.i(block);
            return this;
        }

        private void m(Block block) {
            if (BlockModelGenerators.this.e.contains(block)) {
                BlockModelGenerators.this.k(block);
            } else {
                BlockModelGenerators.this.j(block);
            }
        }

        private MinecraftKey a(ModelTemplate model, Block block) {
            return this.c.computeIfAbsent(model, newModel -> newModel.a(block, this.b, BlockModelGenerators.this.c));
        }

        public b a(BlockFamily family) {
            this.d = family;
            family.b().forEach((variant, block) -> {
                if (this.f.contains(block)) {
                    return;
                }
                BiConsumer<b, Block> biConsumer = h.get(variant);
                if (biConsumer != null) {
                    biConsumer.accept(this, (Block)block);
                }
            });
            return this;
        }
    }

    class f {
        private final TextureMapping b;

        public f(TextureMapping textures) {
            this.b = textures;
        }

        public f a(Block woodBlock) {
            TextureMapping textureMapping = this.b.c(TextureSlot.d, this.b.a(TextureSlot.i));
            MinecraftKey resourceLocation = ModelTemplates.j.a(woodBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(woodBlock, resourceLocation));
            return this;
        }

        public f b(Block stemBlock) {
            MinecraftKey resourceLocation = ModelTemplates.j.a(stemBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(stemBlock, resourceLocation));
            return this;
        }

        public f c(Block logBlock) {
            MinecraftKey resourceLocation = ModelTemplates.j.a(logBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.k.a(logBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(logBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public f d(Block logBlock) {
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(logBlock, this.b, BlockModelGenerators.this.c));
            return this;
        }
    }

    static final class e
    extends Enum<e> {
        public static final /* enum */ e a = new e();
        public static final /* enum */ e b = new e();
        private static final /* synthetic */ e[] c;

        public static e[] values() {
            return (e[])c.clone();
        }

        public static e valueOf(String string) {
            return Enum.valueOf(e.class, string);
        }

        public ModelTemplate a() {
            return this == a ? ModelTemplates.ap : ModelTemplates.ao;
        }

        public ModelTemplate b() {
            return this == a ? ModelTemplates.ar : ModelTemplates.aq;
        }

        private static /* synthetic */ e[] c() {
            return new e[]{a, b};
        }

        static {
            c = net.minecraft.data.models.BlockModelGenerators$e.c();
        }
    }

    class a {
        private final MinecraftKey b;

        public a(MinecraftKey modelId, Block block) {
            this.b = ModelTemplates.aa.a(modelId, TextureMapping.u(block), BlockModelGenerators.this.c);
        }

        public a a(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.b));
            }
            return this;
        }

        public a b(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.c(block);
            }
            return this.a(blocks);
        }

        public a a(ModelTemplate model, Block ... blocks) {
            for (Block block : blocks) {
                model.a(ModelLocationUtils.a(block.r()), TextureMapping.u(block), BlockModelGenerators.this.c);
            }
            return this.a(blocks);
        }
    }

    record d(ModelTemplate a, String b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this, object);
        }
    }
}

