/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TerrainProvider {
    private static final float a = -0.51f;
    private static final float b = -0.4f;
    private static final float c = 0.1f;
    private static final float d = -0.15f;
    private static final ToFloatFunction<Float> e = ToFloatFunction.a;
    private static final ToFloatFunction<Float> f = ToFloatFunction.a(value -> value < 0.0f ? value : value * 2.0f);
    private static final ToFloatFunction<Float> g = ToFloatFunction.a(value -> 1.25f - 6.25f / (value + 5.0f));
    private static final ToFloatFunction<Float> h = ToFloatFunction.a(value -> value * 2.0f);

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I continents, I erosion, I ridgesFolded, boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? f : e;
        CubicSpline<C, I> cubicSpline = TerrainProvider.a(erosion, ridgesFolded, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, toFloatFunction);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.a(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, toFloatFunction);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.a(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, toFloatFunction);
        CubicSpline<C, I> cubicSpline4 = TerrainProvider.a(erosion, ridgesFolded, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, toFloatFunction);
        return CubicSpline.a(continents, toFloatFunction).a(-1.1f, 0.044f).a(-1.02f, -0.2222f).a(-0.51f, -0.2222f).a(-0.44f, -0.12f).a(-0.18f, -0.12f).a(-0.16f, cubicSpline).a(-0.15f, cubicSpline).a(-0.1f, cubicSpline2).a(0.25f, cubicSpline3).a(1.0f, cubicSpline4).a();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? g : e;
        return CubicSpline.a(continents, e).a(-0.19f, 3.95f).a(-0.15f, TerrainProvider.a(erosion, ridges, ridgesFolded, 6.25f, true, e)).a(-0.1f, TerrainProvider.a(erosion, ridges, ridgesFolded, 5.47f, true, toFloatFunction)).a(0.03f, TerrainProvider.a(erosion, ridges, ridgesFolded, 5.08f, true, toFloatFunction)).a(0.06f, TerrainProvider.a(erosion, ridges, ridgesFolded, 4.69f, false, toFloatFunction)).a();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> b(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? h : e;
        float f2 = 0.65f;
        return CubicSpline.a(continents, toFloatFunction).a(-0.11f, 0.0f).a(0.03f, TerrainProvider.a(erosion, ridges, ridgesFolded, 1.0f, 0.5f, 0.0f, 0.0f, toFloatFunction)).a(0.65f, TerrainProvider.a(erosion, ridges, ridgesFolded, 1.0f, 1.0f, 1.0f, 0.0f, toFloatFunction)).a();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I erosion, I ridges, I ridgesFolded, float f2, float g2, float h2, float i2, ToFloatFunction<Float> amplifier) {
        float j2 = -0.5775f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.a(ridges, ridgesFolded, f2, h2, amplifier);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.a(ridges, ridgesFolded, g2, i2, amplifier);
        return CubicSpline.a(erosion, amplifier).a(-1.0f, cubicSpline).a(-0.78f, cubicSpline2).a(-0.5775f, cubicSpline2).a(-0.375f, 0.0f).a();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I ridges, I ridgesFolded, float f2, float g2, ToFloatFunction<Float> amplifier) {
        float h2 = NoiseRouterData.a(0.4f);
        float i2 = NoiseRouterData.a(0.56666666f);
        float j2 = (h2 + i2) / 2.0f;
        CubicSpline.b<C, I> builder = CubicSpline.a(ridgesFolded, amplifier);
        builder.a(h2, 0.0f);
        if (g2 > 0.0f) {
            builder.a(j2, TerrainProvider.a(ridges, g2, amplifier));
        } else {
            builder.a(j2, 0.0f);
        }
        if (f2 > 0.0f) {
            builder.a(1.0f, TerrainProvider.a(ridges, f2, amplifier));
        } else {
            builder.a(1.0f, 0.0f);
        }
        return builder.a();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I ridges, float f2, ToFloatFunction<Float> amplifier) {
        float g2 = 0.63f * f2;
        float h2 = 0.3f * f2;
        return CubicSpline.a(ridges, amplifier).a(-0.01f, g2).a(0.01f, h2).a();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I erosion, I ridges, I ridgesFolded, float f2, boolean bl, ToFloatFunction<Float> amplifier) {
        CubicSpline cubicSpline = CubicSpline.a(ridges, amplifier).a(-0.2f, 6.3f).a(0.2f, f2).a();
        CubicSpline.b builder = CubicSpline.a(erosion, amplifier).a(-0.6f, cubicSpline).a(-0.5f, CubicSpline.a(ridges, amplifier).a(-0.05f, 6.3f).a(0.05f, 2.67f).a()).a(-0.35f, cubicSpline).a(-0.25f, cubicSpline).a(-0.1f, CubicSpline.a(ridges, amplifier).a(-0.05f, 2.67f).a(0.05f, 6.3f).a()).a(0.03f, cubicSpline);
        if (bl) {
            CubicSpline cubicSpline2 = CubicSpline.a(ridges, amplifier).a(0.0f, f2).a(0.1f, 0.625f).a();
            CubicSpline cubicSpline3 = CubicSpline.a(ridgesFolded, amplifier).a(-0.9f, f2).a(-0.69f, cubicSpline2).a();
            builder.a(0.35f, f2).a(0.45f, cubicSpline3).a(0.55f, cubicSpline3).a(0.62f, f2);
        } else {
            CubicSpline cubicSpline4 = CubicSpline.a(ridgesFolded, amplifier).a(-0.7f, cubicSpline).a(-0.15f, 1.37f).a();
            CubicSpline cubicSpline5 = CubicSpline.a(ridgesFolded, amplifier).a(0.45f, cubicSpline).a(0.7f, 1.56f).a();
            builder.a(0.05f, cubicSpline5).a(0.4f, cubicSpline5).a(0.45f, cubicSpline4).a(0.55f, cubicSpline4).a(0.58f, f2);
        }
        return builder.a();
    }

    private static float a(float f2, float g2, float h2, float i2) {
        return (g2 - f2) / (i2 - h2);
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I ridgesFolded, float f2, boolean bl, ToFloatFunction<Float> amplifier) {
        CubicSpline.b builder = CubicSpline.a(ridgesFolded, amplifier);
        float g2 = -0.7f;
        float h2 = -1.0f;
        float i2 = TerrainProvider.a(-1.0f, f2, -0.7f);
        float j2 = 1.0f;
        float k2 = TerrainProvider.a(1.0f, f2, -0.7f);
        float l2 = TerrainProvider.a(f2);
        float m2 = -0.65f;
        if (-0.65f < l2 && l2 < 1.0f) {
            float n2 = TerrainProvider.a(-0.65f, f2, -0.7f);
            float o2 = -0.75f;
            float p2 = TerrainProvider.a(-0.75f, f2, -0.7f);
            float q2 = TerrainProvider.a(i2, p2, -1.0f, -0.75f);
            builder.a(-1.0f, i2, q2);
            builder.a(-0.75f, p2);
            builder.a(-0.65f, n2);
            float r2 = TerrainProvider.a(l2, f2, -0.7f);
            float s2 = TerrainProvider.a(r2, k2, l2, 1.0f);
            float t2 = 0.01f;
            builder.a(l2 - 0.01f, r2);
            builder.a(l2, r2, s2);
            builder.a(1.0f, k2, s2);
        } else {
            float u2 = TerrainProvider.a(i2, k2, -1.0f, 1.0f);
            if (bl) {
                builder.a(-1.0f, Math.max(0.2f, i2));
                builder.a(0.0f, MathHelper.i(0.5f, i2, k2), u2);
            } else {
                builder.a(-1.0f, i2, u2);
            }
            builder.a(1.0f, k2, u2);
        }
        return builder.a();
    }

    private static float a(float f2, float g2, float h2) {
        float i2 = 1.17f;
        float j2 = 0.46082947f;
        float k2 = 1.0f - (1.0f - g2) * 0.5f;
        float l2 = 0.5f * (1.0f - g2);
        float m2 = (f2 + 1.17f) * 0.46082947f;
        float n2 = m2 * k2 - l2;
        if (f2 < h2) {
            return Math.max(n2, -0.2222f);
        }
        return Math.max(n2, 0.0f);
    }

    private static float a(float f2) {
        float g2 = 1.17f;
        float h2 = 0.46082947f;
        float i2 = 1.0f - (1.0f - f2) * 0.5f;
        float j2 = 0.5f * (1.0f - f2);
        return j2 / (0.46082947f * i2) - 1.17f;
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I erosion, I ridgesFolded, float continentalness, float f2, float g2, float h2, float i2, float j2, boolean bl, boolean bl2, ToFloatFunction<Float> amplifier) {
        float k2 = 0.6f;
        float l2 = 0.5f;
        float m2 = 0.5f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.a(ridgesFolded, MathHelper.i(h2, 0.6f, 1.5f), bl2, amplifier);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.a(ridgesFolded, MathHelper.i(h2, 0.6f, 1.0f), bl2, amplifier);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.a(ridgesFolded, h2, bl2, amplifier);
        CubicSpline<C, I> cubicSpline4 = TerrainProvider.a(ridgesFolded, continentalness - 0.15f, 0.5f * h2, MathHelper.i(0.5f, 0.5f, 0.5f) * h2, 0.5f * h2, 0.6f * h2, 0.5f, amplifier);
        CubicSpline<C, I> cubicSpline5 = TerrainProvider.a(ridgesFolded, continentalness, i2 * h2, f2 * h2, 0.5f * h2, 0.6f * h2, 0.5f, amplifier);
        CubicSpline<C, I> cubicSpline6 = TerrainProvider.a(ridgesFolded, continentalness, i2, i2, f2, g2, 0.5f, amplifier);
        CubicSpline<C, I> cubicSpline7 = TerrainProvider.a(ridgesFolded, continentalness, i2, i2, f2, g2, 0.5f, amplifier);
        CubicSpline cubicSpline8 = CubicSpline.a(ridgesFolded, amplifier).a(-1.0f, continentalness).a(-0.4f, cubicSpline6).a(0.0f, g2 + 0.07f).a();
        CubicSpline<C, I> cubicSpline9 = TerrainProvider.a(ridgesFolded, -0.02f, j2, j2, f2, g2, 0.0f, amplifier);
        CubicSpline.b<C, I> builder = CubicSpline.a(erosion, amplifier).a(-0.85f, cubicSpline).a(-0.7f, cubicSpline2).a(-0.4f, cubicSpline3).a(-0.35f, cubicSpline4).a(-0.1f, cubicSpline5).a(0.2f, cubicSpline6);
        if (bl) {
            builder.a(0.4f, cubicSpline7).a(0.45f, cubicSpline8).a(0.55f, cubicSpline8).a(0.58f, cubicSpline7);
        }
        builder.a(0.7f, cubicSpline9);
        return builder.a();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(I ridgesFolded, float continentalness, float f2, float g2, float h2, float i2, float j2, ToFloatFunction<Float> amplifier) {
        float k2 = Math.max(0.5f * (f2 - continentalness), j2);
        float l2 = 5.0f * (g2 - f2);
        return CubicSpline.a(ridgesFolded, amplifier).a(-1.0f, continentalness, k2).a(-0.4f, f2, Math.min(k2, l2)).a(0.0f, g2, l2).a(0.4f, h2, 2.0f * (h2 - g2)).a(1.0f, i2, 0.7f * (i2 - h2)).a();
    }
}

