/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ConnectionEvent;
import io.papermc.paper.util.IntervalledCounter;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.MonitorFrameDecoder;
import net.minecraft.network.NoOpFrameDecoder;
import net.minecraft.network.NoOpFrameEncoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.event.player.PlayerQuitEvent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float h = 0.75f;
    private static final Logger i = LogUtils.getLogger();
    public static final Marker a = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker b = SystemUtils.a(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), (? super T marker) -> marker.add(a));
    public static final Marker c = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), (? super T marker) -> marker.add(b));
    public static final Marker d = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_SENT"), (? super T marker) -> marker.add(b));
    public static final Supplier<NioEventLoopGroup> e = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(i)).build()));
    public static final Supplier<EpollEventLoopGroup> f = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(i)).build()));
    public static final Supplier<DefaultEventLoopGroup> g = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(i)).build()));
    private static final ProtocolInfo<PacketHandshakingInListener> j = HandshakeProtocols.b;
    private final EnumProtocolDirection k;
    private volatile boolean l = true;
    private final Queue<WrappedConsumer> m = Queues.newConcurrentLinkedQueue();
    public Channel n;
    public SocketAddress o;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    @Nullable
    private volatile PacketListener p;
    @Nullable
    private volatile PacketListener q;
    @Nullable
    private DisconnectionDetails r;
    private boolean s;
    private boolean t;
    private int u;
    private int v;
    private float w;
    private float x;
    private int y;
    private boolean z;
    @Nullable
    private volatile DisconnectionDetails A;
    @Nullable
    BandwidthDebugMonitor B;
    public String hostname = "";
    public int protocolVersion;
    public InetSocketAddress virtualHost;
    private static boolean enableExplicitFlush = Boolean.getBoolean("paper.explicit-flush");
    public boolean isPending = true;
    public boolean queueImmunity;
    protected final Object PACKET_LIMIT_LOCK = new Object();
    @Nullable
    protected final IntervalledCounter allPacketCounts;
    protected final Map<Class<? extends Packet<?>>, IntervalledCounter> packetSpecificLimits;
    private boolean stopReadingPackets;
    @Nullable
    public SocketAddress haProxyAddress;
    private static final int MAX_PER_TICK = GlobalConfiguration.get().misc.maxJoinsPerTick;
    private static int joinAttemptsThisTick;
    private static int currTick;

    public final EntityPlayer getPlayer() {
        PacketListener packetListener = this.q;
        if (packetListener instanceof PlayerConnection) {
            PlayerConnection impl = (PlayerConnection)packetListener;
            return impl.f;
        }
        packetListener = this.q;
        if (packetListener instanceof ServerCommonPacketListenerImpl) {
            ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener;
            CraftPlayer player = impl.getCraftPlayer();
            return player == null ? null : player.getHandle();
        }
        return null;
    }

    private void killForPacketSpam() {
        this.b(new ClientboundDisconnectPacket(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage)), PacketSendListener.a(() -> this.a(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage))), true);
        this.m();
        this.stopReadingPackets = true;
    }

    public NetworkManager(EnumProtocolDirection side) {
        this.allPacketCounts = GlobalConfiguration.get().packetLimiter.allPackets.isEnabled() ? new IntervalledCounter((long)(GlobalConfiguration.get().packetLimiter.allPackets.interval() * 1.0E9)) : null;
        this.packetSpecificLimits = new HashMap();
        this.k = side;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.n = channelhandlercontext.channel();
        this.o = this.n.remoteAddress();
        this.preparing = false;
        if (this.A != null) {
            this.a(this.A);
        }
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.a(IChatBaseComponent.c("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof EncoderException && (throwable2 = throwable.getCause()) instanceof PacketEncoder.PacketTooLargeException) {
            PacketEncoder.PacketTooLargeException packetTooLargeException = (PacketEncoder.PacketTooLargeException)throwable2;
            Packet<?> packet = packetTooLargeException.getPacket();
            if (packet.packetTooLarge(this)) {
                ProtocolSwapHandler.b(channelhandlercontext, packet);
                return;
            }
            if (packet.c()) {
                i.debug("Skipping packet due to errors", throwable.getCause());
                ProtocolSwapHandler.b(channelhandlercontext, packet);
                return;
            }
            throwable = throwable.getCause();
        }
        if (throwable instanceof SkipEncodeException) {
            i.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.z;
            this.z = true;
            if (this.n.isOpen()) {
                EntityPlayer player = this.getPlayer();
                if (throwable instanceof TimeoutException) {
                    i.debug("Timeout", throwable);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.TIMED_OUT;
                    }
                    this.a(IChatBaseComponent.c("disconnect.timeout"));
                } else {
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + String.valueOf(throwable)});
                    PacketListener packetlistener = this.q;
                    DisconnectionDetails disconnectiondetails = packetlistener != null ? packetlistener.a(ichatmutablecomponent, throwable) : new DisconnectionDetails(ichatmutablecomponent);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.ERRONEOUS_STATE;
                    }
                    if (flag) {
                        boolean doesDisconnectExist;
                        i.debug("Failed to sent packet", throwable);
                        boolean bl = doesDisconnectExist = this.q.b() != EnumProtocol.c && this.q.b() != EnumProtocol.a;
                        if (this.g() == EnumProtocolDirection.b && doesDisconnectExist) {
                            Packet<PacketLoginOutListener> packet = this.l ? new PacketLoginOutDisconnect(ichatmutablecomponent) : new ClientboundDisconnectPacket(ichatmutablecomponent);
                            this.a(packet, PacketSendListener.a(() -> this.a(disconnectiondetails)));
                        } else {
                            this.a(disconnectiondetails);
                        }
                        this.m();
                    } else {
                        i.debug("Double fault", throwable);
                        this.a(disconnectiondetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            TraceUtil.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.n.isOpen()) {
            PacketListener packetlistener = this.q;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (this.stopReadingPackets) {
                return;
            }
            if (this.allPacketCounts != null || GlobalConfiguration.get().packetLimiter.overrides.containsKey(packet.getClass())) {
                long time = System.nanoTime();
                Object object = this.PACKET_LIMIT_LOCK;
                synchronized (object) {
                    if (this.allPacketCounts != null) {
                        this.allPacketCounts.updateAndAdd(1L, time);
                        if (this.allPacketCounts.getRate() >= GlobalConfiguration.get().packetLimiter.allPackets.maxPacketRate()) {
                            this.killForPacketSpam();
                            return;
                        }
                    }
                    for (Class<?> check = packet.getClass(); check != Object.class; check = check.getSuperclass()) {
                        GlobalConfiguration.PacketLimiter.PacketLimit packetSpecificLimit = GlobalConfiguration.get().packetLimiter.overrides.get(check);
                        if (packetSpecificLimit == null || !packetSpecificLimit.isEnabled()) continue;
                        IntervalledCounter counter = this.packetSpecificLimits.computeIfAbsent(check, clazz -> new IntervalledCounter((long)(packetSpecificLimit.interval() * 1.0E9)));
                        counter.updateAndAdd(1L, time);
                        if (!(counter.getRate() >= packetSpecificLimit.maxPacketRate())) continue;
                        switch (packetSpecificLimit.action()) {
                            case DROP: {
                                return;
                            }
                            case KICK: {
                                String playerName;
                                String deobfedPacketName = ObfHelper.INSTANCE.deobfClassName(check.getName());
                                PacketListener packetListener = this.q;
                                if (packetListener instanceof ServerCommonPacketListenerImpl) {
                                    ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener;
                                    playerName = impl.j().getName();
                                } else {
                                    playerName = this.a(MinecraftServer.getServer().bn());
                                }
                                i.warn("{} kicked for packet spamming: {}", (Object)playerName, (Object)deobfedPacketName.substring(deobfedPacketName.lastIndexOf(".") + 1));
                                this.killForPacketSpam();
                                return;
                            }
                        }
                    }
                }
            }
            if (packetlistener.a(packet)) {
                try {
                    NetworkManager.a(packet, packetlistener);
                }
                catch (CancelledPacketHandleException time) {
                }
                catch (ServerStopRejectedExecutionException time) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    i.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_packet"));
                }
                ++this.u;
            }
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener listener) {
        packet.a(listener);
    }

    private void b(ProtocolInfo<?> state, PacketListener listener) {
        Validate.notNull((Object)listener, (String)"packetListener", (Object[])new Object[0]);
        EnumProtocolDirection enumprotocoldirection = listener.a();
        if (enumprotocoldirection != this.k) {
            String s2 = String.valueOf((Object)this.k);
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + s2 + ", but listener is " + String.valueOf((Object)enumprotocoldirection));
        }
        EnumProtocol enumprotocol = listener.b();
        if (state.a() != enumprotocol) {
            String s3 = String.valueOf((Object)enumprotocol);
            throw new IllegalStateException("Listener protocol (" + s3 + ") does not match requested one " + String.valueOf(state));
        }
    }

    private static void a(ChannelFuture future) {
        try {
            future.syncUninterruptibly();
        }
        catch (Exception exception) {
            if (exception instanceof ClosedChannelException) {
                i.info("Connection closed during protocol change");
            }
            throw exception;
        }
    }

    public <T extends PacketListener> void a(ProtocolInfo<T> state, T packetListener) {
        this.b(state, packetListener);
        if (state.b() != this.f()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)state.a()));
        }
        this.q = packetListener;
        this.p = null;
        UnconfiguredPipelineHandler.b unconfiguredpipelinehandler_b = UnconfiguredPipelineHandler.a(state);
        BundlerInfo bundlerinfo = state.d();
        if (bundlerinfo != null) {
            PacketBundlePacker packetbundlepacker = new PacketBundlePacker(bundlerinfo);
            unconfiguredpipelinehandler_b = unconfiguredpipelinehandler_b.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetbundlepacker));
        }
        NetworkManager.a(this.n.writeAndFlush((Object)unconfiguredpipelinehandler_b));
    }

    public void a(ProtocolInfo<?> newState) {
        if (newState.b() != this.g()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)newState.a()));
        }
        UnconfiguredPipelineHandler.d unconfiguredpipelinehandler_d = UnconfiguredPipelineHandler.b(newState);
        BundlerInfo bundlerinfo = newState.d();
        if (bundlerinfo != null) {
            PacketBundleUnpacker packetbundleunpacker = new PacketBundleUnpacker(bundlerinfo);
            unconfiguredpipelinehandler_d = unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetbundleunpacker));
        }
        boolean flag = newState.a() == EnumProtocol.d;
        NetworkManager.a(this.n.writeAndFlush((Object)unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> {
            this.l = flag;
        })));
    }

    public void a(PacketListener packetListener) {
        if (this.q != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.k != EnumProtocolDirection.a || packetListener.a() != EnumProtocolDirection.a || packetListener.b() != j.a()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.q = packetListener;
    }

    public void a(String address, int port, PacketStatusOutListener listener) {
        this.a(address, port, StatusProtocols.b, StatusProtocols.d, listener, ClientIntent.a);
    }

    public void a(String address, int port, PacketLoginOutListener listener) {
        this.a(address, port, LoginProtocols.b, LoginProtocols.d, listener, ClientIntent.b);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String address, int port, ProtocolInfo<S> outboundState, ProtocolInfo<C> inboundState, C prePlayStateListener, boolean transfer) {
        this.a(address, port, outboundState, inboundState, prePlayStateListener, transfer ? ClientIntent.c : ClientIntent.b);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String address, int port, ProtocolInfo<S> outboundState, ProtocolInfo<C> inboundState, C prePlayStateListener, ClientIntent intent) {
        if (outboundState.a() != inboundState.a()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.p = prePlayStateListener;
        this.a((NetworkManager networkmanager) -> {
            this.a(inboundState, prePlayStateListener);
            networkmanager.b(new PacketHandshakingInSetProtocol(SharedConstants.b().e(), address, port, intent), null, true);
            this.a(outboundState);
        });
    }

    public void a(Packet<?> packet) {
        this.a(packet, (PacketSendListener)null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks) {
        this.a(packet, callbacks, true);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        boolean connected = this.i();
        if (!connected && !this.preparing) {
            return;
        }
        packet.onPacketDispatch(this.getPlayer());
        if (connected && (InnerUtil.canSendImmediate(this, packet) || MCUtil.isMainThread() && packet.isReady() && this.m.isEmpty() && (packet.getExtraPackets() == null || packet.getExtraPackets().isEmpty()))) {
            this.b(packet, callbacks, flush);
        } else {
            boolean hasExtraPackets;
            List<Packet<?>> extraPackets = InnerUtil.buildExtraPackets(packet);
            boolean bl = hasExtraPackets = extraPackets != null && !extraPackets.isEmpty();
            if (!hasExtraPackets) {
                this.m.add(new PacketSendAction(packet, callbacks, flush));
            } else {
                ArrayList<PacketSendAction> actions = new ArrayList<PacketSendAction>(1 + extraPackets.size());
                actions.add(new PacketSendAction(packet, null, false));
                int i2 = 0;
                int len = extraPackets.size();
                while (i2 < len) {
                    Packet<?> extraPacket = extraPackets.get(i2);
                    boolean end = ++i2 == len;
                    actions.add(new PacketSendAction(extraPacket, end ? callbacks : null, end));
                }
                this.m.addAll(actions);
            }
            this.flushQueue();
        }
    }

    public void a(Consumer<NetworkManager> task) {
        if (this.i()) {
            this.flushQueue();
            task.accept(this);
        } else {
            this.m.add(new WrappedConsumer(task));
        }
    }

    private void b(Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        ++this.v;
        if (this.n.eventLoop().inEventLoop()) {
            this.c(packet, callbacks, flush);
        } else {
            this.n.eventLoop().execute(() -> this.c(packet, callbacks, flush));
        }
    }

    private void c(Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        EntityPlayer player = this.getPlayer();
        if (!this.i()) {
            packet.onPacketDispatchFinish(player, null);
            return;
        }
        try {
            ChannelFuture channelfuture;
            ChannelFuture channelFuture2 = channelfuture = flush ? this.n.writeAndFlush(packet) : this.n.write(packet);
            if (callbacks != null) {
                channelfuture.addListener(future -> {
                    if (future.isSuccess()) {
                        callbacks.a();
                    } else {
                        Packet<?> packet1 = callbacks.b();
                        if (packet1 != null) {
                            ChannelFuture channelfuture1 = this.n.writeAndFlush(packet1);
                            channelfuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                        }
                    }
                });
            }
            if (packet.hasFinishListener()) {
                channelfuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> packet.onPacketDispatchFinish(player, (ChannelFuture)channelFuture)));
            }
            channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        catch (Exception e2) {
            i.error("NetworkException: {}", (Object)player, (Object)e2);
            this.a(IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + e2.getMessage()}));
            packet.onPacketDispatchFinish(player, null);
        }
    }

    public void a() {
        if (this.i()) {
            this.q();
        } else {
            this.m.add(new WrappedConsumer(NetworkManager::q));
        }
    }

    private void q() {
        if (this.n.eventLoop().inEventLoop()) {
            this.n.flush();
        } else {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushQueue() {
        if (!this.i()) {
            return true;
        }
        if (MCUtil.isMainThread()) {
            return this.processQueue();
        }
        if (this.isPending) {
            Queue<WrappedConsumer> queue = this.m;
            synchronized (queue) {
                return this.processQueue();
            }
        }
        return false;
    }

    private boolean processQueue() {
        if (this.m.isEmpty()) {
            return true;
        }
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            WrappedConsumer queued = (WrappedConsumer)iterator.next();
            if (queued == null) {
                return true;
            }
            if (queued.isConsumed()) continue;
            if (queued instanceof PacketSendAction) {
                PacketSendAction packetSendAction = (PacketSendAction)queued;
                Packet<?> packet = packetSendAction.packet;
                if (!packet.isReady()) {
                    return false;
                }
            }
            iterator.remove();
            if (!queued.tryMarkConsumed()) continue;
            queued.accept(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b() {
        block11: {
            TickablePacketListener tickablepacketlistener;
            block12: {
                PacketListener packetlistener;
                this.flushQueue();
                if (currTick != MinecraftServer.currentTick) {
                    currTick = MinecraftServer.currentTick;
                    joinAttemptsThisTick = 0;
                }
                if (!((packetlistener = this.q) instanceof TickablePacketListener)) break block11;
                tickablepacketlistener = (TickablePacketListener)packetlistener;
                PacketListener packetListener = this.q;
                if (!(packetListener instanceof LoginListener)) break block12;
                LoginListener loginPacketListener = (LoginListener)packetListener;
                if (loginPacketListener.h == LoginListener.EnumProtocolState.e && joinAttemptsThisTick++ >= MAX_PER_TICK) break block11;
            }
            PlayerConnectionUtils.packetProcessing.push(this.q);
            try {
                tickablepacketlistener.d();
            }
            finally {
                PlayerConnectionUtils.packetProcessing.pop();
            }
        }
        if (!this.i() && !this.t) {
            this.n();
        }
        if (this.n != null && enableExplicitFlush) {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
        if (this.y++ % 20 == 0) {
            this.c();
        }
        if (this.B != null) {
            this.B.a();
        }
    }

    protected void c() {
        this.x = MathHelper.i(0.75f, this.v, this.x);
        this.w = MathHelper.i(0.75f, this.u, this.w);
        this.v = 0;
        this.u = 0;
    }

    public SocketAddress d() {
        return this.o;
    }

    public String a(boolean logIps) {
        return this.o == null ? "local" : (logIps ? this.o.toString() : "IP hidden");
    }

    public void a(IChatBaseComponent disconnectReason) {
        this.a(new DisconnectionDetails(disconnectReason));
    }

    public void a(DisconnectionDetails disconnectionInfo) {
        this.preparing = false;
        this.clearPacketQueue();
        if (this.n == null) {
            this.A = disconnectionInfo;
        }
        if (this.i()) {
            this.n.close();
            this.r = disconnectionInfo;
        }
    }

    public boolean e() {
        return this.n instanceof LocalChannel || this.n instanceof LocalServerChannel;
    }

    public EnumProtocolDirection f() {
        return this.k;
    }

    public EnumProtocolDirection g() {
        return this.k.a();
    }

    public static NetworkManager a(InetSocketAddress address, boolean useEpoll, @Nullable LocalSampleLogger packetSizeLog) {
        NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        if (packetSizeLog != null) {
            networkmanager.a(packetSizeLog);
        }
        ChannelFuture channelfuture = NetworkManager.a(address, useEpoll, networkmanager);
        channelfuture.syncUninterruptibly();
        return networkmanager;
    }

    public static ChannelFuture a(InetSocketAddress address, boolean useEpoll, final NetworkManager connection) {
        EventLoopGroup eventloopgroup;
        Class<NioSocketChannel> oclass;
        if (Epoll.isAvailable() && useEpoll) {
            oclass = EpollSocketChannel.class;
            eventloopgroup = (EventLoopGroup)f.get();
        } else {
            oclass = NioSocketChannel.class;
            eventloopgroup = (EventLoopGroup)e.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b, false, connection.B);
                connection.a(channelpipeline);
            }
        })).channel(oclass)).connect(address.getAddress(), address.getPort());
    }

    private static String b(boolean sendingSide) {
        return sendingSide ? "encoder" : "outbound_config";
    }

    private static String c(boolean receivingSide) {
        return receivingSide ? "decoder" : "inbound_config";
    }

    public void a(ChannelPipeline pipeline) {
        pipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelhandlercontext, Object object, ChannelPromise channelpromise) throws Exception {
                super.write(channelhandlercontext, object, channelpromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void a(ChannelPipeline pipeline, EnumProtocolDirection side, boolean local, @Nullable BandwidthDebugMonitor packetSizeLogger) {
        EnumProtocolDirection enumprotocoldirection1 = side.a();
        boolean flag1 = side == EnumProtocolDirection.a;
        boolean flag2 = enumprotocoldirection1 == EnumProtocolDirection.a;
        pipeline.addLast("splitter", (ChannelHandler)NetworkManager.a(packetSizeLogger, local)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(NetworkManager.c(flag1), flag1 ? new PacketDecoder<PacketHandshakingInListener>(j) : new UnconfiguredPipelineHandler.a()).addLast("prepender", (ChannelHandler)NetworkManager.d(local)).addLast(NetworkManager.b(flag2), flag2 ? new PacketEncoder<PacketHandshakingInListener>(j) : new UnconfiguredPipelineHandler.c());
    }

    private static ChannelOutboundHandler d(boolean local) {
        return local ? new NoOpFrameEncoder() : new PacketPrepender();
    }

    private static ChannelInboundHandler a(@Nullable BandwidthDebugMonitor packetSizeLogger, boolean local) {
        return !local ? new PacketSplitter(packetSizeLogger) : (packetSizeLogger != null ? new MonitorFrameDecoder(packetSizeLogger) : new NoOpFrameDecoder());
    }

    public static void a(ChannelPipeline pipeline, EnumProtocolDirection side) {
        NetworkManager.a(pipeline, side, true, null);
    }

    public static NetworkManager a(SocketAddress address) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)g.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelpipeline = channel.pipeline();
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b);
                networkmanager.a(channelpipeline);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return networkmanager;
    }

    public void setupEncryption(SecretKey key) throws CryptographyException {
        if (!this.s) {
            try {
                VelocityCipher decryption = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
                VelocityCipher encryption = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
                this.s = true;
                this.n.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(decryption));
                this.n.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(encryption));
            }
            catch (GeneralSecurityException e2) {
                throw new CryptographyException(e2);
            }
        }
    }

    public boolean h() {
        return this.s;
    }

    public boolean i() {
        return this.n != null && this.n.isOpen();
    }

    public boolean j() {
        return this.n == null;
    }

    @Nullable
    public PacketListener k() {
        return this.q;
    }

    @Nullable
    public DisconnectionDetails l() {
        return this.r;
    }

    public void m() {
        if (this.n != null) {
            this.n.config().setAutoRead(false);
        }
    }

    public void enableAutoRead() {
        if (this.n != null) {
            this.n.config().setAutoRead(true);
        }
    }

    public void a(int compressionThreshold, boolean rejectsBadPackets) {
        if (compressionThreshold >= 0) {
            VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(GlobalConfiguration.get().misc.compressionLevel.or(-1));
            ChannelHandler channelhandler = this.n.pipeline().get("decompress");
            if (channelhandler instanceof PacketDecompressor) {
                PacketDecompressor packetdecompressor = (PacketDecompressor)channelhandler;
                packetdecompressor.setThreshold(compressor, compressionThreshold, rejectsBadPackets);
            } else {
                this.n.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new PacketDecompressor(compressionThreshold, rejectsBadPackets));
            }
            channelhandler = this.n.pipeline().get("compress");
            if (channelhandler instanceof PacketCompressor) {
                PacketCompressor packetcompressor = (PacketCompressor)channelhandler;
                packetcompressor.a(compressionThreshold);
            } else {
                this.n.pipeline().addAfter("prepender", "compress", (ChannelHandler)new PacketCompressor(compressor, compressionThreshold));
            }
            this.n.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_THRESHOLD_SET);
        } else {
            if (this.n.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.n.pipeline().remove("decompress");
            }
            if (this.n.pipeline().get("compress") instanceof PacketCompressor) {
                this.n.pipeline().remove("compress");
            }
            this.n.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_DISABLED);
        }
    }

    public void n() {
        if (this.n != null && !this.n.isOpen() && !this.t) {
            PacketListener packetlistener1;
            this.t = true;
            PacketListener packetlistener = this.k();
            PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.p;
            if (packetlistener1 != null) {
                DisconnectionDetails disconnectiondetails = Objects.requireNonNullElseGet(this.l(), () -> new DisconnectionDetails(IChatBaseComponent.c("multiplayer.disconnect.generic")));
                packetlistener1.a(disconnectiondetails);
            }
            this.clearPacketQueue();
            PacketListener packetListener2 = this.k();
            if (packetListener2 instanceof ServerCommonPacketListenerImpl) {
                ServerCommonPacketListenerImpl commonPacketListener = (ServerCommonPacketListenerImpl)packetListener2;
                GameProfile profile = commonPacketListener.j();
                new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.o).getAddress(), false).callEvent();
            } else if (packetListener2 instanceof LoginListener) {
                LoginListener loginListener = (LoginListener)packetListener2;
                switch (loginListener.h) {
                    case e: 
                    case f: 
                    case g: 
                    case h: {
                        GameProfile profile = loginListener.k;
                        new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.o).getAddress(), false).callEvent();
                    }
                }
            }
        }
    }

    public float o() {
        return this.w;
    }

    public float p() {
        return this.x;
    }

    public void a(LocalSampleLogger log) {
        this.B = new BandwidthDebugMonitor(log);
    }

    public void clearPacketQueue() {
        EntityPlayer player = this.getPlayer();
        for (Consumer consumer : this.m) {
            if (!(consumer instanceof PacketSendAction)) continue;
            PacketSendAction packetSendAction = (PacketSendAction)consumer;
            Packet<?> packet = packetSendAction.packet;
            if (!packet.hasFinishListener()) continue;
            packet.onPacketDispatchFinish(player, null);
        }
        this.m.clear();
    }

    private static class InnerUtil {
        private InnerUtil() {
        }

        @Nullable
        private static List<Packet<?>> buildExtraPackets(Packet<?> packet) {
            List<Packet<?>> extra = packet.getExtraPackets();
            if (extra == null || extra.isEmpty()) {
                return null;
            }
            ArrayList ret = new ArrayList(1 + extra.size());
            InnerUtil.buildExtraPackets0(extra, ret);
            return ret;
        }

        private static void buildExtraPackets0(List<Packet<?>> extraPackets, List<Packet<?>> into) {
            for (Packet<?> extra : extraPackets) {
                into.add(extra);
                List<Packet<?>> extraExtra = extra.getExtraPackets();
                if (extraExtra == null || extraExtra.isEmpty()) continue;
                InnerUtil.buildExtraPackets0(extraExtra, into);
            }
        }

        private static boolean canSendImmediate(NetworkManager networkManager, Packet<?> packet) {
            return networkManager.isPending || networkManager.q.b() != EnumProtocol.b || packet instanceof ClientboundKeepAlivePacket || packet instanceof ClientboundPlayerChatPacket || packet instanceof ClientboundSystemChatPacket || packet instanceof PacketPlayOutTabComplete || packet instanceof ClientboundSetTitleTextPacket || packet instanceof ClientboundSetSubtitleTextPacket || packet instanceof ClientboundSetActionBarTextPacket || packet instanceof ClientboundSetTitlesAnimationPacket || packet instanceof ClientboundClearTitlesPacket || packet instanceof PacketPlayOutNamedSoundEffect || packet instanceof PacketPlayOutEntitySound || packet instanceof PacketPlayOutStopSound || packet instanceof PacketPlayOutWorldParticles || packet instanceof PacketPlayOutBoss;
        }
    }

    private static final class PacketSendAction
    extends WrappedConsumer {
        private final Packet<?> packet;

        private PacketSendAction(Packet<?> packet, @Nullable PacketSendListener packetSendListener, boolean flush) {
            super(connection -> connection.b(packet, packetSendListener, flush));
            this.packet = packet;
        }
    }

    private static class WrappedConsumer
    implements Consumer<NetworkManager> {
        private final Consumer<NetworkManager> delegate;
        private final AtomicBoolean consumed = new AtomicBoolean(false);

        private WrappedConsumer(Consumer<NetworkManager> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(NetworkManager connection) {
            this.delegate.accept(connection);
        }

        public boolean tryMarkConsumed() {
            return this.consumed.compareAndSet(false, true);
        }

        public boolean isConsumed() {
            return this.consumed.get();
        }
    }
}

