/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.network.VarInt;

public class PacketDecompressor
extends ByteToMessageDecoder {
    public static final int a = 0x200000;
    public static final int b = 0x800000;
    private final Inflater c;
    private VelocityCompressor compressor;
    private int d;
    private boolean e;

    public PacketDecompressor(int compressionThreshold, boolean rejectsBadPackets) {
        this(null, compressionThreshold, rejectsBadPackets);
    }

    public PacketDecompressor(VelocityCompressor compressor, int compressionThreshold, boolean rejectsBadPackets) {
        this.d = compressionThreshold;
        this.e = rejectsBadPackets;
        this.c = compressor == null ? new Inflater() : null;
        this.compressor = compressor;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() != 0) {
            int i2 = VarInt.a(byteBuf);
            if (i2 == 0) {
                list.add(byteBuf.readBytes(byteBuf.readableBytes()));
            } else {
                if (this.e) {
                    if (i2 < this.d) {
                        throw new DecoderException("Badly compressed packet - size of " + i2 + " is below server threshold of " + this.d);
                    }
                    if (i2 > 0x800000) {
                        throw new DecoderException("Badly compressed packet - size of " + i2 + " is larger than protocol maximum of 8388608");
                    }
                }
                if (this.c != null) {
                    this.a(byteBuf);
                    ByteBuf byteBuf2 = this.a(channelHandlerContext, i2);
                    this.c.reset();
                    list.add(byteBuf2);
                    return;
                }
                int claimedUncompressedSize = i2;
                ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (ByteBuf)byteBuf);
                ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
                try {
                    this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
                    list.add(uncompressed);
                    byteBuf.clear();
                }
                catch (Exception e2) {
                    uncompressed.release();
                    throw e2;
                }
                finally {
                    compatibleIn.release();
                }
            }
        }
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }

    private void a(ByteBuf buf) {
        ByteBuffer byteBuffer;
        if (buf.nioBufferCount() > 0) {
            byteBuffer = buf.nioBuffer();
            buf.skipBytes(buf.readableBytes());
        } else {
            byteBuffer = ByteBuffer.allocateDirect(buf.readableBytes());
            buf.readBytes(byteBuffer);
            byteBuffer.flip();
        }
        this.c.setInput(byteBuffer);
    }

    private ByteBuf a(ChannelHandlerContext context, int expectedSize) throws DataFormatException {
        ByteBuf byteBuf = context.alloc().directBuffer(expectedSize);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(0, expectedSize);
            int i2 = byteBuffer.position();
            this.c.inflate(byteBuffer);
            int j2 = byteBuffer.position() - i2;
            if (j2 != expectedSize) {
                throw new DecoderException("Badly compressed packet - actual length of uncompressed payload " + j2 + " is does not match declared size " + expectedSize);
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + j2);
            return byteBuf;
        }
        catch (Exception var7) {
            byteBuf.release();
            throw var7;
        }
    }

    public void setThreshold(VelocityCompressor compressor, int compressionThreshold, boolean rejectsBadPackets) {
        this.d = compressionThreshold;
        this.e = rejectsBadPackets;
    }
}

