/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class SelectorContents
implements ComponentContents {
    private static final Logger d = LogUtils.getLogger();
    public static final MapCodec<SelectorContents> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("selector").forGetter(SelectorContents::b), (App)ComponentSerialization.a.optionalFieldOf("separator").forGetter(SelectorContents::d)).apply((Applicative)instance, SelectorContents::new));
    public static final ComponentContents.a<SelectorContents> b = new ComponentContents.a<SelectorContents>(a, "selector");
    private final String e;
    @Nullable
    private final EntitySelector f;
    protected final Optional<IChatBaseComponent> c;

    public SelectorContents(String pattern, Optional<IChatBaseComponent> separator) {
        this.e = pattern;
        this.c = separator;
        this.f = SelectorContents.a(pattern);
    }

    @Nullable
    private static EntitySelector a(String pattern) {
        EntitySelector entitySelector = null;
        try {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(pattern), true);
            entitySelector = entitySelectorParser.t();
        }
        catch (CommandSyntaxException var3) {
            return null;
        }
        return entitySelector;
    }

    @Override
    public ComponentContents.a<?> a() {
        return b;
    }

    public String b() {
        return this.e;
    }

    @Nullable
    public EntitySelector c() {
        return this.f;
    }

    public Optional<IChatBaseComponent> d() {
        return this.c;
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source != null && this.f != null) {
            Optional<IChatMutableComponent> optional = ChatComponentUtils.updateSeparatorForEntity(source, this.c, sender, depth);
            return ChatComponentUtils.a(this.f.b(source), optional, Entity::S_);
        }
        return IChatBaseComponent.i();
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.b<T> visitor, ChatModifier style) {
        return visitor.accept(style, this.e);
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.a<T> visitor) {
        return visitor.accept(this.e);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SelectorContents) {
            SelectorContents selectorContents = (SelectorContents)object;
            if (this.e.equals(selectorContents.e) && this.c.equals(selectorContents.c)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int i2 = this.e.hashCode();
        return 31 * i2 + this.c.hashCode();
    }

    public String toString() {
        return "pattern{" + this.e + "}";
    }
}

