/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    final EnumProtocol a;
    final EnumProtocolDirection b;
    private final List<a<T, ?, B>> c = new ArrayList();
    @Nullable
    private BundlerInfo d;

    public ProtocolInfoBuilder(EnumProtocol type, EnumProtocolDirection side) {
        this.a = type;
        this.b = side;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> a(PacketType<P> id, StreamCodec<? super B, P> codec) {
        this.c.add(new a(id, codec));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> a(PacketType<P> id, Function<Iterable<Packet<? super T>>, P> bundler, D splitter) {
        StreamCodec streamCodec = StreamCodec.a(splitter);
        PacketType<BundleDelimiterPacket<? super T>> packetType = splitter.a();
        this.c.add(new a(packetType, streamCodec));
        this.d = BundlerInfo.a(id, bundler, splitter);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> a(Function<ByteBuf, B> bufUpgrader, List<a<T, ?, B>> packetTypes) {
        ProtocolCodecBuilder protocolCodecBuilder = new ProtocolCodecBuilder(this.b);
        for (a a2 : packetTypes) {
            a2.a(protocolCodecBuilder, bufUpgrader);
        }
        return protocolCodecBuilder.a();
    }

    public ProtocolInfo<T> a(Function<ByteBuf, B> bufUpgrader) {
        return new b(this.a, this.b, this.a(bufUpgrader, this.c), this.d);
    }

    public ProtocolInfo.a<T, B> a() {
        final List<a<T, ?, B>> list = List.copyOf(this.c);
        final BundlerInfo bundlerInfo = this.d;
        return new ProtocolInfo.a<T, B>(){

            @Override
            @Override
            public ProtocolInfo<T> a(Function<ByteBuf, B> registryBinder) {
                return new b(ProtocolInfoBuilder.this.a, ProtocolInfoBuilder.this.b, ProtocolInfoBuilder.this.a(registryBinder, list), bundlerInfo);
            }

            @Override
            @Override
            public EnumProtocol a() {
                return ProtocolInfoBuilder.this.a;
            }

            @Override
            @Override
            public EnumProtocolDirection b() {
                return ProtocolInfoBuilder.this.b;
            }

            @Override
            @Override
            public void a(ProtocolInfo.a.a callback) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    a codecEntry = (a)list.get(i2);
                    callback.accept(codecEntry.a, i2);
                }
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.a<L, B> a(EnumProtocol type, EnumProtocolDirection side, Consumer<ProtocolInfoBuilder<L, B>> registrar) {
        ProtocolInfoBuilder protocolInfoBuilder = new ProtocolInfoBuilder(type, side);
        registrar.accept(protocolInfoBuilder);
        return protocolInfoBuilder.a();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> a(EnumProtocol type, Consumer<ProtocolInfoBuilder<T, B>> registrar) {
        return ProtocolInfoBuilder.a(type, EnumProtocolDirection.a, registrar);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> b(EnumProtocol type, Consumer<ProtocolInfoBuilder<T, B>> registrar) {
        return ProtocolInfoBuilder.a(type, EnumProtocolDirection.b, registrar);
    }

    record a<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>(PacketType<P> a, StreamCodec<? super B, P> b) {
        public void a(ProtocolCodecBuilder<ByteBuf, T> builder, Function<ByteBuf, B> bufUpgrader) {
            StreamCodec<ByteBuf, P> streamCodec = this.b.b(bufUpgrader);
            builder.a(this.a, streamCodec);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;serializer", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;serializer", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;serializer", "a", "b"}, this, object);
        }
    }

    record b<L extends PacketListener>(EnumProtocol a, EnumProtocolDirection b, StreamCodec<ByteBuf, Packet<? super L>> c, @Nullable BundlerInfo d) implements ProtocolInfo<L>
    {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this, object);
        }
    }
}

