/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final Map<Pair<Holder<ArmorMaterial>, EnumItemSlot>, Item> a = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put(Pair.of(EnumArmorMaterial.b, (Object)EnumItemSlot.f), Items.pC);
        map.put(Pair.of(EnumArmorMaterial.b, (Object)EnumItemSlot.e), Items.pD);
        map.put(Pair.of(EnumArmorMaterial.b, (Object)EnumItemSlot.d), Items.pE);
        map.put(Pair.of(EnumArmorMaterial.b, (Object)EnumItemSlot.c), Items.pF);
        map.put(Pair.of(EnumArmorMaterial.c, (Object)EnumItemSlot.f), Items.pG);
        map.put(Pair.of(EnumArmorMaterial.c, (Object)EnumItemSlot.e), Items.pH);
        map.put(Pair.of(EnumArmorMaterial.c, (Object)EnumItemSlot.d), Items.pI);
        map.put(Pair.of(EnumArmorMaterial.c, (Object)EnumItemSlot.c), Items.pJ);
        map.put(Pair.of(EnumArmorMaterial.d, (Object)EnumItemSlot.f), Items.pO);
        map.put(Pair.of(EnumArmorMaterial.d, (Object)EnumItemSlot.e), Items.pP);
        map.put(Pair.of(EnumArmorMaterial.d, (Object)EnumItemSlot.d), Items.pQ);
        map.put(Pair.of(EnumArmorMaterial.d, (Object)EnumItemSlot.c), Items.pR);
        map.put(Pair.of(EnumArmorMaterial.g, (Object)EnumItemSlot.f), Items.pS);
        map.put(Pair.of(EnumArmorMaterial.g, (Object)EnumItemSlot.e), Items.pT);
        map.put(Pair.of(EnumArmorMaterial.g, (Object)EnumItemSlot.d), Items.pU);
        map.put(Pair.of(EnumArmorMaterial.g, (Object)EnumItemSlot.c), Items.pV);
        map.put(Pair.of(EnumArmorMaterial.e, (Object)EnumItemSlot.f), Items.pK);
        map.put(Pair.of(EnumArmorMaterial.e, (Object)EnumItemSlot.e), Items.pL);
        map.put(Pair.of(EnumArmorMaterial.e, (Object)EnumItemSlot.d), Items.pM);
        map.put(Pair.of(EnumArmorMaterial.e, (Object)EnumItemSlot.c), Items.pN);
        map.put(Pair.of(EnumArmorMaterial.f, (Object)EnumItemSlot.f), Items.oo);
    });
    private static final List<ResourceKey<TrimPattern>> b = List.of(TrimPatterns.a, TrimPatterns.b, TrimPatterns.c, TrimPatterns.d, TrimPatterns.e, TrimPatterns.f, TrimPatterns.g, TrimPatterns.h, TrimPatterns.i, TrimPatterns.j, TrimPatterns.k, TrimPatterns.l, TrimPatterns.m, TrimPatterns.n, TrimPatterns.o, TrimPatterns.p, TrimPatterns.q, TrimPatterns.r);
    private static final List<ResourceKey<TrimMaterial>> c = List.of(TrimMaterials.a, TrimMaterials.b, TrimMaterials.c, TrimMaterials.d, TrimMaterials.e, TrimMaterials.f, TrimMaterials.g, TrimMaterials.h, TrimMaterials.i, TrimMaterials.j);
    private static final ToIntFunction<ResourceKey<TrimPattern>> d = SystemUtils.g(b);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> e = SystemUtils.g(c);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spawn_armor_trims").requires(source -> source.c(2))).executes(context -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).h()))));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player) {
        World level = player.dO();
        NonNullList<ArmorTrim> nonNullList = NonNullList.a();
        IRegistry<TrimPattern> registry = level.H_().d(Registries.aX);
        IRegistry<TrimMaterial> registry2 = level.H_().d(Registries.aW);
        registry.t().sorted(Comparator.comparing(pattern -> d.applyAsInt(registry.d((TrimPattern)pattern).orElse(null)))).forEachOrdered(pattern -> registry2.t().sorted(Comparator.comparing(material -> e.applyAsInt(registry2.d((TrimMaterial)material).orElse(null)))).forEachOrdered(material -> nonNullList.add(new ArmorTrim(registry2.e((TrimMaterial)material), registry.e((TrimPattern)pattern)))));
        BlockPosition blockPos = player.do().a(player.cH(), 5);
        IRegistry<ArmorMaterial> registry3 = source.v().d(Registries.az);
        int i2 = registry3.c() - 1;
        double d2 = 3.0;
        int j2 = 0;
        int k2 = 0;
        for (ArmorTrim armorTrim : nonNullList) {
            for (ArmorMaterial armorMaterial : registry3) {
                if (armorMaterial == EnumArmorMaterial.a.a()) continue;
                double e2 = (double)blockPos.u() + 0.5 - (double)(j2 % registry2.c()) * 3.0;
                double f2 = (double)blockPos.v() + 0.5 + (double)(k2 % i2) * 3.0;
                double g2 = (double)blockPos.w() + 0.5 + (double)(j2 / registry2.c() * 10);
                EntityArmorStand armorStand = new EntityArmorStand(level, e2, f2, g2);
                armorStand.t(180.0f);
                armorStand.f(true);
                for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
                    ItemArmor armorItem;
                    Item item = a.get(Pair.of((Object)armorMaterial, (Object)equipmentSlot));
                    if (item == null) continue;
                    ItemStack itemStack = new ItemStack(item);
                    itemStack.b(DataComponents.K, armorTrim);
                    armorStand.a(equipmentSlot, itemStack);
                    if (item instanceof ItemArmor && (armorItem = (ItemArmor)item).h().a(EnumArmorMaterial.f)) {
                        armorStand.b(armorTrim.a().a().a(armorTrim.b()).f().f(" ").b(armorTrim.b().a().e()));
                        armorStand.p(true);
                        continue;
                    }
                    armorStand.k(true);
                }
                level.b(armorStand);
                ++k2;
            }
            ++j2;
        }
        source.a(() -> IChatBaseComponent.b("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

