/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.slf4j.Logger;

public abstract class ChunkMapDistance
implements ChunkSystemDistanceManager,
ChunkTickDistanceManager {
    static final Logger a = LogUtils.getLogger();
    static final int b = ChunkLevel.a(FullChunkStatus.d);
    private static final int c = 4;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> d = new Long2ObjectOpenHashMap();
    private long p;
    private final PositionCountingAreaMap<EntityPlayer> spawnChunkTracker = new PositionCountingAreaMap();

    protected ChunkMapDistance(Executor workerExecutor, Executor mainThreadExecutor) {
        Objects.requireNonNull(mainThreadExecutor);
        Mailbox<Runnable> mailbox = Mailbox.a("player ticket throttler", mainThreadExecutor::execute);
        ChunkTaskQueueSorter chunktaskqueuesorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(mailbox), workerExecutor, 4);
    }

    public ChunkHolderManager getChunkHolderManager() {
        return this.moonrise$getChunkMap().s.moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Override
    public final void moonrise$addPlayer(EntityPlayer player, SectionPosition pos) {
        this.spawnChunkTracker.add(player, pos.a(), pos.c(), 8);
    }

    @Override
    public final void moonrise$removePlayer(EntityPlayer player, SectionPosition pos) {
        this.spawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(EntityPlayer player, SectionPosition oldPos, SectionPosition newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.a(), newPos.c(), 8);
        }
    }

    protected void a() {
        this.getChunkHolderManager().tick();
    }

    private static int a(ArraySetSorted<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.b().b() : ChunkLevel.b + 1;
    }

    protected abstract boolean a(long var1);

    @Nullable
    protected abstract PlayerChunk b(long var1);

    @Nullable
    protected abstract PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean a(PlayerChunkMap chunkLoadingManager) {
        return this.getChunkHolderManager().processTicketUpdates();
    }

    boolean addTicket(long i2, Ticket<?> ticket) {
        return this.getChunkHolderManager().addTicketAtLevel(ticket.a(), i2, ticket.b(), ticket.c);
    }

    boolean removeTicket(long i2, Ticket<?> ticket) {
        return this.getChunkHolderManager().removeTicketAtLevel(ticket.a(), i2, ticket.b(), ticket.c);
    }

    public <T> void a(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        this.addTicket(pos.a(), new Ticket<T>(type, level, argument));
    }

    public <T> void b(TicketType<T> type, ChunkCoordIntPair pos, int level, T argument) {
        Ticket<T> ticket = new Ticket<T>(type, level, argument);
        this.removeTicket(pos.a(), ticket);
    }

    public <T> void c(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        this.addRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        return this.getChunkHolderManager().addTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.a(FullChunkStatus.b) - i2, t0);
    }

    public <T> void d(TicketType<T> type, ChunkCoordIntPair pos, int radius, T argument) {
        this.removeRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        return this.getChunkHolderManager().removeTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.a(FullChunkStatus.b) - i2, t0);
    }

    private ArraySetSorted<Ticket<?>> g(long position) {
        throw new UnsupportedOperationException();
    }

    protected void a(ChunkCoordIntPair pos, boolean forced) {
        if (forced) {
            this.getChunkHolderManager().addTicketAtLevel(TicketType.d, pos, PlayerChunkMap.c, pos);
        } else {
            this.getChunkHolderManager().removeTicketAtLevel(TicketType.d, pos, PlayerChunkMap.c, pos);
        }
    }

    public void a(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ((ObjectSet)this.d.computeIfAbsent(i2, j2 -> new ObjectOpenHashSet())).add((Object)player);
    }

    public void b(SectionPosition pos, EntityPlayer player) {
        ChunkCoordIntPair chunkcoordintpair = pos.r();
        long i2 = chunkcoordintpair.a();
        ObjectSet objectset = (ObjectSet)this.d.get(i2);
        if (objectset == null) {
            return;
        }
        if (objectset != null) {
            objectset.remove((Object)player);
        }
        if (objectset == null || objectset.isEmpty()) {
            this.d.remove(i2);
        }
    }

    private int g() {
        throw new UnsupportedOperationException();
    }

    public boolean c(long chunkPos) {
        NewChunkHolder chunkHolder = this.getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    protected String e(long pos) {
        return this.getChunkHolderManager().getTicketDebugString(pos);
    }

    protected void a(int viewDistance) {
        this.moonrise$getChunkMap().a(viewDistance);
    }

    public void b(int simulationDistance) {
        this.moonrise$getChunkMap().s.moonrise$getPlayerChunkLoader().setTickDistance(simulationDistance);
    }

    public int b() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    public boolean f(long chunkPos) {
        return this.spawnChunkTracker.hasObjectsNear(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos));
    }

    public String c() {
        return "No DistanceManager stats available";
    }

    private void a(String path) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    TickingTracker d() {
        throw new UnsupportedOperationException();
    }

    public void e() {
    }

    public boolean f() {
        throw new UnsupportedOperationException();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.getChunkHolderManager().removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    private class b
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected b(int i2) {
            super(i2 + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = i2;
            this.a.defaultReturnValue((byte)(i2 + 2));
        }

        @Override
        protected int c(long id) {
            return this.a.get(id);
        }

        @Override
        protected void a(long id, int level) {
            byte b0 = level > this.b ? this.a.remove(id) : this.a.put(id, (byte)level);
            this.a(id, (int)b0, level);
        }

        protected void a(long pos, int oldDistance, int distance) {
        }

        @Override
        protected int b(long id) {
            return this.d(id) ? 0 : Integer.MAX_VALUE;
        }

        private boolean d(long chunkPos) {
            ObjectSet objectset = (ObjectSet)ChunkMapDistance.this.d.get(chunkPos);
            return objectset != null && !objectset.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }

        private void a(String path) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.a.long2ByteEntrySet()) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.e + "\t" + chunkcoordintpair.f + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                a.error("Failed to dump chunks to {}", (Object)path, (Object)ioexception);
            }
        }
    }
}

