/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> f = ChunkResult.a("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> g = CompletableFuture.completedFuture(f);
    private static final byte h = -1;
    private static final byte i = 0;
    private static final byte j = 1;
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 200;
    private static final int m = 20;
    private static final int n = 10000;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final WorldServer s;
    private final LightEngineThreaded t;
    private final IAsyncTaskHandler<Runnable> u;
    private final RandomState v;
    private final ChunkGeneratorStructureState w;
    private final Supplier<WorldPersistentData> x;
    private final VillagePlace y;
    public final LongSet z;
    private boolean A;
    public final WorldLoadListener E;
    private final ChunkStatusUpdateListener F;
    public final ChunkDistanceManager G;
    public final AtomicInteger H;
    private final String I;
    private final PlayerMap J;
    public final Int2ObjectMap<EntityTracker> K;
    private final Long2ByteMap L;
    private final Long2LongMap M;
    public int O;
    public final WorldGenContext P;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    public PlayerChunkMap(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess chunkProvider, ChunkGenerator chunkGenerator, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(new RegionStorageInfo(session.f(), world.af(), "chunk"), session.a(world.af()).resolve("region"), dataFixer, dsync);
        this.z = new LongOpenHashSet();
        this.H = new AtomicInteger();
        this.J = new PlayerMap();
        this.K = new Int2ObjectOpenHashMap();
        this.L = new Long2ByteOpenHashMap();
        this.M = new Long2LongOpenHashMap();
        Path path = session.a(world.af());
        this.I = path.getFileName().toString();
        this.s = world;
        IRegistryCustom iregistrycustom = world.H_();
        long j2 = world.C();
        ChunkGenerator randomGenerator = chunkGenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)randomGenerator;
            this.v = RandomState.a(chunkgeneratorabstract.h().a(), iregistrycustom.b(Registries.aP), j2);
        } else {
            this.v = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.b(Registries.aP), j2);
        }
        this.w = chunkGenerator.createState(iregistrycustom.b(Registries.aT), this.v, j2, world.spigotConfig);
        this.u = mainThreadExecutor;
        ThreadedMailbox<Runnable> threadedmailbox = ThreadedMailbox.a(executor, "worldgen");
        Objects.requireNonNull(mainThreadExecutor);
        Mailbox<Runnable> mailbox = Mailbox.a("main", mainThreadExecutor::i);
        this.E = worldGenerationProgressListener;
        this.F = chunkStatusChangeListener;
        ThreadedMailbox<Runnable> threadedmailbox1 = ThreadedMailbox.a(executor, "light");
        this.t = new LightEngineThreaded(chunkProvider, this, this.s.D_().g(), threadedmailbox1, null);
        this.G = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.x = persistentStateManagerFactory;
        this.y = new VillagePlace(new RegionStorageInfo(session.f(), world.af(), "poi"), path.resolve("poi"), dataFixer, dsync, iregistrycustom, world.o(), world);
        this.a(viewDistance);
        this.P = new WorldGenContext(world, chunkGenerator, structureTemplateManager, this.t, null);
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.s.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.am().f().ordinal();
        ReferenceList<EntityPlayer> inRange = this.s.moonrise$getNearbyPlayers().getPlayers(entity.dq(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = index;
            backingSet[i2].mobCounts[n2] = backingSet[i2].mobCounts[n2] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, EnumCreatureType mobCategory) {
        if (!this.s.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<EntityPlayer> inRange = this.s.moonrise$getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = idx;
            backingSet[i2].mobBackoffCounts[n2] = backingSet[i2].mobBackoffCounts[n2] + 1;
        }
    }

    public int getMobCountNear(EntityPlayer player, EnumCreatureType mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    protected ChunkGenerator a() {
        return this.P.b();
    }

    protected ChunkGeneratorStructureState b() {
        return this.w;
    }

    protected RandomState c() {
        return this.v;
    }

    private static double a(ChunkCoordIntPair pos, net.minecraft.world.entity.Entity entity) {
        double d0 = SectionPosition.a(pos.e, 8);
        double d1 = SectionPosition.a(pos.f, 8);
        double d2 = d0 - entity.dt();
        double d3 = d1 - entity.dz();
        return d2 * d2 + d3 * d3;
    }

    boolean a(EntityPlayer player, int chunkX, int chunkZ) {
        return this.s.moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ);
    }

    private boolean b(EntityPlayer player, int chunkX, int chunkZ) {
        return this.s.moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ, true);
    }

    protected LightEngineThreaded d() {
        return this.t;
    }

    @Nullable
    protected PlayerChunk a(long pos) {
        NewChunkHolder holder = this.s.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public PlayerChunk b(long pos) {
        NewChunkHolder holder = this.s.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier c(long pos) {
        throw new UnsupportedOperationException();
    }

    public String a(ChunkCoordIntPair chunkPos) {
        PlayerChunk playerchunk = this.b(chunkPos.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.i() + "\n";
        ChunkStatus chunkstatus = playerchunk.u();
        IChunkAccess ichunkaccess = playerchunk.p();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.b() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.j().b() + String.valueOf(ichunkaccess.j()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.s();
        s2 = s2 + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s2 + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<IChunkAccess>>> a(PlayerChunk centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    public ReportedException a(IllegalStateException exception, String details) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.t().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.r()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        ChunkSystem.getUpdatingChunkHolders(this.s).forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        ChunkSystem.getVisibleChunkHolders(this.s).forEach(consumer);
        CrashReport crashreport = CrashReport.a(exception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", details);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<Chunk>> a(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void a(boolean flush) {
        this.s.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        GameProfilerFiller gameprofilerfiller = this.s.ag();
        gameprofilerfiller.a("poi");
        this.y.a(shouldKeepTicking);
        gameprofilerfiller.b("chunk_unload");
        if (!this.s.t()) {
            this.b(shouldKeepTicking);
        }
        gameprofilerfiller.c();
    }

    public boolean e() {
        throw new UnsupportedOperationException();
    }

    private void b(BooleanSupplier shouldKeepTicking) {
        this.s.moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        this.s.moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    private void a(long pos, PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    protected boolean f() {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<IChunkAccess> f(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    private static boolean b(NBTTagCompound nbt) {
        return nbt.b("Status", 8);
    }

    private IChunkAccess a(Throwable throwable, ChunkCoordIntPair chunkPos) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.s.o().a(throwable3, this.q(), chunkPos);
            return this.g(chunkPos);
        }
        CrashReport crashreport = CrashReport.a(throwable, "Exception loading chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk being loaded");
        crashreportsystemdetails.a("pos", chunkPos);
        this.h(chunkPos);
        throw new ReportedException(crashreport);
    }

    private IChunkAccess g(ChunkCoordIntPair chunkPos) {
        this.h(chunkPos);
        return new ProtoChunk(chunkPos, ChunkConverter.a, this.s, this.s.H_().d(Registries.aF), null);
    }

    private void h(ChunkCoordIntPair pos) {
        this.L.put(pos.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair pos, ChunkType type) {
        return this.L.put(pos.a(), (byte)(type == ChunkType.a ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder d(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void a(GenerationChunkHolder chunkHolder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(GenerationChunkHolder chunkHolder, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkGenerationTask a(ChunkStatus requestedStatus, ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    private void a(ChunkGenerationTask chunkLoader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void g() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> b(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    private void a(Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> c(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    public int h() {
        return this.H.get();
    }

    private boolean d(PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public boolean a(IChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean i(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    public void a(int watchDistance) {
        int clamped = MathHelper.a(watchDistance, 2, 32);
        if (clamped == this.O) {
            return;
        }
        this.O = clamped;
        this.s.moonrise$getPlayerChunkLoader().setLoadDistance(this.O + 1);
    }

    public int b(EntityPlayer player) {
        return ChunkSystem.getSendViewDistance(player);
    }

    private void a(EntityPlayer player, ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    private static void a(EntityPlayer player, Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void b(EntityPlayer player, ChunkCoordIntPair pos) {
    }

    @Override
    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair pos) {
        if (!RegionFileIOThread.isRegionFileThread()) {
            try {
                return CompletableFuture.completedFuture(Optional.ofNullable(RegionFileIOThread.loadData(this.s, pos.e, pos.f, RegionFileIOThread.RegionFileType.CHUNK_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread())));
            }
            catch (Throwable thr) {
                return CompletableFuture.failedFuture(thr);
            }
        }
        return super.d(pos);
    }

    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair pos, NBTTagCompound tag) {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this.s, pos.e, pos.f, tag, RegionFileIOThread.RegionFileType.CHUNK_DATA);
            return null;
        }
        super.a(pos, tag);
        return null;
    }

    @Override
    public void o() {
        RegionFileIOThread.flush();
    }

    @Nullable
    public Chunk e(long pos) {
        PlayerChunk playerchunk = this.b(pos);
        return playerchunk == null ? null : playerchunk.e();
    }

    public int i() {
        return ChunkSystem.getVisibleChunkHolderCount(this.s);
    }

    public ChunkMapDistance j() {
        return this.G;
    }

    protected Iterable<PlayerChunk> k() {
        return Iterables.unmodifiableIterable(ChunkSystem.getVisibleChunkHolders(this.s));
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        TickingTracker tickingtracker = this.G.d();
        for (PlayerChunk playerchunk : ChunkSystem.getVisibleChunkHolders(this.s)) {
            long i2 = playerchunk.d.a();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.p());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.e, chunkcoordintpair.f, playerchunk.i(), optional.isPresent(), optional.map(IChunkAccess::j).orElse(null), optional1.map(Chunk::D).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.G.e(i2), this.b(chunkcoordintpair), optional1.map(chunk -> chunk.G().size()).orElse(0), tickingtracker.d(i2), tickingtracker.c(i2), optional1.map(chunk -> chunk.o().a()).orElse(0), optional1.map(chunk -> chunk.p().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<ChunkResult<Chunk>> future) {
        try {
            ChunkResult chunkresult = future.getNow(null);
            return chunkresult != null ? (chunkresult.a() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> j(ChunkCoordIntPair chunkPos) {
        return this.d(chunkPos).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((NBTTagCompound)nbttagcompound, chunkPos)), (Executor)SystemUtils.g());
    }

    public NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.s.getTypeKey(), this.x, nbttagcompound, this.a().c(), chunkcoordintpair, this.s);
    }

    public boolean b(ChunkCoordIntPair pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        EntityPlayer entityplayer;
        int chunkRange = this.s.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.s.spigotConfig.viewDistance ? (int)this.s.spigotConfig.viewDistance : chunkRange;
        int finalChunkRange = chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = 16384.0;
        if (!this.G.f(chunkcoordintpair.a())) {
            return false;
        }
        Iterator<EntityPlayer> iterator = this.J.a().iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            entityplayer = iterator.next();
            blockRange = 16384.0;
            if (!reducedRange) continue;
            PlayerNaturallySpawnCreaturesEvent event = entityplayer.playerNaturallySpawnedEvent;
            if (event == null || event.isCancelled()) {
                return false;
            }
            blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, blockRange));
        return true;
    }

    public List<EntityPlayer> c(ChunkCoordIntPair pos) {
        long i2 = pos.a();
        if (!this.G.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.J.a()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.R_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean c(EntityPlayer player) {
        return player.R_() && !this.s.ab().b(GameRules.r);
    }

    void a(EntityPlayer player, boolean added) {
        boolean flag1 = this.c(player);
        boolean flag2 = this.J.d(player);
        if (added) {
            this.J.a(player, flag1);
            this.d(player);
            if (!flag1) {
                this.G.a(SectionPosition.a(player), player);
                this.G.moonrise$addPlayer(player, SectionPosition.a(player));
            }
            player.a(ChunkTrackingView.a);
            ChunkSystem.addPlayerToDistanceMaps(this.s, player);
        } else {
            SectionPosition sectionposition = player.W();
            this.J.a(player);
            if (!flag2) {
                this.G.b(sectionposition, player);
                this.G.moonrise$removePlayer(player, SectionPosition.a(player));
            }
            ChunkSystem.removePlayerFromDistanceMaps(this.s, player);
        }
    }

    private void d(EntityPlayer player) {
        SectionPosition sectionposition = SectionPosition.a(player);
        player.a(sectionposition);
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        SectionPosition sectionposition = player.W();
        SectionPosition sectionposition1 = SectionPosition.a(player);
        boolean flag = this.J.e(player);
        boolean flag1 = this.c(player);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.d(player);
            this.G.moonrise$updatePlayer(player, sectionposition, sectionposition1, flag, flag1);
            if (!flag) {
                this.G.b(sectionposition, player);
            }
            if (!flag1) {
                this.G.a(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.J.b(player);
            }
            if (flag && !flag1) {
                this.J.c(player);
            }
        }
        ChunkSystem.updateMaps(this.s, player);
    }

    private void e(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void a(EntityPlayer player, ChunkTrackingView chunkFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkPos, boolean onlyOnWatchDistanceEdge) {
        PlayerChunk holder = this.b(chunkPos.a());
        if (holder == null) {
            return new ArrayList<EntityPlayer>();
        }
        return holder.moonrise$getPlayers(onlyOnWatchDistanceEdge);
    }

    public void a(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.dO() != this.s || this.K.containsKey(entity.an())) {
            k.error("Illegal ChunkMap::addEntity for world " + this.s.getWorld().getName() + ": " + String.valueOf(entity) + (this.K.containsKey(entity.an()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.am();
            int i2 = entitytypes.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int j2 = entitytypes.p();
                if (this.K.containsKey(entity.an())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
                this.K.put(entity.an(), (Object)playerchunkmap_entitytracker);
                if (entity.moonrise$getTrackedEntity() != null) {
                    throw new IllegalStateException("Entity is already tracked");
                }
                entity.moonrise$setTrackedEntity(playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.a(this.s.x());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.K.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.K.remove(entity.an())) != null) {
            playerchunkmap_entitytracker1.a();
        }
        entity.moonrise$setTrackedEntity(null);
    }

    private void newTrackerTick() {
        NearbyPlayers nearbyPlayers = this.s.moonrise$getNearbyPlayers();
        ServerEntityLookup entityLookup = (ServerEntityLookup)this.s.moonrise$getEntityLookup();
        ReferenceList<net.minecraft.world.entity.Entity> trackerEntities = entityLookup.trackerEntities;
        net.minecraft.world.entity.Entity[] trackerEntitiesRaw = trackerEntities.getRawDataUnchecked();
        int len = trackerEntities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = trackerEntitiesRaw[i2];
            EntityTracker tracker = entity.moonrise$getTrackedEntity();
            if (tracker == null) continue;
            tracker.moonrise$tick(nearbyPlayers.getChunk(entity.dq()));
            tracker.b.a();
        }
        ReferenceList<net.minecraft.world.entity.Entity> unloadedEntities = entityLookup.trackerUnloadedEntities;
        net.minecraft.world.entity.Entity[] unloadedEntitiesRaw = Arrays.copyOf(unloadedEntities.getRawDataUnchecked(), unloadedEntities.size());
        unloadedEntities.clear();
        for (net.minecraft.world.entity.Entity entity : unloadedEntitiesRaw) {
            EntityTracker tracker = entity.moonrise$getTrackedEntity();
            if (tracker == null) continue;
            tracker.moonrise$clearPlayers();
        }
    }

    protected void l() {
        this.newTrackerTick();
    }

    public void a(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.an());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.an());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public void a(List<IChunkAccess> chunks) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : chunks) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.s.d(chunkcoordintpair.e, chunkcoordintpair.f);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.c.b(ClientboundChunksBiomesPacket.a(list1)));
    }

    protected VillagePlace m() {
        return this.y;
    }

    public String n() {
        return this.I;
    }

    void a(ChunkCoordIntPair chunkPos, FullChunkStatus levelType) {
        this.F.onChunkStatusChange(chunkPos, levelType);
    }

    public void a(ChunkCoordIntPair centerPos, int radius) {
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    public class ChunkDistanceManager
    extends ChunkMapDistance
    implements ChunkSystemDistanceManager {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor);
        }

        @Override
        public final PlayerChunkMap moonrise$getChunkMap() {
            return PlayerChunkMap.this;
        }

        @Override
        protected boolean a(long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected PlayerChunk b(long pos) {
            return PlayerChunkMap.this.a(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
            return PlayerChunkMap.this.a(pos, level, holder, k2);
        }
    }

    public class EntityTracker
    implements EntityTrackerTrackedEntity {
        public final EntityTrackerEntry b;
        final net.minecraft.world.entity.Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        private long lastChunkUpdate = -1L;
        private NearbyPlayers.TrackedChunk lastTrackedChunk;

        @Override
        public final void moonrise$tick(NearbyPlayers.TrackedChunk chunk) {
            EntityPlayer player;
            if (chunk == null) {
                this.moonrise$clearPlayers();
                return;
            }
            ReferenceList<EntityPlayer> players = chunk.getPlayers(NearbyPlayers.NearbyMapType.VIEW_DISTANCE);
            if (players == null) {
                this.moonrise$clearPlayers();
                return;
            }
            long lastChunkUpdate = this.lastChunkUpdate;
            long currChunkUpdate = chunk.getUpdateCount();
            NearbyPlayers.TrackedChunk lastTrackedChunk = this.lastTrackedChunk;
            this.lastChunkUpdate = currChunkUpdate;
            this.lastTrackedChunk = chunk;
            EntityPlayer[] playersRaw = players.getRawDataUnchecked();
            int len = players.size();
            for (int i2 = 0; i2 < len; ++i2) {
                player = playersRaw[i2];
                this.b(player);
            }
            if (lastChunkUpdate != currChunkUpdate || lastTrackedChunk != chunk) {
                for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                    player = conn.o();
                    if (players.contains(player)) continue;
                    this.a(player);
                }
            }
        }

        @Override
        public final void moonrise$removeNonTickThreadPlayers() {
            boolean foundToRemove = false;
            for (ServerPlayerConnection conn : this.f) {
                if (TickThread.isTickThreadFor(conn.o())) continue;
                foundToRemove = true;
                break;
            }
            if (!foundToRemove) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                EntityPlayer player = conn.o();
                if (TickThread.isTickThreadFor(player)) continue;
                this.a(player);
            }
        }

        @Override
        public final void moonrise$clearPlayers() {
            this.lastChunkUpdate = -1L;
            this.lastTrackedChunk = null;
            if (this.f.isEmpty()) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                EntityPlayer player = conn.o();
                this.a(player);
            }
        }

        public EntityTracker(net.minecraft.world.entity.Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.s, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.an() == this.c.an() : false;
        }

        public int hashCode() {
            return this.c.an();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.b(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).c.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.o());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.c)) {
                this.b.a(player);
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double rangeY;
                boolean flag;
                double vec3d_dx = player.dt() - this.c.dt();
                double vec3d_dz = player.dz() - this.c.dz();
                int i2 = PlayerChunkMap.this.b(player);
                double d1 = vec3d_dx * vec3d_dx + vec3d_dz * vec3d_dz;
                double d0 = Math.min(this.b(), i2 * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2;
                if (flag && PlayerChunkMap.this.s.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)PlayerChunkMap.this.s.paperConfig().entities.trackingRangeY.get(this.c, -1)) != -1.0) {
                    double vec3d_dy = player.dv() - this.c.dv();
                    flag = vec3d_dy * vec3d_dy <= rangeY * rangeY;
                }
                boolean bl2 = flag = flag && this.c.a(player) && PlayerChunkMap.this.a(player, this.c.dq().e, this.c.dq().f);
                if (flag && !player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.c)) {
                        if (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.c.getBukkitEntity()).callEvent()) {
                            this.b.b(player);
                        }
                        this.b.onPlayerAdd();
                    }
                } else if (this.f.remove(player.c)) {
                    this.b.a(player);
                }
            }
        }

        private int a(int initialDistance) {
            return PlayerChunkMap.this.s.o().b(initialDistance);
        }

        private int b() {
            int i2 = this.d;
            for (net.minecraft.world.entity.Entity entity : this.c.cW()) {
                int j2 = entity.am().o() * 16;
                if ((j2 = TrackingRange.getEntityTrackingRange(entity, j2)) <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> players) {
            for (EntityPlayer entityplayer : players) {
                this.b(entityplayer);
            }
        }
    }
}

