/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.player.CartographyItemEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.Translator;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger h = LogUtils.getLogger();
    private static final int i = -1;
    private static final int j = 4096;
    private static final int k = 80;
    private static final IChatBaseComponent l = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent m = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int n = 1000;
    public EntityPlayer f;
    public final PlayerChunkSender g;
    private int o;
    private int p = -1;
    private final AtomicInteger chatSpamTickCount = new AtomicInteger();
    private final AtomicInteger tabSpamLimiter = new AtomicInteger();
    private final AtomicInteger recipeSpamPackets = new AtomicInteger();
    private int r;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    @Nullable
    private net.minecraft.world.entity.Entity y;
    private double z;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    @Nullable
    private Vec3D F;
    private int G;
    private int H;
    private boolean I;
    private int J;
    private boolean K;
    private int L;
    private int M;
    private int N;
    @Nullable
    private RemoteChatSession O;
    private boolean hasLoggedExpiry = false;
    private SignedMessageChain.b P;
    private final LastSeenMessagesValidator Q = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache R = MessageSignatureCache.a();
    private final FutureChain S;
    private boolean T;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.k)).build());
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player, CommonListenerCookie clientData) {
        super(server, connection, clientData, player);
        this.g = new PlayerChunkSender(connection.e());
        this.f = player;
        player.c = this;
        player.Y().a();
        UUID uuid = player.cz();
        Objects.requireNonNull(server);
        this.P = SignedMessageChain.b.unsigned(uuid, server::aB);
        this.S = new FutureChain(server.chatExecutor);
    }

    @Override
    public void d() {
        int spam;
        if (this.p > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.p));
            this.p = -1;
        }
        this.l();
        this.f.L = this.f.dt();
        this.f.M = this.f.dv();
        this.f.N = this.f.dz();
        this.f.m();
        this.f.a(this.s, this.t, this.u, this.f.dE(), this.f.dG());
        ++this.o;
        this.N = this.M;
        if (this.I && !this.f.fH() && !this.f.bS() && !this.f.ex()) {
            if (++this.J > this.a(this.f)) {
                h.warn("{} was kicked for floating too long!", (Object)this.f.ah().getString());
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return;
            }
        } else {
            this.I = false;
            this.J = 0;
        }
        this.y = this.f.cZ();
        if (this.y != this.f && this.y.cQ() == this.f) {
            this.z = this.y.dt();
            this.A = this.y.dv();
            this.B = this.y.dz();
            this.C = this.y.dt();
            this.D = this.y.dv();
            this.E = this.y.dz();
            if (this.K && this.y.cQ() == this.f) {
                if (++this.L > this.a(this.y)) {
                    h.warn("{} was kicked for floating a vehicle too long!", (Object)this.f.ah().getString());
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return;
                }
            } else {
                this.K = false;
                this.L = 0;
            }
        } else {
            this.y = null;
            this.K = false;
            this.L = 0;
        }
        this.e();
        while ((spam = this.chatSpamTickCount.get()) > 0 && !this.chatSpamTickCount.compareAndSet(spam, spam - 1)) {
        }
        if (this.tabSpamLimiter.get() > 0) {
            this.tabSpamLimiter.getAndDecrement();
        }
        if (this.recipeSpamPackets.get() > 0) {
            this.recipeSpamPackets.getAndDecrement();
        }
        if (this.r > 0) {
            --this.r;
        }
        if (this.f.N() > 0L && this.d.aq() > 0 && SystemUtils.c() - this.f.N() > (long)this.d.aq() * 1000L * 60L && !this.f.h) {
            this.f.H();
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
        }
        if (!this.hasLoggedExpiry && this.O != null && this.O.d().b().a()) {
            h.info("Player profile key for {} has expired!", (Object)this.f.ah().getString());
            this.hasLoggedExpiry = true;
        }
    }

    private int a(net.minecraft.world.entity.Entity vehicle) {
        double d0 = vehicle.ba();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return MathHelper.c(80.0 * Math.max(d1, 1.0));
    }

    public void l() {
        this.s = this.f.dt();
        this.t = this.f.dv();
        this.u = this.f.dz();
        this.v = this.f.dt();
        this.w = this.f.dv();
        this.x = this.f.dz();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.T;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) ? true : this.T && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.f.fX();
    }

    private <T, R> CompletableFuture<R> a(T text, BiFunction<ITextFilter, T, CompletableFuture<R>> filterer) {
        return filterer.apply(this.f.Y(), (ITextFilter)text).thenApply(object -> {
            if (!this.c()) {
                h.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String text) {
        return this.a(text, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> texts) {
        return this.a(texts, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.a(packet.b(), packet.e(), packet.f(), packet.g());
    }

    private static boolean b(double x2, double y2, double z2, float yaw, float pitch) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double a(double d2) {
        return MathHelper.a(d2, -3.0E7, 3.0E7);
    }

    private static double b(double d2) {
        return MathHelper.a(d2, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (PlayerConnection.b(packet.b(), packet.e(), packet.f(), packet.g(), packet.h())) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else if (!this.p()) {
            net.minecraft.world.entity.Entity entity = this.f.cZ();
            if (this.F != null || this.f.fc() || entity.dJ()) {
                return;
            }
            if (entity != this.f && entity.cQ() == this.f && entity == this.y) {
                EntityLiving entityliving;
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                WorldServer worldserver = this.f.A();
                double prevX = this.f.dt();
                double prevY = this.f.dv();
                double prevZ = this.f.dz();
                float prevYaw = this.f.dE();
                float prevPitch = this.f.dG();
                double fromX = d0 = entity.dt();
                double fromY = d1 = entity.dv();
                double fromZ = d2 = entity.dz();
                double toX = d3 = PlayerConnection.a(packet.b());
                double toY = d4 = PlayerConnection.b(packet.e());
                double toZ = d5 = PlayerConnection.a(packet.f());
                float f2 = MathHelper.g(packet.g());
                float f1 = MathHelper.g(packet.h());
                double d6 = d3 - this.z;
                double d7 = d4 - this.A;
                double d8 = d5 - this.B;
                double d9 = entity.dr().g();
                double currDeltaX = toX - fromX;
                double currDeltaY = toY - fromY;
                double currDeltaZ = toZ - fromZ;
                double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = d3 - this.C;
                double otherFieldY = d4 - this.D - 1.0E-6;
                double otherFieldZ = d5 - this.E;
                d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.M;
                int i2 = this.M - this.N;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    h.debug(this.f.cB() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.f.fZ().b ? (double)(this.f.fZ().f * 20.0f) : (double)(this.f.fZ().g * 10.0f);
                speed *= 2.0;
                if (!(!this.f.dO().paperConfig().chunks.preventMovingIntoUnloadedChunks || worldserver.areChunksLoadedForMove(this.f.cK().b(new Vec3D(toX, toY, toZ).d(this.f.dm()))) && worldserver.areChunksLoadedForMove(entity.cK().b(new Vec3D(toX, toY, toZ).d(entity.dm()))))) {
                    this.e.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h()) {
                    h.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.ah().getString(), this.f.ah().getString(), d6, d7, d8});
                    this.b(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                AxisAlignedBB oldBox = entity.cK();
                d6 = d3 - this.C;
                d7 = d4 - this.D - 1.0E-6;
                d8 = d5 - this.E;
                boolean flag1 = entity.S;
                if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).p_()) {
                    entityliving.n();
                }
                entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                boolean didCollide = toX != entity.dt() || toY != entity.dv() || toZ != entity.dz();
                double d11 = d7;
                d6 = d3 - entity.dt();
                d7 = d4 - entity.dv();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.dz();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    h.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.ah().getString(), this.f.ah().getString(), Math.sqrt(d10)});
                }
                entity.a(d3, d4, d5, f2, f1);
                this.f.a(d3, d4, d5, this.f.dE(), this.f.dG());
                boolean teleportBack = flag2;
                if (!teleportBack) {
                    AxisAlignedBB newBox = entity.cK();
                    if (didCollide || !oldBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(worldserver, entity, oldBox, newBox);
                    }
                }
                if (teleportBack) {
                    entity.a(d0, d1, d2, f2, f1);
                    this.f.a(d0, d1, d2, this.f.dE(), this.f.dG());
                    this.b(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = prevX;
                    this.lastPosY = prevY;
                    this.lastPosZ = prevZ;
                    this.lastYaw = prevYaw;
                    this.lastPitch = prevPitch;
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packet.b());
                to.setY(packet.e());
                to.setZ(packet.f());
                to.setYaw(packet.g());
                to.setPitch(packet.h());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fc()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.f.A().l().a(this.f);
                Vec3D vec3d = new Vec3D(entity.dt() - d0, entity.dv() - d1, entity.dz() - d2);
                this.f.b(vec3d);
                this.f.b(vec3d.c, vec3d.d, vec3d.e);
                this.K = d11 >= -0.03125 && !flag1 && !this.d.ae() && !entity.aY() && this.b(entity);
                this.C = entity.dt();
                this.D = entity.dv();
                this.E = entity.dz();
            }
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.cK().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.a(box.a);
        int minY = MathHelper.a(box.b);
        int minZ = MathHelper.a(box.c);
        int maxX = MathHelper.a(box.d);
        int maxY = MathHelper.a(box.e);
        int maxZ = MathHelper.a(box.f);
        net.minecraft.world.level.World world = entity.dO();
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData type = world.getBlockStateIfLoaded(pos);
                    if (type == null || type.i()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.b() == this.G) {
            if (this.F == null) {
                this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.f.b(this.F.c, this.F.d, this.F.e, this.f.dE(), this.f.dG());
            this.v = this.F.c;
            this.w = this.F.d;
            this.x = this.F.e;
            if (this.f.P()) {
                this.f.Q();
            }
            this.F = null;
            this.f.A().l().a(this.f);
        }
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        Optional<RecipeHolder<?>> optional = this.d.aJ().a(packet.b());
        RecipeBookServer recipebookserver = this.f.J();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::e);
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        CraftEventFactory.callRecipeBookSettingsEvent(this.f, packet.b(), packet.e(), packet.f());
        this.f.J().a(packet.b(), packet.e(), packet.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = Objects.requireNonNull(packet.f());
            AdvancementHolder advancementholder = this.d.aE().a(minecraftkey);
            if (advancementholder != null) {
                this.f.R().a(advancementholder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        int index;
        if (this.chatSpamTickCount.addAndGet(GlobalConfiguration.get().spamLimiter.tabSpamIncrement) > GlobalConfiguration.get().spamLimiter.tabSpamLimit && !this.d.ah().f(this.f.fX())) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        if (packet.e().length() > 64 && ((index = packet.e().indexOf(32)) == -1 || index >= 64)) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> this.handleCustomCommandSuggestions0(packet));
    }

    private void handleCustomCommandSuggestions0(PacketPlayInTabComplete packet) {
        Object completions;
        StringReader stringreader = new StringReader(packet.e());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), packet.e(), true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (event.isCancelled()) {
                return;
            }
            this.d.scheduleOnMain(() -> this.sendServerSuggestions(packet, stringreader));
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.e(), stringreader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            Iterator iterator = completions.iterator();
            while (iterator.hasNext()) {
                AsyncTabCompleteEvent.Completion completion = (AsyncTabCompleteEvent.Completion)iterator.next();
                Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                if (intSuggestion != null) {
                    builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    continue;
                }
                builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
            }
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.e.a(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        }
    }

    private static Suggestions limitTo(Suggestions suggestions, int size) {
        return suggestions.getList().size() <= size ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, size));
    }

    private void sendServerSuggestions(PacketPlayInTabComplete packet, StringReader stringreader) {
        ParseResults<CommandListenerWrapper> parseresults = this.d.aH().a().parse(stringreader, this.f.dg());
        if (!parseresults.getExceptions().isEmpty() && parseresults.getExceptions().values().stream().anyMatch(e2 -> e2 instanceof TagParseCommandSyntaxException)) {
            this.disconnect(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        this.d.aH().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
            }
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, packet.e());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.b(new PacketPlayOutTabComplete(packet.b(), PlayerConnection.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.d.q()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.f.gv() || this.f.f() && this.f.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packet.b();
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.b();
            }
            String s2 = packet.e();
            boolean flag = packet.f();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.l();
                IBlockData iblockdata = this.f.dO().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.b);
                IBlockData iblockdata2 = switch (packet.i()) {
                    case TileEntityCommand.Type.a -> Blocks.kH.o();
                    case TileEntityCommand.Type.b -> Blocks.kG.o();
                    default -> Blocks.fN.o();
                };
                IBlockData iblockdata3 = (IBlockData)((IBlockData)iblockdata2.a(BlockCommand.b, enumdirection)).a(BlockCommand.c, packet.g());
                if (iblockdata3 != iblockdata) {
                    this.f.dO().a(blockposition, iblockdata3, 2);
                    tileentity.c(iblockdata3);
                    this.f.dO().m(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.c(null);
                }
                tileentitycommand.b(packet.h());
                if (tileentitycommand_type != packet.i()) {
                    tileentitycommand.f();
                }
                commandblocklistenerabstract.f();
                if (!UtilColor.b(s2)) {
                    this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.d.q()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.f.gv() || this.f.f() && this.f.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packet.a(this.f.dO());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packet.b());
                commandblocklistenerabstract.a(packet.e());
                if (!packet.e()) {
                    commandblocklistenerabstract.c(null);
                }
                commandblocklistenerabstract.f();
                this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packet.b()}));
            }
        }
    }

    @Override
    public void a(PacketPlayInPickItem packet) {
        int sourceSlot;
        int targetSlot;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.b() < 0 || packet.b() >= this.f.fY().h.size()) {
            h.warn("{} tried to set an invalid carried item", (Object)this.f.ah().getString());
            this.disconnect(IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        CraftPlayer bukkitPlayer = this.f.getBukkitEntity();
        PlayerPickItemEvent event = new PlayerPickItemEvent((Player)bukkitPlayer, targetSlot = this.f.fY().i(), sourceSlot = packet.b());
        if (!event.callEvent()) {
            return;
        }
        this.f.fY().pickSlot(event.getSourceSlot(), event.getTargetSlot());
        this.f.c.b(new PacketPlayOutSetSlot(-2, 0, this.f.fY().k, this.f.fY().a(this.f.fY().k)));
        this.f.c.b(new PacketPlayOutSetSlot(-2, 0, packet.b(), this.f.fY().a(packet.b())));
        this.f.c.b(new PacketPlayOutHeldItemSlot(this.f.fY().k));
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        Container container = this.f.cd;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)containeranvil);
                return;
            }
            containeranvil.a(packet.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        Container container = this.f.cd;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
                return;
            }
            containerbeacon.a(packet.b(), packet.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gv()) {
            BlockPosition blockposition = packet.b();
            IBlockData iblockdata = this.f.dO().a_(blockposition);
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packet.f());
                tileentitystructure.a(packet.g());
                tileentitystructure.a(packet.h());
                tileentitystructure.a(packet.i());
                tileentitystructure.a(packet.j());
                tileentitystructure.a(packet.k());
                tileentitystructure.b(packet.l());
                tileentitystructure.a(packet.m());
                tileentitystructure.d(packet.n());
                tileentitystructure.e(packet.o());
                tileentitystructure.a(packet.p());
                tileentitystructure.a(packet.q());
                if (tileentitystructure.d()) {
                    String s2 = tileentitystructure.c();
                    if (packet.e() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.A()) {
                            this.f.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.C()) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.f.A())) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packet.e() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.z()) {
                            this.f.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.f.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packet.g()}), false);
                }
                tileentitystructure.e();
                this.f.dO().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gv()) {
            BlockPosition blockposition = packet.b();
            IBlockData iblockdata = this.f.dO().a_(blockposition);
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packet.e());
                tileentityjigsaw.b(packet.f());
                tileentityjigsaw.a(ResourceKey.a(Registries.aU, packet.g()));
                tileentityjigsaw.a(packet.h());
                tileentityjigsaw.a(packet.i());
                tileentityjigsaw.a(packet.k());
                tileentityjigsaw.b(packet.j());
                tileentityjigsaw.e();
                this.f.dO().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.gv()) {
            BlockPosition blockposition = packet.b();
            TileEntity tileentity = this.f.dO().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.f.A(), packet.e(), packet.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        int i2 = packet.b();
        Container container = this.f.cd;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.f, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.f.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        IntOr.Disabled pageMax = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
        if (!this.cserver.isPrimaryThread() && pageMax.enabled()) {
            List<String> pageList = packet.e();
            long byteTotal = 0L;
            int maxBookPageSize = pageMax.intValue();
            double multiplier = Math.clamp(GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier, 0.3, 1.0);
            long byteAllowed = maxBookPageSize;
            for (String page : pageList) {
                int byteLength = page.getBytes(StandardCharsets.UTF_8).length;
                byteTotal += (long)byteLength;
                int length = page.length();
                int multiByteCharacters = 0;
                if (byteLength != length) {
                    for (char c2 : page.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multiByteCharacters;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.clamp((double)length / 255.0, 0.1, 1.0) * multiplier);
                if (multiByteCharacters <= 1) continue;
                byteAllowed -= (long)multiByteCharacters;
            }
            if (byteTotal > byteAllowed) {
                h.warn("{} tried to send a book too large. Book size: {} - Allowed: {} - Pages: {}", new Object[]{this.f.cB(), byteTotal, byteAllowed, pageList.size()});
                this.disconnectAsync(IChatBaseComponent.b("Book too large!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnectAsync(IChatBaseComponent.b("Book edited too quickly!"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packet.b();
        if (PlayerInventory.d(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.f();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packet.e().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> pages, int slotId) {
        ItemStack handItem = this.f.fY().a(slotId);
        ItemStack itemstack = handItem.s();
        if (itemstack.a(Items.tZ)) {
            List<Filterable<String>> list1 = pages.stream().map(this::a).toList();
            itemstack.b(DataComponents.I, new WritableBookContent(list1));
            this.f.fY().a(slotId, CraftEventFactory.handleEditBookEvent(this.f, slotId, handItem, itemstack));
        }
    }

    private void a(FilteredText title, List<FilteredText> pages, int slotId) {
        ItemStack itemstack = this.f.fY().a(slotId);
        if (itemstack.a(Items.tZ)) {
            ItemStack itemstack1 = itemstack.a((IMaterial)Items.ua);
            itemstack1.c(DataComponents.I);
            List<Filterable<IChatBaseComponent>> list1 = pages.stream().map(filteredtext1 -> this.a((FilteredText)filteredtext1).a(IChatBaseComponent::b)).toList();
            itemstack1.b(DataComponents.J, new WrittenBookContent(this.a(title), this.f.ah().getString(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.f, slotId, itemstack, itemstack1);
            this.f.fY().a(slotId, itemstack);
        }
    }

    private Filterable<String> a(FilteredText message) {
        return this.f.Z() ? Filterable.a(message.b()) : Filterable.a(message);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.l(2) && (entity = this.f.dO().a(packet.e())) != null) {
            NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
            this.f.c.b(new PacketPlayOutNBTQuery(packet.b(), nbttagcompound));
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket packet) {
        CrafterMenu craftermenu;
        IInventory iinventory;
        Container container;
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (!this.f.R_() && packet.e() == this.f.cd.j && (container = this.f.cd) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.a(packet.b(), packet.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.l(2)) {
            TileEntity tileentity = this.f.dO().c_(packet.e());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.d(this.f.dQ()) : null;
            this.f.c.b(new PacketPlayOutNBTQuery(packet.b(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (PlayerConnection.b(packet.a(0.0), packet.b(0.0), packet.c(0.0), packet.a(0.0f), packet.b(0.0f))) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer worldserver = this.f.A();
            if (!this.f.h && !this.f.fc()) {
                if (this.o == 0) {
                    this.l();
                }
                if (!this.p()) {
                    float f1;
                    float f2;
                    double d2;
                    double d1;
                    double d0;
                    double toX = d0 = PlayerConnection.a(packet.a(this.f.dt()));
                    double toY = d1 = PlayerConnection.b(packet.b(this.f.dv()));
                    double toZ = d2 = PlayerConnection.a(packet.c(this.f.dz()));
                    float toYaw = f2 = MathHelper.g(packet.a(this.f.dE()));
                    float toPitch = f1 = MathHelper.g(packet.b(this.f.dG()));
                    if (this.f.bS()) {
                        this.f.a(this.f.dt(), this.f.dv(), this.f.dz(), f2, f1);
                        this.f.A().l().a(this.f);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.f.dt();
                        double prevY = this.f.dv();
                        double prevZ = this.f.dz();
                        float prevYaw = this.f.dE();
                        float prevPitch = this.f.dG();
                        double d3 = this.f.dt();
                        double d4 = this.f.dv();
                        double d5 = this.f.dz();
                        double d6 = d0 - this.s;
                        double d7 = d1 - this.t;
                        double d8 = d2 - this.u;
                        double d9 = this.f.dr().g();
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        double otherFieldX = d0 - this.v;
                        double otherFieldY = d1 - this.w;
                        double otherFieldZ = d2 - this.x;
                        d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                        if (this.f.fH()) {
                            if (d10 > 1.0) {
                                this.a(this.f.dt(), this.f.dv(), this.f.dz(), f2, f1);
                            }
                        } else {
                            PlayerFailMoveEvent event;
                            PlayerFailMoveEvent event2;
                            boolean didCollide;
                            boolean flag1;
                            boolean flag = this.f.fA();
                            if (worldserver.s().i()) {
                                PlayerFailMoveEvent event3;
                                ++this.M;
                                int i2 = this.M - this.N;
                                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                    h.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f.ah().getString(), (Object)i2);
                                    i2 = 1;
                                }
                                this.allowedPlayerTicks = packet.h || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                double speed = this.f.fZ().b ? (double)(this.f.fZ().f * 20.0f) : (double)(this.f.fZ().g * 10.0f);
                                if (!(!this.f.dO().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.f.dt() == toX && this.f.dz() == toZ || worldserver.areChunksLoadedForMove(this.f.cK().b(new Vec3D(toX, toY, toZ).d(this.f.dm()))) || (event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                    this.internalTeleport(this.f.dt(), this.f.dv(), this.f.dz(), this.f.dE(), this.f.dG(), Collections.emptySet());
                                    return;
                                }
                                if (!(this.f.P() || this.f.dO().ab().b(GameRules.t) && flag)) {
                                    PlayerFailMoveEvent event4;
                                    float f22;
                                    float f3 = f22 = flag ? 300.0f : 100.0f;
                                    if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h() && !(event4 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                        if (event4.getLogWarning()) {
                                            h.warn("{} moved too quickly! {},{},{}", new Object[]{this.f.ah().getString(), d6, d7, d8});
                                        }
                                        this.a(this.f.dt(), this.f.dv(), this.f.dz(), this.f.dE(), this.f.dG());
                                        return;
                                    }
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.f.cK();
                            d6 = d0 - this.v;
                            d7 = d1 - this.w;
                            d8 = d2 - this.x;
                            boolean bl = flag1 = d7 > 0.0;
                            if (this.f.aF() && !packet.b() && flag1) {
                                PlayerJumpEvent event5;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                if ((event5 = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                    this.f.ff();
                                } else {
                                    from = event5.getFrom();
                                    this.internalTeleport(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch(), Collections.emptySet());
                                    return;
                                }
                            }
                            boolean flag2 = this.f.S;
                            this.f.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                            ((net.minecraft.world.entity.Entity)this.f).aG = packet.b();
                            boolean bl2 = didCollide = toX != this.f.dt() || toY != this.f.dv() || toZ != this.f.dz();
                            if (this.F != null) {
                                return;
                            }
                            double d11 = d7;
                            d6 = d0 - this.f.dt();
                            d7 = d1 - this.f.dv();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.f.dz();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean movedWrongly = false;
                            if (!(this.f.P() || !(d10 > SpigotConfig.movedWronglyThreshold) || this.f.fH() || this.f.e.e() || this.f.e.b() == EnumGamemode.d || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                movedWrongly = true;
                                if (event2.getLogWarning()) {
                                    h.warn("{} moved wrongly!", (Object)this.f.ah().getString());
                                }
                            }
                            boolean teleportBack = !this.f.ag && !this.f.fH() && movedWrongly;
                            this.f.a(d0, d1, d2, f2, f1);
                            if (!(this.f.ag || this.f.fH() || teleportBack)) {
                                AxisAlignedBB newBox = this.f.cK();
                                if (didCollide || !axisalignedbb.equals(newBox)) {
                                    teleportBack = this.hasNewCollision(worldserver, this.f, axisalignedbb, newBox);
                                }
                            }
                            if (teleportBack && (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                teleportBack = false;
                            }
                            if (teleportBack) {
                                this.internalTeleport(d3, d4, d5, f2, f1, Collections.emptySet());
                                this.f.a(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5, packet.b());
                            } else {
                                this.f.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                if (!this.hasMoved) {
                                    this.lastPosX = prevX;
                                    this.lastPosY = prevY;
                                    this.lastPosZ = prevZ;
                                    this.lastYaw = prevYaw;
                                    this.lastPitch = prevPitch;
                                    this.hasMoved = true;
                                }
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fc()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    Location oldTo = to.clone();
                                    PlayerMoveEvent event6 = new PlayerMoveEvent((Player)player, from, to);
                                    this.cserver.getPluginManager().callEvent((Event)event6);
                                    if (event6.isCancelled()) {
                                        this.teleport(from);
                                        return;
                                    }
                                    if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                        this.f.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                        return;
                                    }
                                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                        this.justTeleported = false;
                                        return;
                                    }
                                }
                                this.f.a(d0, d1, d2, f2, f1);
                                boolean flag4 = this.f.fn();
                                this.I = d11 >= -0.03125 && !flag2 && this.f.e.b() != EnumGamemode.d && !this.d.ae() && !this.f.fZ().c && !this.f.b(MobEffects.y) && !flag && !flag4 && this.b(this.f);
                                this.f.A().l().a(this.f);
                                Vec3D vec3d = new Vec3D(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5);
                                this.f.a(packet.b(), vec3d);
                                this.f.a(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5, packet.b());
                                this.f.b(vec3d);
                                if (flag1) {
                                    this.f.n();
                                }
                                if (packet.b() || this.f.dX() || this.f.p_() || this.f.R_() || flag || flag4) {
                                    this.f.gB();
                                }
                                this.f.b(this.f.dt() - d3, this.f.dv() - d4, this.f.dz() - d5);
                                this.v = this.f.dt();
                                this.w = this.f.dv();
                                this.x = this.f.dz();
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean p() {
        if (this.F != null) {
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.H = this.o;
        return false;
    }

    private boolean hasNewCollision(WorldServer world, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        int i2;
        ArrayList<AxisAlignedBB> collisionsBB = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(world, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB box = (AxisAlignedBB)collisionsBB.get(i2);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i2 = 0; i2 < len; ++i2) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i2);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    private boolean a(IWorldReader world, AxisAlignedBB box, double newX, double newY, double newZ) {
        VoxelShape voxelshape1;
        AxisAlignedBB axisalignedbb1 = this.f.cK().d(newX - this.f.dt(), newY - this.f.dv(), newZ - this.f.dz());
        Iterable<VoxelShape> iterable = world.d(this.f, axisalignedbb1.h(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.a(box.h(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.c(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.i));
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.teleport(x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), cause);
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, Set<RelativeMovement> flags) {
        this.teleport(x2, y2, z2, yaw, pitch, flags, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set);
            return true;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (RelativeMovement relativeArgument : set) {
            relativeFlags.add(CraftPlayer.toApiRelativeFlag(relativeArgument));
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    public void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        AsyncCatcher.catchOp("teleport");
        if (this.f.dJ()) {
            h.info("Attempt to teleport removed player {} restricted", (Object)this.f.cB());
            if (this.d.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.a) ? this.f.dt() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.b) ? this.f.dv() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.c) ? this.f.dz() : 0.0;
        float f22 = set.contains((Object)RelativeMovement.d) ? this.f.dE() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.e) ? this.f.dG() : 0.0f;
        this.F = new Vec3D(d0, d1, d2);
        if (++this.G == Integer.MAX_VALUE) {
            this.G = 0;
        }
        this.lastPosX = this.F.c;
        this.lastPosY = this.F.d;
        this.lastPosZ = this.F.e;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.H = this.o;
        this.f.b(d0, d1, d2, f2, f1);
        this.f.c.b(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.G));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        BlockPosition blockposition = packet.b();
        this.f.H();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packet.f();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case g: {
                if (!this.f.R_()) {
                    ItemStack itemstack = this.f.b(EnumHand.b);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.f.b(EnumHand.a));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.f.a(EnumHand.b, this.f.b(EnumHand.a));
                    } else {
                        this.f.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.f.a(EnumHand.a, itemstack);
                    } else {
                        this.f.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.f.fx();
                }
                return;
            }
            case e: {
                if (!this.f.R_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            h.warn(this.f.cB() + " dropped their items too quickly!");
                            this.disconnect(IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
                            return;
                        }
                    }
                    this.f.a(false);
                }
                return;
            }
            case d: {
                if (!this.f.R_()) {
                    this.f.a(true);
                }
                return;
            }
            case f: {
                this.f.fw();
                return;
            }
            case a: 
            case b: 
            case c: {
                if (this.f.dO().getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) == null) {
                    this.f.c.a(packet.g());
                    return;
                }
                this.f.e.capturedBlockEntity = false;
                this.f.e.captureSentBlockEntities = true;
                this.f.e.a(blockposition, packetplayinblockdig_enumplayerdigtype, packet.e(), this.f.dO().am(), packet.g());
                this.f.c.a(packet.g());
                this.f.e.captureSentBlockEntities = false;
                if (this.f.e.capturedBlockEntity) {
                    this.b(new ClientboundBlockChangedAckPacket(this.p));
                    this.f.c.p = -1;
                    this.f.e.capturedBlockEntity = false;
                    TileEntity tileentity = this.f.dO().c_(blockposition);
                    if (tileentity != null) {
                        this.f.c.b(tileentity.az_());
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean a(EntityPlayer player, ItemStack stack) {
        if (stack.e()) {
            return false;
        }
        Item item = stack.g();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !player.gt().a(item);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)PlayerConnection.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)PlayerConnection.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.f.c.a(packet.f());
        WorldServer worldserver = this.f.A();
        EnumHand enumhand = packet.b();
        ItemStack itemstack = this.f.b(enumhand);
        if (itemstack.a(worldserver.J())) {
            MovingObjectPositionBlock movingobjectpositionblock = packet.e();
            Vec3D vec3d = movingobjectpositionblock.e();
            if (!(Double.isFinite(vec3d.c) && Double.isFinite(vec3d.d) && Double.isFinite(vec3d.e))) {
                return;
            }
            BlockPosition blockposition = movingobjectpositionblock.a();
            if (this.f.a(blockposition, 1.0)) {
                Vec3D vec3d1 = vec3d.d(Vec3D.b(blockposition));
                double d0 = 1.0000001;
                if (Math.abs(vec3d1.a()) < 1.0000001 && Math.abs(vec3d1.b()) < 1.0000001 && Math.abs(vec3d1.c()) < 1.0000001) {
                    EnumDirection enumdirection = movingobjectpositionblock.b();
                    this.f.H();
                    int i2 = this.f.dO().am();
                    if (blockposition.v() < i2) {
                        if (this.F == null && (worldserver.a((EntityHuman)this.f, blockposition) || worldserver.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && worldserver.a_(blockposition).b() instanceof BlockSign)) {
                            EnumInteractionResult enuminteractionresult = this.f.e.a(this.f, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.P.a(this.f, movingobjectpositionblock.a(), itemstack.s());
                            }
                            if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 - 1 && PlayerConnection.a(this.f, itemstack)) {
                                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                                this.f.b(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.b() && !this.f.e.interactResult) {
                                this.f.a(enumhand, true);
                            }
                        } else {
                            this.f.cd.b();
                        }
                    } else {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                        this.f.b(ichatmutablecomponent1, true);
                    }
                    this.f.c.b(new PacketPlayOutBlockChange(worldserver, blockposition));
                    this.f.c.b(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                } else {
                    h.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f.fX().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.a(packet.e());
        WorldServer worldserver = this.f.A();
        EnumHand enumhand = packet.b();
        ItemStack itemstack = this.f.b(enumhand);
        this.f.H();
        if (!itemstack.e() && itemstack.a(worldserver.J())) {
            boolean cancelled;
            float f2 = MathHelper.g(packet.f());
            float f1 = MathHelper.g(packet.g());
            if (f1 != this.f.dG() || f2 != this.f.dE()) {
                this.f.b(f2, f1);
            }
            double d0 = this.f.dt();
            double d1 = this.f.dv() + (double)this.f.cL();
            double d2 = this.f.dz();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.f.gy();
            Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.f.dO().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.f));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.f.e.firedInteract && this.f.e.interactPosition.equals(movingobjectpositionblock.a()) && this.f.e.interactHand == enumhand && ItemStack.c(this.f.e.interactItemStack, itemstack) ? this.f.e.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.a(), movingobjectpositionblock.b(), itemstack, true, enumhand, movingobjectpositionblock.e())).useItemInHand() == Event.Result.DENY;
                this.f.e.firedInteract = false;
            }
            if (cancelled) {
                this.f.resyncUsingItem(this.f);
                this.f.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.f.b(enumhand);
            if (itemstack.e()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.f.e.a(this.f, worldserver, itemstack, enumhand);
            if (enuminteractionresult.b()) {
                this.f.a(enumhand, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.R_()) {
            for (WorldServer worldserver : this.d.K()) {
                net.minecraft.world.entity.Entity entity = packet.a(worldserver);
                if (entity == null) continue;
                this.f.teleportTo(worldserver, entity.dt(), entity.dv(), entity.dz(), entity.dE(), entity.dG(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        net.minecraft.world.entity.Entity entity = this.f.dd();
        if (entity instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)entity;
            entityboat.b(packet.b(), packet.e());
        }
    }

    @Override
    public void a(DisconnectionDetails info) {
        this.onDisconnect(info, null);
    }

    @Override
    public void onDisconnect(DisconnectionDetails info, @Nullable Component quitMessage) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        h.info("{} lost connection: {}", (Object)this.f.ah().getString(), (Object)info.a().getString());
        this.removePlayerFromWorld(quitMessage);
        super.onDisconnect(info, quitMessage);
    }

    private void q() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.S.close();
        this.f.v();
        Component component = quitMessage = quitMessage == null ? this.d.ah().remove(this.f) : this.d.ah().remove(this.f, quitMessage);
        if (quitMessage != null && !quitMessage.equals((Object)Component.empty())) {
            this.d.ah().a(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.f.Y().b();
    }

    public void a(int sequence) {
        if (sequence < 0) {
            this.disconnect(IChatBaseComponent.b("Expected packet sequence nr >= 0"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.p = Math.max(sequence, this.p);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        if (packet.b() >= 0 && packet.b() < PlayerInventory.g()) {
            if (packet.b() == this.f.fY().k) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.f.fY().k, packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.f.fY().k));
                this.f.H();
                return;
            }
            if (this.f.fY().k != packet.b() && this.f.fs() == EnumHand.a) {
                this.f.fx();
            }
            this.f.fY().k = packet.b();
            this.f.H();
        } else {
            h.warn("{} tried to set an invalid carried item", (Object)this.f.ah().getString());
            this.disconnect(IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.d.ag()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packet, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.a(playerchatmessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                CompletableFuture<IChatBaseComponent> componentFuture = this.d.bm().decorate(this.f, null, playerchatmessage.d());
                this.S.append(CompletableFuture.allOf(new CompletableFuture[]{completablefuture, componentFuture}), arg_0 -> this.lambda$handleChat$9(playerchatmessage, componentFuture, (CompletableFuture)completablefuture, arg_0));
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket packet) {
        this.tryHandleChat(packet.b(), () -> {
            if (this.f.w()) {
                return;
            }
            this.b(packet.b());
            this.detectRateSpam("/" + packet.b());
        }, true);
    }

    private void b(String command) {
        String command1 = "/" + command;
        if (SpigotConfig.logCommands) {
            h.info(this.f.cB() + " issued server command: " + command1);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), command1, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c(command);
        if (this.d.aB() && SignableCommand.a(parseresults)) {
            h.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.f.fX().getName(), (Object)command);
            this.f.a(m);
        } else {
            this.d.aH().a(parseresults, command);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket packet) {
        Optional<LastSeenMessages> optional = this.a(packet.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.b(), () -> {
                if (this.f.w()) {
                    return;
                }
                this.a(packet, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + packet.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.b();
        if (SpigotConfig.logCommands) {
            h.info(this.f.cB() + " issued server command: " + (String)command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c(packet.b());
        try {
            map = this.a(packet, SignableCommand.b(parseresults), lastSeenMessages);
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!((String)command).equals(packet.b())) {
            parseresults = this.c((String)command);
            map = Collections.emptyMap();
        }
        CommandSigningContext.a commandsigningcontext_a = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext_a, this.S));
        this.d.aH().a(parseresults, (String)command);
    }

    private void a(SignedMessageChain.a exception) {
        h.warn("Failed to update secure chat state for {}: '{}'", (Object)this.f.fX().getName(), (Object)exception.a().getString());
        this.f.a(exception.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket packet, SignableCommand<S> arguments, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignableCommand.a signablecommand_a1;
        List<ArgumentSignatures.a> list = packet.g().a();
        List<SignableCommand.a<S>> list1 = arguments.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a argumentsignatures_a : list) {
            SignableCommand.a<S> signablecommand_a = arguments.a(argumentsignatures_a.a());
            if (signablecommand_a == null) {
                this.P.setChainBroken();
                throw PlayerConnection.a(packet.b(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), packet.e(), packet.f(), lastSeenMessages);
            map.put(signablecommand_a.a(), this.P.unpack(argumentsignatures_a.b(), signedmessagebody));
        }
        Iterator<Record> iterator = list1.iterator();
        do {
            if (iterator.hasNext()) continue;
            return map;
        } while (map.containsKey((signablecommand_a1 = (SignableCommand.a)iterator.next()).a()));
        throw PlayerConnection.a(packet.b(), list, list1);
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> arguments) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> signablecommand_a : arguments) {
            SignedMessageBody signedmessagebody = SignedMessageBody.a(signablecommand_a.c());
            map.put(signablecommand_a.a(), this.P.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String command, List<ArgumentSignatures.a> actual, List<SignableCommand.a<S>> expected) {
        String s1 = actual.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String s2 = expected.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        h.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{command, s1, s2});
        return new SignedMessageChain.a(m);
    }

    private ParseResults<CommandListenerWrapper> c(String command) {
        CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = this.d.aH().a();
        return com_mojang_brigadier_commanddispatcher.parse(command, this.f.dg());
    }

    private void tryHandleChat(String s2, Runnable runnable, boolean sync) {
        if (PlayerConnection.d(s2)) {
            this.disconnectAsync(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (this.f.dJ() || this.f.E() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.f.H();
            if (sync) {
                this.d.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b acknowledgment) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.Q;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.Q;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.Q.a(acknowledgment);
            if (optional.isEmpty()) {
                h.warn("Failed to validate message acknowledgements from {}", (Object)this.f.ah().getString());
                this.disconnectAsync(l, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
            return optional;
        }
    }

    public static boolean d(String message) {
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (UtilColor.a(message.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.f.E() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (this.f.E() != EnumChatVisibility.b) {
            if (!async && !Bukkit.isPrimaryThread()) {
                AsyncCatcher.catchOp("Asynchronous player chat is not allowed here");
            }
            ChatProcessor cp = new ChatProcessor(this.d, this.f, original, async);
            cp.process();
        }
    }

    @Deprecated
    public void handleCommand(String s2) {
        if (s2.startsWith("/")) {
            s2 = s2.substring(1);
        }
        this.b(s2);
    }

    private PlayerChatMessage a(PacketPlayInChat packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packet.b(), packet.e(), packet.f(), lastSeenMessages);
        return this.P.unpack(packet.g(), signedmessagebody);
    }

    private void b(PlayerChatMessage message) {
        String s2 = message.c();
        if (s2.isEmpty()) {
            h.warn(this.f.cB() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.d.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.f.E() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(s2, message, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (counted && this.chatSpamTickCount.addAndGet(20) > 200 && !this.d.ah().f(this.f.fX()) && !this.d.a(this.f.fX())) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.Q;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.Q;
        synchronized (lastSeenMessagesValidator) {
            if (!this.Q.a(packet.b())) {
                h.warn("Failed to validate message acknowledgements from {}", (Object)this.f.ah().getString());
                this.disconnectAsync(l, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        float f1 = this.f.dG();
        float f2 = this.f.dE();
        double d0 = this.f.dt();
        double d1 = this.f.dv() + (double)this.f.cL();
        double d2 = this.f.dz();
        Location origin = new Location((World)this.f.dO().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.f.gy(), this.f.gz());
        RayTraceResult result = this.f.dO().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.f.getBukkitEntity() && this.f.getBukkitEntity().canSee((Entity)entity) && !handle.R_() && handle.bA() && !handle.y(this.f);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.fY().f(), EnumHand.a);
        } else {
            EnumGamemode gameType = this.f.e.b();
            if (gameType == EnumGamemode.c && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_BLOCK, ((CraftBlock)result.getHitBlock()).getPosition(), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.f.fY().f(), EnumHand.a);
            } else if (gameType != EnumGamemode.b && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > this.f.gz() * this.f.gz()) {
                CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.fY().f(), EnumHand.a);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), CraftEquipmentSlot.getHand(packet.b()));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f.a(packet.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.dJ()) {
            return;
        }
        switch (packet.e()) {
            case a: 
            case b: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.e() == PacketPlayInEntityAction.EnumPlayerAction.a);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case d: 
            case e: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.e() == PacketPlayInEntityAction.EnumPlayerAction.d);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.f.H();
        switch (packet.e()) {
            case a: {
                this.f.g(true);
                if (!this.f.dO().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) break;
                this.f.gm();
                break;
            }
            case b: {
                this.f.g(false);
                break;
            }
            case d: {
                this.f.h(true);
                break;
            }
            case e: {
                this.f.h(false);
                break;
            }
            case c: {
                if (!this.f.fH()) break;
                this.f.a(false, true);
                this.F = this.f.dm();
                break;
            }
            case f: {
                net.minecraft.world.entity.Entity entity = this.f.dd();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                int i2 = packet.f();
                if (!ijumpable.a() || i2 <= 0) break;
                ijumpable.c(i2);
                break;
            }
            case g: {
                net.minecraft.world.entity.Entity entity = this.f.dd();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                ijumpable.b();
                break;
            }
            case h: {
                net.minecraft.world.entity.Entity entity = this.f.dc();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.b(this.f);
                break;
            }
            case i: {
                if (this.f.gd()) break;
                this.f.gf();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage message) {
        MessageSignature messagesignature = message.l();
        if (messagesignature != null) {
            int i2;
            this.R.a(message.m(), message.l());
            LastSeenMessagesValidator lastseenmessagesvalidator = this.Q;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.Q;
            synchronized (lastSeenMessagesValidator) {
                this.Q.a(messagesignature);
                i2 = this.Q.a();
            }
            if (i2 > 4096) {
                this.disconnectAsync(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage message, ChatMessageType.a params) {
        if (!this.getCraftPlayer().canSeePlayer(message.k().c())) {
            this.a(message.d(), params);
            return;
        }
        MessageSignatureCache messageSignatureCache = this.R;
        synchronized (messageSignatureCache) {
            this.b(new ClientboundPlayerChatPacket(message.k().c(), message.k().b(), message.l(), message.m().a(this.R), message.n(), message.o(), params));
            this.a(message);
        }
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params) {
        this.b(new ClientboundDisguisedChatPacket(message, params));
    }

    public SocketAddress m() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        if (this.e.n.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.e.n.remoteAddress();
    }

    public void n() {
        this.T = true;
        this.q();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket packet) {
        this.e.a(new ClientboundPongResponsePacket(packet.b()));
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        final WorldServer worldserver = this.f.A();
        final net.minecraft.world.entity.Entity entity = packet.a(worldserver);
        if (entity == this.f && !this.f.R_()) {
            this.disconnect(IChatBaseComponent.b("Cannot interact with self!"), PlayerKickEvent.Cause.SELF_INTERACTION);
            return;
        }
        this.f.H();
        this.f.g(packet.b());
        if (entity != null) {
            if (!worldserver.C_().a(entity.do())) {
                return;
            }
            AxisAlignedBB axisalignedbb = entity.cK();
            if (this.f.a(axisalignedbb, GlobalConfiguration.get().misc.clientInteractionLeniencyDistance.or(1.0))) {
                packet.a(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.f.b(enumhand);
                        if (itemstack.a(worldserver.J())) {
                            ItemStack itemstack1 = itemstack.s();
                            ItemStack itemInHand = PlayerConnection.this.f.b(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.g() == Items.uK && entity instanceof EntityInsentient;
                            Item origItem = PlayerConnection.this.f.fY().f() == null ? null : PlayerConnection.this.f.fY().f().g();
                            PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.r() == Items.qz && (event.isCancelled() || PlayerConnection.this.f.fY().f() == null || PlayerConnection.this.f.fY().f().g() != origItem)) {
                                entity.resendPossiblyDesyncedEntityData(PlayerConnection.this.f);
                                PlayerConnection.this.f.cd.b();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.f.fY().f() == null || PlayerConnection.this.f.fY().f().g() != origItem)) {
                                PlayerConnection.this.b(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).A()));
                            }
                            if (event.isCancelled() || PlayerConnection.this.f.fY().f() == null || PlayerConnection.this.f.fY().f().g() != origItem) {
                                entity.refreshEntityData(PlayerConnection.this.f);
                                if (entity instanceof Allay || entity instanceof EntityHorseAbstract) {
                                    PlayerConnection.this.b(new PacketPlayOutEntityEquipment(entity.an(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)entity).a((EnumItemSlot)slot).s())).collect(Collectors.toList()), true));
                                }
                                PlayerConnection.this.f.cd.b();
                            }
                            if (event.isCancelled()) {
                                return;
                            }
                            EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.f, entity, enumhand);
                            if (!itemInHand.e() && itemInHand.H() <= -1) {
                                PlayerConnection.this.f.cd.b();
                            }
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.T.a(PlayerConnection.this.f, enuminteractionresult.c() ? itemstack1 : ItemStack.l, entity);
                                if (enuminteractionresult.b()) {
                                    PlayerConnection.this.f.a(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void a(EnumHand hand) {
                        this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        this.performInteraction(hand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, pos, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(pos.c, pos.d, pos.e), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a() {
                        EntityArrow entityarrow;
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity == PlayerConnection.this.f && !PlayerConnection.this.f.R_() || entity instanceof EntityArrow && !(entityarrow = (EntityArrow)entity).cu())) {
                            ItemStack itemstack = PlayerConnection.this.f.b(EnumHand.a);
                            if (!itemstack.a(worldserver.J())) {
                                return;
                            }
                            PlayerConnection.this.f.e(entity);
                            if (!itemstack.e() && itemstack.H() <= -1) {
                                PlayerConnection.this.f.cd.b();
                            }
                            return;
                        }
                        PlayerConnection.this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                        h.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.f.ah().getString());
                    }
                });
            }
        } else {
            packet.a(new PacketPlayInUseEntity.c(){

                @Override
                public void a(EnumHand hand) {
                    CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, hand, null);
                }

                @Override
                public void a(EnumHand hand, Vec3D pos) {
                    CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, hand, pos);
                }

                @Override
                public void a() {
                    CraftEventFactory.callPlayerUseUnknownEntityEvent(PlayerConnection.this.f, packet, EnumHand.a, null);
                }
            });
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.H();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packet.b();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.f.h) {
                    this.f.h = false;
                    this.f = this.d.ah().respawn(this.f, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    CriterionTriggers.w.a(this.f, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.f.ew() > 0.0f) {
                    return;
                }
                this.f = this.d.ah().respawn(this.f, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.d.j()) break;
                this.f.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.f.dO().ab().a(GameRules.r).set(false, this.f.A());
                break;
            }
            case b: {
                this.f.I().a(this.f);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packet, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.f, reason);
        this.f.t();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        if (this.f.cd.j == packet.b() && this.f.cd.b(this.f)) {
            boolean cancelled = this.f.R_();
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                int i2 = packet.e();
                if (!this.f.cd.a(i2)) {
                    h.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f.ah(), i2, this.f.cd.i.size()});
                } else {
                    boolean flag = packet.j() != this.f.cd.j();
                    this.f.cd.h();
                    if (packet.e() < -1 && packet.e() != -999) {
                        return;
                    }
                    InventoryView inventory = this.f.cd.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packet.e());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.l;
                    switch (packet.i()) {
                        case a: {
                            if (packet.f() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.f() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.f() != 0 && packet.f() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packet.e() == -999) {
                                if (this.f.cd.g().e()) break;
                                action = packet.f() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packet.e() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cd.b(packet.e());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.g();
                            ItemStack cursor = this.f.cd.g();
                            if (clickedItem.e()) {
                                if (cursor.e()) break;
                                action = packet.f() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.f)) break;
                            if (cursor.e()) {
                                action = packet.f() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packet.f() == 0 ? cursor.H() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.j() - clickedItem.H());
                                    if ((toPlace = Math.min(toPlace, slot.c.al_() - clickedItem.H())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.H()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.H() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.H() < 0 || clickedItem.H() + cursor.H() > cursor.j()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packet.f() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.f() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.f() != 0 && packet.f() != 1) break;
                            if (packet.e() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cd.b(packet.e());
                            if (slot != null && slot.a(this.f) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packet.f() < 0 || packet.f() >= 9) && packet.f() != 40) break;
                            if (packet.e() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.f() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.f.cd.b(packet.e());
                            if (clickedSlot.a(this.f)) {
                                ItemStack hotbar = this.f.fY().a(packet.f());
                                if (!hotbar.e() && clickedSlot.a(hotbar) || hotbar.e() && clickedSlot.h()) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packet.f() == 2) {
                                click = ClickType.MIDDLE;
                                if (packet.e() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.f.cd.b(packet.e());
                                if (slot != null && slot.h() && this.f.fZ().d && this.f.cd.g().e()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packet.e() >= 0) {
                                if (packet.f() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.f.cd.b(packet.e());
                                    if (slot != null && slot.h() && slot.a(this.f) && !slot.g().e() && slot.g().g() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.f() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.f.cd.b(packet.e());
                                if (slot != null && slot.h() && slot.a(this.f) && !slot.g().e() && slot.g().g() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.f() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            Container containerMenu = this.f.cd;
                            int currentStatus = this.f.cd.u;
                            int newStatus = Container.d(packet.f());
                            if (!(currentStatus != 1 || newStatus != 2 && currentStatus != newStatus || containerMenu.g().e() || newStatus == 0 || newStatus == 1 || newStatus != 2 || this.f.cd.v.isEmpty() || this.f.cd.v.size() != 1)) {
                                int index = containerMenu.v.iterator().next().d;
                                containerMenu.f();
                                this.a(new PacketPlayInWindowClick(packet.b(), packet.j(), index, containerMenu.t, InventoryClickType.a, packet.g(), packet.h()));
                                return;
                            }
                            this.f.cd.a(packet.e(), packet.f(), packet.i(), this.f);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packet.e() < 0 || this.f.cd.g().e()) break;
                            ItemStack cursor = this.f.cd.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.g())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.g()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.i() != InventoryClickType.f) {
                        CartographyInventory cartographyInventory;
                        org.bukkit.inventory.ItemStack result;
                        org.bukkit.inventory.ItemStack result2;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packet.e(), click, action, packet.f()) : new InventoryClickEvent(inventory, type, packet.e(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packet.e() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packet.e(), click, action, packet.f()) : new CraftItemEvent(recipe, inventory, type, packet.e(), click, action);
                        }
                        if (packet.e() == 3 && top instanceof SmithingInventory && (result2 = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packet.e(), click, action, packet.f()) : new SmithItemEvent(inventory, type, packet.e(), click, action);
                        }
                        if (packet.e() == 2 && top instanceof CartographyInventory && (result = (cartographyInventory = (CartographyInventory)top).getResult()) != null && !result.isEmpty()) {
                            event = click == ClickType.NUMBER_KEY ? new CartographyItemEvent(inventory, type, packet.e(), click, action, packet.f()) : new CartographyItemEvent(inventory, type, packet.e(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.f.cd;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.f.cd != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.f.cd.a(i2, packet.f(), packet.i(), this.f);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.f.cd.b();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.f.c.b(new PacketPlayOutSetSlot(-1, -1, this.f.cc.k(), this.f.cd.g()));
                                        this.f.c.b(new PacketPlayOutSetSlot(this.f.cd.j, this.f.cc.k(), packet.e(), this.f.cd.b(packet.e()).g()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.f.c.b(new PacketPlayOutSetSlot(this.f.cd.j, this.f.cc.k(), packet.e(), this.f.cd.b(packet.e()).g()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.f.c.b(new PacketPlayOutSetSlot(-1, -1, this.f.cc.k(), this.f.cd.g()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.f.cd.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.h())) {
                        this.f.cd.b(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.f.cd.a(packet.g());
                    this.f.cd.i();
                    if (flag) {
                        this.f.cd.e();
                    } else {
                        this.f.cd.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        if (!Bukkit.isPrimaryThread() && this.recipeSpamPackets.addAndGet(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement) > GlobalConfiguration.get().spamLimiter.recipeSpamLimit) {
            this.disconnectAsync(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.f.H();
        if (!this.f.R_() && this.f.cd.j == packet.b() && this.f.cd instanceof ContainerRecipeBook) {
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                Container event;
                MinecraftKey recipeName = packet.e();
                boolean makeAll = packet.f();
                PlayerRecipeBookClickEvent paperEvent = new PlayerRecipeBookClickEvent((Player)this.f.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipeName), makeAll);
                if (!paperEvent.callEvent()) {
                    return;
                }
                recipeName = CraftNamespacedKey.toMinecraft(paperEvent.getRecipe());
                makeAll = paperEvent.isMakeAll();
                if (org.bukkit.event.player.PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft(recipeName));
                    if (recipe == null) {
                        return;
                    }
                    event = CraftEventFactory.callRecipeBookClickEvent(this.f, recipe, makeAll);
                    recipeName = CraftNamespacedKey.toMinecraft(((Keyed)event.getRecipe()).getKey());
                    makeAll = event.isShiftClick();
                }
                if (!((event = this.f.cd) instanceof ContainerRecipeBook)) {
                    return;
                }
                ContainerRecipeBook recipeBookMenu = (ContainerRecipeBook)event;
                boolean finalMakeAll = makeAll;
                this.d.aJ().a(recipeName).ifPresent(recipeholder -> recipeBookMenu.a(finalMakeAll, (RecipeHolder<?>)recipeholder, this.f));
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        if (this.f.cd.j == packet.b() && !this.f.R_()) {
            if (!this.f.cd.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cd);
            } else {
                boolean flag = this.f.cd.a((EntityHuman)this.f, packet.e());
                if (flag) {
                    this.f.cd.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.e.e()) {
            boolean flag2;
            boolean flag = packet.b() < 0;
            ItemStack itemstack = packet.e();
            if (!itemstack.a(this.f.dO().J())) {
                return;
            }
            CustomData customdata = itemstack.a(DataComponents.O, CustomData.a);
            if (customdata.a("x") && customdata.a("y") && customdata.a("z") && this.f.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                BlockPosition blockposition = TileEntity.b(customdata.d());
                if (this.f.dO().p(blockposition)) {
                    TileEntity tileentity = null;
                    if (this.f.i(blockposition.u(), blockposition.v(), blockposition.w()) < 1024.0 && this.f.A().isLoadedAndInBounds(blockposition)) {
                        tileentity = this.f.dO().c_(blockposition);
                    }
                    if (tileentity != null) {
                        tileentity.a(itemstack, (HolderLookup.a)this.f.dO().H_());
                    }
                }
            }
            boolean flag1 = packet.b() >= 1 && packet.b() <= 45;
            boolean bl = flag2 = itemstack.e() || itemstack.H() <= itemstack.j();
            if (flag || flag1 && !ItemStack.a(this.f.cc.b(packet.b()).g(), packet.e())) {
                CraftInventoryView inventory = this.f.cc.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packet.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.b() < 36) {
                    type = packet.b() >= 5 && packet.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packet.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.b() >= 0) {
                            this.f.c.b(new PacketPlayOutSetSlot(this.f.cc.j, this.f.cc.k(), packet.b(), this.f.cc.b(packet.b()).g()));
                            this.f.c.b(new PacketPlayOutSetSlot(-1, this.f.cc.k(), -1, ItemStack.l));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f.cc.b(packet.b()).e(itemstack);
                this.f.cc.d();
            } else if (flag && flag2 && this.r < 200) {
                this.r += 20;
                this.f.a(itemstack, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        String[] lines = packet.f();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i2].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i2].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i2].length()) continue;
            lines[i2] = lines[i2].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packet, (List<FilteredText>)list1), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packet, List<FilteredText> signText) {
        if (this.f.fc()) {
            return;
        }
        this.f.H();
        WorldServer worldserver = this.f.A();
        BlockPosition blockposition = packet.b();
        if (worldserver.B(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.f, packet.e(), signText);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.fZ().c && this.f.fZ().b != packet.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.f.getBukkitEntity(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f.fZ().b = packet.b();
            } else {
                this.f.z();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (packet.b().c() < 0) {
            h.warn("Disconnecting " + this.f.cB() + " for invalid view distance: " + packet.b().c());
            this.disconnect(IChatBaseComponent.b("Invalid client settings"), PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.f.a(packet.b());
        this.e.n.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.b().b()));
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.l(2) || this.h()) {
            // empty if block
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        if (this.f.l(2) || this.h()) {
            this.d.b(packet.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        RemoteChatSession.a remotechatsession_a = packet.b();
        ProfilePublicKey.a profilepublickey_a = this.O != null ? this.O.d().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.disconnect(ProfilePublicKey.a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.d.as();
                    if (signaturevalidator == null) {
                        h.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.f.fX().getName());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.f.fX(), signaturevalidator));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    this.disconnect(profilepublickey_b.a(), profilepublickey_b.kickCause);
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.T) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.e.a(ConfigurationProtocols.b, new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.f.C()), this.f));
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.g.a(packet.b());
    }

    @Override
    public void a(ServerboundDebugSampleSubscriptionPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.f.A());
        this.d.a(this.f, packet.b());
    }

    private void a(RemoteChatSession session) {
        this.O = session;
        this.hasLoggedExpiry = false;
        this.P = session.a(this.f.cz());
        this.S.append(() -> {
            this.f.a(session);
            this.d.ah().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), (Collection<EntityPlayer>)List.of(this.f)), this.f);
        });
    }

    @Override
    public EntityPlayer o() {
        return this.f;
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    private /* synthetic */ void lambda$handleChat$9(PlayerChatMessage playerchatmessage, CompletableFuture componentFuture, CompletableFuture completablefuture, Void filteredtext) {
        PlayerChatMessage playerchatmessage1 = playerchatmessage.a((IChatBaseComponent)componentFuture.join()).a(((FilteredText)completablefuture.join()).e());
        this.b(playerchatmessage1);
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

