/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.validation.DirectoryValidator;

public class ResourcePackSourceVanilla
extends BuiltInPackSource {
    private static final ResourcePackInfo c = new ResourcePackInfo(IChatBaseComponent.c("dataPack.vanilla.description"), SharedConstants.b().a(EnumResourcePackType.b), Optional.empty());
    private static final FeatureFlagsMetadataSection d = new FeatureFlagsMetadataSection(FeatureFlags.g);
    private static final BuiltInMetadata e = BuiltInMetadata.a(ResourcePackInfo.b, c, FeatureFlagsMetadataSection.a, d);
    private static final PackLocationInfo f = new PackLocationInfo("vanilla", IChatBaseComponent.c("dataPack.vanilla.name"), PackSource.c, Optional.of(BuiltInPackSource.b));
    private static final PackSelectionConfig g = new PackSelectionConfig(false, ResourcePackLoader.Position.b, false);
    private static final PackSelectionConfig h = new PackSelectionConfig(false, ResourcePackLoader.Position.a, false);
    private static final MinecraftKey i = MinecraftKey.b("datapacks");

    public ResourcePackSourceVanilla(DirectoryValidator symlinkFinder) {
        super(EnumResourcePackType.b, ResourcePackSourceVanilla.b(), i, symlinkFinder);
    }

    private static PackLocationInfo a(String id, IChatBaseComponent title) {
        return new PackLocationInfo(id, title, PackSource.d, Optional.of(KnownPack.a(id)));
    }

    @VisibleForTesting
    public static ResourcePackVanilla b() {
        return new VanillaPackResourcesBuilder().a(e).a("minecraft", "paper").b().a().a(f);
    }

    @Override
    protected IChatBaseComponent a(String id) {
        return IChatBaseComponent.b(id);
    }

    @Override
    @Nullable
    protected ResourcePackLoader a(IResourcePack pack) {
        return ResourcePackLoader.a(f, ResourcePackSourceVanilla.b(pack), EnumResourcePackType.b, g);
    }

    @Override
    @Nullable
    protected ResourcePackLoader a(String fileName, ResourcePackLoader.c packFactory, IChatBaseComponent displayName) {
        PackSelectionConfig packConfig;
        PackLocationInfo info;
        if ("paper".equals(fileName)) {
            info = new PackLocationInfo(fileName, displayName, PackSource.c, Optional.empty());
            packConfig = new PackSelectionConfig(true, ResourcePackLoader.Position.a, true);
        } else {
            info = ResourcePackSourceVanilla.a(fileName, displayName);
            packConfig = h;
        }
        return ResourcePackLoader.a(info, packFactory, EnumResourcePackType.b, packConfig);
    }

    public static ResourcePackRepository a(Path dataPacksPath, DirectoryValidator symlinkFinder) {
        return new ResourcePackRepository(new ResourcePackSourceVanilla(symlinkFinder), new ResourcePackSourceFolder(dataPacksPath, EnumResourcePackType.b, PackSource.e, symlinkFinder));
    }

    public static ResourcePackRepository c() {
        return new ResourcePackRepository(new ResourcePackSourceVanilla(new DirectoryValidator(path -> true)));
    }

    public static ResourcePackRepository a(Convertable.ConversionSession session) {
        return ResourcePackSourceVanilla.a(session.a(SavedFile.j), session.d().e());
    }
}

