/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.sounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;

public class SoundEffect {
    public static final Codec<SoundEffect> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("sound_id").forGetter(SoundEffect::a), (App)Codec.FLOAT.lenientOptionalFieldOf("range").forGetter(SoundEffect::b)).apply((Applicative)instance, SoundEffect::a));
    public static final Codec<Holder<SoundEffect>> b = RegistryFileCodec.a(Registries.al, a);
    public static final StreamCodec<ByteBuf, SoundEffect> c = StreamCodec.a(MinecraftKey.b, SoundEffect::a, ByteBufCodecs.i.a(ByteBufCodecs::a), SoundEffect::b, SoundEffect::a);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SoundEffect>> d = ByteBufCodecs.a(Registries.al, c);
    private static final float e = 16.0f;
    private final MinecraftKey f;
    private final float g;
    private final boolean h;

    private static SoundEffect a(MinecraftKey id, Optional<Float> distanceToTravel) {
        return distanceToTravel.map(float_ -> SoundEffect.a(id, float_.floatValue())).orElseGet(() -> SoundEffect.a(id));
    }

    public static SoundEffect a(MinecraftKey id) {
        return new SoundEffect(id, 16.0f, false);
    }

    public static SoundEffect a(MinecraftKey id, float distanceToTravel) {
        return new SoundEffect(id, distanceToTravel, true);
    }

    private SoundEffect(MinecraftKey id, float distanceToTravel, boolean useStaticDistance) {
        this.f = id;
        this.g = distanceToTravel;
        this.h = useStaticDistance;
    }

    public MinecraftKey a() {
        return this.f;
    }

    public float a(float volume) {
        if (this.h) {
            return this.g;
        }
        return volume > 1.0f ? 16.0f * volume : 16.0f;
    }

    private Optional<Float> b() {
        return this.h ? Optional.of(Float.valueOf(this.g)) : Optional.empty();
    }
}

