/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Map;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class HttpUtilities {
    private static final Logger a = LogUtils.getLogger();

    private HttpUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Path a(Path path, URL url, Map<String, String> headers, HashFunction hashFunction, @Nullable HashCode hashCode, int maxBytes, Proxy proxy, a listener) {
        InputStream inputStream;
        HttpURLConnection httpURLConnection;
        block21: {
            httpURLConnection = null;
            inputStream = null;
            listener.a();
            if (hashCode != null) {
                Path path2 = HttpUtilities.a(path, hashCode);
                try {
                    if (HttpUtilities.a(path2, hashFunction, hashCode)) {
                        a.info("Returning cached file since actual hash matches requested");
                        listener.a(true);
                        HttpUtilities.a(path2);
                        return path2;
                    }
                }
                catch (IOException iOException) {
                    a.warn("Failed to check cached file {}", (Object)path2, (Object)iOException);
                }
                try {
                    a.warn("Existing file {} not found or had mismatched hash", (Object)path2);
                    Files.deleteIfExists(path2);
                }
                catch (IOException iOException2) {
                    listener.a(false);
                    throw new UncheckedIOException("Failed to remove existing file " + String.valueOf(path2), iOException2);
                }
            }
            Path path3 = null;
            httpURLConnection = (HttpURLConnection)url.openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            headers.forEach(httpURLConnection::setRequestProperty);
            inputStream = httpURLConnection.getInputStream();
            long l2 = httpURLConnection.getContentLengthLong();
            OptionalLong optionalLong = l2 != -1L ? OptionalLong.of(l2) : OptionalLong.empty();
            FileUtils.c(path);
            listener.a(optionalLong);
            if (optionalLong.isPresent() && optionalLong.getAsLong() > (long)maxBytes) {
                throw new IOException("Filesize is bigger than maximum allowed (file is " + String.valueOf(optionalLong) + ", limit is " + maxBytes + ")");
            }
            if (path3 == null) break block21;
            HashCode hashCode2 = HttpUtilities.a(hashFunction, maxBytes, listener, inputStream, path3);
            if (!hashCode2.equals((Object)hashCode)) {
                throw new IOException("Hash of downloaded file (" + String.valueOf(hashCode2) + ") did not match requested (" + String.valueOf(hashCode) + ")");
            }
            listener.a(true);
            Path path2 = path3;
            IOUtils.closeQuietly((InputStream)inputStream);
            return path2;
        }
        Path path4 = Files.createTempFile(path, "download", ".tmp", new FileAttribute[0]);
        HashCode hashCode3 = HttpUtilities.a(hashFunction, maxBytes, listener, inputStream, path4);
        Path path5 = HttpUtilities.a(path, hashCode3);
        if (!HttpUtilities.a(path5, hashFunction, hashCode3)) {
            Files.move(path4, path5, StandardCopyOption.REPLACE_EXISTING);
        } else {
            HttpUtilities.a(path5);
        }
        listener.a(true);
        Path path3 = path5;
        Files.deleteIfExists(path4);
        IOUtils.closeQuietly((InputStream)inputStream);
        return path3;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Files.deleteIfExists(path4);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        InputStream inputStream2;
                        if (httpURLConnection != null && (inputStream2 = httpURLConnection.getErrorStream()) != null) {
                            try {
                                a.error("HTTP response error: {}", (Object)IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8));
                            }
                            catch (Exception exception) {
                                a.error("Failed to read response from server");
                            }
                        }
                        listener.a(false);
                        throw new IllegalStateException("Failed to download file " + String.valueOf(url), throwable2);
                    }
                }
                catch (Throwable throwable3) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable3;
                }
            }
        }
    }

    private static void a(Path path) {
        try {
            Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        }
        catch (IOException iOException) {
            a.warn("Failed to update modification time of {}", (Object)path, (Object)iOException);
        }
    }

    private static HashCode a(Path path, HashFunction hashFunction) throws IOException {
        Hasher hasher = hashFunction.newHasher();
        try (OutputStream outputStream = Funnels.asOutputStream((PrimitiveSink)hasher);
             InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.transferTo(outputStream);
        }
        return hasher.hash();
    }

    private static boolean a(Path path, HashFunction hashFunction, HashCode hashCode) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            HashCode hashCode2 = HttpUtilities.a(path, hashFunction);
            if (hashCode2.equals((Object)hashCode)) {
                return true;
            }
            a.warn("Mismatched hash of file {}, expected {} but found {}", new Object[]{path, hashCode, hashCode2});
        }
        return false;
    }

    private static Path a(Path path, HashCode hashCode) {
        return path.resolve(hashCode.toString());
    }

    private static HashCode a(HashFunction hashFunction, int maxBytes, a listener, InputStream stream, Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);){
            int i2;
            Hasher hasher = hashFunction.newHasher();
            byte[] bs = new byte[8196];
            long l2 = 0L;
            while ((i2 = stream.read(bs)) >= 0) {
                listener.a(l2 += (long)i2);
                if (l2 > (long)maxBytes) {
                    throw new IOException("Filesize was bigger than maximum allowed (got >= " + l2 + ", limit was " + maxBytes + ")");
                }
                if (Thread.interrupted()) {
                    a.error("INTERRUPTED");
                    throw new IOException("Download interrupted");
                }
                outputStream.write(bs, 0, i2);
                hasher.putBytes(bs, 0, i2);
            }
            HashCode hashCode = hasher.hash();
            return hashCode;
        }
    }

    public static int a() {
        int n2;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n2 = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return 25564;
            }
        }
        serverSocket.close();
        return n2;
    }

    public static boolean a(int port) {
        boolean bl;
        if (port < 0 || port > 65535) {
            return false;
        }
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            bl = serverSocket.getLocalPort() == port;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        serverSocket.close();
        return bl;
    }

    public static interface a {
        public void a();

        public void a(OptionalLong var1);

        public void a(long var1);

        public void a(boolean var1);
    }
}

