/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Map;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class BannerEntityCustomNameToOverrideComponentFix
extends DataFix {
    public BannerEntityCustomNameToOverrideComponentFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.s);
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.s);
        OpticFinder opticFinder = type.findField("components");
        return this.fixTypeEverywhereTyped("Banner entity custom_name to item_name component fix", type, typed -> {
            Object object = ((Pair)typed.get(taggedChoiceType.finder())).getFirst();
            return object.equals("minecraft:banner") ? this.a((Typed<?>)typed, (OpticFinder<?>)opticFinder) : typed;
        });
    }

    private Typed<?> a(Typed<?> typed, OpticFinder<?> opticFinder) {
        Dynamic dynamic2 = (Dynamic)((Object)typed.getOptional(DSL.remainderFinder()).orElseThrow());
        OptionalDynamic optionalDynamic = dynamic2.get("CustomName");
        boolean bl = optionalDynamic.asString().result().flatMap(ComponentDataFixUtils::a).filter(name -> name.equals("block.minecraft.ominous_banner")).isPresent();
        if (bl) {
            Typed typed2 = typed.getOrCreateTyped(opticFinder).update(DSL.remainderFinder(), dynamic -> dynamic.set("minecraft:item_name", (Dynamic)((Object)((Object)optionalDynamic.result().get()))).set("minecraft:hide_additional_tooltip", dynamic.createMap(Map.of())));
            return typed.set(opticFinder, typed2).set(DSL.remainderFinder(), dynamic2.remove("CustomName"));
        }
        return typed;
    }
}

