/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.ItemStackTagFix;

public class BlockPosFormatAndRenamesFix
extends DataFix {
    private static final List<String> a = List.of("minecraft:witch", "minecraft:ravager", "minecraft:pillager", "minecraft:illusioner", "minecraft:evoker", "minecraft:vindicator");

    public BlockPosFormatAndRenamesFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    private Typed<?> a(Typed<?> typed, Map<String, String> oldToNewKey) {
        return typed.update(DSL.remainderFinder(), dynamic -> {
            for (Map.Entry entry : oldToNewKey.entrySet()) {
                dynamic = dynamic.renameAndFixField((String)entry.getKey(), (String)entry.getValue(), ExtraDataFixUtils::a);
            }
            return dynamic;
        });
    }

    private <T> Dynamic<T> a(Dynamic<T> dynamic) {
        return dynamic.update("frames", frames -> frames.createList(frames.asStream().map(frame -> {
            frame = frame.renameAndFixField("Pos", "pos", ExtraDataFixUtils::a);
            frame = frame.renameField("Rotation", "rotation");
            frame = frame.renameField("EntityId", "entity_id");
            return frame;
        }))).update("banners", banners -> banners.createList(banners.asStream().map(banner -> {
            banner = banner.renameField("Pos", "pos");
            banner = banner.renameField("Color", "color");
            banner = banner.renameField("Name", "name");
            return banner;
        })));
    }

    public TypeRewriteRule makeRule() {
        ArrayList<TypeRewriteRule> list = new ArrayList<TypeRewriteRule>();
        this.a(list);
        this.b(list);
        list.add(this.fixTypeEverywhereTyped("BlockPos format for map frames", this.getInputSchema().getType(DataConverterTypes.j), typed -> typed.update(DSL.remainderFinder(), dynamic -> dynamic.update("data", this::a))));
        Type type = this.getInputSchema().getType(DataConverterTypes.t);
        list.add(this.fixTypeEverywhereTyped("BlockPos format for compass target", type, ItemStackTagFix.a(type, "minecraft:compass"::equals, tagDynamic -> tagDynamic.update("LodestonePos", ExtraDataFixUtils::a))));
        return TypeRewriteRule.seq(list);
    }

    private void a(List<TypeRewriteRule> rules) {
        rules.add(this.a(DataConverterTypes.B, "minecraft:bee", Map.of("HivePos", "hive_pos", "FlowerPos", "flower_pos")));
        rules.add(this.a(DataConverterTypes.B, "minecraft:end_crystal", Map.of("BeamTarget", "beam_target")));
        rules.add(this.a(DataConverterTypes.B, "minecraft:wandering_trader", Map.of("WanderTarget", "wander_target")));
        for (String string : a) {
            rules.add(this.a(DataConverterTypes.B, string, Map.of("PatrolTarget", "patrol_target")));
        }
        rules.add(this.fixTypeEverywhereTyped("BlockPos format in Leash for mobs", this.getInputSchema().getType(DataConverterTypes.B), typed -> typed.update(DSL.remainderFinder(), entityDynamic -> entityDynamic.renameAndFixField("Leash", "leash", ExtraDataFixUtils::a))));
    }

    private void b(List<TypeRewriteRule> rules) {
        rules.add(this.a(DataConverterTypes.s, "minecraft:beehive", Map.of("FlowerPos", "flower_pos")));
        rules.add(this.a(DataConverterTypes.s, "minecraft:end_gateway", Map.of("ExitPortal", "exit_portal")));
    }

    private TypeRewriteRule a(DSL.TypeReference typeReference, String id, Map<String, String> oldToNewKey) {
        String string = "BlockPos format in " + String.valueOf(oldToNewKey.keySet()) + " for " + id + " (" + typeReference.typeName() + ")";
        OpticFinder opticFinder = DSL.namedChoice((String)id, (Type)this.getInputSchema().getChoiceType(typeReference, id));
        return this.fixTypeEverywhereTyped(string, this.getInputSchema().getType(typeReference), typed2 -> typed2.updateTyped(opticFinder, typed -> this.a((Typed<?>)typed, oldToNewKey)));
    }
}

