/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.NamedEntityWriteReadFix;

public class TrialSpawnerConfigFix
extends NamedEntityWriteReadFix {
    public TrialSpawnerConfigFix(Schema outputSchema) {
        super(outputSchema, true, "Trial Spawner config tag fixer", DataConverterTypes.s, "minecraft:trial_spawner");
    }

    private static <T> Dynamic<T> b(Dynamic<T> data) {
        List<String> list = List.of("spawn_range", "total_mobs", "simultaneous_mobs", "total_mobs_added_per_player", "simultaneous_mobs_added_per_player", "ticks_between_spawn", "spawn_potentials", "loot_tables_to_eject", "items_to_drop_when_ominous");
        HashMap<Dynamic, Dynamic> map = new HashMap<Dynamic, Dynamic>(list.size());
        for (String string : list) {
            Optional optional = data.get(string).get().result();
            if (!optional.isPresent()) continue;
            map.put(data.createString(string), (Dynamic)((Object)optional.get()));
            data = data.remove(string);
        }
        return map.isEmpty() ? data : data.set("normal_config", data.createMap(map));
    }

    @Override
    @Override
    protected <T> Dynamic<T> a(Dynamic<T> data) {
        return TrialSpawnerConfigFix.b(data);
    }
}

