/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String b_ = "leash";
    public static final double q_ = 10.0;
    public static final double r_ = 6.0;

    @Nullable
    public a X_();

    public void a(@Nullable a var1);

    default public boolean N_() {
        return this.X_() != null && this.X_().a != null;
    }

    default public boolean O_() {
        return this.X_() != null;
    }

    default public boolean q() {
        return this.y() && !this.N_();
    }

    default public boolean y() {
        return true;
    }

    default public void h_(int unresolvedLeashHolderId) {
        this.a(new a(unresolvedLeashHolderId));
        Leashable.a((Entity)((Object)this), false, false);
    }

    @Nullable
    default public a c(NBTTagCompound nbt) {
        Either either;
        if (nbt.b(b_, 10)) {
            NBTTagCompound leashTag = nbt.p(b_);
            if (!leashTag.b("UUID")) {
                return null;
            }
            return new a(Either.left(leashTag.a("UUID")));
        }
        if (nbt.b(b_, 11) && (either = (Either)GameProfileSerializer.a(nbt, b_).map(Either::right).orElse(null)) != null) {
            return new a(either);
        }
        return null;
    }

    default public void a(NBTTagCompound nbt, @Nullable a leashData) {
        if (leashData != null) {
            Either<UUID, BlockPosition> either = leashData.b;
            Entity entity = leashData.a;
            if (entity != null && entity.pluginRemoved) {
                return;
            }
            if (entity instanceof EntityLeash) {
                EntityLeash entityleash = (EntityLeash)entity;
                either = Either.right(entityleash.t());
            } else if (leashData.a != null) {
                either = Either.left(leashData.a.cz());
            }
            if (either != null) {
                nbt.a(b_, either.map(uuid -> {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.a("UUID", (UUID)uuid);
                    return nbttagcompound1;
                }, GameProfileSerializer::a));
            }
        }
    }

    private static <E extends Entity> void a(E entity, a leashData) {
        World world;
        if (leashData.b != null && (world = entity.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<UUID> optional = leashData.b.left();
            Optional<BlockPosition> optional1 = leashData.b.right();
            if (optional.isPresent()) {
                Entity entity1 = worldserver.a(optional.get());
                if (entity1 != null) {
                    Leashable.a(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.a(entity, (Entity)EntityLeash.b(worldserver, optional1.get()), true);
                return;
            }
            if (entity.ai > 100) {
                entity.forceDrops = true;
                entity.a((IMaterial)Items.uK);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).a(null);
            }
        }
    }

    default public void a(boolean sendPacket, boolean dropItem) {
        Leashable.a((Entity)((Object)this), sendPacket, dropItem);
    }

    private static <E extends Entity> void a(E entity, boolean sendPacket, boolean dropItem) {
        a leashable_a = ((Leashable)((Object)entity)).X_();
        if (leashable_a != null && leashable_a.a != null) {
            World world;
            ((Leashable)((Object)entity)).a(null);
            if (!entity.dO().B && dropItem) {
                entity.forceDrops = true;
                entity.a((IMaterial)Items.uK);
                entity.forceDrops = false;
            }
            if (sendPacket && (world = entity.dO()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                worldserver.l().b(entity, new PacketPlayOutAttachEntity(entity, null));
            }
        }
    }

    public static <E extends Entity> void b_(E entity) {
        a leashable_a = ((Leashable)((Object)entity)).X_();
        if (leashable_a != null && leashable_a.b != null) {
            Leashable.a(entity, leashable_a);
        }
        if (leashable_a != null && leashable_a.a != null) {
            Entity entity1;
            if (!entity.bE() || !leashable_a.a.bE()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.bE() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, !entity.pluginRemoved);
                event.callEvent();
                Leashable.a(entity, true, event.isDropLeash());
            }
            if ((entity1 = ((Leashable)((Object)entity)).A()) != null && entity1.dO() == entity.dO()) {
                float f2 = entity.f(entity1);
                if (!((Leashable)((Object)entity)).a(entity1, f2)) {
                    return;
                }
                if ((double)f2 > entity.dO().paperConfig().misc.maxLeashDistance.or(10.0)) {
                    ((Leashable)((Object)entity)).z();
                } else if ((double)f2 > 6.0) {
                    ((Leashable)((Object)entity)).b(entity1, f2);
                    entity.cr();
                } else {
                    ((Leashable)((Object)entity)).b(entity1);
                }
            }
        }
    }

    default public boolean a(Entity leashHolder, float distance) {
        return true;
    }

    default public void z() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            dropLeash = event.isDropLeash();
        }
        this.a(true, dropLeash);
    }

    default public void b(Entity entity) {
    }

    default public void b(Entity leashHolder, float distance) {
        Leashable.a((Entity)((Object)this), leashHolder, distance);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, float distance) {
        double d0 = (leashHolder.dt() - entity.dt()) / (double)distance;
        double d1 = (leashHolder.dv() - entity.dv()) / (double)distance;
        double d2 = (leashHolder.dz() - entity.dz()) / (double)distance;
        entity.i(entity.dr().b(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
    }

    default public void b(Entity leashHolder, boolean sendPacket) {
        Leashable.a((Entity)((Object)this), leashHolder, sendPacket);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, boolean sendPacket) {
        World world;
        a leashable_a = ((Leashable)((Object)entity)).X_();
        if (leashable_a == null) {
            leashable_a = new a(leashHolder);
            ((Leashable)((Object)entity)).a(leashable_a);
        } else {
            leashable_a.a(leashHolder);
        }
        if (sendPacket && (world = entity.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.l().b(entity, new PacketPlayOutAttachEntity(entity, leashHolder));
        }
        if (entity.bS()) {
            entity.ad();
        }
    }

    @Nullable
    default public Entity A() {
        return Leashable.c((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity c(E entity) {
        Entity entity1;
        a leashable_a = ((Leashable)((Object)entity)).X_();
        if (leashable_a == null) {
            return null;
        }
        if (leashable_a.c != 0 && entity.dO().B && (entity1 = entity.dO().a(leashable_a.c)) instanceof Entity) {
            leashable_a.a(entity1);
        }
        return leashable_a.a;
    }

    public static final class a {
        int c;
        @Nullable
        public Entity a;
        @Nullable
        public Either<UUID, BlockPosition> b;

        a(Either<UUID, BlockPosition> unresolvedLeashData) {
            this.b = unresolvedLeashData;
        }

        a(Entity leashHolder) {
            this.a = leashHolder;
        }

        a(int unresolvedLeashHolderId) {
            this.c = unresolvedLeashHolderId;
        }

        public void a(Entity leashHolder) {
            this.a = leashHolder;
            this.b = null;
            this.c = 0;
        }
    }
}

