/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.attributes.AttributeBase;

public class AttributeRanged
extends AttributeBase {
    private final double c;
    public double d;

    public AttributeRanged(String translationKey, double fallback, double min, double max) {
        super(translationKey, fallback);
        this.c = min;
        this.d = max;
        if (min > max) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (fallback < min) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (fallback > max) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
    }

    public double d() {
        return this.c;
    }

    public double e() {
        return this.d;
    }

    @Override
    @Override
    public double a(double value) {
        if (Double.isNaN(value)) {
            return this.c;
        }
        return MathHelper.a(value, this.c, this.d);
    }
}

