/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;

public class AnimalPanic<E extends EntityCreature>
extends Behavior<E> {
    private static final int c = 100;
    private static final int d = 120;
    private static final int e = 5;
    private static final int f = 4;
    private final float g;
    private final Function<EntityCreature, TagKey<DamageType>> h;

    public AnimalPanic(float speed) {
        this(speed, entity -> DamageTypeTags.F);
    }

    public AnimalPanic(float speed, Function<EntityCreature, TagKey<DamageType>> entityToDangerousDamageTypes) {
        super(Map.of(MemoryModuleType.Z, MemoryStatus.c, MemoryModuleType.x, MemoryStatus.c), 100, 120);
        this.g = speed;
        this.h = entityToDangerousDamageTypes;
    }

    @Override
    @Override
    protected boolean a(WorldServer world, E entity) {
        return ((EntityLiving)entity).dT().c(MemoryModuleType.x).map(hurtBy -> hurtBy.a(this.h.apply((EntityCreature)entity))).orElse(false) != false || ((EntityLiving)entity).dT().a(MemoryModuleType.Z);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, E entity, long time) {
        return true;
    }

    @Override
    @Override
    protected void b(WorldServer serverLevel, E pathfinderMob, long l2) {
        ((EntityLiving)pathfinderMob).dT().a(MemoryModuleType.Z, true);
        ((EntityLiving)pathfinderMob).dT().b(MemoryModuleType.m);
    }

    @Override
    @Override
    protected void c(WorldServer serverLevel, E pathfinderMob, long l2) {
        BehaviorController<?> brain = ((EntityLiving)pathfinderMob).dT();
        brain.b(MemoryModuleType.Z);
    }

    @Override
    @Override
    protected void d(WorldServer serverLevel, E pathfinderMob, long l2) {
        Vec3D vec3;
        if (((EntityInsentient)pathfinderMob).N().l() && (vec3 = this.a(pathfinderMob, serverLevel)) != null) {
            ((EntityLiving)pathfinderMob).dT().a(MemoryModuleType.m, new MemoryTarget(vec3, this.g, 0));
        }
    }

    @Nullable
    private Vec3D a(E entity, WorldServer world) {
        Optional<Vec3D> optional;
        if (((Entity)entity).bR() && (optional = this.a((IBlockAccess)world, (Entity)entity).map(Vec3D::c)).isPresent()) {
            return optional.get();
        }
        return LandRandomPos.a(entity, 5, 4);
    }

    private Optional<BlockPosition> a(IBlockAccess world, Entity entity) {
        Predicate<BlockPosition> predicate2;
        BlockPosition blockPos = entity.do();
        if (!world.a_(blockPos).k(world, blockPos).c()) {
            return Optional.empty();
        }
        if (MathHelper.f(entity.dj()) == 2) {
            Predicate<BlockPosition> predicate = pos -> BlockPosition.a(pos).allMatch(posx -> world.b_((BlockPosition)posx).a(TagsFluid.a));
        } else {
            predicate2 = pos -> world.b_((BlockPosition)pos).a(TagsFluid.a);
        }
        return BlockPosition.a(blockPos, 5, 1, predicate2);
    }

    @Override
    protected /* synthetic */ void b(WorldServer world, EntityLiving entity, long time) {
        this.c(world, (E)((EntityCreature)entity), time);
    }

    @Override
    protected /* synthetic */ void c(WorldServer world, EntityLiving entity, long time) {
        this.d(world, (E)((EntityCreature)entity), time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (E)((EntityCreature)entity), time);
    }
}

