/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class BehaviorUtil {
    private BehaviorUtil() {
    }

    public static void a(EntityLiving first, EntityLiving second, float speed, int walkCompletionRange) {
        BehaviorUtil.c(first, second);
        BehaviorUtil.b(first, second, speed, walkCompletionRange);
    }

    public static boolean a(BehaviorController<?> brain, EntityLiving target) {
        Optional<NearestVisibleLivingEntities> optional = brain.c(MemoryModuleType.h);
        return optional.isPresent() && optional.get().a(target);
    }

    public static boolean a(BehaviorController<?> brain, MemoryModuleType<? extends EntityLiving> memoryModuleType, EntityTypes<?> entityType) {
        return BehaviorUtil.a(brain, memoryModuleType, (EntityLiving entityliving) -> entityliving.am() == entityType);
    }

    private static boolean a(BehaviorController<?> brain, MemoryModuleType<? extends EntityLiving> memoryType, Predicate<EntityLiving> filter) {
        return brain.c(memoryType).filter(filter).filter(EntityLiving::bE).filter(entityliving -> BehaviorUtil.a(brain, entityliving)).isPresent();
    }

    private static void c(EntityLiving first, EntityLiving second) {
        BehaviorUtil.a(first, second);
        BehaviorUtil.a(second, first);
    }

    public static void a(EntityLiving entity, EntityLiving target) {
        entity.dT().a(MemoryModuleType.n, new BehaviorPositionEntity(target, true));
    }

    private static void b(EntityLiving first, EntityLiving second, float speed, int completionRange) {
        BehaviorUtil.a(first, (Entity)second, speed, completionRange);
        BehaviorUtil.a(second, (Entity)first, speed, completionRange);
    }

    public static void a(EntityLiving entity, Entity target, float speed, int completionRange) {
        BehaviorUtil.a(entity, new BehaviorPositionEntity(target, true), speed, completionRange);
    }

    public static void a(EntityLiving entity, BlockPosition target, float speed, int completionRange) {
        BehaviorUtil.a(entity, new BehaviorTarget(target), speed, completionRange);
    }

    public static void a(EntityLiving entity, BehaviorPosition target, float speed, int completionRange) {
        MemoryTarget memorytarget = new MemoryTarget(target, speed, completionRange);
        entity.dT().a(MemoryModuleType.n, target);
        entity.dT().a(MemoryModuleType.m, memorytarget);
    }

    public static void a(EntityLiving entity, ItemStack stack, Vec3D targetLocation) {
        Vec3D vec3d1 = new Vec3D(0.3f, 0.3f, 0.3f);
        BehaviorUtil.a(entity, stack, targetLocation, vec3d1, 0.3f);
    }

    public static void a(EntityLiving entity, ItemStack stack, Vec3D targetLocation, Vec3D velocityFactor, float yOffset) {
        if (stack.e()) {
            return;
        }
        double d0 = entity.dx() - (double)yOffset;
        EntityItem entityitem = new EntityItem(entity.dO(), entity.dt(), d0, entity.dz(), stack);
        entityitem.b((Entity)entity);
        Vec3D vec3d2 = targetLocation.d(entity.dm());
        vec3d2 = vec3d2.d().d(velocityFactor.c, velocityFactor.d, velocityFactor.e);
        entityitem.i(vec3d2);
        entityitem.v();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
        entityitem.dO().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        entity.dO().b(entityitem);
    }

    public static SectionPosition a(WorldServer world, SectionPosition center, int radius) {
        int j2 = world.b(center);
        Stream<SectionPosition> stream = SectionPosition.a(center, radius).filter(sectionposition1 -> world.b((SectionPosition)sectionposition1) < j2);
        Objects.requireNonNull(world);
        return stream.min(Comparator.comparingInt(world::b)).orElse(center);
    }

    public static boolean a(EntityInsentient mob, EntityLiving target, int rangedWeaponReachReduction) {
        ItemProjectileWeapon itemprojectileweapon;
        Item item = mob.eT().g();
        if (item instanceof ItemProjectileWeapon && mob.a(itemprojectileweapon = (ItemProjectileWeapon)item)) {
            int j2 = itemprojectileweapon.c() - rangedWeaponReachReduction;
            return mob.a((Entity)target, (double)j2);
        }
        return mob.i(target);
    }

    public static boolean a(EntityLiving source, EntityLiving target, double extraDistance) {
        Optional<EntityLiving> optional = source.dT().c(MemoryModuleType.o);
        if (optional.isEmpty()) {
            return false;
        }
        double d1 = source.g(optional.get().dm());
        double d2 = source.g(target.dm());
        return d2 > d1 + extraDistance * extraDistance;
    }

    public static boolean b(EntityLiving source, EntityLiving target) {
        BehaviorController<NearestVisibleLivingEntities> behaviorcontroller = source.dT();
        return !behaviorcontroller.a(MemoryModuleType.h) ? false : behaviorcontroller.c(MemoryModuleType.h).get().a(target);
    }

    public static EntityLiving a(EntityLiving source, Optional<EntityLiving> first, EntityLiving second) {
        return first.isEmpty() ? second : BehaviorUtil.a(source, first.get(), second);
    }

    public static EntityLiving a(EntityLiving source, EntityLiving first, EntityLiving second) {
        Vec3D vec3d = first.dm();
        Vec3D vec3d1 = second.dm();
        return source.g(vec3d) < source.g(vec3d1) ? first : second;
    }

    public static Optional<EntityLiving> a(EntityLiving entity, MemoryModuleType<UUID> uuidMemoryModule) {
        Optional<UUID> optional = entity.dT().c(uuidMemoryModule);
        return optional.map(uuid -> ((WorldServer)entity.dO()).a((UUID)uuid)).map(entity1 -> {
            EntityLiving entityliving2;
            EntityLiving entityliving1 = entity1 instanceof EntityLiving ? (entityliving2 = (EntityLiving)entity1) : null;
            return entityliving1;
        });
    }

    @Nullable
    public static Vec3D a(EntityCreature entity, int horizontalRange, int verticalRange) {
        Vec3D vec3d = DefaultRandomPos.a(entity, horizontalRange, verticalRange);
        int k2 = 0;
        while (vec3d != null && !entity.dO().a_(BlockPosition.a(vec3d)).a(PathMode.b) && k2++ < 10) {
            vec3d = DefaultRandomPos.a(entity, horizontalRange, verticalRange);
        }
        return vec3d;
    }

    public static boolean a(EntityLiving entity) {
        return entity.dT().a(MemoryModuleType.r);
    }
}

