/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cf = 6000;
    public int cc;
    @Nullable
    public UUID cd;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    protected void ab() {
        if (this.g() != 0) {
            this.cc = 0;
        }
        super.ab();
    }

    @Override
    public void m_() {
        super.m_();
        if (this.g() != 0) {
            this.cc = 0;
        }
        if (this.cc > 0) {
            --this.cc;
            if (this.cc % 10 == 0) {
                double d0 = this.ah.k() * 0.02;
                double d1 = this.ah.k() * 0.02;
                double d2 = this.ah.k() * 0.02;
                this.dO().a(Particles.Q, this.d(1.0), this.dw() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.gt();
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.e()).a(Blocks.i) ? 10.0f : world.w(pos);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("InLove", this.cc);
        if (this.cd != null) {
            nbt.a("LoveCause", this.cd);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.cc = nbt.h("InLove");
        this.cd = nbt.b("LoveCause") ? nbt.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag = EnumMobSpawn.b(spawnReason) || EntityAnimal.a(world, pos);
        return world.a_(pos.e()).a(TagsBlock.bX) && flag;
    }

    protected static boolean a(IBlockLightAccess world, BlockPosition pos) {
        return world.b(pos, 0) > 8;
    }

    @Override
    public int R() {
        return 120;
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    protected int eg() {
        return 1 + this.dO().z.a(3);
    }

    public abstract boolean o(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.o(itemstack)) {
            int i2 = this.g();
            if (!this.dO().B && i2 == 0 && this.gp()) {
                ItemStack breedCopy = itemstack.s();
                this.a(player, hand, itemstack);
                this.setInLove(player, breedCopy);
                return EnumInteractionResult.a;
            }
            if (this.o_()) {
                this.a(player, hand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                return EnumInteractionResult.a(this.dO().B);
            }
            if (this.dO().B) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(player, hand);
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        stack.a(1, (EntityLiving)player);
    }

    public boolean gp() {
        return this.cc <= 0;
    }

    @Deprecated
    @DoNotUse
    public void f(@Nullable EntityHuman player) {
        this.setInLove(player, null);
    }

    public void setInLove(@Nullable EntityHuman player, @Nullable ItemStack breedItemCopy) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent;
        if (breedItemCopy != null) {
            this.breedItem = breedItemCopy;
        }
        if ((entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600)).isCancelled()) {
            this.breedItem = null;
            return;
        }
        this.cc = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.cd = player.cz();
        }
        this.dO().a((Entity)this, (byte)18);
    }

    public void s(int loveTicks) {
        this.cc = loveTicks;
    }

    public int gq() {
        return this.cc;
    }

    @Nullable
    public EntityPlayer gr() {
        if (this.cd == null) {
            return null;
        }
        EntityHuman entityhuman = this.dO().b(this.cd);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean gs() {
        return this.cc > 0;
    }

    public void gt() {
        this.cc = 0;
    }

    public boolean a(EntityAnimal other) {
        return other == this ? false : (other.getClass() != this.getClass() ? false : this.gs() && other.gs());
    }

    public void a(WorldServer world, EntityAnimal other) {
        EntityAgeable entityageable = this.a(world, (EntityAgeable)other);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dt(), this.dv(), this.dz(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gr()).or(() -> Optional.ofNullable(other.gr())).orElse(null);
            int experience = this.dR().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, other, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(world, other, entityageable, experience);
            world.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer world, EntityAnimal other, @Nullable EntityAgeable baby) {
        this.finalizeSpawnChildFromBreeding(world, other, baby, this.dR().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        EntityPlayer entityplayer = this.gr();
        if (entityplayer == null) {
            entityplayer = entityanimal.gr();
        }
        if (entityplayer != null) {
            entityplayer.a(StatisticList.P);
            CriterionTriggers.p.a(entityplayer, this, entityanimal, entityageable);
        }
        this.c_(6000);
        entityanimal.c_(6000);
        this.gt();
        entityanimal.gt();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.ab().b(GameRules.f) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dt(), this.dv(), this.dz(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityageable));
        }
    }

    @Override
    public void b(byte status) {
        if (status == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.ah.k() * 0.02;
                double d1 = this.ah.k() * 0.02;
                double d2 = this.ah.k() * 0.02;
                this.dO().a(Particles.Q, this.d(1.0), this.dw() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(status);
        }
    }
}

