/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int cn = 400;
    public static final int co = 499;
    public static final int cp = 500;
    public static final double cq = 0.15;
    private static final float cc = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float cd = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float ce = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float cg = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float ch = EntityHorseAbstract.a((int i2) -> 0);
    private static final float ci = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float cj = 0.25f;
    private static final float ck = 0.5f;
    private static final Predicate<EntityLiving> cl = entityliving -> entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).gE();
    private static final PathfinderTargetCondition cm = PathfinderTargetCondition.b().a(16.0).d().a(cl);
    private static final DataWatcherObject<Byte> cD = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cE = 2;
    private static final int cF = 4;
    private static final int cG = 8;
    private static final int cH = 16;
    private static final int cI = 32;
    private static final int cJ = 64;
    public static final int cr = 0;
    public static final int cs = 1;
    private int cK;
    private int cL;
    private int cM;
    public int ct;
    public int cu;
    protected boolean cv;
    public InventorySubcontainer cw;
    protected int cx;
    protected float cy;
    protected boolean cz;
    private float cN;
    private float cO;
    private float cP;
    private float cQ;
    private float cR;
    private float cS;
    protected boolean cA = true;
    protected int cB;
    @Nullable
    private UUID cT;
    private final IInventory cU = new ContainerSingleItem(){
        public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 99;

        @Override
        public ItemStack f() {
            return EntityHorseAbstract.this.fO();
        }

        @Override
        public void b(ItemStack stack) {
            EntityHorseAbstract.this.m(stack);
        }

        @Override
        public void e() {
        }

        @Override
        public boolean a(EntityHuman player) {
            return player.dc() == EntityHorseAbstract.this || player.b(EntityHorseAbstract.this, 4.0);
        }

        @Override
        public List<ItemStack> getContents() {
            return Arrays.asList(this.f());
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.transaction.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.transaction.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        @Override
        public int al_() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public InventoryHolder getOwner() {
            return (AbstractHorse)EntityHorseAbstract.this.getBukkitEntity();
        }

        @Override
        public Location getLocation() {
            return EntityHorseAbstract.this.getBukkitEntity().getLocation();
        }
    };
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.gH();
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bW.a(1, new PathfinderGoalTame(this, 1.2));
        this.bW.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bW.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bW.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bW.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bW.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gl()) {
            this.bW.a(9, new RandomStandGoal(this));
        }
        this.gA();
    }

    protected void gA() {
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.ag), false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cD, (byte)0);
    }

    protected boolean t(int bitmask) {
        return (this.ao.a(cD) & bitmask) != 0;
    }

    protected void d(int bitmask, boolean flag) {
        byte b0 = this.ao.a(cD);
        if (flag) {
            this.ao.a(cD, (byte)(b0 | bitmask));
        } else {
            this.ao.a(cD, (byte)(b0 & ~bitmask));
        }
    }

    public boolean gz() {
        return this.t(2);
    }

    @Override
    @Nullable
    public UUID aa_() {
        return this.cT;
    }

    public void b(@Nullable UUID ownerUuid) {
        this.cT = ownerUuid;
    }

    public boolean gB() {
        return this.cv;
    }

    public void y(boolean tame) {
        this.d(2, tame);
    }

    public void z(boolean inAir) {
        this.cv = inAir;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (distance > 6.0f && this.gC()) {
            this.B(false);
        }
        return true;
    }

    public boolean gC() {
        return this.t(16);
    }

    public boolean gD() {
        return this.t(32);
    }

    public boolean gE() {
        return this.t(8);
    }

    public void A(boolean bred) {
        this.d(8, bred);
    }

    @Override
    public boolean f() {
        return this.bE() && !this.o_() && this.gz();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundCategory) {
        this.cw.a(0, stack);
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.l(stack)) {
            this.m(stack.c(1));
            stack.a(1, (EntityLiving)player);
        }
    }

    @Override
    public boolean i() {
        return this.t(4);
    }

    public int gF() {
        return this.cx;
    }

    public void u(int temper) {
        this.cx = temper;
    }

    public int v(int difference) {
        int j2 = MathHelper.a(this.gF() + difference, 0, this.gL());
        this.u(j2);
        return j2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.bT();
    }

    private void s() {
        SoundEffect soundeffect;
        this.x();
        if (!this.aX() && (soundeffect = this.gm()) != null) {
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), soundeffect, this.de(), 1.0f, 1.0f + (this.ah.i() - this.ah.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.mP, 0.4f, 1.0f);
        }
        if ((i2 = this.e(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        if (this.bT()) {
            for (Entity entity : this.cW()) {
                entity.a(damageSource, (float)i2);
            }
        }
        this.eJ();
        return true;
    }

    public final int gG() {
        return EntityHorseAbstract.w(this.af_());
    }

    public static int w(int columns) {
        return columns * 3 + 1;
    }

    public void gH() {
        InventorySubcontainer inventorysubcontainer = this.cw;
        this.cw = new InventorySubcontainer(this.gG(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.cw.b());
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (itemstack.e()) continue;
                this.cw.a(j2, itemstack.s());
            }
        }
        this.cw.a(this);
        this.gI();
    }

    protected void gI() {
        if (!this.dO().B) {
            this.d(4, !this.cw.a(0).e());
        }
    }

    @Override
    public void a(IInventory sender) {
        boolean flag = this.i();
        this.gI();
        if (this.ai > 20 && !flag && this.i()) {
            this.a(this.ac_(), 0.5f, 1.0f);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (flag && this.ah.a(3) == 0) {
            this.gP();
        }
        return flag;
    }

    protected boolean gl() {
        return true;
    }

    @Nullable
    protected SoundEffect gm() {
        return null;
    }

    @Nullable
    protected SoundEffect gJ() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.k()) {
            IBlockData iblockdata1 = this.dO().a_(pos.d());
            SoundEffectType soundeffecttype = state.w();
            if (iblockdata1.a(Blocks.dN)) {
                soundeffecttype = iblockdata1.w();
            }
            if (this.bT() && this.cA) {
                ++this.cB;
                if (this.cB > 5 && this.cB % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.cB <= 5) {
                    this.a(SoundEffects.mS, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (this.b(soundeffecttype)) {
                this.a(SoundEffects.mS, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.mR, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    private boolean b(SoundEffectType soundGroup) {
        return soundGroup == SoundEffectType.b || soundGroup == SoundEffectType.aT || soundGroup == SoundEffectType.B || soundGroup == SoundEffectType.aU || soundGroup == SoundEffectType.aS;
    }

    protected void a(SoundEffectType group) {
        this.a(SoundEffects.mM, group.a() * 0.15f, group.b());
    }

    public static AttributeProvider.Builder gK() {
        return EntityInsentient.C().a(GenericAttributes.o, 0.7).a(GenericAttributes.s, 53.0).a(GenericAttributes.v, 0.225f).a(GenericAttributes.B, 1.0).a(GenericAttributes.x, 6.0).a(GenericAttributes.k, 0.5);
    }

    @Override
    public int fN() {
        return 6;
    }

    public int gL() {
        return this.maxDomestication;
    }

    @Override
    public float fa() {
        return 0.8f;
    }

    @Override
    public int R() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dO().B && (!this.bT() || this.x(player)) && this.gz()) {
            player.a(this, this.cw);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag) {
            stack.a(1, (EntityLiving)player);
        }
        return this.dO().B ? EnumInteractionResult.c : (flag ? EnumInteractionResult.a : EnumInteractionResult.e);
    }

    protected boolean a(EntityHuman player, ItemStack item) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (item.a(Items.pw)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (item.a(Items.rA)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (item.a(Blocks.ij.r())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (item.a(Items.ou)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (item.a(Items.uk)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.dO().B && this.gz() && this.g() == 0 && !this.gs()) {
                flag = true;
                this.setInLove(player, item.s());
            }
        } else if (item.a(Items.qa) || item.a(Items.qb)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.dO().B && this.gz() && this.g() == 0 && !this.gs()) {
                flag = true;
                this.setInLove(player, item.s());
            }
        }
        if (this.ew() < this.eN() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.o_() && short0 > 0) {
            this.dO().a(Particles.O, this.d(1.0), this.dw() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dO().B) {
                this.b_(short0);
                flag = true;
            }
        }
        if (!(b0 <= 0 || !flag && this.gz() || this.gF() >= this.gL() || this.dO().B)) {
            this.v(b0);
            flag = true;
        }
        if (flag) {
            this.s();
            ((Entity)this).a(GameEvent.m);
        }
        return flag;
    }

    protected void a(EntityHuman player) {
        this.B(false);
        this.C(false);
        if (!this.dO().B) {
            player.t(this.dE());
            player.u(this.dG());
            player.n(this);
        }
    }

    @Override
    public boolean fc() {
        return super.fc() && this.bT() && this.i() || this.gC() || this.gD();
    }

    @Override
    public boolean o(ItemStack stack) {
        return stack.a(TagsItem.af);
    }

    private void t() {
        this.ct = 1;
    }

    @Override
    protected void ez() {
        super.ez();
        if (this.cw != null) {
            for (int i2 = 0; i2 < this.cw.b(); ++i2) {
                ItemStack itemstack = this.cw.a(i2);
                if (itemstack.e() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
                this.b(itemstack);
            }
        }
    }

    @Override
    public void m_() {
        if (this.ah.a(200) == 0) {
            this.t();
        }
        super.m_();
        if (!this.dO().B && this.bE()) {
            if (this.ah.a(900) == 0 && this.aQ == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.gN()) {
                if (!this.gC() && !this.bT() && this.ah.a(300) == 0 && this.dO().a_(this.do().e()).a(Blocks.i)) {
                    this.B(true);
                }
                if (this.gC() && ++this.cK > 50) {
                    this.cK = 0;
                    this.B(false);
                }
            }
            this.gM();
        }
    }

    protected void gM() {
        EntityHorseAbstract entityliving;
        if (this.gE() && this.o_() && !this.gC() && (entityliving = this.dO().a(EntityHorseAbstract.class, cm, this, this.dt(), this.dv(), this.dz(), this.cK().g(16.0))) != null && this.g((Entity)entityliving) > 4.0) {
            this.bV.a((Entity)entityliving, 0);
        }
    }

    public boolean gN() {
        return true;
    }

    @Override
    public void l() {
        super.l();
        if (this.cL > 0 && ++this.cL > 30) {
            this.cL = 0;
            this.d(64, false);
        }
        if (this.db() && this.cM > 0 && ++this.cM > 20) {
            this.cM = 0;
            this.C(false);
        }
        if (this.ct > 0 && ++this.ct > 8) {
            this.ct = 0;
        }
        if (this.cu > 0) {
            ++this.cu;
            if (this.cu > 300) {
                this.cu = 0;
            }
        }
        this.cO = this.cN;
        if (this.gC()) {
            this.cN += (1.0f - this.cN) * 0.4f + 0.05f;
            if (this.cN > 1.0f) {
                this.cN = 1.0f;
            }
        } else {
            this.cN += (0.0f - this.cN) * 0.4f - 0.05f;
            if (this.cN < 0.0f) {
                this.cN = 0.0f;
            }
        }
        this.cQ = this.cP;
        if (this.gD()) {
            this.cO = this.cN = 0.0f;
            this.cP += (1.0f - this.cP) * 0.4f + 0.05f;
            if (this.cP > 1.0f) {
                this.cP = 1.0f;
            }
        } else {
            this.cz = false;
            this.cP += (0.8f * this.cP * this.cP * this.cP - this.cP) * 0.6f - 0.05f;
            if (this.cP < 0.0f) {
                this.cP = 0.0f;
            }
        }
        this.cS = this.cR;
        if (this.t(64)) {
            this.cR += (1.0f - this.cR) * 0.7f + 0.05f;
            if (this.cR > 1.0f) {
                this.cR = 1.0f;
            }
        } else {
            this.cR += (0.0f - this.cR) * 0.7f - 0.05f;
            if (this.cR < 0.0f) {
                this.cR = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.t(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (!this.bT() && !this.o_()) {
            if (this.gz() && player.fN()) {
                this.b(player);
                return EnumInteractionResult.a(this.dO().B);
            }
            ItemStack itemstack = player.b(hand);
            if (!itemstack.e()) {
                EnumInteractionResult enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand);
                if (enuminteractionresult.a()) {
                    return enuminteractionresult;
                }
                if (this.d(EnumItemSlot.g) && this.l(itemstack) && !this.fP()) {
                    this.b(player, itemstack);
                    return EnumInteractionResult.a(this.dO().B);
                }
            }
            this.a(player);
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(player, hand);
    }

    private void x() {
        if (!this.dO().B) {
            this.cL = 1;
            this.d(64, true);
        }
    }

    public void B(boolean eatingGrass) {
        this.d(16, eatingGrass);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void C(boolean angry) {
        if (angry) {
            this.B(false);
        }
        this.d(32, angry);
    }

    @Nullable
    public SoundEffect gO() {
        return this.v();
    }

    public void gP() {
        if (this.gl() && this.db()) {
            this.cM = 1;
            this.C(true);
        }
    }

    public void gQ() {
        if (!this.gD()) {
            this.gP();
            this.b(this.gJ());
        }
    }

    public boolean g(EntityHuman player) {
        this.b(player.cz());
        this.y(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.dO().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        super.a(controllingPlayer, movementInput);
        Vec2F vec2f = this.j(controllingPlayer);
        this.a(vec2f.j, vec2f.i);
        this.aY = this.ba = this.dE();
        this.O = this.ba;
        if (this.da()) {
            if (movementInput.e <= 0.0) {
                this.cB = 0;
            }
            if (this.aF()) {
                this.z(false);
                if (this.cy > 0.0f && !this.gB()) {
                    this.b(this.cy, movementInput);
                }
                this.cy = 0.0f;
            }
        }
    }

    protected Vec2F j(EntityLiving controllingPassenger) {
        return new Vec2F(controllingPassenger.dG() * 0.5f, controllingPassenger.dE());
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        if (this.aF() && this.cy == 0.0f && this.gD() && !this.cz) {
            return Vec3D.b;
        }
        float f2 = controllingPlayer.bo * 0.5f;
        float f1 = controllingPlayer.bq;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)this.g(GenericAttributes.v);
    }

    protected void b(float strength, Vec3D movementInput) {
        double d0 = this.y(strength);
        Vec3D vec3d1 = this.dr();
        this.n(vec3d1.c, d0, vec3d1.e);
        this.z(true);
        this.av = true;
        if (movementInput.e > 0.0) {
            float f1 = MathHelper.a(this.dE() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dE() * ((float)Math.PI / 180));
            this.i(this.dr().b(-0.4f * f1 * strength, 0.0, 0.4f * f2 * strength));
        }
    }

    protected void gR() {
        this.a(SoundEffects.mO, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("EatingHaystack", this.gC());
        nbt.a("Bred", this.gE());
        nbt.a("Temper", this.gF());
        nbt.a("Tame", this.gz());
        if (this.aa_() != null) {
            nbt.a("Owner", this.aa_());
        }
        nbt.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.cw.a(0).e()) {
            nbt.a("SaddleItem", this.cw.a(0).a(this.dQ()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbt);
        this.B(nbt.q("EatingHaystack"));
        this.A(nbt.q("Bred"));
        this.u(nbt.h("Temper"));
        this.y(nbt.q("Tame"));
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cO(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbt.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbt.h("Bukkit.MaxDomestication");
        }
        if (nbt.b("SaddleItem", 10) && (itemstack = ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbt.p("SaddleItem")).orElse(ItemStack.l)).a(Items.nL)) {
            this.cw.a(0, itemstack);
        }
        this.gI();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    protected boolean gS() {
        return !this.bT() && !this.bS() && this.gz() && !this.o_() && this.ew() >= this.eN() && this.gs();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    protected void a(EntityAgeable other, EntityHorseAbstract child) {
        this.a(other, child, GenericAttributes.s, (double)ch, (double)ci);
        this.a(other, child, GenericAttributes.o, (double)ce, (double)cg);
        this.a(other, child, GenericAttributes.v, (double)cc, (double)cd);
    }

    private void a(EntityAgeable other, EntityHorseAbstract child, Holder<AttributeBase> attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.h(attribute), other.h(attribute), min, max, this.ah);
        child.f(attribute).a(d2);
    }

    static double a(double parentBase, double otherParentBase, double min, double max, RandomSource random) {
        double d7;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        parentBase = MathHelper.a(parentBase, min, max);
        otherParentBase = MathHelper.a(otherParentBase, min, max);
        double d4 = 0.15 * (max - min);
        double d6 = (parentBase + otherParentBase) / 2.0;
        double d5 = Math.abs(parentBase - otherParentBase) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d8 > max) {
            double d9 = d8 - max;
            return max - d9;
        }
        if (d8 < min) {
            double d9 = min - d8;
            return min + d9;
        }
        return d8;
    }

    public float H(float tickDelta) {
        return MathHelper.i(tickDelta, this.cO, this.cN);
    }

    public float I(float tickDelta) {
        return MathHelper.i(tickDelta, this.cQ, this.cP);
    }

    public float J(float tickDelta) {
        return MathHelper.i(tickDelta, this.cS, this.cR);
    }

    @Override
    public void b(int strength) {
        if (this.i()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.cz = true;
                this.gP();
            }
            this.cy = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.i();
    }

    @Override
    public void c(int height) {
        float power = height >= 90 ? 1.0f : 0.4f + 0.4f * (float)height / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cz = true;
        this.gP();
        this.gR();
    }

    @Override
    public void b() {
    }

    protected void D(boolean positive) {
        ParticleType particletype = positive ? Particles.Q : Particles.ae;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ah.k() * 0.02;
            double d1 = this.ah.k() * 0.02;
            double d2 = this.ah.k() * 0.02;
            this.dO().a(particletype, this.d(1.0), this.dw() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.D(true);
        } else if (status == 6) {
            this.D(false);
        } else {
            super.b(status);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aY = this.aY;
        }
    }

    protected static float a(IntUnaryOperator randomIntGetter) {
        return 15.0f + (float)randomIntGetter.applyAsInt(8) + (float)randomIntGetter.applyAsInt(9);
    }

    protected static double a(DoubleSupplier randomDoubleGetter) {
        return (double)0.4f + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier randomDoubleGetter) {
        return ((double)0.45f + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean p_() {
        return false;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 400;
        if (j2 == 0) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHorseAbstract.this.cw.a(0);
                }

                @Override
                public boolean a(ItemStack stack) {
                    if (!stack.e() && !stack.a(Items.nL)) {
                        return false;
                    }
                    EntityHorseAbstract.this.cw.a(0, stack);
                    EntityHorseAbstract.this.gI();
                    return true;
                }
            };
        }
        int k2 = mappedIndex - 500 + 1;
        return k2 >= 1 && k2 < this.cw.b() ? SlotAccess.a(this.cw, k2) : super.a_(mappedIndex);
    }

    @Override
    @Nullable
    public EntityLiving cQ() {
        Entity entity;
        if (this.i() && (entity = this.cT()) instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return entityhuman;
        }
        return super.cQ();
    }

    @Nullable
    private Vec3D a(Vec3D offset, EntityLiving passenger) {
        double d0 = this.dt() + offset.c;
        double d1 = this.cK().b;
        double d2 = this.dz() + offset.e;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : passenger.fE()) {
            blockposition_mutableblockposition.b(d0, d1, d2);
            double d3 = this.cK().e + 0.75;
            do {
                double d4 = this.dO().j(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4)) {
                    AxisAlignedBB axisalignedbb = passenger.f(entitypose);
                    Vec3D vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2);
                    if (DismountUtil.a(this.dO(), passenger, axisalignedbb.c(vec3d1))) {
                        passenger.b(entitypose);
                        return vec3d1;
                    }
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityHorseAbstract.a(this.dj(), passenger.dj(), this.dE() + (passenger.fq() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, passenger);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.dj(), passenger.dj(), this.dE() + (passenger.fq() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, passenger);
        return vec3d3 != null ? vec3d3 : this.dm();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(0.2f);
        }
        this.a(world.E_());
        return super.a(world, difficulty, spawnReason, entityData);
    }

    public boolean b(IInventory inventory) {
        return this.cw != inventory;
    }

    public int gT() {
        return this.R();
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return super.a(passenger, dimensions, scaleFactor).e(new Vec3D(0.0, 0.15 * (double)this.cQ * (double)scaleFactor, -0.7 * (double)this.cQ * (double)scaleFactor).b(-this.dE() * ((float)Math.PI / 180)));
    }

    public final IInventory gU() {
        return this.cU;
    }

    public int af_() {
        return 0;
    }
}

