/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger g = LogUtils.getLogger();
    public IBlockData h = Blocks.I.o();
    public int b;
    public boolean c = true;
    public boolean i;
    public boolean j;
    public int k = 40;
    public float l;
    @Nullable
    public NBTTagCompound d;
    public boolean e;
    protected static final DataWatcherObject<BlockPosition> f = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);
    public boolean autoExpire = true;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World world) {
        super(type, world);
    }

    public EntityFallingBlock(World world, double x2, double y2, double z2, IBlockData block) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.O, world);
        this.h = block;
        this.J = true;
        this.a_(x2, y2, z2);
        this.i(Vec3D.b);
        this.L = x2;
        this.M = y2;
        this.N = z2;
        this.a(this.do());
    }

    public static EntityFallingBlock a(World world, BlockPosition pos, IBlockData state) {
        return EntityFallingBlock.fall(world, pos, state, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, iblockdata.b(BlockProperties.C) ? (IBlockData)iblockdata.a(BlockProperties.C, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.u().g())) {
            return entityfallingblock;
        }
        world.a(blockposition, iblockdata.u().g(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean cu() {
        return false;
    }

    public void a(BlockPosition pos) {
        this.ao.a(f, pos);
    }

    public BlockPosition p() {
        return this.ao.a(f);
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, BlockPosition.c);
    }

    @Override
    public boolean bA() {
        return !this.dJ();
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    @Override
    public void l() {
        if (this.h.i()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.h.b();
            ++this.b;
            this.bb();
            this.a(EnumMoveType.a, this.dr());
            if (this.dO().paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dv() > (double)v2)) {
                if (this.c && this.dO().ab().b(GameRules.i)) {
                    this.a(block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            this.bP();
            if (!this.dO().B && (this.bE() || this.e)) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.do();
                boolean flag = this.h.b() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.dO().b_(blockposition).a(TagsFluid.a);
                double d0 = this.dr().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.dO().a(new RayTrace(new Vec3D(this.L, this.M, this.N), this.dm(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.dO().b_(movingobjectpositionblock.a()).a(TagsFluid.a)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.aF() && !flag1) {
                    if (!this.dO().B && (this.b > 100 && this.autoExpire && (blockposition.v() <= this.dO().I_() || blockposition.v() > this.dO().am()) || this.b > 600 && this.autoExpire)) {
                        if (this.c && this.dO().ab().b(GameRules.i)) {
                            this.a(block);
                        }
                        this.discard(EntityRemoveEvent.Cause.DROP);
                    }
                } else {
                    IBlockData iblockdata = this.dO().a_(blockposition);
                    this.i(this.dr().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bQ)) {
                        if (!this.i) {
                            boolean flag4;
                            boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.dO(), blockposition, EnumDirection.a, ItemStack.l, EnumDirection.b));
                            boolean flag3 = BlockFalling.m(this.dO().a_(blockposition.e())) && (!flag || !flag1);
                            boolean bl = flag4 = this.h.a((IWorldReader)this.dO(), blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.h.b(BlockProperties.C) && this.dO().b_(blockposition).a() == FluidTypes.c) {
                                    this.h = (IBlockData)this.h.a(BlockProperties.C, true);
                                }
                                if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.h)) {
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                                if (this.dO().a(blockposition, this.h, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.dO()).l().a.a(this, new PacketPlayOutBlockChange(blockposition, this.dO().a_(blockposition)));
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).a(this.dO(), blockposition, this.h, iblockdata, this);
                                    }
                                    if (this.d != null && this.h.t() && (tileentity = this.dO().c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.d(this.dO().H_());
                                        for (String s2 : this.d.e()) {
                                            nbttagcompound.a(s2, this.d.c(s2).d());
                                        }
                                        try {
                                            tileentity.c(nbttagcompound, this.dO().H_());
                                        }
                                        catch (Exception exception) {
                                            g.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                } else if (this.c && this.dO().ab().b(GameRules.i)) {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DROP);
                                if (this.c && this.dO().ab().b(GameRules.i)) {
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            }
                        } else {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            this.a(block, blockposition);
                        }
                    }
                }
            }
            this.i(this.dr().a(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.dO(), pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damagesource1;
        if (!this.j) {
            return false;
        }
        int i2 = MathHelper.f(fallDistance - 1.0f);
        if (i2 < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.h.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.a(this);
        } else {
            damagesource1 = this.dP().a(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f2 = Math.min(MathHelper.d((float)i2 * this.l), this.k);
        this.dO().a((Entity)this, this.cK(), predicate).forEach(entity -> entity.a(damagesource2, f2));
        boolean flag = this.h.a(TagsBlock.N);
        if (flag && f2 > 0.0f && this.ah.i() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.h);
            if (iblockdata == null) {
                this.i = true;
            } else {
                this.h = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("BlockState", GameProfileSerializer.a(this.h));
        nbt.a("Time", this.b);
        nbt.a("DropItem", this.c);
        nbt.a("HurtEntities", this.j);
        nbt.a("FallHurtAmount", this.l);
        nbt.a("FallHurtMax", this.k);
        if (this.d != null) {
            nbt.a("TileEntityData", this.d);
        }
        nbt.a("CancelDrop", this.i);
        if (!this.autoExpire) {
            nbt.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.h = GameProfileSerializer.a(this.dO().a(Registries.f), nbt.p("BlockState"));
        this.b = nbt.h("Time");
        if (nbt.b("HurtEntities", 99)) {
            this.j = nbt.q("HurtEntities");
            this.l = nbt.j("FallHurtAmount");
            this.k = nbt.h("FallHurtMax");
        } else if (this.h.a(TagsBlock.N)) {
            this.j = true;
        }
        if (nbt.b("DropItem", 99)) {
            this.c = nbt.q("DropItem");
        }
        if (!(!nbt.b("TileEntityData", 10) || this.dO().paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.h.b() instanceof GameMasterBlock)) {
            this.d = nbt.p("TileEntityData").i();
        }
        this.i = nbt.q("CancelDrop");
        if (this.h.i()) {
            this.h = Blocks.I.o();
        }
        if (nbt.e("Paper.AutoExpire")) {
            this.autoExpire = nbt.q("Paper.AutoExpire");
        }
    }

    public void b(float fallHurtAmount, int fallHurtMax) {
        this.j = true;
        this.l = fallHurtAmount;
        this.k = fallHurtMax;
    }

    public void s() {
        this.i = true;
    }

    @Override
    public boolean cy() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        super.a(section);
        section.a("Immitating BlockState", this.h.toString());
    }

    public IBlockData t() {
        return this.h;
    }

    @Override
    protected IChatBaseComponent cs() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.h.b().f());
    }

    @Override
    public boolean cP() {
        return true;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entityTrackerEntry, Block.i(this.t()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.h = Block.a(packet.p());
        this.J = true;
        double d0 = packet.g();
        double d1 = packet.h();
        double d2 = packet.i();
        this.a_(d0, d1, d2);
        this.a(this.do());
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition teleportTarget) {
        ResourceKey<World> resourcekey = teleportTarget.a().af();
        ResourceKey<World> resourcekey1 = this.dO().af();
        boolean flag = (resourcekey1 == World.j || resourcekey == World.j) && resourcekey1 != resourcekey;
        Entity entity = super.a(teleportTarget);
        this.e = entity != null && flag && GlobalConfiguration.get().unsupportedSettings.allowUnsafeEndPortalTeleportation;
        return entity;
    }
}

