/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class Bogged
extends EntitySkeletonAbstract
implements IShearable {
    private static final int c = 50;
    private static final int d = 70;
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(Bogged.class, DataWatcherRegistry.k);
    public static final String b = "sheared";

    public static AttributeProvider.Builder gn() {
        return EntitySkeletonAbstract.s().a(GenericAttributes.s, 16.0);
    }

    public Bogged(EntityTypes<? extends Bogged> type, World world) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)type, world);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(b, this.go());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q(b));
    }

    public boolean go() {
        return this.ao.a(e);
    }

    public void x(boolean sheared) {
        this.ao.a(e, sheared);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.rV) && this.a()) {
            List<ItemStack> drops = this.generateDefaultDrops();
            PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
            if (event != null) {
                if (event.isCancelled()) {
                    if (player instanceof EntityPlayer) {
                        EntityPlayer serverPlayer = (EntityPlayer)player;
                        this.resendPossiblyDesyncedDataValues(List.of(e), serverPlayer);
                    }
                    return EnumInteractionResult.e;
                }
                drops = CraftItemStack.asNMSCopy(event.getDrops());
            }
            this.shear(SoundCategory.h, drops);
            this.a(GameEvent.M, (Entity)player);
            if (!this.dO().B) {
                itemstack.a(1, (EntityLiving)player, Bogged.d(hand));
            }
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(player, hand);
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.cn;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.cp;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.co;
    }

    @Override
    protected SoundEffect t() {
        return SoundEffects.cr;
    }

    @Override
    protected EntityArrow a(ItemStack arrow, float damageModifier, @Nullable ItemStack shotFrom) {
        EntityArrow entityarrow = super.a(arrow, damageModifier, shotFrom);
        if (entityarrow instanceof EntityTippedArrow) {
            EntityTippedArrow entitytippedarrow = (EntityTippedArrow)entityarrow;
            entitytippedarrow.a(new MobEffect(MobEffects.s, 100));
        }
        return entityarrow;
    }

    @Override
    protected int gk() {
        return 50;
    }

    @Override
    protected int gl() {
        return 70;
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.shear(shearedSoundCategory, this.generateDefaultDrops());
    }

    @Override
    public void shear(SoundCategory shearedSoundCategory, List<ItemStack> drops) {
        this.dO().a((EntityHuman)null, this, SoundEffects.cq, shearedSoundCategory, 1.0f, 1.0f);
        this.spawnDrops(drops);
        this.x(true);
    }

    private void gr() {
        this.spawnDrops(this.generateDefaultDrops());
    }

    private void spawnDrops(List<ItemStack> drops) {
        drops.forEach(stack -> {
            this.forceDrops = true;
            this.a((ItemStack)stack, this.dk());
            this.forceDrops = false;
        });
    }

    private void generateShearedMushrooms(Consumer<ItemStack> stackConsumer) {
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            LootTable loottable = worldserver.o().be().b(LootTables.bc);
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, this.dm()).a(LootContextParameters.a, this).a(LootContextParameterSets.s);
            for (ItemStack itemstack : loottable.a(lootparams)) {
                stackConsumer.accept(itemstack);
            }
        }
    }

    @Override
    public List<ItemStack> generateDefaultDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.generateShearedMushrooms(drops::add);
        return drops;
    }

    @Override
    public boolean a() {
        return !this.go() && this.bE();
    }
}

