/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster
implements PowerableMob {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int e;
    public int cc;
    public int cd = 30;
    public int ce = 3;
    private int cf;
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalFloat(this));
        this.bW.a(2, new PathfinderGoalSwell(this));
        this.bW.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bW.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bW.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(6, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bX.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gq().a(GenericAttributes.v, 0.25);
    }

    @Override
    public int cx() {
        return this.p() == null ? this.w(0.0f) : this.w(this.ew() - 1.0f);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.cc += (int)(fallDistance * 1.5f);
        if (this.cc > this.cd - 5) {
            this.cc = this.cd - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(b, -1);
        builder.a(c, false);
        builder.a(d, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.ao.a(c).booleanValue()) {
            nbt.a("powered", true);
        }
        nbt.a("Fuse", (short)this.cd);
        nbt.a("ExplosionRadius", (byte)this.ce);
        nbt.a("ignited", this.x());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ao.a(c, nbt.q("powered"));
        if (nbt.b("Fuse", 99)) {
            this.cd = nbt.g("Fuse");
        }
        if (nbt.b("ExplosionRadius", 99)) {
            this.ce = nbt.f("ExplosionRadius");
        }
        if (nbt.q("ignited")) {
            this.ao.a(d, true);
        }
    }

    @Override
    public void l() {
        if (this.bE()) {
            int i2;
            this.e = this.cc;
            if (this.x()) {
                this.b(1);
            }
            if ((i2 = this.t()) > 0 && this.cc == 0) {
                this.a(SoundEffects.gk, 1.0f, 0.5f);
                ((Entity)this).a(GameEvent.I);
            }
            this.cc += i2;
            if (this.cc < 0) {
                this.cc = 0;
            }
            if (this.cc >= this.cd) {
                this.cc = this.cd;
                this.gn();
            }
        }
        super.l();
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (!(target instanceof Goat)) {
            super.h(target);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.gj;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.gi;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        EntityCreeper entitycreeper;
        super.a(world, source, causedByPlayer);
        Entity entity = source.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gl()) {
            entitycreeper.gm();
            this.a((IMaterial)Items.up);
        }
    }

    @Override
    public boolean D(Entity target) {
        return true;
    }

    @Override
    public boolean a() {
        return this.ao.a(c);
    }

    public float H(float timeDelta) {
        return MathHelper.i(timeDelta, this.e, this.cc) / (float)(this.cd - 2);
    }

    public int t() {
        return this.ao.a(b);
    }

    public void b(int fuseSpeed) {
        this.ao.a(b, fuseSpeed);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        super.a(world, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.ao.a(c, true);
    }

    public void setPowered(boolean powered) {
        this.ao.a(c, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(TagsItem.be)) {
            SoundEffect soundeffect = itemstack.a(Items.tX) ? SoundEffects.iK : SoundEffects.iZ;
            this.dO().a(player, this.dt(), this.dv(), this.dz(), soundeffect, this.de(), 1.0f, this.ah.i() * 0.4f + 0.8f);
            if (!this.dO().B) {
                this.entityIgniter = player;
                this.gk();
                if (itemstack.o() == 0) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, (EntityLiving)player, EntityCreeper.d(hand));
                }
            }
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(player, hand);
    }

    public void gn() {
        if (!this.dO().B) {
            float f2 = this.a() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.ce * f2, false);
            if (!event.isCancelled()) {
                this.be = true;
                this.dO().a((Entity)this, this.dt(), this.dv(), this.dz(), event.getRadius(), event.getFire(), World.a.c);
                this.go();
                this.c(Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.cc = 0;
                this.ao.a(d, false);
            }
        }
    }

    private void go() {
        Collection<MobEffect> collection = this.et();
        if (!collection.isEmpty() && !this.dO().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dO(), this.dt(), this.dv(), this.dz());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.c(10);
            entityareaeffectcloud.a(entityareaeffectcloud.j() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.g() / (float)entityareaeffectcloud.j());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.dO().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean x() {
        return this.ao.a(d);
    }

    public void gk() {
        this.setIgnited(true);
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.x() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.ao.a(d, event.isIgnited());
        }
    }

    public boolean gl() {
        return this.a() && this.cf < 1;
    }

    public void gm() {
        ++this.cf;
    }
}

