/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;

public class EntityIllagerIllusioner
extends EntityIllagerWizard
implements IRangedEntity {
    private static final int e = 4;
    private static final int cc = 3;
    private static final int cd = 3;
    private int ce;
    private final Vec3D[][] cf;

    public EntityIllagerIllusioner(EntityTypes<? extends EntityIllagerIllusioner> type, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, world);
        this.bR = 5;
        this.cf = new Vec3D[2][4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.cf[0][i2] = Vec3D.b;
            this.cf[1][i2] = Vec3D.b;
        }
    }

    @Override
    protected void B() {
        super.B();
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(1, new EntityIllagerWizard.b(this));
        this.bW.a(4, new b());
        this.bW.a(5, new a());
        this.bW.a(6, new PathfinderGoalBowShoot<EntityIllagerIllusioner>(this, 0.5, 20, 15.0f));
        this.bW.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bW.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bW.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bX.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bX.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false).c(300));
    }

    public static AttributeProvider.Builder t() {
        return EntityMonster.gq().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 18.0).a(GenericAttributes.s, 32.0);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        this.a(EnumItemSlot.a, new ItemStack(Items.ov));
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public AxisAlignedBB h_() {
        return this.cK().c(3.0, 0.0, 3.0);
    }

    @Override
    public void m_() {
        super.m_();
        if (this.dO().B && this.ci()) {
            --this.ce;
            if (this.ce < 0) {
                this.ce = 0;
            }
            if (this.aO != 1 && this.ai % 1200 != 0) {
                if (this.aO == this.aP - 1) {
                    this.ce = 3;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        this.cf[0][i2] = this.cf[1][i2];
                        this.cf[1][i2] = new Vec3D(0.0, 0.0, 0.0);
                    }
                }
            } else {
                int j2;
                this.ce = 3;
                float f2 = -6.0f;
                boolean flag = true;
                for (j2 = 0; j2 < 4; ++j2) {
                    this.cf[0][j2] = this.cf[1][j2];
                    this.cf[1][j2] = new Vec3D((double)(-6.0f + (float)this.ah.a(13)) * 0.5, Math.max(0, this.ah.a(6) - 4), (double)(-6.0f + (float)this.ah.a(13)) * 0.5);
                }
                for (j2 = 0; j2 < 16; ++j2) {
                    this.dO().a(Particles.e, this.d(0.5), this.dw(), this.f(0.5), 0.0, 0.0, 0.0);
                }
                this.dO().a(this.dt(), this.dv(), this.dz(), SoundEffects.ni, this.de(), 1.0f, 1.0f, false);
            }
        }
    }

    @Override
    public SoundEffect ai_() {
        return SoundEffects.ne;
    }

    public Vec3D[] H(float tickDelta) {
        if (this.ce <= 0) {
            return this.cf[1];
        }
        double d0 = ((float)this.ce - tickDelta) / 3.0f;
        d0 = Math.pow(d0, 0.25);
        Vec3D[] avec3d = new Vec3D[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            avec3d[i2] = this.cf[1][i2].a(1.0 - d0).e(this.cf[0][i2].a(d0));
        }
        return avec3d;
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.ne;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.ng;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.nh;
    }

    @Override
    protected SoundEffect gk() {
        return SoundEffects.nf;
    }

    @Override
    public void a(WorldServer world, int wave, boolean unused) {
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.ov));
        ItemStack itemstack1 = this.g(itemstack);
        EntityArrow entityarrow = ProjectileHelper.a(this, itemstack1, pullProgress, itemstack);
        double d0 = target.dt() - this.dt();
        double d1 = target.e(0.3333333333333333) - entityarrow.dv();
        double d2 = target.dz() - this.dz();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entityarrow.c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.dO().al().a() * 4);
        EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.eT(), entityarrow.w(), entityarrow, target.fs(), 0.8f, true);
        if (event.isCancelled()) {
            event.getProjectile().remove();
            return;
        }
        if (event.getProjectile() == entityarrow.getBukkitEntity()) {
            this.dO().b(entityarrow);
        }
        this.a(SoundEffects.xn, 1.0f, 1.0f / (this.dR().i() * 0.4f + 0.8f));
    }

    @Override
    public EntityIllagerAbstract.a s() {
        return this.gu() ? EntityIllagerAbstract.a.c : (this.gb() ? EntityIllagerAbstract.a.d : EntityIllagerAbstract.a.a);
    }

    private class b
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        b() {
            super(EntityIllagerIllusioner.this);
        }

        @Override
        public boolean b() {
            return !super.b() ? false : !EntityIllagerIllusioner.this.b(MobEffects.n);
        }

        @Override
        protected int h() {
            return 20;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            EntityIllagerIllusioner.this.addEffect(new MobEffect(MobEffects.n, 1200), EntityPotionEffectEvent.Cause.ILLUSION);
        }

        @Override
        @Nullable
        protected SoundEffect l() {
            return SoundEffects.nk;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.e;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private int e;

        a() {
            super(EntityIllagerIllusioner.this);
        }

        @Override
        public boolean b() {
            return !super.b() ? false : (EntityIllagerIllusioner.this.p() == null ? false : (EntityIllagerIllusioner.this.p().an() == this.e ? false : EntityIllagerIllusioner.this.dO().d_(EntityIllagerIllusioner.this.do()).a(EnumDifficulty.c.ordinal())));
        }

        @Override
        public void d() {
            super.d();
            EntityLiving entityliving = EntityIllagerIllusioner.this.p();
            if (entityliving != null) {
                this.e = entityliving.an();
            }
        }

        @Override
        protected int h() {
            return 20;
        }

        @Override
        protected int i() {
            return 180;
        }

        @Override
        protected void k() {
            EntityIllagerIllusioner.this.p().addEffect(new MobEffect(MobEffects.o, 400), EntityIllagerIllusioner.this, EntityPotionEffectEvent.Cause.ATTACK);
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.nj;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.f;
        }
    }
}

