/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.BreezeUtil;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class LongJump
extends Behavior<Breeze> {
    private static final int c = 4;
    private static final int d = 10;
    private static final int e = 2;
    private static final int f = Math.round(10.0f);
    private static final float g = 1.4f;
    private static final ObjectArrayList<Integer> h = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.o, MemoryStatus.a, MemoryModuleType.aU, MemoryStatus.b, MemoryModuleType.aZ, MemoryStatus.c, MemoryModuleType.ba, MemoryStatus.c, MemoryModuleType.aV, MemoryStatus.b, MemoryModuleType.m, MemoryStatus.b, MemoryModuleType.bb, MemoryStatus.c), 200);
    }

    public static boolean a(WorldServer world, Breeze breeze) {
        if (!breeze.aF() && !breeze.bf()) {
            return false;
        }
        if (BehaviorSwim.a(breeze)) {
            return false;
        }
        if (breeze.dT().a(MemoryModuleType.ba, MemoryStatus.a)) {
            return true;
        }
        EntityLiving livingEntity = breeze.dT().c(MemoryModuleType.o).orElse(null);
        if (livingEntity == null) {
            return false;
        }
        if (LongJump.a(breeze, livingEntity)) {
            breeze.dT().b(MemoryModuleType.o);
            return false;
        }
        if (LongJump.b(breeze, livingEntity)) {
            return false;
        }
        if (!LongJump.c(world, breeze)) {
            return false;
        }
        BlockPosition blockPos = LongJump.a((EntityLiving)breeze, BreezeUtil.a(livingEntity, breeze.dR()));
        if (blockPos == null) {
            return false;
        }
        IBlockData blockState = world.a_(blockPos.e());
        if (breeze.am().a(blockState)) {
            return false;
        }
        if (!BreezeUtil.a(breeze, blockPos.b()) && !BreezeUtil.a(breeze, blockPos.b(4).b())) {
            return false;
        }
        breeze.dT().a(MemoryModuleType.ba, blockPos);
        return true;
    }

    @Override
    protected boolean b(WorldServer serverLevel, Breeze breeze) {
        return LongJump.a(serverLevel, breeze);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, Breeze entity, long time) {
        return entity.at() != EntityPose.a && !entity.dT().a(MemoryModuleType.aU);
    }

    @Override
    @Override
    protected void b(WorldServer serverLevel, Breeze breeze, long l2) {
        if (breeze.dT().a(MemoryModuleType.aZ, MemoryStatus.b)) {
            breeze.dT().a(MemoryModuleType.aZ, Unit.a, f);
        }
        breeze.b(EntityPose.r);
        serverLevel.a(null, breeze, SoundEffects.cE, SoundCategory.f, 1.0f, 1.0f);
        breeze.dT().c(MemoryModuleType.ba).ifPresent(jumpTarget -> breeze.a(ArgumentAnchor.Anchor.b, jumpTarget.b()));
    }

    @Override
    @Override
    protected void c(WorldServer world, Breeze entity, long time) {
        boolean bl = entity.bf();
        if (!bl && entity.dT().a(MemoryModuleType.bb, MemoryStatus.a)) {
            entity.dT().b(MemoryModuleType.bb);
        }
        if (LongJump.a(entity)) {
            Vec3D vec3 = entity.dT().c(MemoryModuleType.ba).flatMap(jumpTarget -> LongJump.a(entity, entity.dR(), Vec3D.c(jumpTarget))).orElse(null);
            if (vec3 == null) {
                entity.b(EntityPose.a);
                return;
            }
            if (bl) {
                entity.dT().a(MemoryModuleType.bb, Unit.a);
            }
            entity.a(SoundEffects.cK, 1.0f, 1.0f);
            entity.b(EntityPose.g);
            entity.t(entity.aY);
            entity.r(true);
            entity.i(vec3);
        } else if (LongJump.b(entity)) {
            entity.a(SoundEffects.cL, 1.0f, 1.0f);
            entity.b(EntityPose.a);
            entity.r(false);
            boolean bl2 = entity.dT().a(MemoryModuleType.x);
            entity.dT().a(MemoryModuleType.aU, Unit.a, bl2 ? 2L : 10L);
            entity.dT().a(MemoryModuleType.aV, Unit.a, 100L);
        }
    }

    @Override
    @Override
    protected void d(WorldServer serverLevel, Breeze breeze, long l2) {
        if (breeze.at() == EntityPose.g || breeze.at() == EntityPose.r) {
            breeze.b(EntityPose.a);
        }
        breeze.dT().b(MemoryModuleType.ba);
        breeze.dT().b(MemoryModuleType.aZ);
        breeze.dT().b(MemoryModuleType.bb);
    }

    private static boolean a(Breeze breeze) {
        return breeze.dT().c(MemoryModuleType.aZ).isEmpty() && breeze.at() == EntityPose.r;
    }

    private static boolean b(Breeze breeze) {
        boolean bl = breeze.at() == EntityPose.g;
        boolean bl2 = breeze.aF();
        boolean bl3 = breeze.bf() && breeze.dT().a(MemoryModuleType.bb, MemoryStatus.b);
        return bl && (bl2 || bl3);
    }

    @Nullable
    private static BlockPosition a(EntityLiving breeze, Vec3D pos) {
        RayTrace clipContext = new RayTrace(pos, pos.a(EnumDirection.a, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze);
        MovingObjectPositionBlock hitResult = breeze.dO().a(clipContext);
        if (((MovingObjectPosition)hitResult).c() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult.e()).d();
        }
        RayTrace clipContext2 = new RayTrace(pos, pos.a(EnumDirection.b, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze);
        MovingObjectPositionBlock hitResult2 = breeze.dO().a(clipContext2);
        if (((MovingObjectPosition)hitResult2).c() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult2.e()).d();
        }
        return null;
    }

    private static boolean a(Breeze breeze, EntityLiving target) {
        return !target.a((Entity)breeze, 24.0);
    }

    private static boolean b(Breeze breeze, EntityLiving target) {
        return target.f((Entity)breeze) - 4.0f <= 0.0f;
    }

    private static boolean c(WorldServer world, Breeze breeze) {
        BlockPosition blockPos = breeze.do();
        for (int i2 = 1; i2 <= 4; ++i2) {
            BlockPosition blockPos2 = blockPos.a(EnumDirection.b, i2);
            if (world.a_(blockPos2).i() || world.b_(blockPos2).a(TagsFluid.a)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3D> a(Breeze breeze, RandomSource random, Vec3D jumpTarget) {
        List<Integer> list = SystemUtils.a(h, random);
        for (int i2 : list) {
            Optional<Vec3D> optional = LongJumpUtil.a(breeze, jumpTarget, 1.4f, i2, false);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ boolean a(WorldServer world, EntityLiving entity) {
        return this.b(world, (Breeze)entity);
    }

    @Override
    protected /* synthetic */ void b(WorldServer world, EntityLiving entity, long time) {
        this.d(world, (Breeze)entity, time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (Breeze)entity, time);
    }
}

